/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlImportForeignSchemaStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseDialect
extends DatabaseDialectEx {
    private final TypeHelper myTypeHelper;
    private volatile NamingService myNamingService;

    protected AbstractDatabaseDialect(TypeHelper typeHelper) {
        this.myTypeHelper = typeHelper;
    }

    @Override
    @NotNull
    public final Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(0);
        }
        Casing casing = this.getNamingService().getCasing(kind, context);
        if (casing == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(1);
        }
        return casing;
    }

    @NotNull
    protected NamingService getNamingService() {
        if (this.myNamingService == null) {
            this.myNamingService = NamingServices.getNamingService(this.getDbms());
        }
        NamingService namingService = this.myNamingService;
        if (namingService == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(2);
        }
        return namingService;
    }

    protected SqlCodeStyleSettings getCodeStyle() {
        return SqlCodeStyles.getSqlSettings((Project)null, (Language)DbSqlUtilCore.getSqlDialect(this.getDbms()));
    }

    protected boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(3);
        }
        return this.getNamingService().isPlain(identifier);
    }

    @Override
    public boolean canUnquoteAlias(@NotNull String alias, @Nullable ObjectKind kind, boolean afterAS) {
        if (alias == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(4);
        }
        return StringUtil.equals((CharSequence)this.getNamingService().catToScript(alias, kind), (CharSequence)alias);
    }

    @Override
    public String catToScript(@NotNull String identifier, @Nullable ObjectKind kind, boolean forceQuoting, boolean suppress, @NotNull Casing casing) {
        if (identifier == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(5);
        }
        if (casing == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(6);
        }
        if (!(forceQuoting |= this.isReservedKeyword(identifier)) && !suppress && casing.quoted == Case.EXACT && casing.plain != Case.EXACT && casing.plain != Case.MIXED) {
            Case identifierCase = Case.forString(identifier);
            forceQuoting = identifierCase == Case.MIXED || identifierCase != casing.plain;
        }
        return this.getNamingService().catToScript(identifier, kind, true, null, forceQuoting);
    }

    private boolean isReservedKeyword(String name2) {
        return DbSqlUtilCore.getSqlDialect(this.getDbms()).getReservedKeywords().contains(name2);
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(7);
        }
        if (procedure == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(8);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure(builder, procedure, false);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return false;
    }

    @NotNull
    public String getTypeWithSubstitution(@NotNull String name2, int length, int precision, int scale) {
        if (name2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(10);
        }
        String string = this.myTypeHelper.getTypeWithSubstitution(name2, length, precision, scale);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(12);
        }
        return this.myTypeHelper.findJdbcType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsTableInfo() {
        return false;
    }

    @Override
    public boolean supportsSearchPath() {
        return false;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.SCHEMA;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(14);
        }
        return "'" + ObjectFormatterUtil.toHexString((byte[])binaryData) + "'";
    }

    @Override
    public boolean supportsQualificationBySchema() {
        return true;
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2, boolean longMode, boolean withReturn) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(15);
        }
        if (routine2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(16);
        }
        DasArgument returnArg = routine2.getReturnArgument();
        builder.symbol("(");
        this.sqlParameters(builder, routine2, longMode);
        builder.symbol(")");
        if (returnArg != null && withReturn) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnArg);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    protected void sqlParameters(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2, boolean longMode) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(18);
        }
        if (routine2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(19);
        }
        JBIterable parameters = DasUtil.getParameters(routine2).filter(a -> a.getArgumentDirection() != ArgumentDirection.SELF);
        boolean first2 = true;
        for (DasArgument parameter : parameters) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            this.sqlParameter(builder, parameter, longMode);
        }
    }

    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(20);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 0, false);
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return false;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return null;
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(21);
        }
        return dialect == this;
    }

    @Override
    public boolean triggersIntrospection(@NotNull PsiElement element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(22);
        }
        if (element instanceof SqlTableDefinition || element instanceof SqlImportForeignSchemaStatement) {
            return true;
        }
        if (element instanceof SqlAlterStatement) {
            ObjectKind kind;
            SqlReferenceExpression ref = ((SqlAlterStatement)element).getAlterTargetReference();
            ObjectKind objectKind = kind = ref == null ? null : ref.getReferenceElementType().getTargetKind();
            if (kind == null) {
                return false;
            }
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
                return true;
            }
            return PsiTreeUtil.getChildOfType((PsiElement)element, SqlRenameToClause.class) != null;
        }
        return element instanceof SqlDdlStatement;
    }

    @Override
    public boolean supportsSchemaChanging() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 9, 11, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/AbstractDatabaseDialect";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 7: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/AbstractDatabaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithSubstitution";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canUnquoteAlias";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "catToScript";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithSubstitution";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 9, 11, 17 -> new IllegalStateException(string);
        };
    }
}

