/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import java.util.List;
import java.util.Objects;

public class ExecCreateCmdImpl
extends AbstrDockerCmd<ExecCreateCmd, ExecCreateCmdResponse>
implements ExecCreateCmd {
    private String containerId;
    @JsonProperty(value="AttachStdin")
    private Boolean attachStdin;
    @JsonProperty(value="AttachStdout")
    private Boolean attachStdout;
    @JsonProperty(value="AttachStderr")
    private Boolean attachStderr;
    @JsonProperty(value="Tty")
    private Boolean tty;
    @JsonProperty(value="Privileged")
    private Boolean privileged;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="Env")
    private List<String> env;
    @JsonProperty(value="WorkingDir")
    private String workingDir;

    public ExecCreateCmdImpl(ExecCreateCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    public ExecCreateCmd withContainerId(String containerId) {
        this.containerId = Objects.requireNonNull(containerId, "containerId was not specified");
        return this;
    }

    public ExecCreateCmd withAttachStdin(Boolean attachStdin) {
        this.attachStdin = attachStdin;
        return this;
    }

    public ExecCreateCmd withAttachStdout(Boolean attachStdout) {
        this.attachStdout = attachStdout;
        return this;
    }

    public ExecCreateCmd withAttachStderr(Boolean attachStderr) {
        this.attachStderr = attachStderr;
        return this;
    }

    public ExecCreateCmd withTty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    public ExecCreateCmd withUser(String user) {
        this.user = user;
        return this;
    }

    public ExecCreateCmd withCmd(String ... cmd) {
        this.cmd = cmd;
        return this;
    }

    public ExecCreateCmd withEnv(List<String> env) {
        this.env = env;
        return this;
    }

    public ExecCreateCmd withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    public ExecCreateCmd withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public Boolean hasAttachStdinEnabled() {
        return this.attachStdin;
    }

    public Boolean hasAttachStdoutEnabled() {
        return this.attachStdout;
    }

    public Boolean hasAttachStderrEnabled() {
        return this.attachStderr;
    }

    public Boolean hasTtyEnabled() {
        return this.tty;
    }

    public List<String> getEnv() {
        return this.env;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public String getUser() {
        return this.user;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public ExecCreateCmdResponse exec() throws NotFoundException {
        return (ExecCreateCmdResponse)super.exec();
    }
}

