/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.uml;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.django.uml.DjangoUmlDiagramProvider;
import com.intellij.python.django.util.DjangoUtil;
import com.intellij.python.uml.ERDiagramModel;
import com.intellij.python.uml.ERDiagramNode;
import com.intellij.python.uml.ERDummyModelInit;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoDiagramModel
extends ERDiagramModel {
    private static final Logger LOG = Logger.getInstance(DjangoDiagramModel.class);

    public DjangoDiagramModel(Project project, PyClass element) {
        super(project, element, DjangoUmlDiagramProvider.getInstance());
        this.init(project, element);
        this.calculateRelations();
    }

    protected void init(Project project, PyClass element) {
        ourAdditionalFields.clear();
        if (!DjangoDiagramModel.isAvailable(project)) {
            return;
        }
        List<PyFile> models = DjangoDiagramModel.getModels(project, element);
        for (PyFile file : models) {
            List classes = file.getTopLevelClasses();
            for (PyClass pyClass : classes) {
                PyClass meta;
                if (!DjangoModel.isDjangoModelDescendant((PyClass)pyClass, null) || (meta = pyClass.findNestedClass("Meta", false)) != null && meta.findClassAttribute("abstract", false, null) != null) continue;
                this.myClasses.add(pyClass);
            }
        }
        this.findAllClasses();
    }

    private static List<PyFile> getModels(@NotNull Project project, @NotNull PyClass element) {
        if (project == null) {
            DjangoDiagramModel.$$$reportNull$$$0(0);
        }
        if (element == null) {
            DjangoDiagramModel.$$$reportNull$$$0(1);
        }
        ArrayList<PyFile> models = new ArrayList<PyFile>();
        Set<PsiFile> files = DjangoDiagramModel.getFiles(project, element);
        for (PsiFile file : files) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile) || ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibrarySource(virtualFile) || !(file instanceof PyFile)) continue;
            models.add((PyFile)file);
        }
        return models;
    }

    private static boolean isAvailable(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        Module module = DjangoUtil.getDjangoModule((Project)project);
        if (module == null) {
            return false;
        }
        return DjangoFacet.isPresent((Module)module);
    }

    private static Set<PsiFile> getFiles(@NotNull Project project, @NotNull PyClass element) {
        if (project == null) {
            DjangoDiagramModel.$$$reportNull$$$0(2);
        }
        if (element == null) {
            DjangoDiagramModel.$$$reportNull$$$0(3);
        }
        HashSet<PsiFile> files = new HashSet<PsiFile>();
        if (!(element instanceof ERDummyModelInit)) {
            return files;
        }
        if (((ERDummyModelInit)element).getElement() != null && DjangoDiagramModel.fillFromDirectory((ERDummyModelInit)element, files)) {
            return files;
        }
        List applications = DjangoUtil.getApplications((Module)((ERDummyModelInit)element).getModule());
        for (PsiDirectory app : applications) {
            PsiFile modelsFile;
            PsiDirectory models = app.findSubdirectory("models");
            if (models != null && models.isDirectory()) {
                Collections.addAll(files, models.getFiles());
            }
            if ((modelsFile = app.findFile("models.py")) == null) continue;
            files.add(modelsFile);
        }
        if (files.isEmpty()) {
            LOG.info("Failed to find any models/ or models.py in Django Project " + project.getBasePath());
        }
        return files;
    }

    private static boolean fillFromDirectory(@NotNull ERDummyModelInit element, @NotNull Set<PsiFile> files) {
        PsiDirectory models;
        PsiFile file;
        if (element == null) {
            DjangoDiagramModel.$$$reportNull$$$0(4);
        }
        if (files == null) {
            DjangoDiagramModel.$$$reportNull$$$0(5);
        }
        if ((file = element.getElement().findFile("models.py")) != null) {
            files.add(file);
        }
        if ((models = element.getElement().findSubdirectory("models")) != null) {
            Collections.addAll(files, models.getFiles());
        }
        return !files.isEmpty();
    }

    protected void findAllClasses() {
        for (PyClass pyClass : this.myClasses) {
            pyClass.visitClassAttributes(expression -> {
                QualifiedName calleeQName = expression.getCalleeName();
                if (calleeQName != null) {
                    PyCallExpression initCall = (PyCallExpression)expression.findAssignedValue();
                    assert (initCall != null);
                    PyExpression toClass = (PyExpression)initCall.getArgument(0, "to", PyExpression.class);
                    if (toClass instanceof PyReferenceExpression) {
                        PyReferenceExpression refClassRef = (PyReferenceExpression)toClass;
                        TypeEvalContext context = TypeEvalContext.userInitiated((Project)pyClass.getProject(), (PsiFile)pyClass.getContainingFile());
                        PyType refClassType = context.getType((PyTypedElement)refClassRef);
                        if (refClassType instanceof PyClassType) {
                            PyClass aClass = ((PyClassType)refClassType).getPyClass();
                            this.myClasses.add(aClass);
                        }
                    }
                }
                return true;
            }, true, null);
        }
        for (PyClass pyClass : this.myClasses) {
            DiagramProvider<PyClass> instance = DjangoUmlDiagramProvider.getInstance();
            assert (instance != null);
            this.myNodes.add(new ERDiagramNode(pyClass, instance));
        }
    }

    protected void calculateRelations() {
        for (DiagramNode fromNode : this.myNodes) {
            PyClass fromClass = (PyClass)fromNode.getIdentifyingElement();
            Map<PyClass, String> res = this.getRelation(fromClass, "django.db.models.fields.related.ForeignKey");
            this.addEdges(fromNode, res, "ForeignKey", DjangoUmlDiagramProvider.getInstance());
            res = this.getRelation(fromClass, "django.db.models.fields.related.OneToOneField");
            this.addEdges(fromNode, res, "OneToOne", DjangoUmlDiagramProvider.getInstance());
            res = this.getRelation(fromClass, "django.db.models.fields.related.ManyToManyField");
            this.addEdges(fromNode, res, "ManyToMany", DjangoUmlDiagramProvider.getInstance());
            res = this.getInheritedRelation(fromClass);
            this.addEdges(fromNode, res, "OneToOne", DjangoUmlDiagramProvider.getInstance());
        }
    }

    public Map<PyClass, String> getInheritedRelation(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            DjangoDiagramModel.$$$reportNull$$$0(6);
        }
        HashMap<PyClass, String> relations = new HashMap<PyClass, String>();
        List superClasses = pyClass.getSuperClassTypes(TypeEvalContext.userInitiated((Project)pyClass.getProject(), (PsiFile)pyClass.getContainingFile()));
        for (PyClassLikeType superClass : superClasses) {
            if (!(superClass instanceof PyClassType)) continue;
            PyClass aClass = ((PyClassType)superClass).getPyClass();
            boolean insideDjango = DjangoUtil.isInsideDjango((VirtualFile)aClass.getContainingFile().getVirtualFile(), null);
            PyClass meta = aClass.findNestedClass("Meta", false);
            if (meta != null && meta.findClassAttribute("abstract", false, null) != null || insideDjango) continue;
            relations.put(aClass, "");
        }
        return relations;
    }

    public Map<PyClass, String> getRelation(@NotNull PyClass pyClass, @NotNull String type) {
        if (pyClass == null) {
            DjangoDiagramModel.$$$reportNull$$$0(7);
        }
        if (type == null) {
            DjangoDiagramModel.$$$reportNull$$$0(8);
        }
        HashMap<PyClass, String> relations = new HashMap<PyClass, String>();
        pyClass.visitClassAttributes(expression -> {
            QualifiedName calleeQName = expression.getCalleeName();
            if (calleeQName != null) {
                PyCallExpression initCall = (PyCallExpression)expression.findAssignedValue();
                assert (initCall != null);
                PyClass fieldClass = PyCallExpressionHelper.resolveCalleeClass((PyCallExpression)initCall);
                if (fieldClass == null) {
                    return true;
                }
                String fieldClassQName = fieldClass.getQualifiedName();
                boolean isSuitable = type.equals(fieldClassQName);
                for (PyClass ansector : fieldClass.getAncestorClasses(null)) {
                    String ansectorClassQName = ansector == null ? "" : ansector.getQualifiedName();
                    if (!type.equals(ansectorClassQName) || "django.db.models.fields.related.OneToOneField".equals(fieldClassQName)) continue;
                    isSuitable = true;
                    break;
                }
                if (isSuitable) {
                    relations.putAll(this.getRelation(pyClass, initCall));
                }
            }
            return true;
        }, true, null);
        return relations;
    }

    private Map<PyClass, String> getRelation(PyClass pyClass, PyCallExpression initCall) {
        String label;
        HashMap<PyClass, String> result = new HashMap<PyClass, String>();
        PyExpression toClass = (PyExpression)initCall.getArgument(0, "to", PyExpression.class);
        PyExpression through = (PyExpression)initCall.getArgument((FunctionParameter)DjangoFunctionParams.MANY_TO_MANY_THROUGH, PyExpression.class);
        PyExpression relatedNameExpression = initCall.getKeywordArgument("related_name");
        String relatedName = relatedNameExpression instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)relatedNameExpression).getStringValue() : "";
        String string = label = through == null ? "" : "through = " + through.getText() + "; ";
        if (toClass instanceof PyReferenceExpression) {
            PyReferenceExpression refClassRef = (PyReferenceExpression)toClass;
            TypeEvalContext context = TypeEvalContext.userInitiated((Project)pyClass.getProject(), (PsiFile)pyClass.getContainingFile());
            PyType refClassType = context.getType((PyTypedElement)refClassRef);
            if (refClassType instanceof PyClassType) {
                PyClass aClass = ((PyClassType)refClassType).getPyClass();
                result.put(aClass, label);
                this.additionalFields(pyClass, relatedName, aClass);
            }
        } else if (toClass instanceof PyStringLiteralExpression) {
            String fkModelName = ((PyStringLiteralExpression)toClass).getStringValue();
            if (fkModelName.equals("self")) {
                result.put(pyClass, label);
                this.additionalFields(pyClass, relatedName, pyClass);
            } else {
                PyClass aClass;
                QualifiedName name = QualifiedName.fromDottedString((String)fkModelName);
                PsiFile file = null;
                if (name.getComponentCount() == 1) {
                    file = pyClass.getContainingFile();
                } else {
                    PsiDirectory application;
                    PsiReference modelReference;
                    PsiElement resolved;
                    PsiReference[] references = toClass.getReferences();
                    if (references.length != 0 && (resolved = (modelReference = references[references.length - 1]).resolve()) instanceof PyClass) {
                        result.put((PyClass)resolved, label);
                        this.additionalFields(pyClass, relatedName, (PyClass)resolved);
                    }
                    fkModelName = name.getLastComponent();
                    List components = name.getComponents();
                    String applicationName = (String)components.get(0);
                    PsiDirectory projectRoot = DjangoUtil.getProjectRoot((PsiElement)pyClass);
                    if (projectRoot != null && (application = projectRoot.findSubdirectory(applicationName)) != null) {
                        file = application.findFile("models.py");
                    }
                }
                if (file instanceof PyFile && (aClass = ((PyFile)file).findTopLevelClass(fkModelName)) != null) {
                    result.put(aClass, label);
                    this.additionalFields(pyClass, relatedName, aClass);
                }
            }
        }
        return result;
    }

    private void additionalFields(PyClass pyClass, String relatedName, PyClass aClass) {
        this.myClasses.add(pyClass);
        if (!relatedName.equals("+")) {
            if (relatedName.isEmpty()) {
                String aClassName = pyClass.getName();
                relatedName = aClassName != null ? StringUtil.toLowerCase((String)aClassName) + "_set" : "";
            }
            ourAdditionalFields.put(aClass, new ERDiagramModel.MyEntry((Object)relatedName, (Object)"QuerySet"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/uml/DjangoDiagramModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModels";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fillFromDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInheritedRelation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

