/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.manage;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class ProcessHandlerWaiter
extends ProcessAdapter {
    @NotNull
    private final CountDownLatch myLatch;
    @NotNull
    private final ProcessHandler myHandler;
    private volatile int myResultCode;

    private ProcessHandlerWaiter(@NotNull ProcessHandler handler) {
        if (handler == null) {
            ProcessHandlerWaiter.$$$reportNull$$$0(0);
        }
        this.myLatch = new CountDownLatch(1);
        this.myHandler = handler;
    }

    @NotNull
    static ProcessHandlerWaiter create(@NotNull ProcessHandler handler) {
        if (handler == null) {
            ProcessHandlerWaiter.$$$reportNull$$$0(1);
        }
        ProcessHandlerWaiter waiter = new ProcessHandlerWaiter(handler);
        handler.addProcessListener((ProcessListener)waiter);
        ProcessHandlerWaiter processHandlerWaiter = waiter;
        if (processHandlerWaiter == null) {
            ProcessHandlerWaiter.$$$reportNull$$$0(2);
        }
        return processHandlerWaiter;
    }

    int waitForExit(int secondsToWait) throws InterruptedException, TimeoutException {
        assert (secondsToWait > 0) : "Should be positive";
        if (!this.myLatch.await(secondsToWait, TimeUnit.SECONDS)) {
            this.myHandler.destroyProcess();
            throw new TimeoutException();
        }
        return this.myResultCode;
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            ProcessHandlerWaiter.$$$reportNull$$$0(3);
        }
        super.processTerminated(event);
        this.myResultCode = event.getExitCode();
        this.myLatch.countDown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/manage/ProcessHandlerWaiter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/manage/ProcessHandlerWaiter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processTerminated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class TimeoutException
    extends Exception {
        private TimeoutException() {
            super("Timeout elapsed while waiting for process to complete");
        }
    }
}

