/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import java.io.PrintStream;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class GlobalState {
    private static final GlobalState ourInstance = new GlobalState();
    private final PrintStream originalSystemOut = System.out;
    private final PrintStream originalSystemErr = System.err;

    public static void checkSystemStreams() {
        ourInstance.checkSystemOut();
        ourInstance.checkSystemErr();
    }

    private void checkSystemOut() {
        PrintStream out = System.out;
        if (out != this.originalSystemOut) {
            System.setOut(this.originalSystemOut);
            this.throwStreamRedirected("System.out", this.originalSystemOut, out);
        }
        if (this.originalSystemOut.checkError()) {
            this.throwStreamClosed("System.out");
        }
    }

    private void checkSystemErr() {
        PrintStream err = System.err;
        if (err != this.originalSystemErr) {
            System.setErr(this.originalSystemErr);
            this.throwStreamRedirected("System.err", this.originalSystemErr, err);
        }
        if (this.originalSystemErr.checkError()) {
            this.throwStreamClosed("System.err");
        }
    }

    private void throwStreamRedirected(String name, PrintStream original, PrintStream curr) {
        this.throwMessage("The global '%s' has changed from '%s' to '%s'.", name, original, curr);
    }

    private void throwStreamClosed(String name) {
        this.throwMessage("The global '%s' is in error state; maybe it has been closed.", name);
    }

    private void throwMessage(String fmt, Object ... args) {
        String msg = GlobalState.class.getName() + ": " + String.format(Locale.ROOT, fmt, args);
        this.originalSystemOut.println(msg);
        this.originalSystemErr.println(msg);
        throw new IllegalStateException(msg);
    }
}

