/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.descriptor;

import com.intellij.codeInsight.completion.TagNameReferenceCompletionProvider;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcomponents.descriptor.SimpleTagWithNameDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementTagDescriptor
extends SimpleTagWithNameDescriptor {
    public ElementTagDescriptor(XmlTag xmlTag) {
        super(xmlTag);
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        ArrayList<XmlAttributeDescriptor> result = new ArrayList<XmlAttributeDescriptor>(Arrays.asList(super.getAttributesDescriptors(context)));
        result.add((XmlAttributeDescriptor)new AnyXmlAttributeDescriptor(this.getIdAttributeName(context)){

            public boolean isRequired() {
                return true;
            }
        });
        result.add((XmlAttributeDescriptor)new ExtendsAttributeDescriptor());
        result.add((XmlAttributeDescriptor)new AnyXmlAttributeDescriptor("constructor"));
        return result.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @NotNull
    protected String getIdAttributeName(@Nullable XmlTag context) {
        return "name";
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        return (XmlAttributeDescriptor)ContainerUtil.find((Object[])this.getAttributesDescriptors(context), descriptor -> attributeName.equalsIgnoreCase(descriptor.getName()));
    }

    private class ExtendsAttributeDescriptor
    extends AnyXmlAttributeDescriptor {
        ExtendsAttributeDescriptor() {
            super("extends");
        }

        public String getDefaultValue() {
            return "";
        }

        public boolean isEnumerated() {
            return true;
        }

        public String[] getEnumeratedValues() {
            PsiReference reference = ElementTagDescriptor.this.myXmlTag.getReference();
            if (reference instanceof TagNameReference) {
                ArrayList result = new ArrayList();
                TagNameReferenceCompletionProvider.collectCompletionVariants((TagNameReference)((TagNameReference)reference), element -> result.add(element.getLookupString()));
                return ArrayUtilRt.toStringArray(result);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
    }
}

