/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stylelint;

import com.intellij.javascript.nodejs.util.JSLinterPackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.stylelint.StylelintInspection;
import com.intellij.stylelint.StylelintState;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="StylelintConfiguration", storages={@Storage(value="stylesheetLinters/stylelint.xml")})
public class StylelintConfiguration
extends JSLinterConfiguration<StylelintState> {
    private static final StylelintState DEFAULT_STATE = new StylelintState();
    private static final String STYLELINT_ELEMENT_NAME = "stylelint";
    private static final String CONFIG_FILE_TAG_NAME = "config-file";
    private static final String FILE_PATTERNS_TAG_NAME = "file-patterns";
    private static final String ALLOW_JS_ATTRIBUTE_NAME = "allowJS";
    private static final String TAG_RUN_ON_SAVE = "fix-on-save";
    private final JSLinterPackage myPackage;

    public StylelintConfiguration(@NotNull Project project) {
        if (project == null) {
            StylelintConfiguration.$$$reportNull$$$0(0);
        }
        super(project);
        this.myPackage = new JSLinterPackage(project, STYLELINT_ELEMENT_NAME);
    }

    @NotNull
    public static StylelintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            StylelintConfiguration.$$$reportNull$$$0(1);
        }
        StylelintConfiguration stylelintConfiguration = (StylelintConfiguration)StylelintConfiguration.getInstance((Project)project, StylelintConfiguration.class);
        if (stylelintConfiguration == null) {
            StylelintConfiguration.$$$reportNull$$$0(2);
        }
        return stylelintConfiguration;
    }

    protected void savePrivateSettings(@NotNull StylelintState state) {
        if (state == null) {
            StylelintConfiguration.$$$reportNull$$$0(3);
        }
        this.myPackage.force(state.getNodePackageRef());
    }

    @NotNull
    protected StylelintState loadPrivateSettings(@NotNull StylelintState state) {
        if (state == null) {
            StylelintConfiguration.$$$reportNull$$$0(4);
        }
        this.myPackage.readOrDetect();
        NodePackage constantPackage = this.myPackage.getPackage().getConstantPackage();
        assert (constantPackage != null) : "Stylelint does not support non-constant node package refs";
        return new StylelintState(constantPackage, state.getConfigFilePath(), state.getFilesPattern(), state.isRunOnSave());
    }

    @Nullable
    protected Element toXml(@NotNull StylelintState state) {
        if (state == null) {
            StylelintConfiguration.$$$reportNull$$$0(5);
        }
        String configFilePath = state.getConfigFilePath();
        String filesPattern = state.getFilesPattern();
        if (DEFAULT_STATE.getConfigFilePath().equals(configFilePath) && DEFAULT_STATE.getFilesPattern().equals(filesPattern) && DEFAULT_STATE.isRunOnSave() == state.isRunOnSave()) {
            return null;
        }
        Element root = new Element(STYLELINT_ELEMENT_NAME);
        if (!DEFAULT_STATE.getConfigFilePath().equals(configFilePath)) {
            JDOMExternalizerUtil.writeCustomField((Element)root, (String)CONFIG_FILE_TAG_NAME, (String)configFilePath);
        }
        if (!DEFAULT_STATE.getFilesPattern().equals(filesPattern)) {
            JDOMExternalizerUtil.writeCustomField((Element)root, (String)FILE_PATTERNS_TAG_NAME, (String)filesPattern);
        }
        JDOMExternalizerUtil.writeField((Element)root, (String)TAG_RUN_ON_SAVE, (String)String.valueOf(state.isRunOnSave()), (String)String.valueOf(DEFAULT_STATE.isRunOnSave()));
        return root;
    }

    @NotNull
    protected StylelintState fromXml(@NotNull Element element) {
        if (element == null) {
            StylelintConfiguration.$$$reportNull$$$0(6);
        }
        String configFilePath = JDOMExternalizerUtil.readCustomField((Element)element, (String)CONFIG_FILE_TAG_NAME);
        String filesPattern = JDOMExternalizerUtil.readCustomField((Element)element, (String)FILE_PATTERNS_TAG_NAME);
        if (filesPattern == null && Boolean.parseBoolean(element.getAttributeValue(ALLOW_JS_ATTRIBUTE_NAME))) {
            filesPattern = "**/*.{css,js,jsx,ts,tsx}";
        }
        boolean runOnSave = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)TAG_RUN_ON_SAVE, (String)String.valueOf(false)));
        return new StylelintState(DEFAULT_STATE.getStylelintPackage(), StringUtil.notNullize((String)configFilePath), StringUtil.notNullize((String)filesPattern, (String)"**/*.{css}"), runOnSave);
    }

    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return StylelintInspection.class;
    }

    @NotNull
    public StylelintState getDefaultState() {
        StylelintState stylelintState = DEFAULT_STATE;
        if (stylelintState == null) {
            StylelintConfiguration.$$$reportNull$$$0(7);
        }
        return stylelintState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/stylelint/StylelintConfiguration";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/stylelint/StylelintConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "savePrivateSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadPrivateSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromXml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }
}

