/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.geom.YRectangle;
import com.intellij.openapi.graph.io.graphml.Port;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PortLocationModelParameter;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.Set;

public interface NodePort
extends Port {
    public NodePort createCopy();

    public NodePort createCopy(NodePort var1);

    public NodeRealizer getRealizer();

    public void bindSourcePort(Edge var1);

    public void bindSourcePort(EdgeRealizer var1);

    public void bindTargetPort(Edge var1);

    public void bindTargetPort(EdgeRealizer var1);

    public EdgeCursor edges();

    public EdgeCursor inEdges();

    public EdgeCursor outEdges();

    public boolean isSelected();

    public void setSelected(boolean var1);

    public PortLocationModelParameter getModelParameter();

    public void setModelParameter(PortLocationModelParameter var1);

    public YPoint getLocation();

    public Object getUserData();

    public void setUserData(Object var1);

    public String getConfiguration();

    public void setConfiguration(String var1);

    public boolean contains(double var1, double var3);

    public boolean findIntersection(double var1, double var3, double var5, double var7, Point2D var9);

    public void paint(Graphics2D var1);

    public YRectangle getBounds();

    public void calcUnionRect(Rectangle2D var1);

    public static class Statics {
        public static void bindSourcePort(NodePort nodePort, Edge edge) {
            GraphManager.getGraphManager()._NodePort_bindSourcePort(nodePort, edge);
        }

        public static void bindSourcePort(NodePort nodePort, EdgeRealizer edgeRealizer) {
            GraphManager.getGraphManager()._NodePort_bindSourcePort(nodePort, edgeRealizer);
        }

        public static NodePort getSourcePort(Edge edge) {
            return GraphManager.getGraphManager()._NodePort_getSourcePort(edge);
        }

        public static NodePort getSourcePort(EdgeRealizer edgeRealizer) {
            return GraphManager.getGraphManager()._NodePort_getSourcePort(edgeRealizer);
        }

        public static void bindTargetPort(NodePort nodePort, Edge edge) {
            GraphManager.getGraphManager()._NodePort_bindTargetPort(nodePort, edge);
        }

        public static void bindTargetPort(NodePort nodePort, EdgeRealizer edgeRealizer) {
            GraphManager.getGraphManager()._NodePort_bindTargetPort(nodePort, edgeRealizer);
        }

        public static NodePort getTargetPort(Edge edge) {
            return GraphManager.getGraphManager()._NodePort_getTargetPort(edge);
        }

        public static NodePort getTargetPort(EdgeRealizer edgeRealizer) {
            return GraphManager.getGraphManager()._NodePort_getTargetPort(edgeRealizer);
        }

        public static void remove(NodePort nodePort) {
            GraphManager.getGraphManager()._NodePort_remove(nodePort);
        }

        public static Factory getFactory() {
            return GraphManager.getGraphManager()._NodePort_getFactory();
        }
    }

    public static interface Factory {
        public Map createDefaultConfigurationMap();

        public void addConfiguration(String var1, Map var2);

        public void removeConfiguration(String var1);

        public Set getAvailableConfigurations();

        public void configure(NodePort var1, String var2);

        public Object getImplementation(String var1, Class var2);
    }

    public static interface ContainsTest {
        public boolean contains(NodePort var1, double var2, double var4);
    }

    public static interface IntersectionTest {
        public boolean findIntersection(NodePort var1, double var2, double var4, double var6, double var8, Point2D var10);
    }

    public static interface Painter {
        public void paint(NodePort var1, Graphics2D var2);
    }

    public static interface BoundsProvider {
        public YRectangle getBounds(NodePort var1);
    }

    public static interface SelectionChangeHandler {
        public void selectionChanged(NodePort var1);
    }

    public static interface UnionRectCalculator {
        public void calcUnionRect(NodePort var1, Rectangle2D var2);
    }

    public static interface UserDataHandler {
        public Object copyUserData(NodePort var1, Object var2, NodePort var3);
    }
}

