/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.view.Drawable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public interface Graph2DPrinter
extends Printable {
    public static final byte TITLE_AND_FOOTER_FOR_ENTIRE_POSTER = GraphManager.getGraphManager()._Graph2DPrinter_TITLE_AND_FOOTER_FOR_ENTIRE_POSTER();
    public static final byte TITLE_AND_FOOTER_FOR_EVERY_PAGE = GraphManager.getGraphManager()._Graph2DPrinter_TITLE_AND_FOOTER_FOR_EVERY_PAGE();
    public static final byte SCALING_AUTO = GraphManager.getGraphManager()._Graph2DPrinter_SCALING_AUTO();
    public static final byte SCALING_FIX = GraphManager.getGraphManager()._Graph2DPrinter_SCALING_FIX();
    public static final byte CLIP_VIEW = GraphManager.getGraphManager()._Graph2DPrinter_CLIP_VIEW();
    public static final byte CLIP_GRAPH = GraphManager.getGraphManager()._Graph2DPrinter_CLIP_GRAPH();
    public static final byte CLIP_CUSTOM = GraphManager.getGraphManager()._Graph2DPrinter_CLIP_CUSTOM();

    public boolean getPrintPosterCoords();

    public void setPrintPosterCoords(boolean var1);

    public boolean isCenterContentsOnPageEnabled();

    public void setCenterContentsOnPageEnabled(boolean var1);

    public int getPosterRows();

    public void setPosterRows(int var1);

    public int getPosterColumns();

    public void setPosterColumns(int var1);

    public byte getClipType();

    public void setClipType(byte var1);

    public double getScalingFactor();

    public void setScalingFactor(double var1);

    public byte getScalingType();

    public void setScalingType(byte var1);

    public Rectangle2D getCustomClip();

    public void setCustomClip(Rectangle2D var1);

    public byte getTextBarType();

    public void setTextBarType(byte var1);

    @Override
    public int print(Graphics var1, PageFormat var2, int var3) throws PrinterException;

    public Dimension getFixedScalingPosterDimension(PageFormat var1);

    public TitleDrawable getTitleDrawable();

    public void setTitleDrawable(TitleDrawable var1);

    public FooterDrawable getFooterDrawable();

    public void setFooterDrawable(FooterDrawable var1);

    public RenderingHints getRenderingHints();

    public void setRenderingHints(RenderingHints var1);

    public static interface PrintContext {
        public int getCurrentColumn();

        public int getCurrentPageNumber();

        public int getCurrentRow();

        public Graphics2D getGraphics2D();

        public PageFormat getPageFormat();

        public int getPosterColumns();

        public int getPosterRows();
    }

    public static interface TitleDrawable
    extends Drawable {
        public void setContext(PrintContext var1);
    }

    public static interface FooterDrawable
    extends Drawable {
        public void setContext(PrintContext var1);
    }

    public static interface AbstractTextBarDrawable
    extends FooterDrawable,
    TitleDrawable {
        @Override
        public void setContext(PrintContext var1);

        @Override
        public void paint(Graphics2D var1);

        @Override
        public Rectangle getBounds();

        public Font getFont();

        public void setFont(Font var1);

        public PrintContext getPrintContext();

        public void setPrintContext(PrintContext var1);

        public String getText();

        public void setText(String var1);

        public Color getTextColor();

        public void setTextColor(Color var1);
    }

    public static interface AbstractFooterDrawable
    extends AbstractTextBarDrawable {
        @Override
        public void paint(Graphics2D var1);

        public Color getFooterColor();

        public void setFooterColor(Color var1);
    }

    public static interface DefaultFooterDrawable
    extends AbstractFooterDrawable {
    }

    public static interface RepeatingFooterDrawable
    extends AbstractFooterDrawable {
    }

    public static interface AbstractTitleDrawable
    extends AbstractTextBarDrawable {
        @Override
        public void paint(Graphics2D var1);

        public Color getTitleBarColor();

        public void setTitleBarColor(Color var1);
    }

    public static interface DefaultTitleDrawable
    extends AbstractTitleDrawable {
    }

    public static interface RepeatingTitleDrawable
    extends AbstractTitleDrawable {
    }
}

