/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.jinja.template.psi.impl.DjangoTemplateFileImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.search.PySearchUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoPythonUtil {
    @Nullable
    public static String getCallName(PyCallExpression call) {
        PyExpression callee;
        if (call != null && (callee = call.getCallee()) != null) {
            return callee.getName();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findLibraryFile(String path2, Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        RootProvider rootProvider = sdk.getRootProvider();
        for (VirtualFile root : rootProvider.getFiles(OrderRootType.CLASSES)) {
            VirtualFile result = root.findFileByRelativePath(path2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static String toFilePath(String packageName) {
        return packageName != null ? packageName.replace(".", "/") + ".py" : null;
    }

    @Nullable
    public static String toFolderPath(String packageName) {
        return packageName != null ? packageName.replace(".", "/") : null;
    }

    public static boolean isVariable(PyExpression expr, String name) {
        return expr.getText().equals(name);
    }

    public static boolean isKeyAccess(PyExpression expr, String name) {
        if (expr instanceof PySubscriptionExpression) {
            PsiElement[] children = expr.getChildren();
            PyExpression child = children.length > 0 && children[0] instanceof PyExpression ? (PyExpression)children[0] : null;
            return DjangoPythonUtil.isVariable(child, name);
        }
        return false;
    }

    @Nullable
    public static PyStringLiteralExpression getKey(PyExpression expr) {
        PsiElement[] children;
        if (expr instanceof PySubscriptionExpression && (children = expr.getChildren()).length >= 2 && children[1] instanceof PyStringLiteralExpression) {
            return (PyStringLiteralExpression)children[1];
        }
        return null;
    }

    @NotNull
    public static Set<LookupElement> getKeys(PyDictLiteralExpression dictLiteral) {
        PyKeyValueExpression[] elems = dictLiteral.getElements();
        HashSet<LookupElement> result = new HashSet<LookupElement>();
        for (PyKeyValueExpression keyValue : elems) {
            PyExpression key = keyValue.getKey();
            if (!(key instanceof PyStringLiteralExpression)) continue;
            result.add((LookupElement)LookupElementBuilder.createWithSmartPointer((String)((PyStringLiteralExpression)key).getStringValue(), (PsiElement)key).withIcon(AllIcons.Nodes.Variable));
        }
        HashSet<LookupElement> hashSet = result;
        if (hashSet == null) {
            DjangoPythonUtil.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    public static List<Pair<PyExpression, PyExpression>> getTargetsToValuesMapping(PyAssignmentStatement assign) {
        PsiElement[] children = assign.getChildren();
        if (children.length >= 2 && children[0] instanceof PyExpression && children[1] instanceof PyExpression) {
            return Collections.singletonList(Pair.create((Object)((PyExpression)children[0]), (Object)((PyExpression)children[1])));
        }
        return Collections.emptyList();
    }

    @NlsSafe
    public static String computeElementNameForStringSearch(@NotNull PsiElement element) {
        if (element == null) {
            DjangoPythonUtil.$$$reportNull$$$0(1);
        }
        return (String)ReadAction.compute(() -> {
            if (element instanceof DjangoTemplateFileImpl) {
                return ((DjangoTemplateFileImpl)element).getName();
            }
            return PySearchUtil.computeElementNameForStringSearch((PsiElement)element);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/util/DjangoPythonUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/util/DjangoPythonUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeElementNameForStringSearch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

