/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.gherkin;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.gherkin.api.PyGherkinApi;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

final class PyBDDInspectionExtension
extends PyInspectionExtension {
    PyBDDInspectionExtension() {
    }

    public boolean ignoreUnused(@NotNull PsiElement local, @NotNull TypeEvalContext evalContext) {
        PyGherkinApi api;
        if (local == null) {
            PyBDDInspectionExtension.$$$reportNull$$$0(0);
        }
        if (evalContext == null) {
            PyBDDInspectionExtension.$$$reportNull$$$0(1);
        }
        if ((api = PyGherkinApi.getPyGherkinApi(local)) == null) {
            return false;
        }
        if (local instanceof PyParameter) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)local, PyFunction.class);
            if (function == null) {
                return false;
            }
            return PyBDDInspectionExtension.isStepDefinition(function, api, evalContext);
        }
        if (local instanceof PyFromImportStatement) {
            StreamEx functions;
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)local;
            PyStarImportElement starImportElement = fromImportStatement.getStarImportElement();
            if (starImportElement != null) {
                functions = StreamEx.of(starImportElement.iterateNames().iterator()).select(PyFunction.class);
            } else {
                TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)local.getProject(), (PsiFile)local.getContainingFile());
                functions = StreamEx.of((Object[])fromImportStatement.getImportElements()).map(PyImportElement::getImportReferenceExpression).nonNull().map(o -> context.getType((PyTypedElement)o)).select(PyFunctionType.class).map(PyFunctionType::getCallable).select(PyFunction.class);
            }
            return functions.anyMatch(o -> PyBDDInspectionExtension.isStepDefinition(o, api, evalContext));
        }
        return false;
    }

    private static boolean isStepDefinition(@NotNull PyFunction function, @NotNull PyGherkinApi api, @NotNull TypeEvalContext context) {
        PyDecoratorList decoratorList;
        if (function == null) {
            PyBDDInspectionExtension.$$$reportNull$$$0(2);
        }
        if (api == null) {
            PyBDDInspectionExtension.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyBDDInspectionExtension.$$$reportNull$$$0(4);
        }
        if ((decoratorList = function.getDecoratorList()) == null) {
            return false;
        }
        for (PyDecorator decorator : decoratorList.getDecorators()) {
            if (!api.isStepDefinition(decorator, false, context)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/gherkin/PyBDDInspectionExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreUnused";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isStepDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

