/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.MoveRelativeDateResult;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalMoveRelativeDateNode
extends JavaScriptBaseNode {
    protected TemporalMoveRelativeDateNode() {
    }

    public abstract MoveRelativeDateResult execute(CalendarMethodsRecord var1, JSTemporalPlainDateObject var2, JSTemporalDurationObject var3);

    @Specialization
    protected MoveRelativeDateResult moveRelativeDate(CalendarMethodsRecord calendarRec, JSTemporalPlainDateObject relativeTo, JSTemporalDurationObject duration, @Cached TemporalAddDateNode addDateNode) {
        JSTemporalPlainDateObject newDate = addDateNode.execute(calendarRec, relativeTo, duration, Undefined.instance);
        long days = TemporalUtil.daysUntil(relativeTo, newDate);
        return new MoveRelativeDateResult(newDate, days);
    }
}

