/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.table.TableResultViewColumn;
import com.intellij.util.Range;
import java.util.Arrays;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridTableModel
extends AbstractTableModel
implements GridModel.Listener<GridRow, GridColumn> {
    protected final DataGrid myGrid;

    public GridTableModel(@NotNull DataGrid grid) {
        if (grid == null) {
            GridTableModel.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myGrid.isEditable() && !GridUtil.isFailedToLoad(this.getValueAt(rowIndex, columnIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new AssertionError((Object)"Modification is not supported!");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModelIndex row = ModelIndex.forRow((CoreGrid)this.myGrid, (int)this.row(rowIndex, columnIndex));
        ModelIndex column = ModelIndex.forColumn((CoreGrid)this.myGrid, (int)this.col(rowIndex, columnIndex));
        return this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column);
    }

    public void cellsUpdated(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns, @Nullable GridRequestSource.RequestPlace place) {
        if (columns.size() == 1 && rows.size() == 1) {
            int rowIndex = rows.asArray()[0];
            int colIndex = columns.asArray()[0];
            int row = this.row(rowIndex, colIndex);
            int column = this.col(rowIndex, colIndex);
            RequestedTableModelEvent event = new RequestedTableModelEvent((TableModel)this, row, row, column, place);
            this.fireTableChanged(event);
        } else {
            Range<Integer> range = this.rowRange(rows, columns);
            RequestedTableModelEvent event = new RequestedTableModelEvent(this, (Integer)range.getFrom(), (Integer)range.getTo(), -1, 0, place);
            this.fireTableChanged(event);
        }
    }

    protected abstract int row(int var1, int var2);

    protected abstract int col(int var1, int var2);

    protected abstract Range<Integer> rowRange(ModelIndexSet<GridRow> var1, ModelIndexSet<GridColumn> var2);

    @NotNull
    public abstract TableResultViewColumn createColumn(int var1);

    static Range<Integer> getSmallestCoveringRange(ModelIndexSet<?> indexSet) {
        assert (indexSet.size() > 0);
        int[] indices = indexSet.asArray();
        Arrays.sort(indices);
        return new Range((Comparable)Integer.valueOf(indices[0]), (Comparable)Integer.valueOf(indices[indices.length - 1]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/table/GridTableModel", "<init>"));
    }

    static class RequestedTableModelEvent
    extends TableModelEvent {
        private final GridRequestSource.RequestPlace myRequestor;

        RequestedTableModelEvent(TableModel source, int firstRow, int lastRow, int column, @Nullable GridRequestSource.RequestPlace requestor) {
            super(source, firstRow, lastRow, column);
            this.myRequestor = requestor;
        }

        RequestedTableModelEvent(TableModel source, int firstRow, int lastRow, int column, int type, @Nullable GridRequestSource.RequestPlace requestor) {
            super(source, firstRow, lastRow, column, type);
            this.myRequestor = requestor;
        }

        @Nullable
        GridRequestSource.RequestPlace getPlace() {
            return this.myRequestor;
        }
    }
}

