/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataOutputStream;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TickIndexer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogStackDurationWorker;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8OverviewScalesBuilder;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8TickProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.FlatTopCalls;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8EventType;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.io.IntegerRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.LinksWriter;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.StringRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class V8LogIndexesWriter
implements Closeable {
    private final File myV8LogFile;
    @NotNull
    private final ByteArrayWrapper myDigest;
    @NotNull
    private final IndexFiles<Category> myIndexFiles;
    private final LinksWriter<Long> myStackWriter;
    private final SequentialRawWriter<Long> myTimeWriter;
    private final SequentialRawWriter<Integer> myStackSizeWriter;
    private final LinksWriter<String> myStrWriter;
    private final LinksWriter<TimerEvent> myEventsWriter;
    private final File myNumStackFile;
    private final File myStackFile;
    private final File myTimeFile;
    private final File myNumStringsFile;
    private final File myStringsFile;
    private final File myNumEventsFile;
    private final File myEventsFile;
    private final File myStackSizeFile;
    private final V8LogStackDurationWorker myDurationWorker;
    private long myNumTicks;
    private int myNumIdleTicks;
    private int myNumGcTicks;
    private int myMaxStackSize;
    private File myHeaderFile;
    private long myLastTick;
    private List<File> myOverviewFiles;
    @NotNull
    private final TickIndexer myEventsTickIndexer;
    @NotNull
    private final TickIndexer myEventsEndTickIndexer;

    public V8LogIndexesWriter(File v8LogFile, @NotNull ByteArrayWrapper digest, @NotNull IndexFiles<Category> indexFiles) throws IOException {
        if (digest == null) {
            V8LogIndexesWriter.$$$reportNull$$$0(0);
        }
        if (indexFiles == null) {
            V8LogIndexesWriter.$$$reportNull$$$0(1);
        }
        this.myV8LogFile = v8LogFile;
        this.myDigest = digest;
        this.myIndexFiles = indexFiles;
        this.myNumStackFile = this.myIndexFiles.generate(Category.numStack, "numStack");
        this.myStackFile = this.myIndexFiles.generate(Category.stack, "stack");
        this.myTimeFile = this.myIndexFiles.generate(Category.timeForTick, "time");
        this.myNumStringsFile = this.myIndexFiles.generate(Category.numStrings, "numStr");
        this.myStringsFile = this.myIndexFiles.generate(Category.strings, "str");
        this.myNumEventsFile = this.myIndexFiles.generate(Category.numEvents, "numEvents");
        this.myEventsFile = this.myIndexFiles.generate(Category.events, "events");
        this.myStackSizeFile = this.myIndexFiles.generate(Category.stackSize, "stackSize");
        this.myStackWriter = new LinksWriter<Long>(this.myNumStackFile, this.myStackFile, new LongRawSerializer());
        this.myTimeWriter = new SequentialRawWriter<Long>(this.myTimeFile, new LongRawSerializer());
        this.myStrWriter = new LinksWriter<String>(this.myNumStringsFile, this.myStringsFile, new StringRawSerializer());
        this.myEventsWriter = new LinksWriter<TimerEvent>(this.myNumEventsFile, this.myEventsFile, new TimerEvent.MyRawSerializer());
        this.myStackSizeWriter = new SequentialRawWriter<Integer>(this.myStackSizeFile, new IntegerRawSerializer());
        this.myNumTicks = 0L;
        this.myNumIdleTicks = 0;
        this.myNumGcTicks = 0;
        this.myMaxStackSize = 0;
        this.myDurationWorker = new V8LogStackDurationWorker(indexFiles);
        this.myEventsTickIndexer = new TickIndexer(1000000L);
        this.myEventsEndTickIndexer = new TickIndexer(1000000L);
    }

    public V8LogCachingReader createReader(@NotNull CompositeCloseable resourses, @NotNull LinksReaderFactory<Long> durationFactory, @NotNull V8ProfileLine bottomUp, @NotNull V8ProfileLine topDown, @NotNull FlatTopCalls flat, Map<String, V8TickProcessor.CodeType> codeTypes, File distributionFile, File selfDistributionFile) throws IOException {
        if (resourses == null) {
            V8LogIndexesWriter.$$$reportNull$$$0(2);
        }
        if (durationFactory == null) {
            V8LogIndexesWriter.$$$reportNull$$$0(3);
        }
        if (bottomUp == null) {
            V8LogIndexesWriter.$$$reportNull$$$0(4);
        }
        if (topDown == null) {
            V8LogIndexesWriter.$$$reportNull$$$0(5);
        }
        if (flat == null) {
            V8LogIndexesWriter.$$$reportNull$$$0(6);
        }
        return new V8LogCachingReader(this.myDigest, this.myV8LogFile, this.myHeaderFile, this.myTimeFile, this.myStackSizeFile, new LinksReaderFactory<Long>(new LongRawSerializer(), this.myNumStackFile, this.myStackFile), new LinksReaderFactory<String>(new StringRawSerializer(), this.myNumStringsFile, this.myStringsFile), new LinksReaderFactory<TimerEvent>(new TimerEvent.MyRawSerializer(), this.myNumEventsFile, this.myEventsFile), this.myOverviewFiles, durationFactory, bottomUp, topDown, flat, resourses, this.myEventsTickIndexer, this.myEventsEndTickIndexer, codeTypes, distributionFile, selfDistributionFile);
    }

    public void postProcess() throws IOException {
        V8OverviewScalesBuilder scalesBuilder = new V8OverviewScalesBuilder(this.myTimeFile, this.myStackSizeFile, this.myNumTicks, this.myLastTick, this.myIndexFiles, 50000L);
        scalesBuilder.execute();
        this.myOverviewFiles = scalesBuilder.getOverviewFiles();
    }

    public long getNumTicks() {
        return this.myNumTicks;
    }

    public void processTick(long nanos, V8TickProcessor.VmState vmState, List<Long> symbolicStack) throws IOException {
        this.myLastTick = nanos;
        this.myTimeWriter.write(nanos);
        this.myStackWriter.write(symbolicStack);
        int size = symbolicStack.size();
        this.myStackSizeWriter.write(size);
        ++this.myNumTicks;
        this.myMaxStackSize = Math.max(this.myMaxStackSize, size);
        this.myDurationWorker.tick(nanos, symbolicStack);
    }

    public void setTickCounters(int numIdle, int numGc) {
        this.myNumIdleTicks = numIdle;
        this.myNumGcTicks = numGc;
    }

    public V8LogStackDurationWorker getDurationWorker() {
        return this.myDurationWorker;
    }

    public void writeHeader(long lastTs) throws IOException {
        this.myHeaderFile = this.myIndexFiles.generate(Category.header, "header");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream((OutputStream)out);
        stream.writeLong(lastTs);
        stream.writeLong(this.myNumTicks);
        stream.writeInt(this.myMaxStackSize);
        stream.writeInt(this.myNumGcTicks);
        stream.writeInt(this.myNumIdleTicks);
        stream.flush();
        FileUtil.writeToFile((File)this.myHeaderFile, (byte[])out.toByteArray());
    }

    public int getMaxStackSize() {
        return this.myMaxStackSize;
    }

    public void writeStrings(Collection<String> str) throws IOException {
        for (String s : str) {
            this.myStrWriter.writeVariableValue(s);
        }
    }

    public void recordEvent(TimerEvent event) throws IOException {
        this.myEventsWriter.writeVariableValue(event);
        this.myEventsTickIndexer.nextTick(event.getStartNanos());
        this.myEventsEndTickIndexer.nextTick(event.getStartNanos() + event.getPause());
    }

    @Override
    public void close() throws IOException {
        this.myTimeWriter.close();
        this.myStrWriter.close();
        this.myStackWriter.close();
        this.myEventsWriter.close();
        this.myStackSizeWriter.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourses";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "durationFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomUp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topDown";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogIndexesWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createReader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Category {
        header,
        timeForTick,
        numStrings,
        strings,
        numStack,
        stack,
        numEvents,
        events,
        stackSize,
        durationByTick1,
        numDurationByTick1,
        durationByTick2,
        numDurationByTick2,
        description,
        overviewScale,
        bottomUp,
        flatTree,
        topDown,
        eventsIndex,
        eventsEndsIndex,
        eventsOverview,
        codeTypes,
        distribution,
        selfDistribution;

    }

    public static class TimerEvent {
        private final long myStartNanos;
        private final V8EventType myEventType;
        private final long myPause;

        public TimerEvent(long startNanos, V8EventType eventType, long pause) {
            this.myStartNanos = startNanos;
            this.myEventType = eventType;
            this.myPause = pause;
        }

        public long getStartNanos() {
            return this.myStartNanos;
        }

        public V8EventType getEventType() {
            return this.myEventType;
        }

        public long getPause() {
            return this.myPause;
        }

        public static class MyRawSerializer
        implements RawSerializer<TimerEvent> {
            @Override
            public long getRecordSize() {
                return 0L;
            }

            @Override
            public void write(@NotNull DataOutput out, @NotNull TimerEvent event) throws IOException {
                if (out == null) {
                    MyRawSerializer.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    MyRawSerializer.$$$reportNull$$$0(1);
                }
                out.writeLong(event.myStartNanos);
                out.writeUTF(event.myEventType.getCode());
                out.writeLong(event.myPause);
            }

            @Override
            public TimerEvent read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    MyRawSerializer.$$$reportNull$$$0(2);
                }
                long startNanos = in.readLong();
                V8EventType eventType = V8EventType.getByCode(in.readUTF());
                long pause = in.readLong();
                return new TimerEvent(startNanos, eventType, pause);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogIndexesWriter$TimerEvent$MyRawSerializer";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "write";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

