/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/BasicStats;", "", "count", "", "mean", "", "variance", "(IDD)V", "getCount", "()I", "getMean", "()D", "getVariance", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "std", "ddof", "toString", "", "core"})
public final class BasicStats {
    private final int count;
    private final double mean;
    private final double variance;

    public BasicStats(int count2, double mean2, double variance) {
        this.count = count2;
        this.mean = mean2;
        this.variance = variance;
    }

    public final int getCount() {
        return this.count;
    }

    public final double getMean() {
        return this.mean;
    }

    public final double getVariance() {
        return this.variance;
    }

    public final double std(int ddof) {
        if (this.count <= ddof) {
            return Double.NaN;
        }
        return Math.sqrt(this.variance / (double)(this.count - ddof));
    }

    public final int component1() {
        return this.count;
    }

    public final double component2() {
        return this.mean;
    }

    public final double component3() {
        return this.variance;
    }

    @NotNull
    public final BasicStats copy(int count2, double mean2, double variance) {
        return new BasicStats(count2, mean2, variance);
    }

    public static /* synthetic */ BasicStats copy$default(BasicStats basicStats, int n, double d, double d3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = basicStats.count;
        }
        if ((n2 & 2) != 0) {
            d = basicStats.mean;
        }
        if ((n2 & 4) != 0) {
            d3 = basicStats.variance;
        }
        return basicStats.copy(n, d, d3);
    }

    @NotNull
    public String toString() {
        return "BasicStats(count=" + this.count + ", mean=" + this.mean + ", variance=" + this.variance + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.count);
        result2 = result2 * 31 + Double.hashCode(this.mean);
        result2 = result2 * 31 + Double.hashCode(this.variance);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicStats)) {
            return false;
        }
        BasicStats basicStats = (BasicStats)other;
        if (this.count != basicStats.count) {
            return false;
        }
        if (Double.compare(this.mean, basicStats.mean) != 0) {
            return false;
        }
        return Double.compare(this.variance, basicStats.variance) == 0;
    }
}

