/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model.api;

import com.intellij.openapi.project.Project;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwAuthority;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwEndpoint;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwNamedElement;
import com.intellij.swagger.core.model.api.SwPresentation;
import com.intellij.swagger.core.model.api.SwSchema;
import com.intellij.swagger.core.model.api.SwUrl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006!\u00c0\u0006\u0001"}, d2={"Lcom/intellij/swagger/core/model/api/SwModelBase;", "Lcom/intellij/swagger/core/model/api/SwNamedElement;", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "Lcom/intellij/swagger/core/model/api/SwPresentation;", "schemes", "", "Lcom/intellij/swagger/core/model/api/SwSchema;", "getSchemes", "()Ljava/util/List;", "authorities", "Lcom/intellij/swagger/core/model/api/SwAuthority;", "getAuthorities", "endpoints", "Lcom/intellij/swagger/core/model/api/SwEndpoint;", "getEndpoints", "basePaths", "Lcom/intellij/swagger/core/model/api/SwUrl;", "getBasePaths", "urls", "getUrls", "allLocalObjectDefinitions", "Lcom/intellij/swagger/core/model/api/SwDefinition;", "getAllLocalObjectDefinitions", "isRemote", "", "()Z", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "substitute", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger.core"})
public interface SwModelBase
extends SwNamedElement,
SwModelElement,
SwPresentation {
    @NotNull
    public List<SwSchema> getSchemes();

    @NotNull
    public List<SwAuthority> getAuthorities();

    @NotNull
    public List<SwEndpoint> getEndpoints();

    @NotNull
    public List<SwUrl> getBasePaths();

    @NotNull
    public List<SwUrl> getUrls();

    @NotNull
    public List<SwDefinition> getAllLocalObjectDefinitions();

    public boolean isRemote();

    @Override
    @NotNull
    default public String getPresentableName() {
        String string;
        List<SwUrl> allBasePaths = this.getBasePaths();
        if (allBasePaths.size() > 1) {
            string = SwaggerBundle.message("openapi.multiple.base.paths", new Object[0]);
        } else {
            SwUrl swUrl = (SwUrl)CollectionsKt.singleOrNull(allBasePaths);
            string = SwaggerUtilsKt.orDefaultPath(swUrl != null ? swUrl.getUrlString() : null);
        }
        return string;
    }

    @Override
    @NotNull
    default public SwModelBase substitute(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this;
    }
}

