/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.telephony;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/cwm/plugin/common/telephony/MyFormatter;", "Ljava/util/logging/Formatter;", "<init>", "()V", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "format", "", "record", "Ljava/util/logging/LogRecord;", "intellij.cwm.plugin.common"})
final class MyFormatter
extends Formatter {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(ZoneId.systemDefault());

    @Override
    @NotNull
    public String format(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Instant instant = Instant.ofEpochMilli(record.getMillis());
        String timestamp = this.dateTimeFormatter.format(instant);
        String string = "%-7s";
        Object[] objectArray = new Object[]{record.getLevel()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String level = string2;
        return timestamp + " [" + record.getLongThreadID() + "] " + level + " - " + record.getMessage() + "\n";
    }
}

