/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.idea.svn.history.BunchProvider;
import org.jetbrains.idea.svn.history.CachedProvider;
import org.jetbrains.idea.svn.history.Fragment;
import org.jetbrains.idea.svn.history.LiveProvider;

public class BunchFactory {
    private final LiveProvider myLiveProvider;
    private final List<Fragment> myResult;
    private final Iterator<BunchProvider> myProviderIterator;
    private BunchProvider myCurrentProvider;
    private int myBunchSize;
    private long myYoungest;

    public BunchFactory(CachedProvider internallyCached, CachedProvider visuallyCached, LiveProvider liveProvider) {
        this.myLiveProvider = liveProvider;
        ArrayList<BunchProvider> providers = new ArrayList<BunchProvider>();
        if (internallyCached != null) {
            providers.add(internallyCached);
        }
        if (visuallyCached != null) {
            providers.add(visuallyCached);
        }
        providers.add(this.myLiveProvider);
        this.myResult = new ArrayList<Fragment>();
        for (BunchProvider this.myCurrentProvider : providers) {
            if (this.myCurrentProvider.isEmpty()) continue;
        }
        this.myYoungest = -1L;
    }

    public List<Fragment> goBack(int bunchSize, Ref<Boolean> myYoungestRead) throws VcsException {
        this.execute(bunchSize);
        myYoungestRead.set((Object)this.myLiveProvider.isEarliestRevisionWasAccessed());
        return new ArrayList<Fragment>(this.myResult);
    }

    private void addToResult(Fragment fragment) {
        if (this.myBunchSize == 0 || fragment.getList().isEmpty()) {
            return;
        }
        List<CommittedChangeList> list = fragment.getList();
        List subList = ContainerUtil.getFirstItems(list, (int)this.myBunchSize);
        this.myResult.add(new Fragment(fragment.getOrigin(), subList, fragment.isConsistentWithOlder(), fragment.isConsistentWithYounger(), fragment.getOriginBunch()));
        this.myBunchSize -= subList.size();
        this.myBunchSize = Math.max(this.myBunchSize, 0);
        this.myYoungest = ((CommittedChangeList)subList.get(subList.size() - 1)).getNumber();
    }

    private void execute(int bunchSize) throws VcsException {
        this.myBunchSize = bunchSize;
        this.myResult.clear();
        int defender = 1000;
        while (true) {
            if (--defender == 0) {
                return;
            }
            ProgressManager.checkCanceled();
            Fragment fragment = this.myCurrentProvider.getEarliestBunchInInterval(this.myYoungest, 0L, this.myYoungest == -1L ? this.myBunchSize : this.myBunchSize + 1, this.myYoungest == -1L, true);
            if (fragment != null && !fragment.getList().isEmpty()) {
                Fragment liveFragment;
                long endRevision;
                ProgressManager.checkCanceled();
                List<CommittedChangeList> bunchLists = fragment.getList();
                if (!(fragment.isConsistentWithYounger() || (endRevision = bunchLists.get(0).getNumber()) >= this.myYoungest && this.myYoungest != -1L || (liveFragment = this.myLiveProvider.getEarliestBunchInInterval(this.myYoungest, endRevision, this.myYoungest == -1L ? this.myBunchSize + 1 : this.myBunchSize + 2, this.myYoungest == -1L, false)) == null)) {
                    this.addToResult(liveFragment);
                    if (this.myBunchSize == 0) {
                        return;
                    }
                }
                this.addToResult(fragment);
                if (this.myBunchSize != 0) continue;
                return;
            }
            if (!this.myProviderIterator.hasNext()) break;
            this.myCurrentProvider = this.myProviderIterator.next();
        }
    }
}

