/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unresolvedReference;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.codeInsight.controlflow.PyDataFlowKt;
import com.jetbrains.python.documentation.docstrings.DocStringParameterReference;
import com.jetbrains.python.documentation.docstrings.DocStringTypeReference;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.AddFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.AddMethodQuickFix;
import com.jetbrains.python.inspections.quickfix.CreateClassQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameUnresolvedRefQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefCreateFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefTrueFalseQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddSelfQuickFix;
import com.jetbrains.python.inspections.unresolvedReference.PyPackageInstallAllProblemInfo;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.references.PyFromImportNameReference;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.impl.references.hasattr.PyHasAttrHelper;
import com.jetbrains.python.psi.impl.stubs.PyVersionSpecificStubBaseKt;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyFunctionTypeImpl;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class PyUnresolvedReferencesVisitor
extends PyInspectionVisitor {
    private final ImmutableSet<String> myIgnoredIdentifiers;
    private final Version myVersion;
    private volatile Boolean myIsEnabled;
    protected final List<PyPackageInstallAllProblemInfo> myUnresolvedRefs;

    protected PyUnresolvedReferencesVisitor(@Nullable ProblemsHolder holder, @NotNull List<String> ignoredIdentifiers, @NotNull TypeEvalContext context, @NotNull LanguageLevel languageLevel) {
        if (ignoredIdentifiers == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(2);
        }
        super(holder, context);
        this.myIsEnabled = null;
        this.myUnresolvedRefs = Collections.synchronizedList(new ArrayList());
        this.myIgnoredIdentifiers = ImmutableSet.copyOf(ignoredIdentifiers);
        this.myVersion = new Version(languageLevel.getMajorVersion(), languageLevel.getMinorVersion(), 0);
    }

    @Override
    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(3);
        }
        this.checkSlotsAndProperties(node);
    }

    private void checkSlotsAndProperties(PyQualifiedExpression node) {
        PyType type2;
        PyExpression qualifier = node.getQualifier();
        String attrName = node.getReferencedName();
        if (qualifier != null && attrName != null && (type2 = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType && !((PyClassType)type2).isAttributeWritable(attrName, this.myTypeEvalContext)) {
            ASTNode nameNode = node.getNameElement();
            PyQualifiedExpression e = nameNode != null ? nameNode.getPsi() : node;
            this.registerProblem((PsiElement)e, PyPsiBundle.message("INSP.unresolved.refs.class.object.has.no.attribute", type2.getName(), attrName));
        }
    }

    @Override
    public void visitPyElement(@NotNull PyElement node) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(4);
        }
        super.visitPyElement(node);
        if (node instanceof PyReferenceOwner) {
            PyReferenceOwner referenceOwner = (PyReferenceOwner)node;
            PyResolveContext resolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext);
            this.processReference(node, (PsiReference)referenceOwner.getReference(resolveContext));
        } else {
            for (PsiReference reference : node.getReferences()) {
                this.processReference(node, reference);
            }
        }
    }

    private void processReference(@NotNull PyElement node, @Nullable PsiReference reference) {
        boolean unresolved;
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(5);
        }
        if (!this.isEnabled((PsiElement)node) || reference == null || reference.isSoft()) {
            return;
        }
        PyExceptPart guard = PyUnresolvedReferencesVisitor.getImportErrorGuard(node);
        if (guard != null) {
            return;
        }
        if (node instanceof PyQualifiedExpression) {
            PyQualifiedExpression qExpr = (PyQualifiedExpression)node;
            PyExpression qualifier = qExpr.getQualifier();
            String name2 = node.getName();
            if (qualifier != null && name2 != null && PyHasAttrHelper.INSTANCE.getNamesFromHasAttrs((PsiElement)node, qualifier).contains(name2)) {
                return;
            }
        }
        PsiElement target = null;
        if (reference instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference poly = (PsiPolyVariantReference)reference;
            ResolveResult[] resolveResults = poly.multiResolve(false);
            unresolved = resolveResults.length == 0;
            for (ResolveResult resolveResult : resolveResults) {
                if (target != null || !resolveResult.isValidResult()) continue;
                target = resolveResult.getElement();
            }
        } else {
            target = reference.resolve();
            boolean bl = unresolved = target == null;
        }
        if (unresolved) {
            boolean ignoreUnresolved;
            boolean bl = ignoreUnresolved = this.ignoreUnresolved(node, reference) || !PyVersionSpecificStubBaseKt.evaluateVersionsForElement((PsiElement)node).contains((Comparable)this.myVersion);
            if (!ignoreUnresolved) {
                HighlightSeverity severity;
                HighlightSeverity highlightSeverity = severity = reference instanceof PsiReferenceEx ? ((PsiReferenceEx)reference).getUnresolvedHighlightSeverity(this.myTypeEvalContext) : HighlightSeverity.ERROR;
                if (severity == null && this.isAwaitCallToImportedNonAsyncFunction(reference)) {
                    severity = HighlightSeverity.WEAK_WARNING;
                }
                if (severity == null) {
                    return;
                }
                this.registerUnresolvedReferenceProblem(node, reference, severity);
            }
        } else if (reference instanceof PyImportReference && target == reference.getElement().getContainingFile() && !PyUnresolvedReferencesVisitor.isContainingFileImportAllowed(node, (PsiFile)target)) {
            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unresolved.refs.import.resolves.to.its.containing.file", new Object[0]));
        }
    }

    private boolean isAwaitCallToImportedNonAsyncFunction(@NotNull PsiReference reference) {
        PyPrefixExpression prefixExpression;
        Object object;
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(6);
        }
        if ((object = reference.getElement()) instanceof PyPrefixExpression && "__await__".equals((prefixExpression = (PyPrefixExpression)object).getOperator().getSpecialMethodName()) && (object = PyUnresolvedReferencesVisitor.getReferenceQualifier(reference)) instanceof PyCallExpression) {
            PyCallExpression callExpression = (PyCallExpression)object;
            @NotNull List<@NotNull PyCallable> callees = callExpression.multiResolveCalleeFunction(PyResolveContext.defaultContext(this.myTypeEvalContext));
            if (callees.isEmpty()) {
                return false;
            }
            for (PyCallable callee : callees) {
                PyFunction pyFunction;
                if (!(callee instanceof PyFunction) || !(pyFunction = (PyFunction)callee).isAsync()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void registerUnresolvedReferenceProblem(@NotNull PyElement node, @NotNull PsiReference reference, @NotNull HighlightSeverity severity) {
        String refName;
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(7);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(8);
        }
        if (severity == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(9);
        }
        if (reference instanceof DocStringTypeReference) {
            return;
        }
        String description = null;
        PsiElement element = reference.getElement();
        String text = element.getText();
        TextRange rangeInElement = reference.getRangeInElement();
        String refText = text;
        if (rangeInElement.getStartOffset() >= 0 && rangeInElement.getEndOffset() > 0) {
            refText = rangeInElement.substring(text);
        }
        String string = refName = element instanceof PyQualifiedExpression ? ((PyQualifiedExpression)element).getReferencedName() : refText;
        if (StringUtil.isEmpty((String)refName)) {
            return;
        }
        List<QualifiedName> qualifiedNames = PyUnresolvedReferencesVisitor.getCanonicalNames(reference, this.myTypeEvalContext);
        for (QualifiedName name2 : qualifiedNames) {
            String canonicalName = name2.toString();
            for (String ignored : this.myIgnoredIdentifiers) {
                String prefix;
                if (!(ignored.endsWith(".*") ? canonicalName.startsWith(prefix = ignored.substring(0, ignored.length() - ".*".length())) : canonicalName.equals(ignored))) continue;
                return;
            }
        }
        if (this.myIgnoredIdentifiers.contains((Object)refName)) {
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (element instanceof PyReferenceExpression) {
            PyReferenceExpression expr = (PyReferenceExpression)element;
            if (PyNames.COMPARISON_OPERATORS.contains(refName)) {
                return;
            }
            if (!expr.isQualified()) {
                if (PyDataFlowKt.isUnreachableForInspection((PsiElement)expr, this.myTypeEvalContext)) {
                    return;
                }
                ContainerUtil.addIfNotNull(fixes, (Object)PyUnresolvedReferencesVisitor.getTrueFalseQuickFix(refText));
                ContainerUtil.addAll(fixes, PyUnresolvedReferencesVisitor.getAddSelfFixes(this.myTypeEvalContext, node, expr));
                ContainerUtil.addIfNotNull(fixes, (Object)PyUnresolvedReferencesVisitor.getCreateFunctionQuickFix(expr));
                ContainerUtil.addIfNotNull(fixes, (Object)PyUnresolvedReferencesVisitor.getAddParameterQuickFix(refName, expr));
                fixes.add(new PyRenameUnresolvedRefQuickFix());
            }
            if (PyModuleType.getPossibleInstanceMembers().contains(refName)) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportElement.class), (Class[])new Class[]{PyTryExceptStatement.class, PyIfStatement.class}) != null) {
                severity = HighlightSeverity.WEAK_WARNING;
                description = PyPsiBundle.message("INSP.unresolved.refs.module.not.found", refText);
            }
        }
        if (reference instanceof PsiReferenceEx && description == null) {
            description = ((PsiReferenceEx)reference).getUnresolvedDescription();
        }
        if (description == null) {
            PyExpression qualifier;
            boolean markedQualified = false;
            if (element instanceof PyQualifiedExpression) {
                if ("__qualname__".equals(refText) && !LanguageLevel.forElement((PsiElement)element).isPython2()) {
                    return;
                }
                if (PyNames.COMPARISON_OPERATORS.contains(refName)) {
                    return;
                }
            }
            if ((qualifier = PyUnresolvedReferencesVisitor.getReferenceQualifier(reference)) != null) {
                PyType type2 = this.myTypeEvalContext.getType(qualifier);
                if (type2 != null) {
                    if (this.ignoreUnresolvedMemberForType(type2, reference, refName) || this.isDeclaredInSlots(type2, refName)) {
                        return;
                    }
                    ContainerUtil.addAll(fixes, this.getCreateMemberFromUsageFixes(type2, reference, refText));
                    if (type2 instanceof PyClassType) {
                        PyClassType classType = (PyClassType)type2;
                        if (reference instanceof PyOperatorReference) {
                            PyClassLikeType metaClassType;
                            String className = type2.getName();
                            if (classType.isDefinition() && (metaClassType = classType.getMetaClassType(this.myTypeEvalContext, true)) != null) {
                                className = metaClassType.getName();
                            }
                            description = PyPsiBundle.message("INSP.unresolved.refs.class.does.not.define.operator", className, refName, ((PyOperatorReference)reference).getReadableOperatorName());
                        } else {
                            description = PyPsiBundle.message("INSP.unresolved.refs.unresolved.attribute.for.class", refText, type2.getName());
                        }
                    } else {
                        description = PyPsiBundle.message("INSP.unresolved.refs.cannot.find.reference.in.type", refText, type2.getName());
                    }
                    markedQualified = true;
                } else if (this.isAwaitCallToImportedNonAsyncFunction(reference)) {
                    description = PyPsiBundle.message("INSP.await.call.on.imported.untyped.function", qualifier.getText());
                    node = qualifier;
                    rangeInElement = TextRange.create((int)0, (int)qualifier.getTextRange().getLength());
                    markedQualified = true;
                }
            }
            if (!markedQualified) {
                description = PyPsiBundle.message("INSP.unresolved.refs.unresolved.reference", refText);
                ContainerUtil.addAll(fixes, this.getAutoImportFixes(node, reference, element));
                ContainerUtil.addIfNotNull(fixes, (Object)this.getCreateClassFix(refText, element));
            }
        }
        ProblemHighlightType hlType = severity == HighlightSeverity.WARNING ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        ContainerUtil.addAll(fixes, this.getImportStatementQuickFixes(element));
        ContainerUtil.addAll(fixes, this.getAddIgnoredIdentifierQuickFixes(qualifiedNames));
        List<LocalQuickFix> installPackageQuickFixes = this.getInstallPackageQuickFixes(node, reference, refName);
        boolean isAddedToInstallAllFix = false;
        if (!installPackageQuickFixes.isEmpty()) {
            ContainerUtil.addAll(fixes, installPackageQuickFixes);
            PyPackageInstallAllProblemInfo problemInfo = new PyPackageInstallAllProblemInfo((PsiElement)node, description, hlType, refName, fixes);
            this.myUnresolvedRefs.add(problemInfo);
            isAddedToInstallAllFix = true;
        }
        if (reference instanceof PySubstitutionChunkReference) {
            return;
        }
        this.getPluginQuickFixes(fixes, reference);
        if (!isAddedToInstallAllFix) {
            this.registerProblem((PsiElement)node, description, hlType, null, rangeInElement, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private boolean isDeclaredInSlots(@NotNull PyType type2, @NotNull String attrName) {
        if (type2 == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(10);
        }
        if (attrName == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(11);
        }
        return ((StreamEx)PyTypeUtil.toStream(type2).select(PyClassType.class).map(PyClassType::getPyClass).flatMap(cls -> StreamEx.of((Object)cls).append(cls.getAncestorClasses(this.myTypeEvalContext))).nonNull().filter(c -> c.isNewStyleClass(this.myTypeEvalContext))).flatCollection(PyClass::getOwnSlots).anyMatch(attrName::equals);
    }

    private boolean ignoreUnresolvedMemberForType(@NotNull PyType type2, PsiReference reference, String name2) {
        PyCallable callable;
        Object module2;
        if (type2 == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(12);
        }
        if (type2 instanceof PyTypeVarType) {
            PyTypeVarType typeVarType = (PyTypeVarType)type2;
            return typeVarType.getBound() == null && typeVarType.getDefaultType() == null && typeVarType.getConstraints().isEmpty();
        }
        if (PyTypeChecker.isUnknown(type2, this.myTypeEvalContext)) {
            return true;
        }
        if (type2 instanceof PyStructuralType && ((PyStructuralType)type2).isInferredFromUsages()) {
            return true;
        }
        if (type2 instanceof PyImportedModuleType && ((PyImportedModule)(module2 = ((PyImportedModuleType)type2).getImportedModule())).resolve() == null) {
            return true;
        }
        if (type2 instanceof PyCustomType) {
            module2 = ((PyCustomType)type2).getTypesToMimic().iterator();
            while (module2.hasNext()) {
                PyClassLikeType mimic = (PyClassLikeType)module2.next();
                if (!(mimic instanceof PyClassType) || !PyUtil.hasUnresolvedAncestors(((PyClassType)mimic).getPyClass(), this.myTypeEvalContext)) continue;
                return true;
            }
        }
        if (type2 instanceof PyClassType) {
            PyClass cls = ((PyClassType)type2).getPyClass();
            if (PyTypeChecker.overridesGetAttr(cls, this.myTypeEvalContext)) {
                return true;
            }
            if (cls.findProperty(name2, true, this.myTypeEvalContext) != null) {
                return true;
            }
            if (PyUtil.hasUnresolvedAncestors(cls, this.myTypeEvalContext)) {
                return true;
            }
            if (this.isDecoratedAsDynamic(cls, true)) {
                return true;
            }
            if (PyUnresolvedReferencesVisitor.hasUnresolvedDynamicMember((PyClassType)type2, reference, name2, this.myTypeEvalContext)) {
                return true;
            }
            if (this.isAwaitOnGeneratorBasedCoroutine(name2, reference, cls)) {
                return true;
            }
        }
        if (type2 instanceof PyFunctionTypeImpl && (callable = ((PyFunctionTypeImpl)type2).getCallable()) instanceof PyFunction && PyKnownDecoratorUtil.hasUnknownOrUpdatingAttributesDecorator((PyFunction)callable, this.myTypeEvalContext)) {
            return true;
        }
        if (type2 instanceof PyUnionType) {
            return ContainerUtil.exists(((PyUnionType)type2).getMembers(), member -> this.ignoreUnresolvedMemberForType((PyType)member, reference, name2));
        }
        if (type2 instanceof PyModuleType && (module2 = ((PyModuleType)type2).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37)) {
            return PyTypeChecker.definesGetAttr((PyFile)module2, this.myTypeEvalContext);
        }
        for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
            if (!extension.ignoreUnresolvedMember(type2, name2, this.myTypeEvalContext)) continue;
            return true;
        }
        return false;
    }

    private boolean isDecoratedAsDynamic(@NotNull PyClass cls, boolean inherited) {
        if (cls == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(13);
        }
        if (inherited) {
            if (this.isDecoratedAsDynamic(cls, false)) {
                return true;
            }
            for (PyClass base : cls.getAncestorClasses(this.myTypeEvalContext)) {
                if (base == null || !this.isDecoratedAsDynamic(base, false)) continue;
                return true;
            }
        } else {
            String docString = cls.getDocStringValue();
            if (docString != null && docString.contains("@DynamicAttrs")) {
                return true;
            }
        }
        return false;
    }

    private boolean isAwaitOnGeneratorBasedCoroutine(@NotNull String name2, @NotNull PsiReference reference, @NotNull PyClass cls) {
        PyExpression receiver;
        if (name2 == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(14);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(15);
        }
        if (cls == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(16);
        }
        if ("__await__".equals(name2) && reference instanceof PyOperatorReference && "typing.Generator".equals(cls.getQualifiedName()) && (receiver = ((PyOperatorReference)reference).getReceiver()) instanceof PyCallExpression) {
            return PyKnownDecoratorUtil.isResolvedToGeneratorBasedCoroutine((PyCallExpression)receiver, this.getResolveContext(), this.myTypeEvalContext);
        }
        return false;
    }

    private boolean isEnabled(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(17);
        }
        if (this.myIsEnabled == null) {
            Boolean overridden = PyUnresolvedReferencesVisitor.overriddenUnresolvedReferenceInspection(anchor.getContainingFile());
            this.myIsEnabled = Objects.requireNonNullElse(overridden, true);
        }
        return this.myIsEnabled;
    }

    @Nullable
    private static Boolean overriddenUnresolvedReferenceInspection(@NotNull PsiFile file) {
        if (file == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(18);
        }
        return PyInspectionExtension.EP_NAME.getExtensionList().stream().map(e -> e.overrideUnresolvedReferenceInspection(file)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void addInstallAllImports() {
        Set refNames = ContainerUtil.map2Set(this.myUnresolvedRefs, it -> it.getRefName());
        LocalQuickFix installAllPackageQuickFixes = this.getInstallAllPackagesQuickFix();
        for (PyPackageInstallAllProblemInfo unresolved : this.myUnresolvedRefs) {
            List<LocalQuickFix> quickFixes = unresolved.getFixes();
            if (refNames.size() > 1) {
                ContainerUtil.addIfNotNull(quickFixes, (Object)installAllPackageQuickFixes);
            }
            this.registerProblem(unresolved.getPsiElement(), unresolved.getDescriptionTemplate(), unresolved.getHighlightType(), null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private boolean ignoreUnresolved(@NotNull PyElement node, @NotNull PsiReference reference) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(19);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(20);
        }
        boolean ignoreUnresolved = false;
        for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
            if (!extension.ignoreUnresolvedReference(node, reference, this.myTypeEvalContext)) continue;
            ignoreUnresolved = true;
            break;
        }
        return ignoreUnresolved;
    }

    @Nullable
    private static PyExceptPart getImportErrorGuard(PyElement node) {
        PyTryExceptStatement tryExceptStatement;
        PyTryPart tryPart;
        PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class);
        if (importStatement != null && (tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class)) != null && (tryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)tryPart, PyTryExceptStatement.class)) != null) {
            for (PyExceptPart exceptPart : tryExceptStatement.getExceptParts()) {
                PyExpression expr = exceptPart.getExceptClass();
                if (expr == null || !"ImportError".equals(expr.getName())) continue;
                return exceptPart;
            }
        }
        return null;
    }

    private static boolean isContainingFileImportAllowed(PyElement node, PsiFile target) {
        return PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) == null && target.getName().equals("__init__.py");
    }

    @Nullable
    private static PyExpression getReferenceQualifier(@NotNull PsiReference reference) {
        PyReferenceExpression source;
        PyFromImportStatement statement;
        PyExpression qualifier;
        PsiElement element;
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(21);
        }
        if ((element = reference.getElement()) instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)element).getQualifier()) != null) {
            return qualifier;
        }
        if (reference instanceof PyFromImportNameReference && (statement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyFromImportStatement.class)) != null && (source = statement.getImportSource()) != null) {
            return source;
        }
        return null;
    }

    @NotNull
    private static List<QualifiedName> getCanonicalNames(@NotNull PsiReference reference, @NotNull TypeEvalContext context) {
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(23);
        }
        PsiElement element = reference.getElement();
        SmartList result2 = new SmartList();
        if (reference instanceof PyOperatorReference && element instanceof PyQualifiedExpression) {
            PyType type3;
            PyExpression receiver = ((PyOperatorReference)reference).getReceiver();
            if (receiver != null && (type3 = context.getType(receiver)) instanceof PyClassType) {
                String methodName = ((PyQualifiedExpression)element).getReferencedName();
                ContainerUtil.addIfNotNull((Collection)result2, (Object)PyUnresolvedReferencesVisitor.extractAttributeQNameFromClassType(methodName, (PyClassType)type3));
            }
        } else if (element instanceof PyReferenceExpression) {
            PyReferenceExpression expr = (PyReferenceExpression)element;
            PyExpression qualifier = expr.getQualifier();
            String exprName = expr.getName();
            if (exprName != null) {
                if (qualifier != null) {
                    PyType qualifierType = context.getType(qualifier);
                    PyTypeUtil.toStream(qualifierType).map(type2 -> {
                        QualifiedName path2;
                        PyCallable callable;
                        String callableName;
                        if (type2 instanceof PyClassType) {
                            return PyUnresolvedReferencesVisitor.extractAttributeQNameFromClassType(exprName, (PyClassType)type2);
                        }
                        if (type2 instanceof PyModuleType) {
                            PyFile file = ((PyModuleType)type2).getModule();
                            QualifiedName name2 = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, element);
                            if (name2 != null) {
                                return name2.append(exprName);
                            }
                        } else if (type2 instanceof PyImportedModuleType) {
                            QualifiedName path3;
                            PyImportedModule module2 = ((PyImportedModuleType)type2).getImportedModule();
                            PsiElement resolved = module2.resolve();
                            if (resolved != null && (path3 = QualifiedNameFinder.findCanonicalImportPath(resolved, element)) != null) {
                                return path3.append(exprName);
                            }
                        } else if (type2 instanceof PyFunctionType && (callableName = (callable = ((PyFunctionType)type2).getCallable()).getName()) != null && (path2 = QualifiedNameFinder.findCanonicalImportPath((PsiElement)callable, element)) != null) {
                            return path2.append(QualifiedName.fromComponents((String[])new String[]{callableName, exprName}));
                        }
                        return null;
                    }).nonNull().into((Collection)result2);
                } else {
                    PsiElement parent = element.getParent();
                    if (parent instanceof PyImportElement) {
                        QualifiedName path2;
                        PsiFileSystemItem resolved;
                        PyImportStatementBase importStmt = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, PyImportStatementBase.class);
                        if (importStmt instanceof PyImportStatement) {
                            ContainerUtil.addIfNotNull((Collection)result2, (Object)QualifiedName.fromComponents((String[])new String[]{exprName}));
                        } else if (importStmt instanceof PyFromImportStatement && (resolved = ((PyFromImportStatement)importStmt).resolveImportSource()) != null && (path2 = QualifiedNameFinder.findCanonicalImportPath((PsiElement)resolved, element)) != null) {
                            ContainerUtil.addIfNotNull((Collection)result2, (Object)path2.append(exprName));
                        }
                    } else {
                        QualifiedName path3 = QualifiedNameFinder.findCanonicalImportPath(element, element);
                        if (path3 != null) {
                            ContainerUtil.addIfNotNull((Collection)result2, (Object)path3.append(exprName));
                        }
                    }
                }
            }
        } else if (reference instanceof DocStringParameterReference) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)QualifiedName.fromDottedString((String)reference.getCanonicalText()));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    private static QualifiedName extractAttributeQNameFromClassType(String exprName, PyClassType type2) {
        String name2 = type2.getClassQName();
        if (name2 != null) {
            return QualifiedName.fromDottedString((String)name2).append(exprName);
        }
        return null;
    }

    @NotNull
    protected List<LocalQuickFix> getInstallPackageQuickFixes(@NotNull PyElement node, @NotNull PsiReference reference, String refName) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(25);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(26);
        }
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Nullable
    protected LocalQuickFix getInstallAllPackagesQuickFix() {
        return null;
    }

    @Nullable
    private static LocalQuickFix getCreateFunctionQuickFix(@NotNull PyReferenceExpression expr) {
        PyCallExpression callExpression;
        if (expr == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(28);
        }
        if (!((callExpression = PyCallExpressionNavigator.getPyCallExpressionByCallee((PsiElement)expr)) == null || callExpression.getCallee() instanceof PyQualifiedExpression && ((PyQualifiedExpression)callExpression.getCallee()).getQualifier() != null)) {
            return new UnresolvedRefCreateFunctionQuickFix(expr);
        }
        return null;
    }

    @NotNull
    protected List<LocalQuickFix> getAddIgnoredIdentifierQuickFixes(List<QualifiedName> qualifiedNames) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    protected List<LocalQuickFix> getImportStatementQuickFixes(PsiElement element) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    private static LocalQuickFix getAddParameterQuickFix(String refName, PyReferenceExpression expr) {
        PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class);
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)expr, PyDecorator.class);
        PyAnnotation annotation = (PyAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expr, PyAnnotation.class);
        PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PyImportStatement.class);
        if (parentFunction != null && decorator == null && annotation == null && importStatement == null) {
            return new UnresolvedReferenceAddParameterQuickFix(refName);
        }
        return null;
    }

    @Nullable
    private static LocalQuickFix getTrueFalseQuickFix(@NotNull String refText) {
        if (refText == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(31);
        }
        if (refText.equals("true") || refText.equals("false")) {
            return new UnresolvedRefTrueFalseQuickFix(refText);
        }
        return null;
    }

    @Nullable
    private LocalQuickFix getCreateClassFix(@NonNls String refText, PsiElement element) {
        if (refText.length() > 2 && Character.isUpperCase(refText.charAt(0)) && !StringUtil.toUpperCase((String)refText).equals(refText) && element instanceof PyQualifiedExpression) {
            PyFromImportStatement fromImport;
            PyExpression qualifier = ((PyQualifiedExpression)element).getQualifier();
            if (qualifier == null && (fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyFromImportStatement.class)) != null) {
                qualifier = fromImport.getImportSource();
            }
            PyFile destination = null;
            if (qualifier != null) {
                PyType type2 = this.myTypeEvalContext.getType(qualifier);
                if (type2 instanceof PyModuleType) {
                    destination = ((PyModuleType)type2).getModule();
                } else {
                    return null;
                }
            }
            if (destination == null) {
                InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)element.getProject());
                PsiLanguageInjectionHost injectionHost = injectionManager.getInjectionHost(element);
                destination = ((PsiElement)ObjectUtils.chooseNotNull((Object)injectionHost, (Object)element)).getContainingFile();
            }
            return new CreateClassQuickFix(refText, destination);
        }
        return null;
    }

    @NotNull
    private List<LocalQuickFix> getCreateMemberFromUsageFixes(PyType type2, PsiReference reference, String refText) {
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        PsiElement element = reference.getElement();
        if (type2 instanceof PyClassTypeImpl) {
            PyClass cls = ((PyClassType)type2).getPyClass();
            if (!PyBuiltinCache.getInstance(element).isBuiltin(cls)) {
                if (element.getParent() instanceof PyCallExpression) {
                    result2.add(new AddMethodQuickFix(refText, cls.getName(), true));
                } else if (!(reference instanceof PyOperatorReference)) {
                    result2.add(new AddFieldQuickFix(refText, "None", type2.getName(), true));
                }
            }
        } else if (type2 instanceof PyModuleType) {
            PyFile file = ((PyModuleType)type2).getModule();
            LocalQuickFix createClassQuickFix = this.getCreateClassFix(refText, element);
            if (createClassQuickFix != null) {
                result2.add(createClassQuickFix);
            } else {
                result2.add(new AddFunctionQuickFix(refText, file.getName()));
            }
        }
        ArrayList<LocalQuickFix> arrayList = result2;
        if (arrayList == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    private static List<LocalQuickFix> getAddSelfFixes(TypeEvalContext typeEvalContext, PyElement node, PyReferenceExpression expr) {
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        PyClass containedClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
        if (containedClass != null && function != null) {
            PyParameter[] parameters = function.getParameterList().getParameters();
            if (parameters.length == 0) {
                List<LocalQuickFix> list = Collections.emptyList();
                if (list == null) {
                    PyUnresolvedReferencesVisitor.$$$reportNull$$$0(33);
                }
                return list;
            }
            String qualifier = parameters[0].getText();
            PyDecoratorList decoratorList = function.getDecoratorList();
            boolean isClassMethod = false;
            if (decoratorList != null) {
                for (PyDecorator decorator : decoratorList.getDecorators()) {
                    PyExpression callee = decorator.getCallee();
                    if (callee == null || !"classmethod".equals(callee.getText())) continue;
                    isClassMethod = true;
                }
            }
            for (PyTargetExpression target : containedClass.getInstanceAttributes()) {
                if (isClassMethod || !Comparing.strEqual((String)node.getName(), (String)target.getName())) continue;
                result2.add((LocalQuickFix)new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
            for (PyStatement statement : containedClass.getStatementList().getStatements()) {
                PyType type2;
                PyExpression assignedValue;
                PyExpression lhsExpression;
                if (!(statement instanceof PyAssignmentStatement) || (lhsExpression = ((PyAssignmentStatement)statement).getLeftHandSideExpression()) == null || !lhsExpression.getText().equals(expr.getText()) || !((assignedValue = ((PyAssignmentStatement)statement).getAssignedValue()) instanceof PyCallExpression) || !((type2 = typeEvalContext.getType(assignedValue)) instanceof PyClassTypeImpl) || !((PyCallExpression)assignedValue).isCalleeText(new String[]{"property"})) continue;
                result2.add((LocalQuickFix)new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
            for (PyFunction method : containedClass.getMethods()) {
                if (!expr.getText().equals(method.getName())) continue;
                result2.add((LocalQuickFix)new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
        }
        ArrayList<LocalQuickFix> arrayList = result2;
        if (arrayList == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    protected List<LocalQuickFix> getAutoImportFixes(PyElement node, PsiReference reference, PsiElement element) {
        return Collections.emptyList();
    }

    private static boolean hasUnresolvedDynamicMember(@NotNull PyClassType type2, PsiReference reference, @NotNull String name2, TypeEvalContext typeEvalContext) {
        if (type2 == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(35);
        }
        if (name2 == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(36);
        }
        ArrayList<PyClassType> types = new ArrayList<PyClassType>(Collections.singletonList(type2));
        types.addAll((Collection<PyClassType>)FluentIterable.from(type2.getAncestorTypes(typeEvalContext)).filter(PyClassType.class).toList());
        for (PyClassType typeToCheck : types) {
            for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
                Collection<PyCustomMember> resolveResult = provider.getMembers(typeToCheck, reference.getElement(), typeEvalContext);
                for (PyCustomMember member : resolveResult) {
                    if (!member.getName().equals(name2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @VisibleForTesting
    public void getPluginQuickFixes(List<LocalQuickFix> fixes, PsiReference reference) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 27, 29, 30, 32, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredIdentifiers";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 10: 
            case 12: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 14: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesVisitor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesVisitor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallPackageQuickFixes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddIgnoredIdentifierQuickFixes";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatementQuickFixes";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateMemberFromUsageFixes";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddSelfFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTargetExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAwaitCallToImportedNonAsyncFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerUnresolvedReferenceProblem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredInSlots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ignoreUnresolvedMemberForType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDecoratedAsDynamic";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAwaitOnGeneratorBasedCoroutine";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "overriddenUnresolvedReferenceInspection";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "ignoreUnresolved";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceQualifier";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalNames";
                break;
            }
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getInstallPackageQuickFixes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCreateFunctionQuickFix";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTrueFalseQuickFix";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedDynamicMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24, 27, 29, 30, 32, 33, 34 -> new IllegalStateException(string);
        };
    }
}

