/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionSettingsForm;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConsoleSettingsPanel {
    private JPanel myEncodingsListCombo;
    private Presentation myEncodingActionPresentation;
    private final Ref<Charset> myCharset;
    private JPanel myWholePanel;
    private JPanel myConnectionSettingsHolder;
    private SshConsoleOptionsProvider myOptionsProvider;
    private RemoteConnectionSettingsForm myConnectionSettingsForm;
    private final Disposable myParentDisposable;
    @Nullable
    private final Project myProject;

    public SshConsoleSettingsPanel(Disposable parent, @Nullable Project project) {
        this.$$$setupUI$$$();
        this.myCharset = new Ref();
        this.myParentDisposable = parent;
        this.myProject = project;
    }

    public JComponent createPanel(SshConsoleOptionsProvider provider) {
        this.myOptionsProvider = provider;
        this.myEncodingActionPresentation = SshConsoleSettingsPanel.installChooseEncodingCombo(this.myEncodingsListCombo, this.myCharset);
        this.myConnectionSettingsForm = new RemoteConnectionSettingsForm(this.myProject, this.myParentDisposable);
        this.myConnectionSettingsForm.setShowConfigSettingsLink(true);
        this.myConnectionSettingsHolder.setLayout(new BorderLayout());
        this.myConnectionSettingsHolder.add((Component)this.myConnectionSettingsForm.createPanel(), "Center");
        return this.myWholePanel;
    }

    public boolean isModified() {
        return !Comparing.equal((Object)((Charset)this.myCharset.get()), (Object)this.myOptionsProvider.getCharset()) || this.connectionIsModified();
    }

    private boolean connectionIsModified() {
        return this.myConnectionSettingsForm.getConnectionType() != this.myOptionsProvider.getConnectionType() || StringUtil.isEmpty((String)this.myConnectionSettingsForm.getConnectionId()) && !StringUtil.isEmpty((String)this.myOptionsProvider.getConnectionId()) || this.myConnectionSettingsForm.getConnectionId() != null && !this.myConnectionSettingsForm.getConnectionId().equals(this.myOptionsProvider.getConnectionId());
    }

    public void apply() {
        this.myOptionsProvider.setCharset((Charset)this.myCharset.get());
        this.myOptionsProvider.setConnectByDefaultType(this.myConnectionSettingsForm.getConnectionType());
        this.myOptionsProvider.setConnectionId(this.myConnectionSettingsForm.getConnectionId());
    }

    public void reset() {
        this.myCharset.set((Object)this.myOptionsProvider.getCharset());
        SshConsoleSettingsPanel.updateEncodingAction(this.myEncodingActionPresentation, this.myCharset);
        this.myConnectionSettingsForm.setConnectionTypeAndId(this.myOptionsProvider.getConnectionType(), this.myOptionsProvider.getConnectionId());
    }

    @NotNull
    private static Presentation installChooseEncodingCombo(@NotNull JPanel parentPanel, final @NotNull Ref<Charset> selected) {
        if (parentPanel == null) {
            SshConsoleSettingsPanel.$$$reportNull$$$0(0);
        }
        if (selected == null) {
            SshConsoleSettingsPanel.$$$reportNull$$$0(1);
        }
        final Ref presentationRef = Ref.create();
        ChooseFileEncodingAction action = new ChooseFileEncodingAction(null){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                SshConsoleSettingsPanel.updateEncodingAction(e.getPresentation(), (Ref<? extends Charset>)selected);
            }

            protected void chosen(VirtualFile virtualFile, @NotNull Charset charset) {
                if (charset == null) {
                    1.$$$reportNull$$$0(2);
                }
                selected.set((Object)(charset == NO_ENCODING ? null : charset));
                SshConsoleSettingsPanel.updateEncodingAction((Presentation)presentationRef.get(), (Ref<? extends Charset>)selected);
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
                if (button == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(4);
                }
                DefaultActionGroup defaultActionGroup = this.createCharsetsActionGroup(RemoteSdkBundle.message("action.system.default.text", new Object[0]), (Charset)selected.get(), charset -> RemoteSdkBundle.message("choose.encoding.0", charset));
                if (defaultActionGroup == null) {
                    1.$$$reportNull$$$0(5);
                }
                return defaultActionGroup;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 4 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/SshConsoleSettingsPanel$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "charset";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "button";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/SshConsoleSettingsPanel$1";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPopupActionGroup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "chosen";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createPopupActionGroup";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3, 4 -> new IllegalArgumentException(string);
                };
            }
        };
        parentPanel.removeAll();
        Presentation presentation = action.getTemplatePresentation().clone();
        parentPanel.add((Component)action.createCustomComponent(presentation, "unknown"), "Center");
        SshConsoleSettingsPanel.updateEncodingAction(presentation, selected);
        presentationRef.set((Object)presentation);
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            SshConsoleSettingsPanel.$$$reportNull$$$0(2);
        }
        return presentation2;
    }

    private static void updateEncodingAction(@NotNull Presentation presentation, Ref<? extends Charset> selected) {
        if (presentation == null) {
            SshConsoleSettingsPanel.$$$reportNull$$$0(3);
        }
        presentation.setEnabled(true);
        Charset charset = (Charset)selected.get();
        presentation.setText(charset == null ? SshConsoleSettingsPanel.getSystemDefault() : charset.displayName());
    }

    @NlsSafe
    private static String getSystemDefault() {
        return CharsetToolkit.getDefaultSystemCharset().name();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConnectionSettingsHolder = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, new Dimension(24, 25), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", SshConsoleSettingsPanel.class).getString("settings.default.encoding"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEncodingsListCombo = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/SshConsoleSettingsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/SshConsoleSettingsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "installChooseEncodingCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installChooseEncodingCombo";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateEncodingAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

