// RUN: rm -rf %t
// RUN: %clang_cc1 -fmodules -fimplicit-module-maps %s -x c++ -fmodules-cache-path=%t -I %S/Inputs/msvc-vector-deleting-dtors -emit-llvm -triple=i386-pc-win32 -o - | FileCheck %s --check-prefixes CHECK,CHECK32
// RUN: %clang_cc1 -fmodules -fimplicit-module-maps %s -x c++ -fmodules-cache-path=%t -I %S/Inputs/msvc-vector-deleting-dtors -emit-llvm -triple=x86_64-pc-win32 -o - | FileCheck %s --check-prefixes CHECK,CHECK64

#include "msvc-vector-deleting-dtors.h"

void call_in_module_function(void) {
    in_h_tests(new Derived[2], new Derived[3]);
}

void out_of_module_tests(Derived *p, Derived *p1) {
  ::delete[] p;

  delete[] p1;
}

// CHECK32-LABEL: define weak dso_local x86_thiscallcc noundef ptr @"??_EDerived@@UAEPAXI@Z"
// CHECK64-LABEL: define weak dso_local noundef ptr @"??_EDerived@@UEAAPEAXI@Z"
// CHECK: dtor.call_class_delete_after_array_destroy:
// CHECK32-NEXT:  call void @"??_VBase1@@SAXPAX@Z"(ptr noundef %2)
// CHECK64-NEXT:  call void @"??_VBase1@@SAXPEAX@Z"(ptr noundef %2)
// CHECK: dtor.call_glob_delete_after_array_destroy:
// CHECK64-NEXT: %[[ARRSZ:.*]] = mul i64 16, %[[COOKIE:.*]]
// CHECK32-NEXT: %[[ARRSZ:.*]] = mul i32 8, %[[COOKIE:.*]]
// CHECK64-NEXT: %[[TOTALSZ:.*]] = add i64 %[[ARRSZ]], 8
// CHECK32-NEXT: %[[TOTALSZ:.*]] = add i32 %[[ARRSZ]], 4
// CHECK32-NEXT:   call void @"??_V@YAXPAXI@Z"(ptr noundef %2, i32 noundef %[[TOTALSZ]])
// CHECK64-NEXT:   call void @"??_V@YAXPEAX_K@Z"(ptr noundef %2, i64 noundef %[[TOTALSZ]])
// CHECK: dtor.call_glob_delete:
// CHECK32-NEXT:   call void @"??3@YAXPAXI@Z"(ptr noundef %this1, i32 noundef 8)
// CHECK64-NEXT:   call void @"??3@YAXPEAX_K@Z"(ptr noundef %this1, i64 noundef 16)
// CHECK: dtor.call_class_delete:
// CHECK32-NEXT:   call void @"??3Base2@@SAXPAX@Z"(ptr noundef %this1)
// CHECK64-NEXT:   call void @"??3Base2@@SAXPEAX@Z"(ptr noundef %this1)
