/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.UpdateElaborator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class Put
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        throw new XPathException("Dynamic evaluation of fn:put() is not supported");
    }

    @Override
    public Elaborator getElaborator() {
        return new PutFnElaborator();
    }

    public static class PutFnElaborator
    extends UpdateElaborator {
        @Override
        public UpdateEvaluator elaborateForUpdate() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Put targetFunction = (Put)fnc.getTargetFunction();
            ItemEvaluator arg0 = fnc.getArg(0).makeElaborator().elaborateForItem();
            ItemEvaluator arg1 = fnc.getArg(1).makeElaborator().elaborateForItem();
            return (context, pul) -> {
                String abs;
                NodeInfo node = (NodeInfo)arg0.eval(context);
                int kind = node.getNodeKind();
                if (kind != 1 && kind != 9) {
                    throw new XPathException("Node in put() must be a document or element node", "FOUP0001", context);
                }
                String relative = arg1.eval(context).getStringValue();
                try {
                    URI resolved = ResolveURI.makeAbsolute(relative, targetFunction.getStaticBaseUriString());
                    abs = resolved.toString();
                }
                catch (URISyntaxException err) {
                    throw new XPathException("Base URI " + Err.wrap(targetFunction.getStaticBaseUriString()) + " is invalid: " + err.getMessage(), "FOUP0002", context);
                }
                context.getConfiguration().getLogger().info("fn:put writing to " + abs);
                pul.addPutAction(node, abs, fnc);
            };
        }
    }
}

