/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.model;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeaturesValidatorKt;
import com.jetbrains.mlapi.model.MLModel;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001b\u0010\u0007\u001a\u00028\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\rH\u0016J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\rH$J\u001b\u0010\u0010\u001a\u00028\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH$\u00a2\u0006\u0002\u0010\u000bJ&\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0003\"\b\b\u0001\u0010\u0012*\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/mlapi/model/MLModelBase;", "P", "", "Lcom/jetbrains/mlapi/model/MLModel;", "()V", "close", "", "predict", "features", "", "Lcom/jetbrains/mlapi/feature/Feature;", "(Ljava/util/Collection;)Ljava/lang/Object;", "predictBatch", "", "featuresBatch", "predictBatchWithInputFeatures", "predictWithInputFeatures", "predictingType", "T", "predictionClass", "Lkotlin/reflect/KClass;", "mlapi-core"})
public abstract class MLModelBase<P>
implements MLModel<P> {
    @NotNull
    protected abstract P predictWithInputFeatures(@NotNull Collection<? extends Feature> var1);

    @NotNull
    protected abstract List<P> predictBatchWithInputFeatures(@NotNull List<? extends Collection<? extends Feature>> var1);

    @Override
    @NotNull
    public P predict(@NotNull Collection<? extends Feature> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        FeaturesValidatorKt.validateRow(this.getInputFeatures(), features);
        return this.predictWithInputFeatures(features);
    }

    @Override
    @NotNull
    public List<P> predictBatch(@NotNull List<? extends Collection<? extends Feature>> featuresBatch) {
        Intrinsics.checkNotNullParameter(featuresBatch, (String)"featuresBatch");
        FeaturesValidatorKt.validateBatch(this.getInputFeatures(), featuresBatch);
        return this.predictBatchWithInputFeatures(featuresBatch);
    }

    @Override
    @NotNull
    public <T> MLModel<T> predictingType(@NotNull KClass<T> predictionClass) {
        Intrinsics.checkNotNullParameter(predictionClass, (String)"predictionClass");
        if (!JvmClassMappingKt.getJavaClass(predictionClass).isAssignableFrom(this.getPredictedType())) {
            boolean bl = false;
            String string = "ML model predicts " + this.getPredictedType().getName() + ", which is not a kind of " + JvmClassMappingKt.getJavaClass(predictionClass).getName();
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.jetbrains.mlapi.model.MLModel<T of com.jetbrains.mlapi.model.MLModelBase.predictingType>");
        return this;
    }

    @Override
    public void close() {
    }
}

