/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature.json;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureSignature;
import com.jetbrains.mlapi.feature.PrimitiveType;
import com.jetbrains.mlapi.feature.UnionFeatureSignature;
import com.jetbrains.mlapi.feature.UnionType;
import com.jetbrains.mlapi.feature.json.JsonFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0004H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006'"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonIntegerArrayFeature;", "Lcom/jetbrains/mlapi/feature/Feature$Int32Embedding;", "Lcom/jetbrains/mlapi/feature/Feature$Int64Embedding;", "name", "", "elements", "", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Integer;", "(Ljava/lang/String;Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "int32Array", "", "getInt32Array", "()[I", "int64Array", "", "getInt64Array", "()[J", "integersAsStrings", "getIntegersAsStrings", "length", "", "getLength", "()I", "signature", "Lcom/jetbrains/mlapi/feature/FeatureSignature;", "getSignature", "()Lcom/jetbrains/mlapi/feature/FeatureSignature;", "equals", "", "other", "", "hashCode", "toString", "withName", "Lcom/jetbrains/mlapi/feature/Feature;", "newName", "Companion", "mlapi-core"})
@SourceDebugExtension(value={"SMAP\nJsonFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonIntegerArrayFeature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n1549#2:565\n1620#2,3:566\n1549#2:569\n1620#2,3:570\n1549#2:573\n1620#2,3:574\n*S KotlinDebug\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonIntegerArrayFeature\n*L\n164#1:565\n164#1:566,3\n167#1:569\n167#1:570,3\n176#1:573\n176#1:574,3\n*E\n"})
public final class JsonIntegerArrayFeature
implements Feature.Int32Embedding,
Feature.Int64Embedding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<JsonFeature.Integer> elements;
    @NotNull
    private final FeatureSignature signature;
    private final int length;

    public JsonIntegerArrayFeature(@NotNull String name, @NotNull List<JsonFeature.Integer> elements) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.elements = elements;
        this.signature = new UnionFeatureSignature(name, JsonIntegerArrayFeature.Companion.integerArrayType(this.elements), null, 4, null);
        this.length = this.elements.size();
    }

    @NotNull
    public final List<JsonFeature.Integer> getElements() {
        return this.elements;
    }

    @Override
    @NotNull
    public FeatureSignature getSignature() {
        return this.signature;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public int[] getInt32Array() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonFeature.Integer integer = (JsonFeature.Integer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.parseInt(it.getNumberString()));
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public long[] getInt64Array() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonFeature.Integer integer = (JsonFeature.Integer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Long.parseLong(it.getNumberString()));
        }
        return CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public Feature withName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new JsonIntegerArrayFeature(newName, this.elements);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getIntegersAsStrings() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonFeature.Integer integer = (JsonFeature.Integer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getNumberString());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return this.getName() + "(json-integer-array)=" + this.elements;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.mlapi.feature.json.JsonIntegerArrayFeature");
        JsonIntegerArrayFeature cfr_ignored_0 = (JsonIntegerArrayFeature)other;
        if (!Intrinsics.areEqual(this.elements, ((JsonIntegerArrayFeature)other).elements)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getSignature(), (Object)((JsonIntegerArrayFeature)other).getSignature());
    }

    public int hashCode() {
        int result = ((Object)this.elements).hashCode();
        result = 31 * result + this.getSignature().hashCode();
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonIntegerArrayFeature$Companion;", "", "()V", "integerArrayType", "Lcom/jetbrains/mlapi/feature/UnionType;", "elements", "", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Integer;", "mlapi-core"})
    public static final class Companion {
        private Companion() {
        }

        private final UnionType integerArrayType(List<JsonFeature.Integer> elements) {
            PrimitiveType[] primitiveTypeArray = new PrimitiveType[]{new PrimitiveType.EmbeddingInt32(elements.size()), new PrimitiveType.EmbeddingInt64(elements.size())};
            return new UnionType(primitiveTypeArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

