/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class RevertAllUnchangedFilesAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RevertAllUnchangedFilesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        List files;
        if (e == null) {
            RevertAllUnchangedFilesAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setVisible(false);
            return;
        }
        CheckinProjectPanel panel = (CheckinProjectPanel)ObjectUtils.tryCast((Object)e.getData(Refreshable.PANEL_KEY), CheckinProjectPanel.class);
        boolean visible = panel != null ? panel.vcsIsAffected("Perforce") : !(files = VcsContextUtil.selectedFiles((DataContext)e.getDataContext())).isEmpty() && RevertAllUnchangedFilesAction.hasFilesUnderPerforce(files, project);
        presentation.setVisible(visible);
        presentation.setEnabled(PerforceSettings.getSettings((Project)project).ENABLED);
    }

    private static boolean hasFilesUnderPerforce(Collection<VirtualFile> roots, Project project) {
        return !RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project).isEmpty();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertAllUnchangedFilesAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        CheckinProjectPanel panel = (CheckinProjectPanel)ObjectUtils.tryCast((Object)e.getData(Refreshable.PANEL_KEY), CheckinProjectPanel.class);
        Collection roots = panel != null ? panel.getRoots() : VcsContextUtil.selectedFiles((DataContext)e.getDataContext());
        ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments());
        RevertAllUnchangedFilesAction.revertUnchanged(project, roots, panel, changeLists);
    }

    public static void revertUnchanged(Project project, Collection<VirtualFile> roots, @Nullable CheckinProjectPanel panel, ChangeList @Nullable [] selection) {
        ArrayList exceptions = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (selection != null && selection.length > 0 && RevertAllUnchangedFilesAction.revertChangeLists(project, selection, exceptions)) {
                return;
            }
            RevertAllUnchangedFilesAction.revertFiles(roots, project, exceptions);
        }, PerforceBundle.message("message.title.revert.unchanged", new Object[0]), false, project);
        RevertAllUnchangedFilesAction.refreshAndDirty(project, roots);
        if (panel != null) {
            panel.restoreState();
        }
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, PerforceBundle.message("message.title.revert.unchanged.files", new Object[0]));
        }
    }

    private static void refreshAndDirty(Project project, Collection<VirtualFile> roots) {
        VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])roots.toArray(VirtualFile.EMPTY_ARRAY));
        if (RevertAllUnchangedFilesAction.hasDirectories(roots)) {
            VirtualFileManager.getInstance().asyncRefresh(() -> {
                P4File.invalidateFstat(project);
                VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
            });
        } else {
            for (VirtualFile vFile : RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project)) {
                ApplicationManager.getApplication().runWriteAction(() -> vFile.refresh(false, false));
                P4File.invalidateFstat(vFile);
                if (vFile.isDirectory()) {
                    VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(vFile);
                    continue;
                }
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(vFile);
            }
        }
    }

    private static boolean hasDirectories(Collection<VirtualFile> roots) {
        return ContainerUtil.find(roots, file -> file.isDirectory()) != null;
    }

    private static void revertFiles(Collection<VirtualFile> roots, Project project, List<VcsException> exceptions) {
        List<VirtualFile> files = RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project);
        MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(files, project);
        for (P4Connection connection : map.keySet()) {
            try {
                List paths = ContainerUtil.map((Collection)map.get((Object)connection), file -> P4File.create(file).getRecursivePath());
                PerforceRunner.getInstance(project).revertUnchanged(connection, paths);
            }
            catch (VcsException e1) {
                exceptions.add(e1);
            }
        }
    }

    private static @Unmodifiable List<VirtualFile> findFilesUnderPerforce(Collection<VirtualFile> roots, Project project) {
        PerforceVcs vcs = PerforceVcs.getInstance(project);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return ContainerUtil.findAll(roots, file -> vcsManager.getVcsFor(file) == vcs);
    }

    private static boolean revertChangeLists(Project project, ChangeList[] selectedChangeLists, List<VcsException> exceptions) {
        boolean foundAll = true;
        PerforceNumberNameSynchronizer synchronizer = PerforceNumberNameSynchronizer.getInstance(project);
        Collection<P4Connection> connectionList = PerforceSettings.getSettings(project).getAllConnections();
        HashSet<Pair> numbers = new HashSet<Pair>();
        for (P4Connection connection : connectionList) {
            try {
                PerforceManager.ensureValidClient(project, connection);
            }
            catch (VcsException e) {
                exceptions.add(e);
                continue;
            }
            ConnectionKey connectionKey = connection.getConnectionKey();
            for (ChangeList changeList : selectedChangeLists) {
                Long number = synchronizer.getNumber(connectionKey, changeList.getName());
                if (number != null) {
                    numbers.add(Pair.create((Object)number, (Object)connection));
                    continue;
                }
                foundAll = false;
            }
        }
        for (Pair pair : numbers) {
            try {
                PerforceRunner.getInstance(project).revertUnchanged((P4Connection)pair.getSecond(), (Long)pair.getFirst());
            }
            catch (VcsException e1) {
                exceptions.add(e1);
            }
        }
        return foundAll;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/actions/RevertAllUnchangedFilesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/actions/RevertAllUnchangedFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

