/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Transform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0019\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000bH\u0016J\u0017\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0017\u0010\u0016\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/ContinuousTransformWithLimits;", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "actual", "lowerLimit", "", "upperLimit", "(Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;Ljava/lang/Double;Ljava/lang/Double;)V", "Ljava/lang/Double;", "apply", "v", "(Ljava/lang/Double;)Ljava/lang/Double;", "", "l", "applyInverse", "createApplicableDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "middle", "(Ljava/lang/Double;)Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "definedLimits", "Lkotlin/Pair;", "hasDomainLimits", "", "isInDomain", "(Ljava/lang/Double;)Z", "toApplicableDomain", "range", "unwrap", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "plot-base"})
@SourceDebugExtension(value={"SMAP\nContinuousTransformWithLimits.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContinuousTransformWithLimits.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/ContinuousTransformWithLimits\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class ContinuousTransformWithLimits
implements ContinuousTransform {
    @NotNull
    private final ContinuousTransform actual;
    @Nullable
    private final Double lowerLimit;
    @Nullable
    private final Double upperLimit;

    public ContinuousTransformWithLimits(@NotNull ContinuousTransform actual, @Nullable Double lowerLimit, @Nullable Double upperLimit) {
        double d;
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        this.actual = actual;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        if (!(this.lowerLimit != null || this.upperLimit != null)) {
            boolean $i$a$-check-ContinuousTransformWithLimits$72 = false;
            String $i$a$-check-ContinuousTransformWithLimits$72 = "Continuous transform: undefined limit.";
            throw new IllegalStateException($i$a$-check-ContinuousTransformWithLimits$72.toString());
        }
        if (this.lowerLimit != null) {
            d = this.lowerLimit;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                boolean $i$a$-check-ContinuousTransformWithLimits$82 = false;
                String $i$a$-check-ContinuousTransformWithLimits$82 = "Continuous transform lower limit: " + this.lowerLimit + '.';
                throw new IllegalStateException($i$a$-check-ContinuousTransformWithLimits$82.toString());
            }
            if (!this.actual.isInDomain(this.lowerLimit)) {
                boolean $i$a$-check-ContinuousTransformWithLimits$92 = false;
                String $i$a$-check-ContinuousTransformWithLimits$92 = "Lower limit: " + this.lowerLimit + " is outside of " + Reflection.getOrCreateKotlinClass(this.actual.getClass()).getSimpleName() + " domain.";
                throw new IllegalStateException($i$a$-check-ContinuousTransformWithLimits$92.toString());
            }
        }
        if (this.upperLimit != null) {
            d = this.upperLimit;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                boolean $i$a$-check-ContinuousTransformWithLimits$102 = false;
                String $i$a$-check-ContinuousTransformWithLimits$102 = "Continuous transform upper limit: " + this.upperLimit;
                throw new IllegalStateException($i$a$-check-ContinuousTransformWithLimits$102.toString());
            }
            if (!this.actual.isInDomain(this.upperLimit)) {
                boolean $i$a$-check-ContinuousTransformWithLimits$112 = false;
                String $i$a$-check-ContinuousTransformWithLimits$112 = "Upper limit: " + this.upperLimit + " is outside of " + Reflection.getOrCreateKotlinClass(this.actual.getClass()).getSimpleName() + " domain.";
                throw new IllegalStateException($i$a$-check-ContinuousTransformWithLimits$112.toString());
            }
        }
        if (!(this.lowerLimit == null || this.upperLimit == null || this.upperLimit >= this.lowerLimit)) {
            boolean bl = false;
            String string = "Continuous transform limits: lower (" + this.lowerLimit + ") > upper (" + this.upperLimit + ')';
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ ContinuousTransformWithLimits(ContinuousTransform continuousTransform, Double d, Double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = null;
        }
        if ((n & 4) != 0) {
            d2 = null;
        }
        this(continuousTransform, d, d2);
    }

    @Override
    public boolean hasDomainLimits() {
        return true;
    }

    @Override
    public boolean isInDomain(@Nullable Double v) {
        double d;
        if (v == null || !(!Double.isInfinite(d = v.doubleValue()) && !Double.isNaN(d))) {
            return false;
        }
        if (this.lowerLimit != null && v < this.lowerLimit) {
            return false;
        }
        if (this.upperLimit != null && v > this.upperLimit) {
            return false;
        }
        return this.actual.isInDomain(v);
    }

    @Override
    @Nullable
    public Double apply(@Nullable Double v) {
        return this.actual.apply(v);
    }

    @Override
    @NotNull
    public List<Double> apply(@NotNull List<?> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        return this.actual.apply(l);
    }

    @Override
    @Nullable
    public Double applyInverse(@Nullable Double v) {
        return this.actual.applyInverse(v);
    }

    @Override
    @NotNull
    public List<Double> applyInverse(@NotNull List<Double> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        return this.actual.applyInverse(l);
    }

    @Override
    @NotNull
    public DoubleSpan createApplicableDomain(@Nullable Double middle) {
        return this.actual.createApplicableDomain(middle);
    }

    @Override
    @NotNull
    public DoubleSpan toApplicableDomain(@NotNull DoubleSpan range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.actual.toApplicableDomain(range);
    }

    @Override
    @NotNull
    public Transform unwrap() {
        return this.actual.unwrap();
    }

    @Override
    @NotNull
    public Pair<Double, Double> definedLimits() {
        return new Pair((Object)this.lowerLimit, (Object)this.upperLimit);
    }

    @Override
    public boolean isInDomain(@Nullable Object v) {
        return ContinuousTransform.DefaultImpls.isInDomain(this, v);
    }

    @Override
    @Nullable
    public DoubleSpan applyInverse(@NotNull DoubleSpan span) {
        return ContinuousTransform.DefaultImpls.applyInverse(this, span);
    }
}

