/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2.modules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationWithSdk;
import org.jetbrains.kotlin.idea.core.script.k2.configurations.ScriptIdeKeysKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00a6@\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/modules/ScriptWorkspaceModelManager;", "", "updateWorkspaceModel", "", "configurationPerFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptConfigurationWithSdk;", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isModuleExist", "", "project", "Lcom/intellij/openapi/project/Project;", "scriptFile", "definition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getModuleId", "Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "kotlin.base.scripting.k2"})
public interface ScriptWorkspaceModelManager {
    @Nullable
    public Object updateWorkspaceModel(@NotNull Map<VirtualFile, ScriptConfigurationWithSdk> var1, @NotNull Continuation<? super Unit> var2);

    default public boolean isModuleExist(@NotNull Project project, @NotNull VirtualFile scriptFile, @NotNull ScriptDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)((Object)definition), (String)"definition");
        return WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot().contains((SymbolicEntityId)this.getModuleId(project, scriptFile, definition));
    }

    @NotNull
    default public ModuleId getModuleId(@NotNull Project project, @NotNull VirtualFile scriptFile, @NotNull ScriptDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)((Object)definition), (String)"definition");
        String scriptModuleLocation = ScriptIdeKeysKt.scriptModuleRelativeLocation(project, scriptFile);
        return new ModuleId("kotlin.scripts." + definition.getName() + "." + scriptModuleLocation);
    }
}

