/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.CodeInsightFrontbackUtil;
import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaCaseBlockMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        LineRange range2;
        PsiElement lastToMove2;
        PsiElement firstToMove2;
        if (editor == null) {
            JavaCaseBlockMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaCaseBlockMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            JavaCaseBlockMover.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        Document document = editor.getDocument();
        int startOffset = document.getLineStartOffset(info.toMove.startLine);
        int endOffset = JavaCaseBlockMover.getLineStartSafeOffset((Document)document, (int)info.toMove.endLine);
        SmartList statements = new SmartList();
        PsiElement firstElement = null;
        for (PsiElement element : CodeInsightFrontbackUtil.findStatementsInRange(file, startOffset, endOffset)) {
            if (element instanceof PsiSwitchLabelStatement) {
                statements.add((PsiSwitchLabelStatement)element);
                continue;
            }
            if (!statements.isEmpty()) continue;
            firstElement = element;
        }
        if (statements.isEmpty()) {
            return false;
        }
        if (firstElement != null) {
            return info.prohibitMove();
        }
        PsiSwitchLabelStatement firstToMove = JavaCaseBlockMover.getThisCaseBlockStart((PsiSwitchLabelStatement)statements.get(0));
        PsiSwitchLabelStatement lastStatement = (PsiSwitchLabelStatement)statements.get(statements.size() - 1);
        PsiElement nextCaseBlockStart = JavaCaseBlockMover.getNextCaseBlockStart(lastStatement);
        PsiElement lastToMove = PsiTreeUtil.skipWhitespacesBackward((PsiElement)nextCaseBlockStart);
        assert (lastToMove != null);
        LineRange range = JavaCaseBlockMover.createRange(document, firstToMove, lastToMove);
        if (range == null) {
            return info.prohibitMove();
        }
        info.toMove = range;
        if (down) {
            if (!(nextCaseBlockStart instanceof PsiSwitchLabelStatement) || nextCaseBlockStart == lastStatement) {
                return info.prohibitMove();
            }
            firstToMove2 = nextCaseBlockStart;
            nextCaseBlockStart = JavaCaseBlockMover.getNextCaseBlockStart((PsiSwitchLabelStatement)firstToMove2);
            lastToMove2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)nextCaseBlockStart);
            assert (lastToMove2 != null);
        } else {
            lastToMove2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstToMove);
            if (lastToMove2 == null) {
                return info.prohibitMove();
            }
            firstToMove2 = PsiTreeUtil.getPrevSiblingOfType((PsiElement)lastToMove2, PsiSwitchLabelStatement.class);
            if (firstToMove2 == null) {
                return info.prohibitMove();
            }
            firstToMove2 = JavaCaseBlockMover.getThisCaseBlockStart((PsiSwitchLabelStatement)firstToMove2);
        }
        if ((range2 = JavaCaseBlockMover.createRange(document, firstToMove2, lastToMove2)) == null) {
            return info.prohibitMove();
        }
        info.toMove2 = range2;
        return true;
    }

    @NotNull
    private static PsiSwitchLabelStatement getThisCaseBlockStart(PsiSwitchLabelStatement element) {
        PsiElement tmp;
        while ((tmp = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element)) instanceof PsiSwitchLabelStatement) {
            element = (PsiSwitchLabelStatement)tmp;
        }
        PsiSwitchLabelStatement psiSwitchLabelStatement = element;
        if (psiSwitchLabelStatement == null) {
            JavaCaseBlockMover.$$$reportNull$$$0(3);
        }
        return psiSwitchLabelStatement;
    }

    @NotNull
    private static PsiElement getNextCaseBlockStart(PsiSwitchLabelStatement element) {
        PsiElement tmp;
        PsiSwitchLabelStatement result = element;
        while ((tmp = PsiTreeUtil.skipWhitespacesForward((PsiElement)result)) instanceof PsiSwitchLabelStatement) {
            result = tmp;
        }
        tmp = PsiTreeUtil.getNextSiblingOfType((PsiElement)result, PsiSwitchLabelStatement.class);
        PsiElement psiElement = tmp == null ? result.getParent().getLastChild() : tmp;
        if (psiElement == null) {
            JavaCaseBlockMover.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Nullable
    private static LineRange createRange(@NotNull Document document, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        int endLine;
        int startOffset;
        int startLine;
        CharSequence text;
        if (document == null) {
            JavaCaseBlockMover.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            JavaCaseBlockMover.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            JavaCaseBlockMover.$$$reportNull$$$0(7);
        }
        if (!CharArrayUtil.isEmptyOrSpaces((CharSequence)(text = document.getImmutableCharSequence()), (int)document.getLineStartOffset(startLine = document.getLineNumber(startOffset = startElement.getTextRange().getStartOffset())), (int)startOffset)) {
            return null;
        }
        int endOffset = endElement.getTextRange().getEndOffset();
        if (!CharArrayUtil.isEmptyOrSpaces((CharSequence)text, (int)endOffset, (int)document.getLineEndOffset(endLine = document.getLineNumber(endOffset)))) {
            return null;
        }
        return new LineRange(startLine, endLine + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/moveUpDown/JavaCaseBlockMover";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/moveUpDown/JavaCaseBlockMover";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThisCaseBlockStart";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextCaseBlockStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

