/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.tree.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.DependencySourceService;
import com.intellij.packageChecker.PackageUtilKt;
import com.intellij.packageChecker.RegistryKeys;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.Severity;
import com.intellij.packageChecker.model.SeverityFactory;
import com.intellij.packageChecker.service.Checked;
import com.intellij.packageChecker.service.Malicious;
import com.intellij.packageChecker.service.PackageChecker;
import com.intellij.packageChecker.service.PackageStatus;
import com.intellij.packageChecker.service.Safe;
import com.intellij.packageChecker.service.Unchecked;
import com.intellij.packageChecker.service.Vulnerable;
import com.intellij.packageChecker.toolwindow.tree.nodes.State;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u0018\u0000 /2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001/B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0014J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#H\u0014\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001cH\u0002J\u0006\u0010)\u001a\u00020\u001eJ\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/packageChecker/toolwindow/tree/nodes/DependencyNode;", "Lcom/intellij/ui/treeStructure/CachingSimpleNode;", "Lkotlinx/coroutines/CoroutineScope;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "parentNode", "Lcom/intellij/ui/treeStructure/SimpleNode;", "dependency", "Lcom/intellij/packageChecker/model/Dependency;", "parentCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/treeStructure/SimpleNode;Lcom/intellij/packageChecker/model/Dependency;Lkotlin/coroutines/CoroutineContext;)V", "getDependency", "()Lcom/intellij/packageChecker/model/Dependency;", "remainedAttempts", "Ljava/util/concurrent/atomic/AtomicInteger;", "isUpdating", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentUpdateInterval", "Ljava/util/concurrent/atomic/AtomicLong;", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "state", "Lcom/intellij/packageChecker/toolwindow/tree/nodes/State;", "endUpdating", "", "updateState", "", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "buildChildren", "", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "vulnerableChild", "hasVulnerability", "distinctVulnerablePackages", "", "Lcom/intellij/packageChecker/model/Package;", "vulnerablePackages", "", "Companion", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nDependencyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyNode.kt\ncom/intellij/packageChecker/toolwindow/tree/nodes/DependencyNode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,186:1\n11546#2,9:187\n13472#2:196\n13473#2:198\n11555#2:199\n13472#2,2:222\n1#3:197\n1999#4,14:200\n1563#4:214\n1634#4,3:215\n37#5:218\n36#5,3:219\n*S KotlinDebug\n*F\n+ 1 DependencyNode.kt\ncom/intellij/packageChecker/toolwindow/tree/nodes/DependencyNode\n*L\n79#1:187,9\n79#1:196\n79#1:198\n79#1:199\n151#1:222,2\n79#1:197\n81#1:200,14\n113#1:214\n113#1:215,3\n115#1:218\n115#1:219,3\n*E\n"})
public final class DependencyNode
extends CachingSimpleNode
implements CoroutineScope,
UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Dependency dependency;
    @NotNull
    private final AtomicInteger remainedAttempts;
    @NotNull
    private final AtomicBoolean isUpdating;
    @NotNull
    private AtomicLong currentUpdateInterval;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private State state;
    @NotNull
    private static final Severity defaultSeverity = SeverityFactory.Companion.fromScore(0.0f);
    private static final long initialUpdateInterval = RegistryKeys.INSTANCE.getInitialDependencyNodeUpdateInterval();
    private static final long stepForUpdateInterval = RegistryKeys.INSTANCE.getStepForDependencyNodeUpdateInterval();
    private static final int MAXIMUM_NUMBER_OF_UPDATING_ATTEMPTS = 4;

    public DependencyNode(@NotNull Project project, @NotNull SimpleNode parentNode, @NotNull Dependency dependency, @NotNull CoroutineContext parentCoroutineContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineContext, (String)"parentCoroutineContext");
        super(project, (NodeDescriptor)parentNode);
        this.dependency = dependency;
        this.remainedAttempts = new AtomicInteger(4);
        this.isUpdating = new AtomicBoolean(false);
        this.currentUpdateInterval = new AtomicLong(initialUpdateInterval);
        this.coroutineContext = parentCoroutineContext.plus((CoroutineContext)new CoroutineName("PackageChecker.Toolwindow.DependencyNode"));
        this.state = new State(false, false, new Unchecked(this.dependency.getPkg()), null);
        this.updateState(project);
    }

    @NotNull
    public final Dependency getDependency() {
        return this.dependency;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private final void endUpdating() {
        this.isUpdating.set(false);
        this.remainedAttempts.set(4);
        this.currentUpdateInterval.set(initialUpdateInterval);
        this.cleanUpCache();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateState(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.isUpdating.set(true);
        PackageStatus packageStatus = PackageChecker.Companion.getInstance(project).packageStatus(this.dependency.getPkg());
        State state = this.state;
        boolean hasVulnerability = state.component1();
        boolean hasTransitive = state.component2();
        Severity severity = state.component4();
        if (packageStatus instanceof Checked) {
            Checked checked = (Checked)packageStatus;
            if (checked instanceof Vulnerable) {
                severity = (Severity)ComparisonsKt.maxOf((Object)severity, (Object)((Vulnerable)packageStatus).getMaxSeverity(), (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Severity it = (Severity)a;
                        boolean bl = false;
                        Severity severity = it;
                        it = (Severity)b;
                        Comparable comparable = severity != null ? Float.valueOf(severity.getScore()) : null;
                        bl = false;
                        Severity severity2 = it;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(severity2 != null ? Float.valueOf(severity2.getScore()) : null));
                    }
                });
                hasVulnerability = true;
                SimpleNode simpleNode = this.getParent();
                DependencyNode dependencyNode = simpleNode instanceof DependencyNode ? (DependencyNode)simpleNode : null;
                if (dependencyNode != null) {
                    dependencyNode.vulnerableChild();
                }
            } else if (checked instanceof Malicious) {
                severity = ((Malicious)packageStatus).getMaxSeverity();
                hasVulnerability = true;
            } else if (checked instanceof Safe) {
                Severity severity2;
                Object v3;
                void $this$maxByOrNull$iv;
                void $this$mapNotNullTo$iv$iv;
                hasVulnerability = false;
                SimpleNode[] simpleNodeArray = this.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)simpleNodeArray, (String)"getChildren(...)");
                Object $this$mapNotNull$iv = simpleNodeArray;
                boolean $i$f$mapNotNull = false;
                Object[] objectArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    Severity it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    SimpleNode it = (SimpleNode)element$iv$iv;
                    boolean bl2 = false;
                    Object object = it instanceof DependencyNode ? (DependencyNode)it : null;
                    if ((object != null && (object = object.state) != null ? ((State)object).getMaxSeverity() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v3 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v3 = maxElem$iv;
                    } else {
                        Severity it = (Severity)maxElem$iv;
                        boolean bl = false;
                        float maxValue$iv = it.getScore();
                        do {
                            Object e$iv = iterator$iv.next();
                            Severity it2 = (Severity)e$iv;
                            $i$a$-maxByOrNull-DependencyNode$updateState$3 = false;
                            float v$iv = it2.getScore();
                            if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v3 = maxElem$iv;
                    }
                }
                if ((severity2 = (Severity)v3) == null) {
                    severity2 = defaultSeverity;
                }
                severity = severity2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.state = new State(hasVulnerability, hasTransitive, packageStatus, severity);
        if (!this.state.isNotSet() || this.remainedAttempts.decrementAndGet() <= 0) {
            this.endUpdating();
        } else {
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
                int label;
                final /* synthetic */ DependencyNode this$0;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay((long)DependencyNode.access$getCurrentUpdateInterval$p(this.this$0).getAndAdd(DependencyNode.access$getStepForUpdateInterval$cp()), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.this$0.updateState(this.$project);
                            this.this$0.cleanUpCache();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final boolean isUpdating() {
        return this.isUpdating.get();
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        String humanReadableCoordinates = this.dependency.getPkg().getHumanReadableCoordinates();
        presentation.addText(humanReadableCoordinates, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = PackageUtilKt.dependencyNodeIcon(this.state);
        presentation.setIcon(icon);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected SimpleNode[] buildChildren() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.dependency.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Dependency dependency = (Dependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            collection.add(new DependencyNode(project, (SimpleNode)this, (Dependency)it, this.getCoroutineContext()));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SimpleNode[0]);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = CommonDataKeys.NAVIGATABLE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"NAVIGATABLE");
        sink.lazy(dataKey, () -> DependencyNode.uiDataSnapshot$lambda$4(this));
    }

    private final void vulnerableChild() {
        State state = this.state;
        boolean hasVulnerability = state.component1();
        boolean hasTransitiveVulnerability = state.component2();
        PackageStatus packageStatus = state.component3();
        Severity maxSeverity = state.component4();
        if (hasVulnerability || hasTransitiveVulnerability) {
            return;
        }
        SimpleNode simpleNode = this.getParent();
        DependencyNode dependencyNode = simpleNode instanceof DependencyNode ? (DependencyNode)simpleNode : null;
        if (dependencyNode != null) {
            dependencyNode.vulnerableChild();
        }
        this.state = new State(false, true, packageStatus, maxSeverity);
    }

    public final boolean hasVulnerability() {
        return this.state.getHasVulnerability() || this.state.getHasTransitiveVulnerability();
    }

    @NotNull
    public final Set<Package> distinctVulnerablePackages(@NotNull Set<Package> vulnerablePackages) {
        Intrinsics.checkNotNullParameter(vulnerablePackages, (String)"vulnerablePackages");
        if (this.state.getHasVulnerability()) {
            vulnerablePackages.add(this.dependency.getPkg());
        }
        SimpleNode[] simpleNodeArray = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)simpleNodeArray, (String)"getChildren(...)");
        Object[] $this$forEach$iv = simpleNodeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyNode it;
            SimpleNode it2 = (SimpleNode)element$iv;
            boolean bl = false;
            if ((it2 instanceof DependencyNode ? (DependencyNode)it2 : null) == null) continue;
            it = it;
            boolean bl2 = false;
            vulnerablePackages.addAll((Collection<Package>)it.distinctVulnerablePackages(vulnerablePackages));
        }
        return vulnerablePackages;
    }

    private static final Navigatable uiDataSnapshot$lambda$4(DependencyNode this$0) {
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return DependencySourceService.Companion.getInstance(project).getOrCreateDependencySource(this$0.dependency);
    }

    public static final /* synthetic */ AtomicLong access$getCurrentUpdateInterval$p(DependencyNode $this) {
        return $this.currentUpdateInterval;
    }

    public static final /* synthetic */ long access$getStepForUpdateInterval$cp() {
        return stepForUpdateInterval;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/packageChecker/toolwindow/tree/nodes/DependencyNode$Companion;", "", "<init>", "()V", "defaultSeverity", "Lcom/intellij/packageChecker/model/Severity;", "initialUpdateInterval", "", "stepForUpdateInterval", "MAXIMUM_NUMBER_OF_UPDATING_ATTEMPTS", "", "intellij.packageChecker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

