/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureComputationPolicy;
import com.jetbrains.mlapi.feature.FeatureDeclaration;
import com.jetbrains.mlapi.feature.FeatureSet;
import com.jetbrains.mlapi.feature.FeatureSignature;
import com.jetbrains.mlapi.feature.FeatureSignatureKt;
import com.jetbrains.mlapi.feature.NullFeatureHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0003H\u0002J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/mlapi/feature/FeatureSelector;", "", "featureDeclarations", "", "Lcom/jetbrains/mlapi/feature/FeatureDeclaration;", "featureComputationPolicy", "Lcom/jetbrains/mlapi/feature/FeatureComputationPolicy;", "(Ljava/util/List;Lcom/jetbrains/mlapi/feature/FeatureComputationPolicy;)V", "fillNulls", "Lcom/jetbrains/mlapi/feature/Feature;", "providedFeatures", "", "requiredOutput", "Lcom/jetbrains/mlapi/feature/FeatureSet;", "removeRedundantFeatures", "computedFeaturesWithRedundancies", "requireDeclared", "", "computedFeatures", "selectFeatureList", "", "mlapi-core"})
@SourceDebugExtension(value={"SMAP\nFeatureSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureSelector.kt\ncom/jetbrains/mlapi/feature/FeatureSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n766#2:110\n857#2,2:111\n1477#2:113\n1502#2,3:114\n1505#2,3:124\n1603#2,9:134\n1855#2:143\n1856#2:145\n1612#2:146\n372#3,7:117\n526#3:127\n511#3,6:128\n1#4:144\n*S KotlinDebug\n*F\n+ 1 FeatureSelector.kt\ncom/jetbrains/mlapi/feature/FeatureSelector\n*L\n19#1:110\n19#1:111,2\n70#1:113\n70#1:114,3\n70#1:124,3\n80#1:134,9\n80#1:143\n80#1:145\n80#1:146\n70#1:117,7\n71#1:127\n71#1:128,6\n80#1:144\n*E\n"})
public final class FeatureSelector {
    @NotNull
    private final List<FeatureDeclaration<?>> featureDeclarations;
    @NotNull
    private final FeatureComputationPolicy featureComputationPolicy;

    public FeatureSelector(@NotNull List<? extends FeatureDeclaration<?>> featureDeclarations, @NotNull FeatureComputationPolicy featureComputationPolicy) {
        Intrinsics.checkNotNullParameter(featureDeclarations, (String)"featureDeclarations");
        Intrinsics.checkNotNullParameter((Object)featureComputationPolicy, (String)"featureComputationPolicy");
        this.featureDeclarations = featureDeclarations;
        this.featureComputationPolicy = featureComputationPolicy;
    }

    public /* synthetic */ FeatureSelector(List list, FeatureComputationPolicy featureComputationPolicy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            featureComputationPolicy = FeatureComputationPolicy.Companion.getDEFAULT();
        }
        this(list, featureComputationPolicy);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Feature> selectFeatureList(@NotNull Iterable<? extends Feature> computedFeatures, @NotNull FeatureSet requiredOutput) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(computedFeatures, (String)"computedFeatures");
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        List<Feature> redundanciesFreeFeatures = this.removeRedundantFeatures(requiredOutput, computedFeatures);
        this.requireDeclared(redundanciesFreeFeatures);
        List<Feature> result = this.fillNulls((Iterable<? extends Feature>)redundanciesFreeFeatures, requiredOutput);
        Collection<FeatureSignature> missing = requiredOutput.selectMissingFeatures((Collection<? extends Feature>)result);
        Iterable $this$filter$iv = missing;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FeatureSignature it = (FeatureSignature)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)this.featureDeclarations, (Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List knownAndMissing = (List)destination$iv$iv;
        if (!knownAndMissing.isEmpty()) {
            boolean bl = false;
            String string = StringsKt.trimIndent((String)("\n      Some features were expected, but were not computed:\n        " + missing + "\n    "));
            throw new IllegalArgumentException(string.toString());
        }
        return result;
    }

    private final List<Feature> fillNulls(Iterable<? extends Feature> providedFeatures, FeatureSet requiredOutput) {
        List result = CollectionsKt.toMutableList(providedFeatures);
        for (FeatureDeclaration<?> feature : this.featureDeclarations) {
            if (FeatureSignatureKt.anyMatches(providedFeatures, feature) || !requiredOutput.contains(feature)) continue;
            if (!feature.isNullable()) {
                boolean $i$a$-require-FeatureSelector$fillNulls$32 = false;
                String $i$a$-require-FeatureSelector$fillNulls$32 = StringsKt.trimIndent((String)("\n        Feature " + feature + " should have been computed\n         \n         !!! Solution: If your feature is actually nullable, then declare " + feature + " as nullable, by adding `.nullable()` to the declaration.\n             Then, either pass the `null` value explicitly to the result, or set `FeatureComputationPolicy.putNullImplicitly` to true.\n\n      "));
                throw new IllegalArgumentException($i$a$-require-FeatureSelector$fillNulls$32.toString());
            }
            if (!this.featureComputationPolicy.getPutNullImplicitly()) {
                boolean bl = false;
                String string = StringsKt.trimIndent((String)("\n        Feature " + feature + " should have been computed.\n        It is nullable, but any value is missing.\n        \n        !!! Solution: Either pass the `null` value to the result explicitly,\n            or set `FeatureComputationPolicy.putNullImplicitly` to true\n  \n      "));
                throw new IllegalArgumentException(string.toString());
            }
            NullFeatureHolder nullFeature = new NullFeatureHolder(feature);
            result.add(nullFeature);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Feature> removeRedundantFeatures(FeatureSet requiredOutput, Iterable<? extends Feature> computedFeaturesWithRedundancies) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable<? extends Feature> $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable<? extends Feature> iterable = computedFeaturesWithRedundancies;
        boolean $i$f$groupBy = false;
        void var6_6 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Feature it = (Feature)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            object = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            List features = (List)object.getValue();
            if (!(features.size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object duplicates = destination$iv$iv;
        if (!duplicates.isEmpty()) {
            boolean $i$a$-require-FeatureSelector$removeRedundantFeatures$22 = false;
            String $i$a$-require-FeatureSelector$removeRedundantFeatures$22 = StringsKt.trimIndent((String)("\n      " + this + " has produced duplicate features:\n        " + (Map)duplicates + "\n    "));
            throw new IllegalArgumentException($i$a$-require-FeatureSelector$removeRedundantFeatures$22.toString());
        }
        Iterable<? extends Feature> $this$mapNotNull$iv = computedFeaturesWithRedundancies;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Feature feature;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Feature computedFeature = (Feature)element$iv$iv;
            boolean bl3 = false;
            if (!requiredOutput.contains(computedFeature.getSignature())) {
                if (!this.featureComputationPolicy.getTolerateRedundantFeatures()) {
                    throw new IllegalArgumentException(StringsKt.trimIndent((String)("\n              Feature " + computedFeature + " must not have been computed.\n\n                !!! Solution: You could set FeatureComputationPolicy.tolerateRedundantFeatures to true, if this provider computes lightweight features,\n                and redundantly computed features could be tolerated.\n\n            ")));
                }
                feature = null;
            } else {
                feature = computedFeature;
            }
            if (feature == null) continue;
            Feature it$iv$iv = feature;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void requireDeclared(List<? extends Feature> computedFeatures) {
        for (Feature feature : computedFeatures) {
            if (FeatureSignatureKt.isDeclaredBy(feature, (Iterable<? extends FeatureSignature>)this.featureDeclarations)) continue;
            boolean bl = false;
            String string = "Feature " + feature + " has been computed, but was not declared by " + this.featureDeclarations;
            throw new IllegalArgumentException(string.toString());
        }
    }
}

