// Code generated by github.com/jmattheis/goverter, DO NOT EDIT.
//go:build !goverter

package hcloud

import (
	schema "github.com/hetznercloud/hcloud-go/v2/hcloud/schema"
	"net"
	"time"
)

type converterImpl struct{}

func (c *converterImpl) ActionFromSchema(source schema.Action) *Action {
	var hcloudAction Action
	hcloudAction.ID = source.ID
	hcloudAction.Status = ActionStatus(source.Status)
	hcloudAction.Command = source.Command
	hcloudAction.Progress = source.Progress
	hcloudAction.Started = source.Started
	hcloudAction.Finished = c.pTimeTimeToTimeTime(source.Finished)
	var pString *string
	if source.Error != nil {
		pString = &source.Error.Code
	}
	if pString != nil {
		hcloudAction.ErrorCode = *pString
	}
	var pString2 *string
	if source.Error != nil {
		pString2 = &source.Error.Message
	}
	if pString2 != nil {
		hcloudAction.ErrorMessage = *pString2
	}
	if source.Resources != nil {
		hcloudAction.Resources = make([]*ActionResource, len(source.Resources))
		for i := 0; i < len(source.Resources); i++ {
			hcloudAction.Resources[i] = c.schemaActionResourceReferenceToPHcloudActionResource(source.Resources[i])
		}
	}
	return &hcloudAction
}
func (c *converterImpl) ActionsFromSchema(source []schema.Action) []*Action {
	var pHcloudActionList []*Action
	if source != nil {
		pHcloudActionList = make([]*Action, len(source))
		for i := 0; i < len(source); i++ {
			pHcloudActionList[i] = c.ActionFromSchema(source[i])
		}
	}
	return pHcloudActionList
}
func (c *converterImpl) CertificateFromSchema(source schema.Certificate) *Certificate {
	var hcloudCertificate Certificate
	hcloudCertificate.ID = source.ID
	hcloudCertificate.Name = source.Name
	hcloudCertificate.Labels = source.Labels
	hcloudCertificate.Type = CertificateType(source.Type)
	hcloudCertificate.Certificate = source.Certificate
	hcloudCertificate.Created = c.timeTimeToTimeTime(source.Created)
	hcloudCertificate.NotValidBefore = c.timeTimeToTimeTime(source.NotValidBefore)
	hcloudCertificate.NotValidAfter = c.timeTimeToTimeTime(source.NotValidAfter)
	hcloudCertificate.DomainNames = source.DomainNames
	hcloudCertificate.Fingerprint = source.Fingerprint
	hcloudCertificate.Status = c.pSchemaCertificateStatusRefToPHcloudCertificateStatus(source.Status)
	if source.UsedBy != nil {
		hcloudCertificate.UsedBy = make([]CertificateUsedByRef, len(source.UsedBy))
		for i := 0; i < len(source.UsedBy); i++ {
			hcloudCertificate.UsedBy[i] = c.schemaCertificateUsedByRefToHcloudCertificateUsedByRef(source.UsedBy[i])
		}
	}
	return &hcloudCertificate
}
func (c *converterImpl) DatacenterFromSchema(source schema.Datacenter) *Datacenter {
	var hcloudDatacenter Datacenter
	hcloudDatacenter.ID = source.ID
	hcloudDatacenter.Name = source.Name
	hcloudDatacenter.Description = source.Description
	hcloudDatacenter.Location = c.LocationFromSchema(source.Location)
	hcloudDatacenter.ServerTypes = c.schemaDatacenterServerTypesToHcloudDatacenterServerTypes(source.ServerTypes)
	return &hcloudDatacenter
}
func (c *converterImpl) DeprecationFromSchema(source *schema.DeprecationInfo) *DeprecationInfo {
	var pHcloudDeprecationInfo *DeprecationInfo
	if source != nil {
		var hcloudDeprecationInfo DeprecationInfo
		hcloudDeprecationInfo.Announced = c.timeTimeToTimeTime((*source).Announced)
		hcloudDeprecationInfo.UnavailableAfter = c.timeTimeToTimeTime((*source).UnavailableAfter)
		pHcloudDeprecationInfo = &hcloudDeprecationInfo
	}
	return pHcloudDeprecationInfo
}
func (c *converterImpl) ErrorFromSchema(source schema.Error) Error {
	var hcloudError Error
	hcloudError.Code = ErrorCode(source.Code)
	hcloudError.Message = source.Message
	hcloudError.Details = errorDetailsFromSchema(source.Details)
	return hcloudError
}
func (c *converterImpl) FirewallFromSchema(source schema.Firewall) *Firewall {
	var hcloudFirewall Firewall
	hcloudFirewall.ID = source.ID
	hcloudFirewall.Name = source.Name
	hcloudFirewall.Labels = source.Labels
	hcloudFirewall.Created = c.timeTimeToTimeTime(source.Created)
	if source.Rules != nil {
		hcloudFirewall.Rules = make([]FirewallRule, len(source.Rules))
		for i := 0; i < len(source.Rules); i++ {
			hcloudFirewall.Rules[i] = c.schemaFirewallRuleToHcloudFirewallRule(source.Rules[i])
		}
	}
	if source.AppliedTo != nil {
		hcloudFirewall.AppliedTo = make([]FirewallResource, len(source.AppliedTo))
		for j := 0; j < len(source.AppliedTo); j++ {
			hcloudFirewall.AppliedTo[j] = c.schemaFirewallResourceToHcloudFirewallResource(source.AppliedTo[j])
		}
	}
	return &hcloudFirewall
}
func (c *converterImpl) FloatingIPFromSchema(source schema.FloatingIP) *FloatingIP {
	var hcloudFloatingIP FloatingIP
	hcloudFloatingIP.ID = source.ID
	if source.Description != nil {
		hcloudFloatingIP.Description = *source.Description
	}
	hcloudFloatingIP.Created = c.timeTimeToTimeTime(source.Created)
	hcloudFloatingIP.IP = ipFromFloatingIPSchema(source)
	hcloudFloatingIP.Network = networkFromFloatingIPSchema(source)
	hcloudFloatingIP.Type = FloatingIPType(source.Type)
	if source.Server != nil {
		hcloudServer := serverFromInt64(*source.Server)
		hcloudFloatingIP.Server = &hcloudServer
	}
	hcloudFloatingIP.DNSPtr = mapFromFloatingIPDNSPtrSchema(source.DNSPtr)
	hcloudFloatingIP.HomeLocation = c.LocationFromSchema(source.HomeLocation)
	hcloudFloatingIP.Blocked = source.Blocked
	hcloudFloatingIP.Protection = c.schemaFloatingIPProtectionToHcloudFloatingIPProtection(source.Protection)
	hcloudFloatingIP.Labels = source.Labels
	hcloudFloatingIP.Name = source.Name
	return &hcloudFloatingIP
}
func (c *converterImpl) ISOFromSchema(source schema.ISO) *ISO {
	hcloudISO := c.intISOFromSchema(source)
	return &hcloudISO
}
func (c *converterImpl) ImageFromSchema(source schema.Image) *Image {
	var hcloudImage Image
	hcloudImage.ID = source.ID
	if source.Name != nil {
		hcloudImage.Name = *source.Name
	}
	hcloudImage.Type = ImageType(source.Type)
	hcloudImage.Status = ImageStatus(source.Status)
	hcloudImage.Description = source.Description
	if source.ImageSize != nil {
		hcloudImage.ImageSize = *source.ImageSize
	}
	hcloudImage.DiskSize = source.DiskSize
	hcloudImage.Created = c.pTimeTimeToTimeTime(source.Created)
	hcloudImage.CreatedFrom = c.pSchemaImageCreatedFromToPHcloudServer(source.CreatedFrom)
	if source.BoundTo != nil {
		hcloudServer := serverFromInt64(*source.BoundTo)
		hcloudImage.BoundTo = &hcloudServer
	}
	hcloudImage.RapidDeploy = source.RapidDeploy
	hcloudImage.OSFlavor = source.OSFlavor
	if source.OSVersion != nil {
		hcloudImage.OSVersion = *source.OSVersion
	}
	hcloudImage.Architecture = Architecture(source.Architecture)
	hcloudImage.Protection = c.schemaImageProtectionToHcloudImageProtection(source.Protection)
	hcloudImage.Deprecated = c.pTimeTimeToTimeTime(source.Deprecated)
	hcloudImage.Labels = source.Labels
	hcloudImage.Deleted = c.pTimeTimeToTimeTime(source.Deleted)
	return &hcloudImage
}
func (c *converterImpl) LoadBalancerFromSchema(source schema.LoadBalancer) *LoadBalancer {
	var hcloudLoadBalancer LoadBalancer
	hcloudLoadBalancer.ID = source.ID
	hcloudLoadBalancer.Name = source.Name
	hcloudLoadBalancer.PublicNet = c.schemaLoadBalancerPublicNetToHcloudLoadBalancerPublicNet(source.PublicNet)
	if source.PrivateNet != nil {
		hcloudLoadBalancer.PrivateNet = make([]LoadBalancerPrivateNet, len(source.PrivateNet))
		for i := 0; i < len(source.PrivateNet); i++ {
			hcloudLoadBalancer.PrivateNet[i] = c.schemaLoadBalancerPrivateNetToHcloudLoadBalancerPrivateNet(source.PrivateNet[i])
		}
	}
	hcloudLoadBalancer.Location = c.LocationFromSchema(source.Location)
	hcloudLoadBalancer.LoadBalancerType = c.LoadBalancerTypeFromSchema(source.LoadBalancerType)
	hcloudLoadBalancer.Algorithm = c.schemaLoadBalancerAlgorithmToHcloudLoadBalancerAlgorithm(source.Algorithm)
	if source.Services != nil {
		hcloudLoadBalancer.Services = make([]LoadBalancerService, len(source.Services))
		for j := 0; j < len(source.Services); j++ {
			hcloudLoadBalancer.Services[j] = c.LoadBalancerServiceFromSchema(source.Services[j])
		}
	}
	if source.Targets != nil {
		hcloudLoadBalancer.Targets = make([]LoadBalancerTarget, len(source.Targets))
		for k := 0; k < len(source.Targets); k++ {
			hcloudLoadBalancer.Targets[k] = c.LoadBalancerTargetFromSchema(source.Targets[k])
		}
	}
	hcloudLoadBalancer.Protection = c.schemaLoadBalancerProtectionToHcloudLoadBalancerProtection(source.Protection)
	hcloudLoadBalancer.Labels = source.Labels
	hcloudLoadBalancer.Created = c.timeTimeToTimeTime(source.Created)
	hcloudLoadBalancer.IncludedTraffic = source.IncludedTraffic
	if source.OutgoingTraffic != nil {
		hcloudLoadBalancer.OutgoingTraffic = *source.OutgoingTraffic
	}
	if source.IngoingTraffic != nil {
		hcloudLoadBalancer.IngoingTraffic = *source.IngoingTraffic
	}
	return &hcloudLoadBalancer
}
func (c *converterImpl) LoadBalancerMetricsFromSchema(source *schema.LoadBalancerGetMetricsResponse) (*LoadBalancerMetrics, error) {
	var pHcloudLoadBalancerMetrics *LoadBalancerMetrics
	if source != nil {
		var hcloudLoadBalancerMetrics LoadBalancerMetrics
		hcloudLoadBalancerMetrics.Start = c.timeTimeToTimeTime((*source).Metrics.Start)
		hcloudLoadBalancerMetrics.End = c.timeTimeToTimeTime((*source).Metrics.End)
		hcloudLoadBalancerMetrics.Step = (*source).Metrics.Step
		if (*source).Metrics.TimeSeries != nil {
			hcloudLoadBalancerMetrics.TimeSeries = make(map[string][]LoadBalancerMetricsValue, len((*source).Metrics.TimeSeries))
			for key, value := range (*source).Metrics.TimeSeries {
				hcloudLoadBalancerMetricsValueList, err := loadBalancerMetricsTimeSeriesFromSchema(value)
				if err != nil {
					return nil, err
				}
				hcloudLoadBalancerMetrics.TimeSeries[key] = hcloudLoadBalancerMetricsValueList
			}
		}
		pHcloudLoadBalancerMetrics = &hcloudLoadBalancerMetrics
	}
	return pHcloudLoadBalancerMetrics, nil
}
func (c *converterImpl) LoadBalancerServiceFromSchema(source schema.LoadBalancerService) LoadBalancerService {
	var hcloudLoadBalancerService LoadBalancerService
	hcloudLoadBalancerService.Protocol = LoadBalancerServiceProtocol(source.Protocol)
	hcloudLoadBalancerService.ListenPort = source.ListenPort
	hcloudLoadBalancerService.DestinationPort = source.DestinationPort
	hcloudLoadBalancerService.Proxyprotocol = source.Proxyprotocol
	hcloudLoadBalancerService.HTTP = c.pSchemaLoadBalancerServiceHTTPToHcloudLoadBalancerServiceHTTP(source.HTTP)
	hcloudLoadBalancerService.HealthCheck = c.LoadBalancerServiceHealthCheckFromSchema(source.HealthCheck)
	return hcloudLoadBalancerService
}
func (c *converterImpl) LoadBalancerServiceHealthCheckFromSchema(source *schema.LoadBalancerServiceHealthCheck) LoadBalancerServiceHealthCheck {
	var hcloudLoadBalancerServiceHealthCheck LoadBalancerServiceHealthCheck
	if source != nil {
		var hcloudLoadBalancerServiceHealthCheck2 LoadBalancerServiceHealthCheck
		hcloudLoadBalancerServiceHealthCheck2.Protocol = LoadBalancerServiceProtocol((*source).Protocol)
		hcloudLoadBalancerServiceHealthCheck2.Port = (*source).Port
		hcloudLoadBalancerServiceHealthCheck2.Interval = durationFromIntSeconds((*source).Interval)
		hcloudLoadBalancerServiceHealthCheck2.Timeout = durationFromIntSeconds((*source).Timeout)
		hcloudLoadBalancerServiceHealthCheck2.Retries = (*source).Retries
		hcloudLoadBalancerServiceHealthCheck2.HTTP = c.pSchemaLoadBalancerServiceHealthCheckHTTPToPHcloudLoadBalancerServiceHealthCheckHTTP((*source).HTTP)
		hcloudLoadBalancerServiceHealthCheck = hcloudLoadBalancerServiceHealthCheck2
	}
	return hcloudLoadBalancerServiceHealthCheck
}
func (c *converterImpl) LoadBalancerTargetFromSchema(source schema.LoadBalancerTarget) LoadBalancerTarget {
	var hcloudLoadBalancerTarget LoadBalancerTarget
	hcloudLoadBalancerTarget.Type = LoadBalancerTargetType(source.Type)
	hcloudLoadBalancerTarget.Server = c.pSchemaLoadBalancerTargetServerToPHcloudLoadBalancerTargetServer(source.Server)
	hcloudLoadBalancerTarget.LabelSelector = c.pSchemaLoadBalancerTargetLabelSelectorToPHcloudLoadBalancerTargetLabelSelector(source.LabelSelector)
	hcloudLoadBalancerTarget.IP = c.pSchemaLoadBalancerTargetIPToPHcloudLoadBalancerTargetIP(source.IP)
	if source.HealthStatus != nil {
		hcloudLoadBalancerTarget.HealthStatus = make([]LoadBalancerTargetHealthStatus, len(source.HealthStatus))
		for i := 0; i < len(source.HealthStatus); i++ {
			hcloudLoadBalancerTarget.HealthStatus[i] = c.LoadBalancerTargetHealthStatusFromSchema(source.HealthStatus[i])
		}
	}
	if source.Targets != nil {
		hcloudLoadBalancerTarget.Targets = make([]LoadBalancerTarget, len(source.Targets))
		for j := 0; j < len(source.Targets); j++ {
			hcloudLoadBalancerTarget.Targets[j] = c.LoadBalancerTargetFromSchema(source.Targets[j])
		}
	}
	hcloudLoadBalancerTarget.UsePrivateIP = source.UsePrivateIP
	return hcloudLoadBalancerTarget
}
func (c *converterImpl) LoadBalancerTargetHealthStatusFromSchema(source schema.LoadBalancerTargetHealthStatus) LoadBalancerTargetHealthStatus {
	var hcloudLoadBalancerTargetHealthStatus LoadBalancerTargetHealthStatus
	hcloudLoadBalancerTargetHealthStatus.ListenPort = source.ListenPort
	hcloudLoadBalancerTargetHealthStatus.Status = LoadBalancerTargetHealthStatusStatus(source.Status)
	return hcloudLoadBalancerTargetHealthStatus
}
func (c *converterImpl) LoadBalancerTargetServerFromSchema(source schema.LoadBalancerTargetServer) LoadBalancerTargetServer {
	var hcloudLoadBalancerTargetServer LoadBalancerTargetServer
	hcloudServer := serverFromInt64(source.ID)
	hcloudLoadBalancerTargetServer.Server = &hcloudServer
	return hcloudLoadBalancerTargetServer
}
func (c *converterImpl) LoadBalancerTypeFromSchema(source schema.LoadBalancerType) *LoadBalancerType {
	var hcloudLoadBalancerType LoadBalancerType
	hcloudLoadBalancerType.ID = source.ID
	hcloudLoadBalancerType.Name = source.Name
	hcloudLoadBalancerType.Description = source.Description
	hcloudLoadBalancerType.MaxConnections = source.MaxConnections
	hcloudLoadBalancerType.MaxServices = source.MaxServices
	hcloudLoadBalancerType.MaxTargets = source.MaxTargets
	hcloudLoadBalancerType.MaxAssignedCertificates = source.MaxAssignedCertificates
	if source.Prices != nil {
		hcloudLoadBalancerType.Pricings = make([]LoadBalancerTypeLocationPricing, len(source.Prices))
		for i := 0; i < len(source.Prices); i++ {
			hcloudLoadBalancerType.Pricings[i] = c.LoadBalancerTypeLocationPricingFromSchema(source.Prices[i])
		}
	}
	hcloudLoadBalancerType.Deprecated = source.Deprecated
	return &hcloudLoadBalancerType
}
func (c *converterImpl) LoadBalancerTypeLocationPricingFromSchema(source schema.PricingLoadBalancerTypePrice) LoadBalancerTypeLocationPricing {
	var hcloudLoadBalancerTypeLocationPricing LoadBalancerTypeLocationPricing
	hcloudLocation := locationFromString(source.Location)
	hcloudLoadBalancerTypeLocationPricing.Location = &hcloudLocation
	hcloudLoadBalancerTypeLocationPricing.Hourly = c.PriceFromSchema(source.PriceHourly)
	hcloudLoadBalancerTypeLocationPricing.Monthly = c.PriceFromSchema(source.PriceMonthly)
	hcloudLoadBalancerTypeLocationPricing.IncludedTraffic = source.IncludedTraffic
	hcloudLoadBalancerTypeLocationPricing.PerTBTraffic = c.PriceFromSchema(source.PricePerTBTraffic)
	return hcloudLoadBalancerTypeLocationPricing
}
func (c *converterImpl) LocationFromSchema(source schema.Location) *Location {
	var hcloudLocation Location
	hcloudLocation.ID = source.ID
	hcloudLocation.Name = source.Name
	hcloudLocation.Description = source.Description
	hcloudLocation.Country = source.Country
	hcloudLocation.City = source.City
	hcloudLocation.Latitude = source.Latitude
	hcloudLocation.Longitude = source.Longitude
	hcloudLocation.NetworkZone = NetworkZone(source.NetworkZone)
	return &hcloudLocation
}
func (c *converterImpl) NetworkFromSchema(source schema.Network) *Network {
	var hcloudNetwork Network
	hcloudNetwork.ID = source.ID
	hcloudNetwork.Name = source.Name
	hcloudNetwork.Created = c.timeTimeToTimeTime(source.Created)
	netIPNet := ipNetFromString(source.IPRange)
	hcloudNetwork.IPRange = &netIPNet
	if source.Subnets != nil {
		hcloudNetwork.Subnets = make([]NetworkSubnet, len(source.Subnets))
		for i := 0; i < len(source.Subnets); i++ {
			hcloudNetwork.Subnets[i] = c.NetworkSubnetFromSchema(source.Subnets[i])
		}
	}
	if source.Routes != nil {
		hcloudNetwork.Routes = make([]NetworkRoute, len(source.Routes))
		for j := 0; j < len(source.Routes); j++ {
			hcloudNetwork.Routes[j] = c.NetworkRouteFromSchema(source.Routes[j])
		}
	}
	if source.Servers != nil {
		hcloudNetwork.Servers = make([]*Server, len(source.Servers))
		for k := 0; k < len(source.Servers); k++ {
			hcloudServer := serverFromInt64(source.Servers[k])
			hcloudNetwork.Servers[k] = &hcloudServer
		}
	}
	if source.LoadBalancers != nil {
		hcloudNetwork.LoadBalancers = make([]*LoadBalancer, len(source.LoadBalancers))
		for l := 0; l < len(source.LoadBalancers); l++ {
			hcloudLoadBalancer := loadBalancerFromInt64(source.LoadBalancers[l])
			hcloudNetwork.LoadBalancers[l] = &hcloudLoadBalancer
		}
	}
	hcloudNetwork.Protection = c.schemaNetworkProtectionToHcloudNetworkProtection(source.Protection)
	hcloudNetwork.Labels = source.Labels
	hcloudNetwork.ExposeRoutesToVSwitch = source.ExposeRoutesToVSwitch
	return &hcloudNetwork
}
func (c *converterImpl) NetworkRouteFromSchema(source schema.NetworkRoute) NetworkRoute {
	var hcloudNetworkRoute NetworkRoute
	netIPNet := ipNetFromString(source.Destination)
	hcloudNetworkRoute.Destination = &netIPNet
	hcloudNetworkRoute.Gateway = ipFromString(source.Gateway)
	return hcloudNetworkRoute
}
func (c *converterImpl) NetworkSubnetFromSchema(source schema.NetworkSubnet) NetworkSubnet {
	var hcloudNetworkSubnet NetworkSubnet
	hcloudNetworkSubnet.Type = NetworkSubnetType(source.Type)
	netIPNet := ipNetFromString(source.IPRange)
	hcloudNetworkSubnet.IPRange = &netIPNet
	hcloudNetworkSubnet.NetworkZone = NetworkZone(source.NetworkZone)
	hcloudNetworkSubnet.Gateway = ipFromString(source.Gateway)
	hcloudNetworkSubnet.VSwitchID = source.VSwitchID
	return hcloudNetworkSubnet
}
func (c *converterImpl) PaginationFromSchema(source schema.MetaPagination) Pagination {
	var hcloudPagination Pagination
	hcloudPagination.Page = source.Page
	hcloudPagination.PerPage = source.PerPage
	hcloudPagination.PreviousPage = source.PreviousPage
	hcloudPagination.NextPage = source.NextPage
	hcloudPagination.LastPage = source.LastPage
	hcloudPagination.TotalEntries = source.TotalEntries
	return hcloudPagination
}
func (c *converterImpl) PlacementGroupFromSchema(source schema.PlacementGroup) *PlacementGroup {
	var hcloudPlacementGroup PlacementGroup
	hcloudPlacementGroup.ID = source.ID
	hcloudPlacementGroup.Name = source.Name
	hcloudPlacementGroup.Labels = source.Labels
	hcloudPlacementGroup.Created = c.timeTimeToTimeTime(source.Created)
	hcloudPlacementGroup.Servers = source.Servers
	hcloudPlacementGroup.Type = PlacementGroupType(source.Type)
	return &hcloudPlacementGroup
}
func (c *converterImpl) PriceFromSchema(source schema.Price) Price {
	var hcloudPrice Price
	hcloudPrice.Net = source.Net
	hcloudPrice.Gross = source.Gross
	return hcloudPrice
}
func (c *converterImpl) PricingFromSchema(source schema.Pricing) Pricing {
	var hcloudPricing Pricing
	hcloudPricing.Image = imagePricingFromSchema(source)
	hcloudPricing.FloatingIP = floatingIPPricingFromSchema(source)
	hcloudPricing.FloatingIPs = floatingIPTypePricingFromSchema(source)
	hcloudPricing.PrimaryIPs = primaryIPPricingFromSchema(source)
	hcloudPricing.Traffic = trafficPricingFromSchema(source)
	hcloudPricing.ServerBackup = c.schemaPricingServerBackupToHcloudServerBackupPricing(source.ServerBackup)
	hcloudPricing.ServerTypes = serverTypePricingFromSchema(source)
	hcloudPricing.LoadBalancerTypes = loadBalancerTypePricingFromSchema(source)
	hcloudPricing.Volume = volumePricingFromSchema(source)
	return hcloudPricing
}
func (c *converterImpl) PrimaryIPFromSchema(source schema.PrimaryIP) *PrimaryIP {
	var hcloudPrimaryIP PrimaryIP
	hcloudPrimaryIP.ID = source.ID
	hcloudPrimaryIP.IP = ipFromPrimaryIPSchema(source)
	hcloudPrimaryIP.Network = networkFromPrimaryIPSchema(source)
	hcloudPrimaryIP.Labels = source.Labels
	hcloudPrimaryIP.Name = source.Name
	hcloudPrimaryIP.Type = PrimaryIPType(source.Type)
	hcloudPrimaryIP.Protection = c.schemaPrimaryIPProtectionToHcloudPrimaryIPProtection(source.Protection)
	hcloudPrimaryIP.DNSPtr = mapFromPrimaryIPDNSPtrSchema(source.DNSPtr)
	if source.AssigneeID != nil {
		hcloudPrimaryIP.AssigneeID = *source.AssigneeID
	}
	hcloudPrimaryIP.AssigneeType = source.AssigneeType
	hcloudPrimaryIP.AutoDelete = source.AutoDelete
	hcloudPrimaryIP.Blocked = source.Blocked
	hcloudPrimaryIP.Created = c.timeTimeToTimeTime(source.Created)
	hcloudPrimaryIP.Datacenter = c.DatacenterFromSchema(source.Datacenter)
	return &hcloudPrimaryIP
}
func (c *converterImpl) SSHKeyFromSchema(source schema.SSHKey) *SSHKey {
	var hcloudSSHKey SSHKey
	hcloudSSHKey.ID = source.ID
	hcloudSSHKey.Name = source.Name
	hcloudSSHKey.Fingerprint = source.Fingerprint
	hcloudSSHKey.PublicKey = source.PublicKey
	hcloudSSHKey.Labels = source.Labels
	hcloudSSHKey.Created = c.timeTimeToTimeTime(source.Created)
	return &hcloudSSHKey
}
func (c *converterImpl) SchemaFromAction(source *Action) schema.Action {
	var schemaAction schema.Action
	if source != nil {
		var schemaAction2 schema.Action
		schemaAction2.ID = (*source).ID
		schemaAction2.Status = string((*source).Status)
		schemaAction2.Command = (*source).Command
		schemaAction2.Progress = (*source).Progress
		schemaAction2.Started = c.timeTimeToTimeTime((*source).Started)
		schemaAction2.Finished = timeToTimePtr((*source).Finished)
		schemaAction2.Error = schemaActionErrorFromAction((*source))
		if (*source).Resources != nil {
			schemaAction2.Resources = make([]schema.ActionResourceReference, len((*source).Resources))
			for i := 0; i < len((*source).Resources); i++ {
				schemaAction2.Resources[i] = c.pHcloudActionResourceToSchemaActionResourceReference((*source).Resources[i])
			}
		}
		schemaAction = schemaAction2
	}
	return schemaAction
}
func (c *converterImpl) SchemaFromActions(source []*Action) []schema.Action {
	var schemaActionList []schema.Action
	if source != nil {
		schemaActionList = make([]schema.Action, len(source))
		for i := 0; i < len(source); i++ {
			schemaActionList[i] = c.SchemaFromAction(source[i])
		}
	}
	return schemaActionList
}
func (c *converterImpl) SchemaFromCertificate(source *Certificate) schema.Certificate {
	var schemaCertificate schema.Certificate
	if source != nil {
		var schemaCertificate2 schema.Certificate
		schemaCertificate2.ID = (*source).ID
		schemaCertificate2.Name = (*source).Name
		schemaCertificate2.Labels = (*source).Labels
		schemaCertificate2.Type = string((*source).Type)
		schemaCertificate2.Certificate = (*source).Certificate
		schemaCertificate2.Created = c.timeTimeToTimeTime((*source).Created)
		schemaCertificate2.NotValidBefore = c.timeTimeToTimeTime((*source).NotValidBefore)
		schemaCertificate2.NotValidAfter = c.timeTimeToTimeTime((*source).NotValidAfter)
		schemaCertificate2.DomainNames = (*source).DomainNames
		schemaCertificate2.Fingerprint = (*source).Fingerprint
		schemaCertificate2.Status = c.pHcloudCertificateStatusToPSchemaCertificateStatusRef((*source).Status)
		if (*source).UsedBy != nil {
			schemaCertificate2.UsedBy = make([]schema.CertificateUsedByRef, len((*source).UsedBy))
			for i := 0; i < len((*source).UsedBy); i++ {
				schemaCertificate2.UsedBy[i] = c.hcloudCertificateUsedByRefToSchemaCertificateUsedByRef((*source).UsedBy[i])
			}
		}
		schemaCertificate = schemaCertificate2
	}
	return schemaCertificate
}
func (c *converterImpl) SchemaFromDatacenter(source *Datacenter) schema.Datacenter {
	var schemaDatacenter schema.Datacenter
	if source != nil {
		var schemaDatacenter2 schema.Datacenter
		schemaDatacenter2.ID = (*source).ID
		schemaDatacenter2.Name = (*source).Name
		schemaDatacenter2.Description = (*source).Description
		schemaDatacenter2.Location = c.SchemaFromLocation((*source).Location)
		schemaDatacenter2.ServerTypes = c.hcloudDatacenterServerTypesToSchemaDatacenterServerTypes((*source).ServerTypes)
		schemaDatacenter = schemaDatacenter2
	}
	return schemaDatacenter
}
func (c *converterImpl) SchemaFromDeprecation(source *DeprecationInfo) *schema.DeprecationInfo {
	var pSchemaDeprecationInfo *schema.DeprecationInfo
	if source != nil {
		var schemaDeprecationInfo schema.DeprecationInfo
		schemaDeprecationInfo.Announced = c.timeTimeToTimeTime((*source).Announced)
		schemaDeprecationInfo.UnavailableAfter = c.timeTimeToTimeTime((*source).UnavailableAfter)
		pSchemaDeprecationInfo = &schemaDeprecationInfo
	}
	return pSchemaDeprecationInfo
}
func (c *converterImpl) SchemaFromError(source Error) schema.Error {
	var schemaError schema.Error
	schemaError.Code = string(source.Code)
	schemaError.Message = source.Message
	schemaError.DetailsRaw = rawSchemaFromErrorDetails(source.Details)
	schemaError.Details = schemaFromErrorDetails(source.Details)
	return schemaError
}
func (c *converterImpl) SchemaFromFirewall(source *Firewall) schema.Firewall {
	var schemaFirewall schema.Firewall
	if source != nil {
		var schemaFirewall2 schema.Firewall
		schemaFirewall2.ID = (*source).ID
		schemaFirewall2.Name = (*source).Name
		schemaFirewall2.Labels = (*source).Labels
		schemaFirewall2.Created = c.timeTimeToTimeTime((*source).Created)
		if (*source).Rules != nil {
			schemaFirewall2.Rules = make([]schema.FirewallRule, len((*source).Rules))
			for i := 0; i < len((*source).Rules); i++ {
				schemaFirewall2.Rules[i] = c.hcloudFirewallRuleToSchemaFirewallRule((*source).Rules[i])
			}
		}
		if (*source).AppliedTo != nil {
			schemaFirewall2.AppliedTo = make([]schema.FirewallResource, len((*source).AppliedTo))
			for j := 0; j < len((*source).AppliedTo); j++ {
				schemaFirewall2.AppliedTo[j] = c.SchemaFromFirewallResource((*source).AppliedTo[j])
			}
		}
		schemaFirewall = schemaFirewall2
	}
	return schemaFirewall
}
func (c *converterImpl) SchemaFromFirewallCreateOpts(source FirewallCreateOpts) schema.FirewallCreateRequest {
	var schemaFirewallCreateRequest schema.FirewallCreateRequest
	schemaFirewallCreateRequest.Name = source.Name
	schemaFirewallCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	if source.Rules != nil {
		schemaFirewallCreateRequest.Rules = make([]schema.FirewallRuleRequest, len(source.Rules))
		for i := 0; i < len(source.Rules); i++ {
			schemaFirewallCreateRequest.Rules[i] = c.hcloudFirewallRuleToSchemaFirewallRuleRequest(source.Rules[i])
		}
	}
	if source.ApplyTo != nil {
		schemaFirewallCreateRequest.ApplyTo = make([]schema.FirewallResource, len(source.ApplyTo))
		for j := 0; j < len(source.ApplyTo); j++ {
			schemaFirewallCreateRequest.ApplyTo[j] = c.SchemaFromFirewallResource(source.ApplyTo[j])
		}
	}
	return schemaFirewallCreateRequest
}
func (c *converterImpl) SchemaFromFirewallResource(source FirewallResource) schema.FirewallResource {
	var schemaFirewallResource schema.FirewallResource
	schemaFirewallResource.Type = string(source.Type)
	schemaFirewallResource.Server = c.pHcloudFirewallResourceServerToPSchemaFirewallResourceServer(source.Server)
	schemaFirewallResource.LabelSelector = c.pHcloudFirewallResourceLabelSelectorToPSchemaFirewallResourceLabelSelector(source.LabelSelector)
	return schemaFirewallResource
}
func (c *converterImpl) SchemaFromFirewallSetRulesOpts(source FirewallSetRulesOpts) schema.FirewallActionSetRulesRequest {
	var schemaFirewallActionSetRulesRequest schema.FirewallActionSetRulesRequest
	if source.Rules != nil {
		schemaFirewallActionSetRulesRequest.Rules = make([]schema.FirewallRuleRequest, len(source.Rules))
		for i := 0; i < len(source.Rules); i++ {
			schemaFirewallActionSetRulesRequest.Rules[i] = c.hcloudFirewallRuleToSchemaFirewallRuleRequest(source.Rules[i])
		}
	}
	return schemaFirewallActionSetRulesRequest
}
func (c *converterImpl) SchemaFromFloatingIP(source *FloatingIP) schema.FloatingIP {
	var schemaFloatingIP schema.FloatingIP
	if source != nil {
		var schemaFloatingIP2 schema.FloatingIP
		schemaFloatingIP2.ID = (*source).ID
		pString := (*source).Description
		schemaFloatingIP2.Description = &pString
		schemaFloatingIP2.Created = c.timeTimeToTimeTime((*source).Created)
		schemaFloatingIP2.IP = floatingIPToIPString((*source))
		schemaFloatingIP2.Type = string((*source).Type)
		schemaFloatingIP2.Server = c.pHcloudServerToPInt64((*source).Server)
		schemaFloatingIP2.DNSPtr = floatingIPDNSPtrSchemaFromMap((*source).DNSPtr)
		schemaFloatingIP2.HomeLocation = c.SchemaFromLocation((*source).HomeLocation)
		schemaFloatingIP2.Blocked = (*source).Blocked
		schemaFloatingIP2.Protection = c.hcloudFloatingIPProtectionToSchemaFloatingIPProtection((*source).Protection)
		schemaFloatingIP2.Labels = (*source).Labels
		schemaFloatingIP2.Name = (*source).Name
		schemaFloatingIP = schemaFloatingIP2
	}
	return schemaFloatingIP
}
func (c *converterImpl) SchemaFromISO(source *ISO) schema.ISO {
	var schemaISO schema.ISO
	if source != nil {
		var schemaISO2 schema.ISO
		schemaISO2.ID = (*source).ID
		schemaISO2.Name = (*source).Name
		schemaISO2.Description = (*source).Description
		schemaISO2.Type = string((*source).Type)
		if (*source).Architecture != nil {
			xstring := string(*(*source).Architecture)
			schemaISO2.Architecture = &xstring
		}
		schemaISO2.DeprecatableResource = c.hcloudDeprecatableResourceToSchemaDeprecatableResource((*source).DeprecatableResource)
		schemaISO = schemaISO2
	}
	return schemaISO
}
func (c *converterImpl) SchemaFromImage(source *Image) schema.Image {
	var schemaImage schema.Image
	if source != nil {
		schemaImage = c.intSchemaFromImage((*source))
	}
	return schemaImage
}
func (c *converterImpl) SchemaFromLoadBalancer(source *LoadBalancer) schema.LoadBalancer {
	var schemaLoadBalancer schema.LoadBalancer
	if source != nil {
		var schemaLoadBalancer2 schema.LoadBalancer
		schemaLoadBalancer2.ID = (*source).ID
		schemaLoadBalancer2.Name = (*source).Name
		schemaLoadBalancer2.PublicNet = c.hcloudLoadBalancerPublicNetToSchemaLoadBalancerPublicNet((*source).PublicNet)
		if (*source).PrivateNet != nil {
			schemaLoadBalancer2.PrivateNet = make([]schema.LoadBalancerPrivateNet, len((*source).PrivateNet))
			for i := 0; i < len((*source).PrivateNet); i++ {
				schemaLoadBalancer2.PrivateNet[i] = c.hcloudLoadBalancerPrivateNetToSchemaLoadBalancerPrivateNet((*source).PrivateNet[i])
			}
		}
		schemaLoadBalancer2.Location = c.SchemaFromLocation((*source).Location)
		schemaLoadBalancer2.LoadBalancerType = c.SchemaFromLoadBalancerType((*source).LoadBalancerType)
		schemaLoadBalancer2.Protection = c.hcloudLoadBalancerProtectionToSchemaLoadBalancerProtection((*source).Protection)
		schemaLoadBalancer2.Labels = (*source).Labels
		schemaLoadBalancer2.Created = c.timeTimeToTimeTime((*source).Created)
		if (*source).Services != nil {
			schemaLoadBalancer2.Services = make([]schema.LoadBalancerService, len((*source).Services))
			for j := 0; j < len((*source).Services); j++ {
				schemaLoadBalancer2.Services[j] = c.SchemaFromLoadBalancerService((*source).Services[j])
			}
		}
		if (*source).Targets != nil {
			schemaLoadBalancer2.Targets = make([]schema.LoadBalancerTarget, len((*source).Targets))
			for k := 0; k < len((*source).Targets); k++ {
				schemaLoadBalancer2.Targets[k] = c.SchemaFromLoadBalancerTarget((*source).Targets[k])
			}
		}
		schemaLoadBalancer2.Algorithm = c.hcloudLoadBalancerAlgorithmToSchemaLoadBalancerAlgorithm((*source).Algorithm)
		schemaLoadBalancer2.IncludedTraffic = (*source).IncludedTraffic
		schemaLoadBalancer2.OutgoingTraffic = mapZeroUint64ToNil((*source).OutgoingTraffic)
		schemaLoadBalancer2.IngoingTraffic = mapZeroUint64ToNil((*source).IngoingTraffic)
		schemaLoadBalancer = schemaLoadBalancer2
	}
	return schemaLoadBalancer
}
func (c *converterImpl) SchemaFromLoadBalancerAddServiceOpts(source LoadBalancerAddServiceOpts) schema.LoadBalancerActionAddServiceRequest {
	var schemaLoadBalancerActionAddServiceRequest schema.LoadBalancerActionAddServiceRequest
	schemaLoadBalancerActionAddServiceRequest.Protocol = string(source.Protocol)
	schemaLoadBalancerActionAddServiceRequest.ListenPort = source.ListenPort
	schemaLoadBalancerActionAddServiceRequest.DestinationPort = source.DestinationPort
	schemaLoadBalancerActionAddServiceRequest.Proxyprotocol = source.Proxyprotocol
	schemaLoadBalancerActionAddServiceRequest.HTTP = c.pHcloudLoadBalancerAddServiceOptsHTTPToPSchemaLoadBalancerActionAddServiceRequestHTTP(source.HTTP)
	schemaLoadBalancerActionAddServiceRequest.HealthCheck = c.pHcloudLoadBalancerAddServiceOptsHealthCheckToPSchemaLoadBalancerActionAddServiceRequestHealthCheck(source.HealthCheck)
	return schemaLoadBalancerActionAddServiceRequest
}
func (c *converterImpl) SchemaFromLoadBalancerCreateOpts(source LoadBalancerCreateOpts) schema.LoadBalancerCreateRequest {
	var schemaLoadBalancerCreateRequest schema.LoadBalancerCreateRequest
	schemaLoadBalancerCreateRequest.Name = source.Name
	schemaLoadBalancerCreateRequest.LoadBalancerType = c.pHcloudLoadBalancerTypeToSchemaIDOrName(source.LoadBalancerType)
	schemaLoadBalancerCreateRequest.Algorithm = c.pHcloudLoadBalancerAlgorithmToPSchemaLoadBalancerCreateRequestAlgorithm(source.Algorithm)
	schemaLoadBalancerCreateRequest.Location = c.pHcloudLocationToPString(source.Location)
	schemaLoadBalancerCreateRequest.NetworkZone = stringPtrFromNetworkZone(source.NetworkZone)
	schemaLoadBalancerCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	if source.Targets != nil {
		schemaLoadBalancerCreateRequest.Targets = make([]schema.LoadBalancerCreateRequestTarget, len(source.Targets))
		for i := 0; i < len(source.Targets); i++ {
			schemaLoadBalancerCreateRequest.Targets[i] = c.hcloudLoadBalancerCreateOptsTargetToSchemaLoadBalancerCreateRequestTarget(source.Targets[i])
		}
	}
	if source.Services != nil {
		schemaLoadBalancerCreateRequest.Services = make([]schema.LoadBalancerCreateRequestService, len(source.Services))
		for j := 0; j < len(source.Services); j++ {
			schemaLoadBalancerCreateRequest.Services[j] = c.hcloudLoadBalancerCreateOptsServiceToSchemaLoadBalancerCreateRequestService(source.Services[j])
		}
	}
	schemaLoadBalancerCreateRequest.PublicInterface = source.PublicInterface
	schemaLoadBalancerCreateRequest.Network = c.pHcloudNetworkToPInt64(source.Network)
	return schemaLoadBalancerCreateRequest
}
func (c *converterImpl) SchemaFromLoadBalancerCreateOptsTargetServer(source LoadBalancerCreateOptsTargetServer) schema.LoadBalancerCreateRequestTargetServer {
	var schemaLoadBalancerCreateRequestTargetServer schema.LoadBalancerCreateRequestTargetServer
	var pInt64 *int64
	if source.Server != nil {
		pInt64 = &source.Server.ID
	}
	if pInt64 != nil {
		schemaLoadBalancerCreateRequestTargetServer.ID = *pInt64
	}
	return schemaLoadBalancerCreateRequestTargetServer
}
func (c *converterImpl) SchemaFromLoadBalancerServerTarget(source LoadBalancerTargetServer) schema.LoadBalancerTargetServer {
	var schemaLoadBalancerTargetServer schema.LoadBalancerTargetServer
	schemaLoadBalancerTargetServer.ID = c.pHcloudServerToInt64(source.Server)
	return schemaLoadBalancerTargetServer
}
func (c *converterImpl) SchemaFromLoadBalancerService(source LoadBalancerService) schema.LoadBalancerService {
	var schemaLoadBalancerService schema.LoadBalancerService
	schemaLoadBalancerService.Protocol = string(source.Protocol)
	schemaLoadBalancerService.ListenPort = source.ListenPort
	schemaLoadBalancerService.DestinationPort = source.DestinationPort
	schemaLoadBalancerService.Proxyprotocol = source.Proxyprotocol
	schemaLoadBalancerService.HTTP = c.hcloudLoadBalancerServiceHTTPToPSchemaLoadBalancerServiceHTTP(source.HTTP)
	schemaLoadBalancerService.HealthCheck = c.SchemaFromLoadBalancerServiceHealthCheck(source.HealthCheck)
	return schemaLoadBalancerService
}
func (c *converterImpl) SchemaFromLoadBalancerServiceHealthCheck(source LoadBalancerServiceHealthCheck) *schema.LoadBalancerServiceHealthCheck {
	var schemaLoadBalancerServiceHealthCheck schema.LoadBalancerServiceHealthCheck
	schemaLoadBalancerServiceHealthCheck.Protocol = string(source.Protocol)
	schemaLoadBalancerServiceHealthCheck.Port = source.Port
	schemaLoadBalancerServiceHealthCheck.Interval = intSecondsFromDuration(source.Interval)
	schemaLoadBalancerServiceHealthCheck.Timeout = intSecondsFromDuration(source.Timeout)
	schemaLoadBalancerServiceHealthCheck.Retries = source.Retries
	schemaLoadBalancerServiceHealthCheck.HTTP = c.pHcloudLoadBalancerServiceHealthCheckHTTPToPSchemaLoadBalancerServiceHealthCheckHTTP(source.HTTP)
	return &schemaLoadBalancerServiceHealthCheck
}
func (c *converterImpl) SchemaFromLoadBalancerTarget(source LoadBalancerTarget) schema.LoadBalancerTarget {
	var schemaLoadBalancerTarget schema.LoadBalancerTarget
	schemaLoadBalancerTarget.Type = string(source.Type)
	schemaLoadBalancerTarget.Server = c.pHcloudLoadBalancerTargetServerToPSchemaLoadBalancerTargetServer(source.Server)
	schemaLoadBalancerTarget.LabelSelector = c.pHcloudLoadBalancerTargetLabelSelectorToPSchemaLoadBalancerTargetLabelSelector(source.LabelSelector)
	schemaLoadBalancerTarget.IP = c.pHcloudLoadBalancerTargetIPToPSchemaLoadBalancerTargetIP(source.IP)
	if source.HealthStatus != nil {
		schemaLoadBalancerTarget.HealthStatus = make([]schema.LoadBalancerTargetHealthStatus, len(source.HealthStatus))
		for i := 0; i < len(source.HealthStatus); i++ {
			schemaLoadBalancerTarget.HealthStatus[i] = c.SchemaFromLoadBalancerTargetHealthStatus(source.HealthStatus[i])
		}
	}
	schemaLoadBalancerTarget.UsePrivateIP = source.UsePrivateIP
	if source.Targets != nil {
		schemaLoadBalancerTarget.Targets = make([]schema.LoadBalancerTarget, len(source.Targets))
		for j := 0; j < len(source.Targets); j++ {
			schemaLoadBalancerTarget.Targets[j] = c.SchemaFromLoadBalancerTarget(source.Targets[j])
		}
	}
	return schemaLoadBalancerTarget
}
func (c *converterImpl) SchemaFromLoadBalancerTargetHealthStatus(source LoadBalancerTargetHealthStatus) schema.LoadBalancerTargetHealthStatus {
	var schemaLoadBalancerTargetHealthStatus schema.LoadBalancerTargetHealthStatus
	schemaLoadBalancerTargetHealthStatus.ListenPort = source.ListenPort
	schemaLoadBalancerTargetHealthStatus.Status = string(source.Status)
	return schemaLoadBalancerTargetHealthStatus
}
func (c *converterImpl) SchemaFromLoadBalancerType(source *LoadBalancerType) schema.LoadBalancerType {
	var schemaLoadBalancerType schema.LoadBalancerType
	if source != nil {
		var schemaLoadBalancerType2 schema.LoadBalancerType
		schemaLoadBalancerType2.ID = (*source).ID
		schemaLoadBalancerType2.Name = (*source).Name
		schemaLoadBalancerType2.Description = (*source).Description
		schemaLoadBalancerType2.MaxConnections = (*source).MaxConnections
		schemaLoadBalancerType2.MaxServices = (*source).MaxServices
		schemaLoadBalancerType2.MaxTargets = (*source).MaxTargets
		schemaLoadBalancerType2.MaxAssignedCertificates = (*source).MaxAssignedCertificates
		if (*source).Pricings != nil {
			schemaLoadBalancerType2.Prices = make([]schema.PricingLoadBalancerTypePrice, len((*source).Pricings))
			for i := 0; i < len((*source).Pricings); i++ {
				schemaLoadBalancerType2.Prices[i] = c.SchemaFromLoadBalancerTypeLocationPricing((*source).Pricings[i])
			}
		}
		schemaLoadBalancerType2.Deprecated = (*source).Deprecated
		schemaLoadBalancerType = schemaLoadBalancerType2
	}
	return schemaLoadBalancerType
}
func (c *converterImpl) SchemaFromLoadBalancerTypeLocationPricing(source LoadBalancerTypeLocationPricing) schema.PricingLoadBalancerTypePrice {
	var schemaPricingLoadBalancerTypePrice schema.PricingLoadBalancerTypePrice
	schemaPricingLoadBalancerTypePrice.Location = c.pHcloudLocationToString(source.Location)
	schemaPricingLoadBalancerTypePrice.PriceHourly = c.hcloudPriceToSchemaPrice(source.Hourly)
	schemaPricingLoadBalancerTypePrice.PriceMonthly = c.hcloudPriceToSchemaPrice(source.Monthly)
	schemaPricingLoadBalancerTypePrice.IncludedTraffic = source.IncludedTraffic
	schemaPricingLoadBalancerTypePrice.PricePerTBTraffic = c.hcloudPriceToSchemaPrice(source.PerTBTraffic)
	return schemaPricingLoadBalancerTypePrice
}
func (c *converterImpl) SchemaFromLoadBalancerUpdateServiceOpts(source LoadBalancerUpdateServiceOpts) schema.LoadBalancerActionUpdateServiceRequest {
	var schemaLoadBalancerActionUpdateServiceRequest schema.LoadBalancerActionUpdateServiceRequest
	schemaLoadBalancerActionUpdateServiceRequest.Protocol = stringPtrFromLoadBalancerServiceProtocol(source.Protocol)
	schemaLoadBalancerActionUpdateServiceRequest.DestinationPort = source.DestinationPort
	schemaLoadBalancerActionUpdateServiceRequest.Proxyprotocol = source.Proxyprotocol
	schemaLoadBalancerActionUpdateServiceRequest.HTTP = c.pHcloudLoadBalancerUpdateServiceOptsHTTPToPSchemaLoadBalancerActionUpdateServiceRequestHTTP(source.HTTP)
	schemaLoadBalancerActionUpdateServiceRequest.HealthCheck = c.pHcloudLoadBalancerUpdateServiceOptsHealthCheckToPSchemaLoadBalancerActionUpdateServiceRequestHealthCheck(source.HealthCheck)
	return schemaLoadBalancerActionUpdateServiceRequest
}
func (c *converterImpl) SchemaFromLocation(source *Location) schema.Location {
	var schemaLocation schema.Location
	if source != nil {
		var schemaLocation2 schema.Location
		schemaLocation2.ID = (*source).ID
		schemaLocation2.Name = (*source).Name
		schemaLocation2.Description = (*source).Description
		schemaLocation2.Country = (*source).Country
		schemaLocation2.City = (*source).City
		schemaLocation2.Latitude = (*source).Latitude
		schemaLocation2.Longitude = (*source).Longitude
		schemaLocation2.NetworkZone = string((*source).NetworkZone)
		schemaLocation = schemaLocation2
	}
	return schemaLocation
}
func (c *converterImpl) SchemaFromNetwork(source *Network) schema.Network {
	var schemaNetwork schema.Network
	if source != nil {
		var schemaNetwork2 schema.Network
		schemaNetwork2.ID = (*source).ID
		schemaNetwork2.Name = (*source).Name
		schemaNetwork2.Created = c.timeTimeToTimeTime((*source).Created)
		schemaNetwork2.IPRange = c.pNetIPNetToString((*source).IPRange)
		if (*source).Subnets != nil {
			schemaNetwork2.Subnets = make([]schema.NetworkSubnet, len((*source).Subnets))
			for i := 0; i < len((*source).Subnets); i++ {
				schemaNetwork2.Subnets[i] = c.SchemaFromNetworkSubnet((*source).Subnets[i])
			}
		}
		if (*source).Routes != nil {
			schemaNetwork2.Routes = make([]schema.NetworkRoute, len((*source).Routes))
			for j := 0; j < len((*source).Routes); j++ {
				schemaNetwork2.Routes[j] = c.SchemaFromNetworkRoute((*source).Routes[j])
			}
		}
		if (*source).Servers != nil {
			schemaNetwork2.Servers = make([]int64, len((*source).Servers))
			for k := 0; k < len((*source).Servers); k++ {
				schemaNetwork2.Servers[k] = c.pHcloudServerToInt64((*source).Servers[k])
			}
		}
		if (*source).LoadBalancers != nil {
			schemaNetwork2.LoadBalancers = make([]int64, len((*source).LoadBalancers))
			for l := 0; l < len((*source).LoadBalancers); l++ {
				schemaNetwork2.LoadBalancers[l] = c.pHcloudLoadBalancerToInt64((*source).LoadBalancers[l])
			}
		}
		schemaNetwork2.Protection = c.hcloudNetworkProtectionToSchemaNetworkProtection((*source).Protection)
		schemaNetwork2.Labels = (*source).Labels
		schemaNetwork2.ExposeRoutesToVSwitch = (*source).ExposeRoutesToVSwitch
		schemaNetwork = schemaNetwork2
	}
	return schemaNetwork
}
func (c *converterImpl) SchemaFromNetworkRoute(source NetworkRoute) schema.NetworkRoute {
	var schemaNetworkRoute schema.NetworkRoute
	schemaNetworkRoute.Destination = c.pNetIPNetToString(source.Destination)
	schemaNetworkRoute.Gateway = stringFromIP(source.Gateway)
	return schemaNetworkRoute
}
func (c *converterImpl) SchemaFromNetworkSubnet(source NetworkSubnet) schema.NetworkSubnet {
	var schemaNetworkSubnet schema.NetworkSubnet
	schemaNetworkSubnet.Type = string(source.Type)
	schemaNetworkSubnet.IPRange = c.pNetIPNetToString(source.IPRange)
	schemaNetworkSubnet.NetworkZone = string(source.NetworkZone)
	schemaNetworkSubnet.Gateway = stringFromIP(source.Gateway)
	schemaNetworkSubnet.VSwitchID = source.VSwitchID
	return schemaNetworkSubnet
}
func (c *converterImpl) SchemaFromPagination(source Pagination) schema.MetaPagination {
	var schemaMetaPagination schema.MetaPagination
	schemaMetaPagination.Page = source.Page
	schemaMetaPagination.PerPage = source.PerPage
	schemaMetaPagination.PreviousPage = source.PreviousPage
	schemaMetaPagination.NextPage = source.NextPage
	schemaMetaPagination.LastPage = source.LastPage
	schemaMetaPagination.TotalEntries = source.TotalEntries
	return schemaMetaPagination
}
func (c *converterImpl) SchemaFromPlacementGroup(source *PlacementGroup) schema.PlacementGroup {
	var schemaPlacementGroup schema.PlacementGroup
	if source != nil {
		var schemaPlacementGroup2 schema.PlacementGroup
		schemaPlacementGroup2.ID = (*source).ID
		schemaPlacementGroup2.Name = (*source).Name
		schemaPlacementGroup2.Labels = (*source).Labels
		schemaPlacementGroup2.Created = c.timeTimeToTimeTime((*source).Created)
		schemaPlacementGroup2.Servers = (*source).Servers
		schemaPlacementGroup2.Type = string((*source).Type)
		schemaPlacementGroup = schemaPlacementGroup2
	}
	return schemaPlacementGroup
}
func (c *converterImpl) SchemaFromPlacementGroupCreateOpts(source PlacementGroupCreateOpts) schema.PlacementGroupCreateRequest {
	var schemaPlacementGroupCreateRequest schema.PlacementGroupCreateRequest
	schemaPlacementGroupCreateRequest.Name = source.Name
	schemaPlacementGroupCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	schemaPlacementGroupCreateRequest.Type = string(source.Type)
	return schemaPlacementGroupCreateRequest
}
func (c *converterImpl) SchemaFromPricing(source Pricing) schema.Pricing {
	var schemaPricing schema.Pricing
	schemaPricing.Currency = source.Image.PerGBMonth.Currency
	schemaPricing.VATRate = source.Image.PerGBMonth.VATRate
	schemaPricing.Image = c.schemaFromImagePricing(source.Image)
	schemaPricing.FloatingIP = c.schemaFromFloatingIPPricing(source.FloatingIP)
	if source.FloatingIPs != nil {
		schemaPricing.FloatingIPs = make([]schema.PricingFloatingIPType, len(source.FloatingIPs))
		for i := 0; i < len(source.FloatingIPs); i++ {
			schemaPricing.FloatingIPs[i] = c.schemaFromFloatingIPTypePricing(source.FloatingIPs[i])
		}
	}
	if source.PrimaryIPs != nil {
		schemaPricing.PrimaryIPs = make([]schema.PricingPrimaryIP, len(source.PrimaryIPs))
		for j := 0; j < len(source.PrimaryIPs); j++ {
			schemaPricing.PrimaryIPs[j] = c.schemaFromPrimaryIPPricing(source.PrimaryIPs[j])
		}
	}
	schemaPricing.Traffic = c.schemaFromTrafficPricing(source.Traffic)
	schemaPricing.ServerBackup = c.hcloudServerBackupPricingToSchemaPricingServerBackup(source.ServerBackup)
	if source.ServerTypes != nil {
		schemaPricing.ServerTypes = make([]schema.PricingServerType, len(source.ServerTypes))
		for k := 0; k < len(source.ServerTypes); k++ {
			schemaPricing.ServerTypes[k] = c.schemaFromServerTypePricing(source.ServerTypes[k])
		}
	}
	if source.LoadBalancerTypes != nil {
		schemaPricing.LoadBalancerTypes = make([]schema.PricingLoadBalancerType, len(source.LoadBalancerTypes))
		for l := 0; l < len(source.LoadBalancerTypes); l++ {
			schemaPricing.LoadBalancerTypes[l] = c.schemaFromLoadBalancerTypePricing(source.LoadBalancerTypes[l])
		}
	}
	schemaPricing.Volume = c.schemaFromVolumePricing(source.Volume)
	return schemaPricing
}
func (c *converterImpl) SchemaFromPrimaryIP(source *PrimaryIP) schema.PrimaryIP {
	var schemaPrimaryIP schema.PrimaryIP
	if source != nil {
		var schemaPrimaryIP2 schema.PrimaryIP
		schemaPrimaryIP2.ID = (*source).ID
		schemaPrimaryIP2.IP = primaryIPToIPString((*source))
		schemaPrimaryIP2.Labels = (*source).Labels
		schemaPrimaryIP2.Name = (*source).Name
		schemaPrimaryIP2.Type = string((*source).Type)
		schemaPrimaryIP2.Protection = c.hcloudPrimaryIPProtectionToSchemaPrimaryIPProtection((*source).Protection)
		schemaPrimaryIP2.DNSPtr = primaryIPDNSPtrSchemaFromMap((*source).DNSPtr)
		schemaPrimaryIP2.AssigneeID = mapZeroInt64ToNil((*source).AssigneeID)
		schemaPrimaryIP2.AssigneeType = (*source).AssigneeType
		schemaPrimaryIP2.AutoDelete = (*source).AutoDelete
		schemaPrimaryIP2.Blocked = (*source).Blocked
		schemaPrimaryIP2.Created = c.timeTimeToTimeTime((*source).Created)
		schemaPrimaryIP2.Datacenter = c.SchemaFromDatacenter((*source).Datacenter)
		schemaPrimaryIP = schemaPrimaryIP2
	}
	return schemaPrimaryIP
}
func (c *converterImpl) SchemaFromPrimaryIPAssignOpts(source PrimaryIPAssignOpts) schema.PrimaryIPActionAssignRequest {
	var schemaPrimaryIPActionAssignRequest schema.PrimaryIPActionAssignRequest
	schemaPrimaryIPActionAssignRequest.AssigneeID = source.AssigneeID
	schemaPrimaryIPActionAssignRequest.AssigneeType = source.AssigneeType
	return schemaPrimaryIPActionAssignRequest
}
func (c *converterImpl) SchemaFromPrimaryIPChangeDNSPtrOpts(source PrimaryIPChangeDNSPtrOpts) schema.PrimaryIPActionChangeDNSPtrRequest {
	var schemaPrimaryIPActionChangeDNSPtrRequest schema.PrimaryIPActionChangeDNSPtrRequest
	schemaPrimaryIPActionChangeDNSPtrRequest.IP = source.IP
	pString := source.DNSPtr
	schemaPrimaryIPActionChangeDNSPtrRequest.DNSPtr = &pString
	return schemaPrimaryIPActionChangeDNSPtrRequest
}
func (c *converterImpl) SchemaFromPrimaryIPChangeProtectionOpts(source PrimaryIPChangeProtectionOpts) schema.PrimaryIPActionChangeProtectionRequest {
	var schemaPrimaryIPActionChangeProtectionRequest schema.PrimaryIPActionChangeProtectionRequest
	schemaPrimaryIPActionChangeProtectionRequest.Delete = source.Delete
	return schemaPrimaryIPActionChangeProtectionRequest
}
func (c *converterImpl) SchemaFromPrimaryIPCreateOpts(source PrimaryIPCreateOpts) schema.PrimaryIPCreateRequest {
	var schemaPrimaryIPCreateRequest schema.PrimaryIPCreateRequest
	schemaPrimaryIPCreateRequest.Name = source.Name
	schemaPrimaryIPCreateRequest.Type = string(source.Type)
	schemaPrimaryIPCreateRequest.AssigneeType = source.AssigneeType
	schemaPrimaryIPCreateRequest.AssigneeID = source.AssigneeID
	schemaPrimaryIPCreateRequest.Labels = source.Labels
	schemaPrimaryIPCreateRequest.AutoDelete = source.AutoDelete
	schemaPrimaryIPCreateRequest.Datacenter = source.Datacenter
	return schemaPrimaryIPCreateRequest
}
func (c *converterImpl) SchemaFromPrimaryIPUpdateOpts(source PrimaryIPUpdateOpts) schema.PrimaryIPUpdateRequest {
	var schemaPrimaryIPUpdateRequest schema.PrimaryIPUpdateRequest
	schemaPrimaryIPUpdateRequest.Name = source.Name
	if source.Labels != nil {
		schemaPrimaryIPUpdateRequest.Labels = (*source.Labels)
	}
	schemaPrimaryIPUpdateRequest.AutoDelete = source.AutoDelete
	return schemaPrimaryIPUpdateRequest
}
func (c *converterImpl) SchemaFromSSHKey(source *SSHKey) schema.SSHKey {
	var schemaSSHKey schema.SSHKey
	if source != nil {
		var schemaSSHKey2 schema.SSHKey
		schemaSSHKey2.ID = (*source).ID
		schemaSSHKey2.Name = (*source).Name
		schemaSSHKey2.Fingerprint = (*source).Fingerprint
		schemaSSHKey2.PublicKey = (*source).PublicKey
		schemaSSHKey2.Labels = (*source).Labels
		schemaSSHKey2.Created = c.timeTimeToTimeTime((*source).Created)
		schemaSSHKey = schemaSSHKey2
	}
	return schemaSSHKey
}
func (c *converterImpl) SchemaFromServer(source *Server) schema.Server {
	var schemaServer schema.Server
	if source != nil {
		var schemaServer2 schema.Server
		schemaServer2.ID = (*source).ID
		schemaServer2.Name = (*source).Name
		schemaServer2.Status = string((*source).Status)
		schemaServer2.Created = c.timeTimeToTimeTime((*source).Created)
		schemaServer2.PublicNet = c.SchemaFromServerPublicNet((*source).PublicNet)
		if (*source).PrivateNet != nil {
			schemaServer2.PrivateNet = make([]schema.ServerPrivateNet, len((*source).PrivateNet))
			for i := 0; i < len((*source).PrivateNet); i++ {
				schemaServer2.PrivateNet[i] = c.SchemaFromServerPrivateNet((*source).PrivateNet[i])
			}
		}
		schemaServer2.ServerType = c.SchemaFromServerType((*source).ServerType)
		schemaServer2.IncludedTraffic = (*source).IncludedTraffic
		schemaServer2.OutgoingTraffic = mapZeroUint64ToNil((*source).OutgoingTraffic)
		schemaServer2.IngoingTraffic = mapZeroUint64ToNil((*source).IngoingTraffic)
		schemaServer2.BackupWindow = mapEmptyStringToNil((*source).BackupWindow)
		schemaServer2.RescueEnabled = (*source).RescueEnabled
		schemaServer2.ISO = c.pHcloudISOToPSchemaISO((*source).ISO)
		schemaServer2.Locked = (*source).Locked
		schemaServer2.Datacenter = c.SchemaFromDatacenter((*source).Datacenter)
		schemaServer2.Image = c.pHcloudImageToPSchemaImage((*source).Image)
		schemaServer2.Protection = c.hcloudServerProtectionToSchemaServerProtection((*source).Protection)
		schemaServer2.Labels = (*source).Labels
		if (*source).Volumes != nil {
			schemaServer2.Volumes = make([]int64, len((*source).Volumes))
			for j := 0; j < len((*source).Volumes); j++ {
				schemaServer2.Volumes[j] = int64FromVolume((*source).Volumes[j])
			}
		}
		schemaServer2.PrimaryDiskSize = (*source).PrimaryDiskSize
		schemaServer2.PlacementGroup = c.pHcloudPlacementGroupToPSchemaPlacementGroup((*source).PlacementGroup)
		if (*source).LoadBalancers != nil {
			schemaServer2.LoadBalancers = make([]int64, len((*source).LoadBalancers))
			for k := 0; k < len((*source).LoadBalancers); k++ {
				schemaServer2.LoadBalancers[k] = c.pHcloudLoadBalancerToInt64((*source).LoadBalancers[k])
			}
		}
		schemaServer = schemaServer2
	}
	return schemaServer
}
func (c *converterImpl) SchemaFromServerPrivateNet(source ServerPrivateNet) schema.ServerPrivateNet {
	var schemaServerPrivateNet schema.ServerPrivateNet
	schemaServerPrivateNet.Network = c.pHcloudNetworkToInt64(source.Network)
	schemaServerPrivateNet.IP = stringFromIP(source.IP)
	if source.Aliases != nil {
		schemaServerPrivateNet.AliasIPs = make([]string, len(source.Aliases))
		for i := 0; i < len(source.Aliases); i++ {
			schemaServerPrivateNet.AliasIPs[i] = stringFromIP(source.Aliases[i])
		}
	}
	schemaServerPrivateNet.MACAddress = source.MACAddress
	return schemaServerPrivateNet
}
func (c *converterImpl) SchemaFromServerPublicNet(source ServerPublicNet) schema.ServerPublicNet {
	var schemaServerPublicNet schema.ServerPublicNet
	schemaServerPublicNet.IPv4 = c.SchemaFromServerPublicNetIPv4(source.IPv4)
	schemaServerPublicNet.IPv6 = c.SchemaFromServerPublicNetIPv6(source.IPv6)
	if source.FloatingIPs != nil {
		schemaServerPublicNet.FloatingIPs = make([]int64, len(source.FloatingIPs))
		for i := 0; i < len(source.FloatingIPs); i++ {
			schemaServerPublicNet.FloatingIPs[i] = int64FromFloatingIP(source.FloatingIPs[i])
		}
	}
	if source.Firewalls != nil {
		schemaServerPublicNet.Firewalls = make([]schema.ServerFirewall, len(source.Firewalls))
		for j := 0; j < len(source.Firewalls); j++ {
			schemaServerPublicNet.Firewalls[j] = serverFirewallSchemaFromFirewallStatus(source.Firewalls[j])
		}
	}
	return schemaServerPublicNet
}
func (c *converterImpl) SchemaFromServerPublicNetIPv4(source ServerPublicNetIPv4) schema.ServerPublicNetIPv4 {
	var schemaServerPublicNetIPv4 schema.ServerPublicNetIPv4
	schemaServerPublicNetIPv4.ID = source.ID
	schemaServerPublicNetIPv4.IP = stringFromIP(source.IP)
	schemaServerPublicNetIPv4.Blocked = source.Blocked
	schemaServerPublicNetIPv4.DNSPtr = source.DNSPtr
	return schemaServerPublicNetIPv4
}
func (c *converterImpl) SchemaFromServerPublicNetIPv6(source ServerPublicNetIPv6) schema.ServerPublicNetIPv6 {
	var schemaServerPublicNetIPv6 schema.ServerPublicNetIPv6
	schemaServerPublicNetIPv6.ID = source.ID
	schemaServerPublicNetIPv6.IP = c.pNetIPNetToString(source.Network)
	schemaServerPublicNetIPv6.Blocked = source.Blocked
	schemaServerPublicNetIPv6.DNSPtr = serverPublicNetIPv6DNSPtrSchemaFromMap(source.DNSPtr)
	return schemaServerPublicNetIPv6
}
func (c *converterImpl) SchemaFromServerType(source *ServerType) schema.ServerType {
	var schemaServerType schema.ServerType
	if source != nil {
		var schemaServerType2 schema.ServerType
		schemaServerType2.ID = (*source).ID
		schemaServerType2.Name = (*source).Name
		schemaServerType2.Description = (*source).Description
		schemaServerType2.Cores = (*source).Cores
		schemaServerType2.Memory = (*source).Memory
		schemaServerType2.Disk = (*source).Disk
		schemaServerType2.StorageType = string((*source).StorageType)
		schemaServerType2.CPUType = string((*source).CPUType)
		schemaServerType2.Architecture = string((*source).Architecture)
		schemaServerType2.IncludedTraffic = (*source).IncludedTraffic
		if (*source).Pricings != nil {
			schemaServerType2.Prices = make([]schema.PricingServerTypePrice, len((*source).Pricings))
			for i := 0; i < len((*source).Pricings); i++ {
				schemaServerType2.Prices[i] = c.schemaFromServerTypeLocationPricing((*source).Pricings[i])
			}
		}
		schemaServerType2.Deprecated = isDeprecationNotNil((*source).DeprecatableResource.Deprecation)
		schemaServerType2.DeprecatableResource = c.hcloudDeprecatableResourceToSchemaDeprecatableResource((*source).DeprecatableResource)
		schemaServerType = schemaServerType2
	}
	return schemaServerType
}
func (c *converterImpl) SchemaFromVolume(source *Volume) schema.Volume {
	var schemaVolume schema.Volume
	if source != nil {
		var schemaVolume2 schema.Volume
		schemaVolume2.ID = (*source).ID
		schemaVolume2.Name = (*source).Name
		schemaVolume2.Server = c.pHcloudServerToPInt64((*source).Server)
		schemaVolume2.Status = string((*source).Status)
		schemaVolume2.Location = c.SchemaFromLocation((*source).Location)
		schemaVolume2.Size = (*source).Size
		schemaVolume2.Format = (*source).Format
		schemaVolume2.Protection = c.hcloudVolumeProtectionToSchemaVolumeProtection((*source).Protection)
		schemaVolume2.Labels = (*source).Labels
		schemaVolume2.LinuxDevice = (*source).LinuxDevice
		schemaVolume2.Created = c.timeTimeToTimeTime((*source).Created)
		schemaVolume = schemaVolume2
	}
	return schemaVolume
}
func (c *converterImpl) ServerFromSchema(source schema.Server) *Server {
	var hcloudServer Server
	hcloudServer.ID = source.ID
	hcloudServer.Name = source.Name
	hcloudServer.Status = ServerStatus(source.Status)
	hcloudServer.Created = c.timeTimeToTimeTime(source.Created)
	hcloudServer.PublicNet = c.ServerPublicNetFromSchema(source.PublicNet)
	if source.PrivateNet != nil {
		hcloudServer.PrivateNet = make([]ServerPrivateNet, len(source.PrivateNet))
		for i := 0; i < len(source.PrivateNet); i++ {
			hcloudServer.PrivateNet[i] = c.ServerPrivateNetFromSchema(source.PrivateNet[i])
		}
	}
	hcloudServer.ServerType = c.ServerTypeFromSchema(source.ServerType)
	hcloudServer.Datacenter = c.DatacenterFromSchema(source.Datacenter)
	hcloudServer.IncludedTraffic = source.IncludedTraffic
	if source.OutgoingTraffic != nil {
		hcloudServer.OutgoingTraffic = *source.OutgoingTraffic
	}
	if source.IngoingTraffic != nil {
		hcloudServer.IngoingTraffic = *source.IngoingTraffic
	}
	if source.BackupWindow != nil {
		hcloudServer.BackupWindow = *source.BackupWindow
	}
	hcloudServer.RescueEnabled = source.RescueEnabled
	hcloudServer.Locked = source.Locked
	hcloudServer.ISO = c.pSchemaISOToPHcloudISO(source.ISO)
	hcloudServer.Image = c.pSchemaImageToPHcloudImage(source.Image)
	hcloudServer.Protection = c.schemaServerProtectionToHcloudServerProtection(source.Protection)
	hcloudServer.Labels = source.Labels
	if source.Volumes != nil {
		hcloudServer.Volumes = make([]*Volume, len(source.Volumes))
		for j := 0; j < len(source.Volumes); j++ {
			hcloudServer.Volumes[j] = volumeFromInt64(source.Volumes[j])
		}
	}
	hcloudServer.PrimaryDiskSize = source.PrimaryDiskSize
	hcloudServer.PlacementGroup = c.pSchemaPlacementGroupToPHcloudPlacementGroup(source.PlacementGroup)
	if source.LoadBalancers != nil {
		hcloudServer.LoadBalancers = make([]*LoadBalancer, len(source.LoadBalancers))
		for k := 0; k < len(source.LoadBalancers); k++ {
			hcloudLoadBalancer := loadBalancerFromInt64(source.LoadBalancers[k])
			hcloudServer.LoadBalancers[k] = &hcloudLoadBalancer
		}
	}
	return &hcloudServer
}
func (c *converterImpl) ServerMetricsFromSchema(source *schema.ServerGetMetricsResponse) (*ServerMetrics, error) {
	var pHcloudServerMetrics *ServerMetrics
	if source != nil {
		var hcloudServerMetrics ServerMetrics
		hcloudServerMetrics.Start = c.timeTimeToTimeTime((*source).Metrics.Start)
		hcloudServerMetrics.End = c.timeTimeToTimeTime((*source).Metrics.End)
		hcloudServerMetrics.Step = (*source).Metrics.Step
		if (*source).Metrics.TimeSeries != nil {
			hcloudServerMetrics.TimeSeries = make(map[string][]ServerMetricsValue, len((*source).Metrics.TimeSeries))
			for key, value := range (*source).Metrics.TimeSeries {
				hcloudServerMetricsValueList, err := serverMetricsTimeSeriesFromSchema(value)
				if err != nil {
					return nil, err
				}
				hcloudServerMetrics.TimeSeries[key] = hcloudServerMetricsValueList
			}
		}
		pHcloudServerMetrics = &hcloudServerMetrics
	}
	return pHcloudServerMetrics, nil
}
func (c *converterImpl) ServerPrivateNetFromSchema(source schema.ServerPrivateNet) ServerPrivateNet {
	var hcloudServerPrivateNet ServerPrivateNet
	hcloudNetwork := networkFromInt64(source.Network)
	hcloudServerPrivateNet.Network = &hcloudNetwork
	hcloudServerPrivateNet.IP = ipFromString(source.IP)
	if source.AliasIPs != nil {
		hcloudServerPrivateNet.Aliases = make([]net.IP, len(source.AliasIPs))
		for i := 0; i < len(source.AliasIPs); i++ {
			hcloudServerPrivateNet.Aliases[i] = ipFromString(source.AliasIPs[i])
		}
	}
	hcloudServerPrivateNet.MACAddress = source.MACAddress
	return hcloudServerPrivateNet
}
func (c *converterImpl) ServerPublicNetFromSchema(source schema.ServerPublicNet) ServerPublicNet {
	var hcloudServerPublicNet ServerPublicNet
	hcloudServerPublicNet.IPv4 = c.ServerPublicNetIPv4FromSchema(source.IPv4)
	hcloudServerPublicNet.IPv6 = c.ServerPublicNetIPv6FromSchema(source.IPv6)
	if source.FloatingIPs != nil {
		hcloudServerPublicNet.FloatingIPs = make([]*FloatingIP, len(source.FloatingIPs))
		for i := 0; i < len(source.FloatingIPs); i++ {
			hcloudServerPublicNet.FloatingIPs[i] = floatingIPFromInt64(source.FloatingIPs[i])
		}
	}
	if source.Firewalls != nil {
		hcloudServerPublicNet.Firewalls = make([]*ServerFirewallStatus, len(source.Firewalls))
		for j := 0; j < len(source.Firewalls); j++ {
			hcloudServerPublicNet.Firewalls[j] = firewallStatusFromSchemaServerFirewall(source.Firewalls[j])
		}
	}
	return hcloudServerPublicNet
}
func (c *converterImpl) ServerPublicNetIPv4FromSchema(source schema.ServerPublicNetIPv4) ServerPublicNetIPv4 {
	var hcloudServerPublicNetIPv4 ServerPublicNetIPv4
	hcloudServerPublicNetIPv4.ID = source.ID
	hcloudServerPublicNetIPv4.IP = ipFromString(source.IP)
	hcloudServerPublicNetIPv4.Blocked = source.Blocked
	hcloudServerPublicNetIPv4.DNSPtr = source.DNSPtr
	return hcloudServerPublicNetIPv4
}
func (c *converterImpl) ServerPublicNetIPv6FromSchema(source schema.ServerPublicNetIPv6) ServerPublicNetIPv6 {
	var hcloudServerPublicNetIPv6 ServerPublicNetIPv6
	hcloudServerPublicNetIPv6.ID = source.ID
	hcloudServerPublicNetIPv6.IP = ipFromServerPublicNetIPv6Schema(source)
	hcloudServerPublicNetIPv6.Network = ipNetFromServerPublicNetIPv6Schema(source)
	hcloudServerPublicNetIPv6.Blocked = source.Blocked
	hcloudServerPublicNetIPv6.DNSPtr = mapFromServerPublicNetIPv6DNSPtrSchema(source.DNSPtr)
	return hcloudServerPublicNetIPv6
}
func (c *converterImpl) ServerTypeFromSchema(source schema.ServerType) *ServerType {
	var hcloudServerType ServerType
	hcloudServerType.ID = source.ID
	hcloudServerType.Name = source.Name
	hcloudServerType.Description = source.Description
	hcloudServerType.Cores = source.Cores
	hcloudServerType.Memory = source.Memory
	hcloudServerType.Disk = source.Disk
	hcloudServerType.StorageType = StorageType(source.StorageType)
	hcloudServerType.CPUType = CPUType(source.CPUType)
	hcloudServerType.Architecture = Architecture(source.Architecture)
	hcloudServerType.IncludedTraffic = source.IncludedTraffic
	if source.Prices != nil {
		hcloudServerType.Pricings = make([]ServerTypeLocationPricing, len(source.Prices))
		for i := 0; i < len(source.Prices); i++ {
			hcloudServerType.Pricings[i] = c.serverTypePricingFromSchema(source.Prices[i])
		}
	}
	hcloudServerType.DeprecatableResource = c.schemaDeprecatableResourceToHcloudDeprecatableResource(source.DeprecatableResource)
	return &hcloudServerType
}
func (c *converterImpl) VolumeFromSchema(source schema.Volume) *Volume {
	var hcloudVolume Volume
	hcloudVolume.ID = source.ID
	hcloudVolume.Name = source.Name
	hcloudVolume.Status = VolumeStatus(source.Status)
	if source.Server != nil {
		hcloudServer := serverFromInt64(*source.Server)
		hcloudVolume.Server = &hcloudServer
	}
	hcloudVolume.Location = c.LocationFromSchema(source.Location)
	hcloudVolume.Size = source.Size
	hcloudVolume.Format = source.Format
	hcloudVolume.Protection = c.schemaVolumeProtectionToHcloudVolumeProtection(source.Protection)
	hcloudVolume.Labels = source.Labels
	hcloudVolume.LinuxDevice = source.LinuxDevice
	hcloudVolume.Created = c.timeTimeToTimeTime(source.Created)
	return &hcloudVolume
}
func (c *converterImpl) hcloudCertificateStatusTypeToString(source CertificateStatusType) string {
	return string(source)
}
func (c *converterImpl) hcloudCertificateUsedByRefToSchemaCertificateUsedByRef(source CertificateUsedByRef) schema.CertificateUsedByRef {
	var schemaCertificateUsedByRef schema.CertificateUsedByRef
	schemaCertificateUsedByRef.ID = source.ID
	schemaCertificateUsedByRef.Type = string(source.Type)
	return schemaCertificateUsedByRef
}
func (c *converterImpl) hcloudDatacenterServerTypesToSchemaDatacenterServerTypes(source DatacenterServerTypes) schema.DatacenterServerTypes {
	var schemaDatacenterServerTypes schema.DatacenterServerTypes
	if source.Supported != nil {
		schemaDatacenterServerTypes.Supported = make([]int64, len(source.Supported))
		for i := 0; i < len(source.Supported); i++ {
			schemaDatacenterServerTypes.Supported[i] = int64FromServerType(source.Supported[i])
		}
	}
	if source.AvailableForMigration != nil {
		schemaDatacenterServerTypes.AvailableForMigration = make([]int64, len(source.AvailableForMigration))
		for j := 0; j < len(source.AvailableForMigration); j++ {
			schemaDatacenterServerTypes.AvailableForMigration[j] = int64FromServerType(source.AvailableForMigration[j])
		}
	}
	if source.Available != nil {
		schemaDatacenterServerTypes.Available = make([]int64, len(source.Available))
		for k := 0; k < len(source.Available); k++ {
			schemaDatacenterServerTypes.Available[k] = int64FromServerType(source.Available[k])
		}
	}
	return schemaDatacenterServerTypes
}
func (c *converterImpl) hcloudDeprecatableResourceToSchemaDeprecatableResource(source DeprecatableResource) schema.DeprecatableResource {
	var schemaDeprecatableResource schema.DeprecatableResource
	schemaDeprecatableResource.Deprecation = c.SchemaFromDeprecation(source.Deprecation)
	return schemaDeprecatableResource
}
func (c *converterImpl) hcloudFirewallRuleToSchemaFirewallRule(source FirewallRule) schema.FirewallRule {
	var schemaFirewallRule schema.FirewallRule
	schemaFirewallRule.Direction = string(source.Direction)
	if source.SourceIPs != nil {
		schemaFirewallRule.SourceIPs = make([]string, len(source.SourceIPs))
		for i := 0; i < len(source.SourceIPs); i++ {
			schemaFirewallRule.SourceIPs[i] = stringFromIPNet(source.SourceIPs[i])
		}
	}
	if source.DestinationIPs != nil {
		schemaFirewallRule.DestinationIPs = make([]string, len(source.DestinationIPs))
		for j := 0; j < len(source.DestinationIPs); j++ {
			schemaFirewallRule.DestinationIPs[j] = stringFromIPNet(source.DestinationIPs[j])
		}
	}
	schemaFirewallRule.Protocol = string(source.Protocol)
	schemaFirewallRule.Port = source.Port
	schemaFirewallRule.Description = source.Description
	return schemaFirewallRule
}
func (c *converterImpl) hcloudFirewallRuleToSchemaFirewallRuleRequest(source FirewallRule) schema.FirewallRuleRequest {
	var schemaFirewallRuleRequest schema.FirewallRuleRequest
	schemaFirewallRuleRequest.Direction = string(source.Direction)
	if source.SourceIPs != nil {
		schemaFirewallRuleRequest.SourceIPs = make([]string, len(source.SourceIPs))
		for i := 0; i < len(source.SourceIPs); i++ {
			schemaFirewallRuleRequest.SourceIPs[i] = stringFromIPNet(source.SourceIPs[i])
		}
	}
	if source.DestinationIPs != nil {
		schemaFirewallRuleRequest.DestinationIPs = make([]string, len(source.DestinationIPs))
		for j := 0; j < len(source.DestinationIPs); j++ {
			schemaFirewallRuleRequest.DestinationIPs[j] = stringFromIPNet(source.DestinationIPs[j])
		}
	}
	schemaFirewallRuleRequest.Protocol = string(source.Protocol)
	schemaFirewallRuleRequest.Port = source.Port
	schemaFirewallRuleRequest.Description = source.Description
	return schemaFirewallRuleRequest
}
func (c *converterImpl) hcloudFloatingIPProtectionToSchemaFloatingIPProtection(source FloatingIPProtection) schema.FloatingIPProtection {
	var schemaFloatingIPProtection schema.FloatingIPProtection
	schemaFloatingIPProtection.Delete = source.Delete
	return schemaFloatingIPProtection
}
func (c *converterImpl) hcloudImageProtectionToSchemaImageProtection(source ImageProtection) schema.ImageProtection {
	var schemaImageProtection schema.ImageProtection
	schemaImageProtection.Delete = source.Delete
	return schemaImageProtection
}
func (c *converterImpl) hcloudLoadBalancerAlgorithmToSchemaLoadBalancerAlgorithm(source LoadBalancerAlgorithm) schema.LoadBalancerAlgorithm {
	var schemaLoadBalancerAlgorithm schema.LoadBalancerAlgorithm
	schemaLoadBalancerAlgorithm.Type = string(source.Type)
	return schemaLoadBalancerAlgorithm
}
func (c *converterImpl) hcloudLoadBalancerCreateOptsServiceToSchemaLoadBalancerCreateRequestService(source LoadBalancerCreateOptsService) schema.LoadBalancerCreateRequestService {
	var schemaLoadBalancerCreateRequestService schema.LoadBalancerCreateRequestService
	schemaLoadBalancerCreateRequestService.Protocol = string(source.Protocol)
	schemaLoadBalancerCreateRequestService.ListenPort = source.ListenPort
	schemaLoadBalancerCreateRequestService.DestinationPort = source.DestinationPort
	schemaLoadBalancerCreateRequestService.Proxyprotocol = source.Proxyprotocol
	schemaLoadBalancerCreateRequestService.HTTP = c.pHcloudLoadBalancerCreateOptsServiceHTTPToPSchemaLoadBalancerCreateRequestServiceHTTP(source.HTTP)
	schemaLoadBalancerCreateRequestService.HealthCheck = c.pHcloudLoadBalancerCreateOptsServiceHealthCheckToPSchemaLoadBalancerCreateRequestServiceHealthCheck(source.HealthCheck)
	return schemaLoadBalancerCreateRequestService
}
func (c *converterImpl) hcloudLoadBalancerCreateOptsTargetToSchemaLoadBalancerCreateRequestTarget(source LoadBalancerCreateOptsTarget) schema.LoadBalancerCreateRequestTarget {
	var schemaLoadBalancerCreateRequestTarget schema.LoadBalancerCreateRequestTarget
	schemaLoadBalancerCreateRequestTarget.Type = string(source.Type)
	schemaLoadBalancerCreateRequestTarget.Server = schemaFromLoadBalancerCreateOptsTargetServer(source.Server)
	schemaLoadBalancerCreateRequestTarget.LabelSelector = schemaFromLoadBalancerCreateOptsTargetLabelSelector(source.LabelSelector)
	schemaLoadBalancerCreateRequestTarget.IP = schemaFromLoadBalancerCreateOptsTargetIP(source.IP)
	schemaLoadBalancerCreateRequestTarget.UsePrivateIP = source.UsePrivateIP
	return schemaLoadBalancerCreateRequestTarget
}
func (c *converterImpl) hcloudLoadBalancerPrivateNetToSchemaLoadBalancerPrivateNet(source LoadBalancerPrivateNet) schema.LoadBalancerPrivateNet {
	var schemaLoadBalancerPrivateNet schema.LoadBalancerPrivateNet
	schemaLoadBalancerPrivateNet.Network = c.pHcloudNetworkToInt64(source.Network)
	schemaLoadBalancerPrivateNet.IP = stringFromIP(source.IP)
	return schemaLoadBalancerPrivateNet
}
func (c *converterImpl) hcloudLoadBalancerProtectionToSchemaLoadBalancerProtection(source LoadBalancerProtection) schema.LoadBalancerProtection {
	var schemaLoadBalancerProtection schema.LoadBalancerProtection
	schemaLoadBalancerProtection.Delete = source.Delete
	return schemaLoadBalancerProtection
}
func (c *converterImpl) hcloudLoadBalancerPublicNetIPv4ToSchemaLoadBalancerPublicNetIPv4(source LoadBalancerPublicNetIPv4) schema.LoadBalancerPublicNetIPv4 {
	var schemaLoadBalancerPublicNetIPv4 schema.LoadBalancerPublicNetIPv4
	schemaLoadBalancerPublicNetIPv4.IP = stringFromIP(source.IP)
	schemaLoadBalancerPublicNetIPv4.DNSPtr = source.DNSPtr
	return schemaLoadBalancerPublicNetIPv4
}
func (c *converterImpl) hcloudLoadBalancerPublicNetIPv6ToSchemaLoadBalancerPublicNetIPv6(source LoadBalancerPublicNetIPv6) schema.LoadBalancerPublicNetIPv6 {
	var schemaLoadBalancerPublicNetIPv6 schema.LoadBalancerPublicNetIPv6
	schemaLoadBalancerPublicNetIPv6.IP = stringFromIP(source.IP)
	schemaLoadBalancerPublicNetIPv6.DNSPtr = source.DNSPtr
	return schemaLoadBalancerPublicNetIPv6
}
func (c *converterImpl) hcloudLoadBalancerPublicNetToSchemaLoadBalancerPublicNet(source LoadBalancerPublicNet) schema.LoadBalancerPublicNet {
	var schemaLoadBalancerPublicNet schema.LoadBalancerPublicNet
	schemaLoadBalancerPublicNet.Enabled = source.Enabled
	schemaLoadBalancerPublicNet.IPv4 = c.hcloudLoadBalancerPublicNetIPv4ToSchemaLoadBalancerPublicNetIPv4(source.IPv4)
	schemaLoadBalancerPublicNet.IPv6 = c.hcloudLoadBalancerPublicNetIPv6ToSchemaLoadBalancerPublicNetIPv6(source.IPv6)
	return schemaLoadBalancerPublicNet
}
func (c *converterImpl) hcloudLoadBalancerServiceHTTPToPSchemaLoadBalancerServiceHTTP(source LoadBalancerServiceHTTP) *schema.LoadBalancerServiceHTTP {
	var schemaLoadBalancerServiceHTTP schema.LoadBalancerServiceHTTP
	schemaLoadBalancerServiceHTTP.CookieName = source.CookieName
	schemaLoadBalancerServiceHTTP.CookieLifetime = intSecondsFromDuration(source.CookieLifetime)
	if source.Certificates != nil {
		schemaLoadBalancerServiceHTTP.Certificates = make([]int64, len(source.Certificates))
		for i := 0; i < len(source.Certificates); i++ {
			schemaLoadBalancerServiceHTTP.Certificates[i] = int64FromCertificate(source.Certificates[i])
		}
	}
	schemaLoadBalancerServiceHTTP.RedirectHTTP = source.RedirectHTTP
	schemaLoadBalancerServiceHTTP.StickySessions = source.StickySessions
	return &schemaLoadBalancerServiceHTTP
}
func (c *converterImpl) hcloudNetworkProtectionToSchemaNetworkProtection(source NetworkProtection) schema.NetworkProtection {
	var schemaNetworkProtection schema.NetworkProtection
	schemaNetworkProtection.Delete = source.Delete
	return schemaNetworkProtection
}
func (c *converterImpl) hcloudPriceToSchemaPrice(source Price) schema.Price {
	var schemaPrice schema.Price
	schemaPrice.Net = source.Net
	schemaPrice.Gross = source.Gross
	return schemaPrice
}
func (c *converterImpl) hcloudPrimaryIPPriceToSchemaPrice(source PrimaryIPPrice) schema.Price {
	var schemaPrice schema.Price
	schemaPrice.Net = source.Net
	schemaPrice.Gross = source.Gross
	return schemaPrice
}
func (c *converterImpl) hcloudPrimaryIPProtectionToSchemaPrimaryIPProtection(source PrimaryIPProtection) schema.PrimaryIPProtection {
	var schemaPrimaryIPProtection schema.PrimaryIPProtection
	schemaPrimaryIPProtection.Delete = source.Delete
	return schemaPrimaryIPProtection
}
func (c *converterImpl) hcloudServerBackupPricingToSchemaPricingServerBackup(source ServerBackupPricing) schema.PricingServerBackup {
	var schemaPricingServerBackup schema.PricingServerBackup
	schemaPricingServerBackup.Percentage = source.Percentage
	return schemaPricingServerBackup
}
func (c *converterImpl) hcloudServerProtectionToSchemaServerProtection(source ServerProtection) schema.ServerProtection {
	var schemaServerProtection schema.ServerProtection
	schemaServerProtection.Delete = source.Delete
	schemaServerProtection.Rebuild = source.Rebuild
	return schemaServerProtection
}
func (c *converterImpl) hcloudVolumeProtectionToSchemaVolumeProtection(source VolumeProtection) schema.VolumeProtection {
	var schemaVolumeProtection schema.VolumeProtection
	schemaVolumeProtection.Delete = source.Delete
	return schemaVolumeProtection
}
func (c *converterImpl) intISOFromSchema(source schema.ISO) ISO {
	var hcloudISO ISO
	hcloudISO.ID = source.ID
	hcloudISO.Name = source.Name
	hcloudISO.Description = source.Description
	hcloudISO.Type = ISOType(source.Type)
	if source.Architecture != nil {
		hcloudArchitecture := Architecture(*source.Architecture)
		hcloudISO.Architecture = &hcloudArchitecture
	}
	var pTimeTime *time.Time
	if source.DeprecatableResource.Deprecation != nil {
		pTimeTime = &source.DeprecatableResource.Deprecation.UnavailableAfter
	}
	hcloudISO.Deprecated = c.pTimeTimeToTimeTime(pTimeTime)
	hcloudISO.DeprecatableResource = c.schemaDeprecatableResourceToHcloudDeprecatableResource(source.DeprecatableResource)
	return hcloudISO
}
func (c *converterImpl) intSchemaFromImage(source Image) schema.Image {
	var schemaImage schema.Image
	schemaImage.ID = source.ID
	schemaImage.Status = string(source.Status)
	schemaImage.Type = string(source.Type)
	pString := source.Name
	schemaImage.Name = &pString
	schemaImage.Description = source.Description
	schemaImage.ImageSize = mapZeroFloat32ToNil(source.ImageSize)
	schemaImage.DiskSize = source.DiskSize
	schemaImage.Created = timeToTimePtr(source.Created)
	schemaImage.CreatedFrom = c.pHcloudServerToPSchemaImageCreatedFrom(source.CreatedFrom)
	schemaImage.BoundTo = c.pHcloudServerToPInt64(source.BoundTo)
	schemaImage.OSFlavor = source.OSFlavor
	pString2 := source.OSVersion
	schemaImage.OSVersion = &pString2
	schemaImage.Architecture = string(source.Architecture)
	schemaImage.RapidDeploy = source.RapidDeploy
	schemaImage.Protection = c.hcloudImageProtectionToSchemaImageProtection(source.Protection)
	schemaImage.Deprecated = timeToTimePtr(source.Deprecated)
	schemaImage.Deleted = timeToTimePtr(source.Deleted)
	schemaImage.Labels = source.Labels
	return schemaImage
}
func (c *converterImpl) pHcloudActionResourceToSchemaActionResourceReference(source *ActionResource) schema.ActionResourceReference {
	var schemaActionResourceReference schema.ActionResourceReference
	if source != nil {
		var schemaActionResourceReference2 schema.ActionResourceReference
		schemaActionResourceReference2.ID = (*source).ID
		schemaActionResourceReference2.Type = string((*source).Type)
		schemaActionResourceReference = schemaActionResourceReference2
	}
	return schemaActionResourceReference
}
func (c *converterImpl) pHcloudCertificateStatusToPSchemaCertificateStatusRef(source *CertificateStatus) *schema.CertificateStatusRef {
	var pSchemaCertificateStatusRef *schema.CertificateStatusRef
	if source != nil {
		var schemaCertificateStatusRef schema.CertificateStatusRef
		schemaCertificateStatusRef.Issuance = c.hcloudCertificateStatusTypeToString((*source).Issuance)
		schemaCertificateStatusRef.Renewal = c.hcloudCertificateStatusTypeToString((*source).Renewal)
		schemaCertificateStatusRef.Error = c.pHcloudErrorToPSchemaError((*source).Error)
		pSchemaCertificateStatusRef = &schemaCertificateStatusRef
	}
	return pSchemaCertificateStatusRef
}
func (c *converterImpl) pHcloudErrorToPSchemaError(source *Error) *schema.Error {
	var pSchemaError *schema.Error
	if source != nil {
		schemaError := c.SchemaFromError((*source))
		pSchemaError = &schemaError
	}
	return pSchemaError
}
func (c *converterImpl) pHcloudFirewallResourceLabelSelectorToPSchemaFirewallResourceLabelSelector(source *FirewallResourceLabelSelector) *schema.FirewallResourceLabelSelector {
	var pSchemaFirewallResourceLabelSelector *schema.FirewallResourceLabelSelector
	if source != nil {
		var schemaFirewallResourceLabelSelector schema.FirewallResourceLabelSelector
		schemaFirewallResourceLabelSelector.Selector = (*source).Selector
		pSchemaFirewallResourceLabelSelector = &schemaFirewallResourceLabelSelector
	}
	return pSchemaFirewallResourceLabelSelector
}
func (c *converterImpl) pHcloudFirewallResourceServerToPSchemaFirewallResourceServer(source *FirewallResourceServer) *schema.FirewallResourceServer {
	var pSchemaFirewallResourceServer *schema.FirewallResourceServer
	if source != nil {
		var schemaFirewallResourceServer schema.FirewallResourceServer
		schemaFirewallResourceServer.ID = (*source).ID
		pSchemaFirewallResourceServer = &schemaFirewallResourceServer
	}
	return pSchemaFirewallResourceServer
}
func (c *converterImpl) pHcloudISOToPSchemaISO(source *ISO) *schema.ISO {
	var pSchemaISO *schema.ISO
	if source != nil {
		var schemaISO schema.ISO
		schemaISO.ID = (*source).ID
		schemaISO.Name = (*source).Name
		schemaISO.Description = (*source).Description
		schemaISO.Type = string((*source).Type)
		if (*source).Architecture != nil {
			xstring := string(*(*source).Architecture)
			schemaISO.Architecture = &xstring
		}
		schemaISO.DeprecatableResource = c.hcloudDeprecatableResourceToSchemaDeprecatableResource((*source).DeprecatableResource)
		pSchemaISO = &schemaISO
	}
	return pSchemaISO
}
func (c *converterImpl) pHcloudImageToPSchemaImage(source *Image) *schema.Image {
	var pSchemaImage *schema.Image
	if source != nil {
		schemaImage := c.intSchemaFromImage((*source))
		pSchemaImage = &schemaImage
	}
	return pSchemaImage
}
func (c *converterImpl) pHcloudLoadBalancerAddServiceOptsHTTPToPSchemaLoadBalancerActionAddServiceRequestHTTP(source *LoadBalancerAddServiceOptsHTTP) *schema.LoadBalancerActionAddServiceRequestHTTP {
	var pSchemaLoadBalancerActionAddServiceRequestHTTP *schema.LoadBalancerActionAddServiceRequestHTTP
	if source != nil {
		var schemaLoadBalancerActionAddServiceRequestHTTP schema.LoadBalancerActionAddServiceRequestHTTP
		schemaLoadBalancerActionAddServiceRequestHTTP.CookieName = (*source).CookieName
		if (*source).CookieLifetime != nil {
			xint := intSecondsFromDuration(*(*source).CookieLifetime)
			schemaLoadBalancerActionAddServiceRequestHTTP.CookieLifetime = &xint
		}
		schemaLoadBalancerActionAddServiceRequestHTTP.Certificates = int64SlicePtrFromCertificatePtrSlice((*source).Certificates)
		schemaLoadBalancerActionAddServiceRequestHTTP.RedirectHTTP = (*source).RedirectHTTP
		schemaLoadBalancerActionAddServiceRequestHTTP.StickySessions = (*source).StickySessions
		pSchemaLoadBalancerActionAddServiceRequestHTTP = &schemaLoadBalancerActionAddServiceRequestHTTP
	}
	return pSchemaLoadBalancerActionAddServiceRequestHTTP
}
func (c *converterImpl) pHcloudLoadBalancerAddServiceOptsHealthCheckHTTPToPSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP(source *LoadBalancerAddServiceOptsHealthCheckHTTP) *schema.LoadBalancerActionAddServiceRequestHealthCheckHTTP {
	var pSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP *schema.LoadBalancerActionAddServiceRequestHealthCheckHTTP
	if source != nil {
		var schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP schema.LoadBalancerActionAddServiceRequestHealthCheckHTTP
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.Domain = (*source).Domain
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.Path = (*source).Path
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.Response = (*source).Response
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.StatusCodes = stringSlicePtrFromStringSlice((*source).StatusCodes)
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.TLS = (*source).TLS
		pSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP = &schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP
	}
	return pSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP
}
func (c *converterImpl) pHcloudLoadBalancerAddServiceOptsHealthCheckToPSchemaLoadBalancerActionAddServiceRequestHealthCheck(source *LoadBalancerAddServiceOptsHealthCheck) *schema.LoadBalancerActionAddServiceRequestHealthCheck {
	var pSchemaLoadBalancerActionAddServiceRequestHealthCheck *schema.LoadBalancerActionAddServiceRequestHealthCheck
	if source != nil {
		var schemaLoadBalancerActionAddServiceRequestHealthCheck schema.LoadBalancerActionAddServiceRequestHealthCheck
		schemaLoadBalancerActionAddServiceRequestHealthCheck.Protocol = string((*source).Protocol)
		schemaLoadBalancerActionAddServiceRequestHealthCheck.Port = (*source).Port
		if (*source).Interval != nil {
			xint := intSecondsFromDuration(*(*source).Interval)
			schemaLoadBalancerActionAddServiceRequestHealthCheck.Interval = &xint
		}
		if (*source).Timeout != nil {
			xint2 := intSecondsFromDuration(*(*source).Timeout)
			schemaLoadBalancerActionAddServiceRequestHealthCheck.Timeout = &xint2
		}
		schemaLoadBalancerActionAddServiceRequestHealthCheck.Retries = (*source).Retries
		schemaLoadBalancerActionAddServiceRequestHealthCheck.HTTP = c.pHcloudLoadBalancerAddServiceOptsHealthCheckHTTPToPSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP((*source).HTTP)
		pSchemaLoadBalancerActionAddServiceRequestHealthCheck = &schemaLoadBalancerActionAddServiceRequestHealthCheck
	}
	return pSchemaLoadBalancerActionAddServiceRequestHealthCheck
}
func (c *converterImpl) pHcloudLoadBalancerAlgorithmToPSchemaLoadBalancerCreateRequestAlgorithm(source *LoadBalancerAlgorithm) *schema.LoadBalancerCreateRequestAlgorithm {
	var pSchemaLoadBalancerCreateRequestAlgorithm *schema.LoadBalancerCreateRequestAlgorithm
	if source != nil {
		var schemaLoadBalancerCreateRequestAlgorithm schema.LoadBalancerCreateRequestAlgorithm
		schemaLoadBalancerCreateRequestAlgorithm.Type = string((*source).Type)
		pSchemaLoadBalancerCreateRequestAlgorithm = &schemaLoadBalancerCreateRequestAlgorithm
	}
	return pSchemaLoadBalancerCreateRequestAlgorithm
}
func (c *converterImpl) pHcloudLoadBalancerCreateOptsServiceHTTPToPSchemaLoadBalancerCreateRequestServiceHTTP(source *LoadBalancerCreateOptsServiceHTTP) *schema.LoadBalancerCreateRequestServiceHTTP {
	var pSchemaLoadBalancerCreateRequestServiceHTTP *schema.LoadBalancerCreateRequestServiceHTTP
	if source != nil {
		var schemaLoadBalancerCreateRequestServiceHTTP schema.LoadBalancerCreateRequestServiceHTTP
		schemaLoadBalancerCreateRequestServiceHTTP.CookieName = (*source).CookieName
		if (*source).CookieLifetime != nil {
			xint := intSecondsFromDuration(*(*source).CookieLifetime)
			schemaLoadBalancerCreateRequestServiceHTTP.CookieLifetime = &xint
		}
		schemaLoadBalancerCreateRequestServiceHTTP.Certificates = int64SlicePtrFromCertificatePtrSlice((*source).Certificates)
		schemaLoadBalancerCreateRequestServiceHTTP.RedirectHTTP = (*source).RedirectHTTP
		schemaLoadBalancerCreateRequestServiceHTTP.StickySessions = (*source).StickySessions
		pSchemaLoadBalancerCreateRequestServiceHTTP = &schemaLoadBalancerCreateRequestServiceHTTP
	}
	return pSchemaLoadBalancerCreateRequestServiceHTTP
}
func (c *converterImpl) pHcloudLoadBalancerCreateOptsServiceHealthCheckHTTPToPSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP(source *LoadBalancerCreateOptsServiceHealthCheckHTTP) *schema.LoadBalancerCreateRequestServiceHealthCheckHTTP {
	var pSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP *schema.LoadBalancerCreateRequestServiceHealthCheckHTTP
	if source != nil {
		var schemaLoadBalancerCreateRequestServiceHealthCheckHTTP schema.LoadBalancerCreateRequestServiceHealthCheckHTTP
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.Domain = (*source).Domain
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.Path = (*source).Path
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.Response = (*source).Response
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.StatusCodes = stringSlicePtrFromStringSlice((*source).StatusCodes)
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.TLS = (*source).TLS
		pSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP = &schemaLoadBalancerCreateRequestServiceHealthCheckHTTP
	}
	return pSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP
}
func (c *converterImpl) pHcloudLoadBalancerCreateOptsServiceHealthCheckToPSchemaLoadBalancerCreateRequestServiceHealthCheck(source *LoadBalancerCreateOptsServiceHealthCheck) *schema.LoadBalancerCreateRequestServiceHealthCheck {
	var pSchemaLoadBalancerCreateRequestServiceHealthCheck *schema.LoadBalancerCreateRequestServiceHealthCheck
	if source != nil {
		var schemaLoadBalancerCreateRequestServiceHealthCheck schema.LoadBalancerCreateRequestServiceHealthCheck
		schemaLoadBalancerCreateRequestServiceHealthCheck.Protocol = string((*source).Protocol)
		schemaLoadBalancerCreateRequestServiceHealthCheck.Port = (*source).Port
		if (*source).Interval != nil {
			xint := intSecondsFromDuration(*(*source).Interval)
			schemaLoadBalancerCreateRequestServiceHealthCheck.Interval = &xint
		}
		if (*source).Timeout != nil {
			xint2 := intSecondsFromDuration(*(*source).Timeout)
			schemaLoadBalancerCreateRequestServiceHealthCheck.Timeout = &xint2
		}
		schemaLoadBalancerCreateRequestServiceHealthCheck.Retries = (*source).Retries
		schemaLoadBalancerCreateRequestServiceHealthCheck.HTTP = c.pHcloudLoadBalancerCreateOptsServiceHealthCheckHTTPToPSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP((*source).HTTP)
		pSchemaLoadBalancerCreateRequestServiceHealthCheck = &schemaLoadBalancerCreateRequestServiceHealthCheck
	}
	return pSchemaLoadBalancerCreateRequestServiceHealthCheck
}
func (c *converterImpl) pHcloudLoadBalancerServiceHealthCheckHTTPToPSchemaLoadBalancerServiceHealthCheckHTTP(source *LoadBalancerServiceHealthCheckHTTP) *schema.LoadBalancerServiceHealthCheckHTTP {
	var pSchemaLoadBalancerServiceHealthCheckHTTP *schema.LoadBalancerServiceHealthCheckHTTP
	if source != nil {
		var schemaLoadBalancerServiceHealthCheckHTTP schema.LoadBalancerServiceHealthCheckHTTP
		schemaLoadBalancerServiceHealthCheckHTTP.Domain = (*source).Domain
		schemaLoadBalancerServiceHealthCheckHTTP.Path = (*source).Path
		schemaLoadBalancerServiceHealthCheckHTTP.Response = (*source).Response
		schemaLoadBalancerServiceHealthCheckHTTP.StatusCodes = (*source).StatusCodes
		schemaLoadBalancerServiceHealthCheckHTTP.TLS = (*source).TLS
		pSchemaLoadBalancerServiceHealthCheckHTTP = &schemaLoadBalancerServiceHealthCheckHTTP
	}
	return pSchemaLoadBalancerServiceHealthCheckHTTP
}
func (c *converterImpl) pHcloudLoadBalancerTargetIPToPSchemaLoadBalancerTargetIP(source *LoadBalancerTargetIP) *schema.LoadBalancerTargetIP {
	var pSchemaLoadBalancerTargetIP *schema.LoadBalancerTargetIP
	if source != nil {
		var schemaLoadBalancerTargetIP schema.LoadBalancerTargetIP
		schemaLoadBalancerTargetIP.IP = (*source).IP
		pSchemaLoadBalancerTargetIP = &schemaLoadBalancerTargetIP
	}
	return pSchemaLoadBalancerTargetIP
}
func (c *converterImpl) pHcloudLoadBalancerTargetLabelSelectorToPSchemaLoadBalancerTargetLabelSelector(source *LoadBalancerTargetLabelSelector) *schema.LoadBalancerTargetLabelSelector {
	var pSchemaLoadBalancerTargetLabelSelector *schema.LoadBalancerTargetLabelSelector
	if source != nil {
		var schemaLoadBalancerTargetLabelSelector schema.LoadBalancerTargetLabelSelector
		schemaLoadBalancerTargetLabelSelector.Selector = (*source).Selector
		pSchemaLoadBalancerTargetLabelSelector = &schemaLoadBalancerTargetLabelSelector
	}
	return pSchemaLoadBalancerTargetLabelSelector
}
func (c *converterImpl) pHcloudLoadBalancerTargetServerToPSchemaLoadBalancerTargetServer(source *LoadBalancerTargetServer) *schema.LoadBalancerTargetServer {
	var pSchemaLoadBalancerTargetServer *schema.LoadBalancerTargetServer
	if source != nil {
		schemaLoadBalancerTargetServer := c.SchemaFromLoadBalancerServerTarget((*source))
		pSchemaLoadBalancerTargetServer = &schemaLoadBalancerTargetServer
	}
	return pSchemaLoadBalancerTargetServer
}
func (c *converterImpl) pHcloudLoadBalancerToInt64(source *LoadBalancer) int64 {
	var xint64 int64
	if source != nil {
		xint64 = int64FromLoadBalancer((*source))
	}
	return xint64
}
func (c *converterImpl) pHcloudLoadBalancerTypeToSchemaIDOrName(source *LoadBalancerType) schema.IDOrName {
	var schemaIDOrName schema.IDOrName
	if source != nil {
		var schemaIDOrName2 schema.IDOrName
		schemaIDOrName2.ID = (*source).ID
		schemaIDOrName2.Name = (*source).Name
		schemaIDOrName = schemaIDOrName2
	}
	return schemaIDOrName
}
func (c *converterImpl) pHcloudLoadBalancerUpdateServiceOptsHTTPToPSchemaLoadBalancerActionUpdateServiceRequestHTTP(source *LoadBalancerUpdateServiceOptsHTTP) *schema.LoadBalancerActionUpdateServiceRequestHTTP {
	var pSchemaLoadBalancerActionUpdateServiceRequestHTTP *schema.LoadBalancerActionUpdateServiceRequestHTTP
	if source != nil {
		var schemaLoadBalancerActionUpdateServiceRequestHTTP schema.LoadBalancerActionUpdateServiceRequestHTTP
		schemaLoadBalancerActionUpdateServiceRequestHTTP.CookieName = (*source).CookieName
		if (*source).CookieLifetime != nil {
			xint := intSecondsFromDuration(*(*source).CookieLifetime)
			schemaLoadBalancerActionUpdateServiceRequestHTTP.CookieLifetime = &xint
		}
		schemaLoadBalancerActionUpdateServiceRequestHTTP.Certificates = int64SlicePtrFromCertificatePtrSlice((*source).Certificates)
		schemaLoadBalancerActionUpdateServiceRequestHTTP.RedirectHTTP = (*source).RedirectHTTP
		schemaLoadBalancerActionUpdateServiceRequestHTTP.StickySessions = (*source).StickySessions
		pSchemaLoadBalancerActionUpdateServiceRequestHTTP = &schemaLoadBalancerActionUpdateServiceRequestHTTP
	}
	return pSchemaLoadBalancerActionUpdateServiceRequestHTTP
}
func (c *converterImpl) pHcloudLoadBalancerUpdateServiceOptsHealthCheckHTTPToPSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP(source *LoadBalancerUpdateServiceOptsHealthCheckHTTP) *schema.LoadBalancerActionUpdateServiceRequestHealthCheckHTTP {
	var pSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP *schema.LoadBalancerActionUpdateServiceRequestHealthCheckHTTP
	if source != nil {
		var schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP schema.LoadBalancerActionUpdateServiceRequestHealthCheckHTTP
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.Domain = (*source).Domain
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.Path = (*source).Path
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.Response = (*source).Response
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.StatusCodes = stringSlicePtrFromStringSlice((*source).StatusCodes)
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.TLS = (*source).TLS
		pSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP = &schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP
	}
	return pSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP
}
func (c *converterImpl) pHcloudLoadBalancerUpdateServiceOptsHealthCheckToPSchemaLoadBalancerActionUpdateServiceRequestHealthCheck(source *LoadBalancerUpdateServiceOptsHealthCheck) *schema.LoadBalancerActionUpdateServiceRequestHealthCheck {
	var pSchemaLoadBalancerActionUpdateServiceRequestHealthCheck *schema.LoadBalancerActionUpdateServiceRequestHealthCheck
	if source != nil {
		var schemaLoadBalancerActionUpdateServiceRequestHealthCheck schema.LoadBalancerActionUpdateServiceRequestHealthCheck
		schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Protocol = stringPtrFromLoadBalancerServiceProtocol((*source).Protocol)
		schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Port = (*source).Port
		if (*source).Interval != nil {
			xint := intSecondsFromDuration(*(*source).Interval)
			schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Interval = &xint
		}
		if (*source).Timeout != nil {
			xint2 := intSecondsFromDuration(*(*source).Timeout)
			schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Timeout = &xint2
		}
		schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Retries = (*source).Retries
		schemaLoadBalancerActionUpdateServiceRequestHealthCheck.HTTP = c.pHcloudLoadBalancerUpdateServiceOptsHealthCheckHTTPToPSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP((*source).HTTP)
		pSchemaLoadBalancerActionUpdateServiceRequestHealthCheck = &schemaLoadBalancerActionUpdateServiceRequestHealthCheck
	}
	return pSchemaLoadBalancerActionUpdateServiceRequestHealthCheck
}
func (c *converterImpl) pHcloudLocationToPString(source *Location) *string {
	var pString *string
	if source != nil {
		xstring := stringFromLocation((*source))
		pString = &xstring
	}
	return pString
}
func (c *converterImpl) pHcloudLocationToString(source *Location) string {
	var xstring string
	if source != nil {
		xstring = stringFromLocation((*source))
	}
	return xstring
}
func (c *converterImpl) pHcloudNetworkToInt64(source *Network) int64 {
	var xint64 int64
	if source != nil {
		xint64 = int64FromNetwork((*source))
	}
	return xint64
}
func (c *converterImpl) pHcloudNetworkToPInt64(source *Network) *int64 {
	var pInt64 *int64
	if source != nil {
		xint64 := int64FromNetwork((*source))
		pInt64 = &xint64
	}
	return pInt64
}
func (c *converterImpl) pHcloudPlacementGroupToPSchemaPlacementGroup(source *PlacementGroup) *schema.PlacementGroup {
	var pSchemaPlacementGroup *schema.PlacementGroup
	if source != nil {
		var schemaPlacementGroup schema.PlacementGroup
		schemaPlacementGroup.ID = (*source).ID
		schemaPlacementGroup.Name = (*source).Name
		schemaPlacementGroup.Labels = (*source).Labels
		schemaPlacementGroup.Created = c.timeTimeToTimeTime((*source).Created)
		schemaPlacementGroup.Servers = (*source).Servers
		schemaPlacementGroup.Type = string((*source).Type)
		pSchemaPlacementGroup = &schemaPlacementGroup
	}
	return pSchemaPlacementGroup
}
func (c *converterImpl) pHcloudServerToInt64(source *Server) int64 {
	var xint64 int64
	if source != nil {
		xint64 = int64FromServer((*source))
	}
	return xint64
}
func (c *converterImpl) pHcloudServerToPInt64(source *Server) *int64 {
	var pInt64 *int64
	if source != nil {
		xint64 := int64FromServer((*source))
		pInt64 = &xint64
	}
	return pInt64
}
func (c *converterImpl) pHcloudServerToPSchemaImageCreatedFrom(source *Server) *schema.ImageCreatedFrom {
	var pSchemaImageCreatedFrom *schema.ImageCreatedFrom
	if source != nil {
		var schemaImageCreatedFrom schema.ImageCreatedFrom
		schemaImageCreatedFrom.ID = (*source).ID
		schemaImageCreatedFrom.Name = (*source).Name
		pSchemaImageCreatedFrom = &schemaImageCreatedFrom
	}
	return pSchemaImageCreatedFrom
}
func (c *converterImpl) pNetIPNetToString(source *net.IPNet) string {
	var xstring string
	if source != nil {
		xstring = stringFromIPNet((*source))
	}
	return xstring
}
func (c *converterImpl) pSchemaCertificateStatusRefToPHcloudCertificateStatus(source *schema.CertificateStatusRef) *CertificateStatus {
	var pHcloudCertificateStatus *CertificateStatus
	if source != nil {
		var hcloudCertificateStatus CertificateStatus
		hcloudCertificateStatus.Issuance = CertificateStatusType((*source).Issuance)
		hcloudCertificateStatus.Renewal = CertificateStatusType((*source).Renewal)
		hcloudCertificateStatus.Error = c.pSchemaErrorToPHcloudError((*source).Error)
		pHcloudCertificateStatus = &hcloudCertificateStatus
	}
	return pHcloudCertificateStatus
}
func (c *converterImpl) pSchemaErrorToPHcloudError(source *schema.Error) *Error {
	var pHcloudError *Error
	if source != nil {
		hcloudError := c.ErrorFromSchema((*source))
		pHcloudError = &hcloudError
	}
	return pHcloudError
}
func (c *converterImpl) pSchemaFirewallResourceLabelSelectorToPHcloudFirewallResourceLabelSelector(source *schema.FirewallResourceLabelSelector) *FirewallResourceLabelSelector {
	var pHcloudFirewallResourceLabelSelector *FirewallResourceLabelSelector
	if source != nil {
		var hcloudFirewallResourceLabelSelector FirewallResourceLabelSelector
		hcloudFirewallResourceLabelSelector.Selector = (*source).Selector
		pHcloudFirewallResourceLabelSelector = &hcloudFirewallResourceLabelSelector
	}
	return pHcloudFirewallResourceLabelSelector
}
func (c *converterImpl) pSchemaFirewallResourceServerToPHcloudFirewallResourceServer(source *schema.FirewallResourceServer) *FirewallResourceServer {
	var pHcloudFirewallResourceServer *FirewallResourceServer
	if source != nil {
		var hcloudFirewallResourceServer FirewallResourceServer
		hcloudFirewallResourceServer.ID = (*source).ID
		pHcloudFirewallResourceServer = &hcloudFirewallResourceServer
	}
	return pHcloudFirewallResourceServer
}
func (c *converterImpl) pSchemaISOToPHcloudISO(source *schema.ISO) *ISO {
	var pHcloudISO *ISO
	if source != nil {
		hcloudISO := c.intISOFromSchema((*source))
		pHcloudISO = &hcloudISO
	}
	return pHcloudISO
}
func (c *converterImpl) pSchemaImageCreatedFromToPHcloudServer(source *schema.ImageCreatedFrom) *Server {
	var pHcloudServer *Server
	if source != nil {
		hcloudServer := serverFromImageCreatedFromSchema((*source))
		pHcloudServer = &hcloudServer
	}
	return pHcloudServer
}
func (c *converterImpl) pSchemaImageToPHcloudImage(source *schema.Image) *Image {
	var pHcloudImage *Image
	if source != nil {
		var hcloudImage Image
		hcloudImage.ID = (*source).ID
		if (*source).Name != nil {
			hcloudImage.Name = *(*source).Name
		}
		hcloudImage.Type = ImageType((*source).Type)
		hcloudImage.Status = ImageStatus((*source).Status)
		hcloudImage.Description = (*source).Description
		if (*source).ImageSize != nil {
			hcloudImage.ImageSize = *(*source).ImageSize
		}
		hcloudImage.DiskSize = (*source).DiskSize
		hcloudImage.Created = c.pTimeTimeToTimeTime((*source).Created)
		hcloudImage.CreatedFrom = c.pSchemaImageCreatedFromToPHcloudServer((*source).CreatedFrom)
		if (*source).BoundTo != nil {
			hcloudServer := serverFromInt64(*(*source).BoundTo)
			hcloudImage.BoundTo = &hcloudServer
		}
		hcloudImage.RapidDeploy = (*source).RapidDeploy
		hcloudImage.OSFlavor = (*source).OSFlavor
		if (*source).OSVersion != nil {
			hcloudImage.OSVersion = *(*source).OSVersion
		}
		hcloudImage.Architecture = Architecture((*source).Architecture)
		hcloudImage.Protection = c.schemaImageProtectionToHcloudImageProtection((*source).Protection)
		hcloudImage.Deprecated = c.pTimeTimeToTimeTime((*source).Deprecated)
		hcloudImage.Labels = (*source).Labels
		hcloudImage.Deleted = c.pTimeTimeToTimeTime((*source).Deleted)
		pHcloudImage = &hcloudImage
	}
	return pHcloudImage
}
func (c *converterImpl) pSchemaLoadBalancerServiceHTTPToHcloudLoadBalancerServiceHTTP(source *schema.LoadBalancerServiceHTTP) LoadBalancerServiceHTTP {
	var hcloudLoadBalancerServiceHTTP LoadBalancerServiceHTTP
	if source != nil {
		var hcloudLoadBalancerServiceHTTP2 LoadBalancerServiceHTTP
		hcloudLoadBalancerServiceHTTP2.CookieName = (*source).CookieName
		hcloudLoadBalancerServiceHTTP2.CookieLifetime = durationFromIntSeconds((*source).CookieLifetime)
		if (*source).Certificates != nil {
			hcloudLoadBalancerServiceHTTP2.Certificates = make([]*Certificate, len((*source).Certificates))
			for i := 0; i < len((*source).Certificates); i++ {
				hcloudLoadBalancerServiceHTTP2.Certificates[i] = certificateFromInt64((*source).Certificates[i])
			}
		}
		hcloudLoadBalancerServiceHTTP2.RedirectHTTP = (*source).RedirectHTTP
		hcloudLoadBalancerServiceHTTP2.StickySessions = (*source).StickySessions
		hcloudLoadBalancerServiceHTTP = hcloudLoadBalancerServiceHTTP2
	}
	return hcloudLoadBalancerServiceHTTP
}
func (c *converterImpl) pSchemaLoadBalancerServiceHealthCheckHTTPToPHcloudLoadBalancerServiceHealthCheckHTTP(source *schema.LoadBalancerServiceHealthCheckHTTP) *LoadBalancerServiceHealthCheckHTTP {
	var pHcloudLoadBalancerServiceHealthCheckHTTP *LoadBalancerServiceHealthCheckHTTP
	if source != nil {
		var hcloudLoadBalancerServiceHealthCheckHTTP LoadBalancerServiceHealthCheckHTTP
		hcloudLoadBalancerServiceHealthCheckHTTP.Domain = (*source).Domain
		hcloudLoadBalancerServiceHealthCheckHTTP.Path = (*source).Path
		hcloudLoadBalancerServiceHealthCheckHTTP.Response = (*source).Response
		hcloudLoadBalancerServiceHealthCheckHTTP.StatusCodes = (*source).StatusCodes
		hcloudLoadBalancerServiceHealthCheckHTTP.TLS = (*source).TLS
		pHcloudLoadBalancerServiceHealthCheckHTTP = &hcloudLoadBalancerServiceHealthCheckHTTP
	}
	return pHcloudLoadBalancerServiceHealthCheckHTTP
}
func (c *converterImpl) pSchemaLoadBalancerTargetIPToPHcloudLoadBalancerTargetIP(source *schema.LoadBalancerTargetIP) *LoadBalancerTargetIP {
	var pHcloudLoadBalancerTargetIP *LoadBalancerTargetIP
	if source != nil {
		var hcloudLoadBalancerTargetIP LoadBalancerTargetIP
		hcloudLoadBalancerTargetIP.IP = (*source).IP
		pHcloudLoadBalancerTargetIP = &hcloudLoadBalancerTargetIP
	}
	return pHcloudLoadBalancerTargetIP
}
func (c *converterImpl) pSchemaLoadBalancerTargetLabelSelectorToPHcloudLoadBalancerTargetLabelSelector(source *schema.LoadBalancerTargetLabelSelector) *LoadBalancerTargetLabelSelector {
	var pHcloudLoadBalancerTargetLabelSelector *LoadBalancerTargetLabelSelector
	if source != nil {
		var hcloudLoadBalancerTargetLabelSelector LoadBalancerTargetLabelSelector
		hcloudLoadBalancerTargetLabelSelector.Selector = (*source).Selector
		pHcloudLoadBalancerTargetLabelSelector = &hcloudLoadBalancerTargetLabelSelector
	}
	return pHcloudLoadBalancerTargetLabelSelector
}
func (c *converterImpl) pSchemaLoadBalancerTargetServerToPHcloudLoadBalancerTargetServer(source *schema.LoadBalancerTargetServer) *LoadBalancerTargetServer {
	var pHcloudLoadBalancerTargetServer *LoadBalancerTargetServer
	if source != nil {
		hcloudLoadBalancerTargetServer := c.LoadBalancerTargetServerFromSchema((*source))
		pHcloudLoadBalancerTargetServer = &hcloudLoadBalancerTargetServer
	}
	return pHcloudLoadBalancerTargetServer
}
func (c *converterImpl) pSchemaPlacementGroupToPHcloudPlacementGroup(source *schema.PlacementGroup) *PlacementGroup {
	var pHcloudPlacementGroup *PlacementGroup
	if source != nil {
		var hcloudPlacementGroup PlacementGroup
		hcloudPlacementGroup.ID = (*source).ID
		hcloudPlacementGroup.Name = (*source).Name
		hcloudPlacementGroup.Labels = (*source).Labels
		hcloudPlacementGroup.Created = c.timeTimeToTimeTime((*source).Created)
		hcloudPlacementGroup.Servers = (*source).Servers
		hcloudPlacementGroup.Type = PlacementGroupType((*source).Type)
		pHcloudPlacementGroup = &hcloudPlacementGroup
	}
	return pHcloudPlacementGroup
}
func (c *converterImpl) pTimeTimeToTimeTime(source *time.Time) time.Time {
	var timeTime time.Time
	if source != nil {
		timeTime = (*source)
	}
	return timeTime
}
func (c *converterImpl) schemaActionResourceReferenceToPHcloudActionResource(source schema.ActionResourceReference) *ActionResource {
	var hcloudActionResource ActionResource
	hcloudActionResource.ID = source.ID
	hcloudActionResource.Type = ActionResourceType(source.Type)
	return &hcloudActionResource
}
func (c *converterImpl) schemaCertificateUsedByRefToHcloudCertificateUsedByRef(source schema.CertificateUsedByRef) CertificateUsedByRef {
	var hcloudCertificateUsedByRef CertificateUsedByRef
	hcloudCertificateUsedByRef.ID = source.ID
	hcloudCertificateUsedByRef.Type = CertificateUsedByRefType(source.Type)
	return hcloudCertificateUsedByRef
}
func (c *converterImpl) schemaDatacenterServerTypesToHcloudDatacenterServerTypes(source schema.DatacenterServerTypes) DatacenterServerTypes {
	var hcloudDatacenterServerTypes DatacenterServerTypes
	if source.Supported != nil {
		hcloudDatacenterServerTypes.Supported = make([]*ServerType, len(source.Supported))
		for i := 0; i < len(source.Supported); i++ {
			hcloudDatacenterServerTypes.Supported[i] = serverTypeFromInt64(source.Supported[i])
		}
	}
	if source.AvailableForMigration != nil {
		hcloudDatacenterServerTypes.AvailableForMigration = make([]*ServerType, len(source.AvailableForMigration))
		for j := 0; j < len(source.AvailableForMigration); j++ {
			hcloudDatacenterServerTypes.AvailableForMigration[j] = serverTypeFromInt64(source.AvailableForMigration[j])
		}
	}
	if source.Available != nil {
		hcloudDatacenterServerTypes.Available = make([]*ServerType, len(source.Available))
		for k := 0; k < len(source.Available); k++ {
			hcloudDatacenterServerTypes.Available[k] = serverTypeFromInt64(source.Available[k])
		}
	}
	return hcloudDatacenterServerTypes
}
func (c *converterImpl) schemaDeprecatableResourceToHcloudDeprecatableResource(source schema.DeprecatableResource) DeprecatableResource {
	var hcloudDeprecatableResource DeprecatableResource
	hcloudDeprecatableResource.Deprecation = c.DeprecationFromSchema(source.Deprecation)
	return hcloudDeprecatableResource
}
func (c *converterImpl) schemaFirewallResourceToHcloudFirewallResource(source schema.FirewallResource) FirewallResource {
	var hcloudFirewallResource FirewallResource
	hcloudFirewallResource.Type = FirewallResourceType(source.Type)
	hcloudFirewallResource.Server = c.pSchemaFirewallResourceServerToPHcloudFirewallResourceServer(source.Server)
	hcloudFirewallResource.LabelSelector = c.pSchemaFirewallResourceLabelSelectorToPHcloudFirewallResourceLabelSelector(source.LabelSelector)
	return hcloudFirewallResource
}
func (c *converterImpl) schemaFirewallRuleToHcloudFirewallRule(source schema.FirewallRule) FirewallRule {
	var hcloudFirewallRule FirewallRule
	hcloudFirewallRule.Direction = FirewallRuleDirection(source.Direction)
	if source.SourceIPs != nil {
		hcloudFirewallRule.SourceIPs = make([]net.IPNet, len(source.SourceIPs))
		for i := 0; i < len(source.SourceIPs); i++ {
			hcloudFirewallRule.SourceIPs[i] = ipNetFromString(source.SourceIPs[i])
		}
	}
	if source.DestinationIPs != nil {
		hcloudFirewallRule.DestinationIPs = make([]net.IPNet, len(source.DestinationIPs))
		for j := 0; j < len(source.DestinationIPs); j++ {
			hcloudFirewallRule.DestinationIPs[j] = ipNetFromString(source.DestinationIPs[j])
		}
	}
	hcloudFirewallRule.Protocol = FirewallRuleProtocol(source.Protocol)
	hcloudFirewallRule.Port = source.Port
	hcloudFirewallRule.Description = source.Description
	return hcloudFirewallRule
}
func (c *converterImpl) schemaFloatingIPProtectionToHcloudFloatingIPProtection(source schema.FloatingIPProtection) FloatingIPProtection {
	var hcloudFloatingIPProtection FloatingIPProtection
	hcloudFloatingIPProtection.Delete = source.Delete
	return hcloudFloatingIPProtection
}
func (c *converterImpl) schemaFromFloatingIPPricing(source FloatingIPPricing) schema.PricingFloatingIP {
	var schemaPricingFloatingIP schema.PricingFloatingIP
	schemaPricingFloatingIP.PriceMonthly = c.hcloudPriceToSchemaPrice(source.Monthly)
	return schemaPricingFloatingIP
}
func (c *converterImpl) schemaFromFloatingIPTypeLocationPricing(source FloatingIPTypeLocationPricing) schema.PricingFloatingIPTypePrice {
	var schemaPricingFloatingIPTypePrice schema.PricingFloatingIPTypePrice
	schemaPricingFloatingIPTypePrice.Location = c.pHcloudLocationToString(source.Location)
	schemaPricingFloatingIPTypePrice.PriceMonthly = c.hcloudPriceToSchemaPrice(source.Monthly)
	return schemaPricingFloatingIPTypePrice
}
func (c *converterImpl) schemaFromFloatingIPTypePricing(source FloatingIPTypePricing) schema.PricingFloatingIPType {
	var schemaPricingFloatingIPType schema.PricingFloatingIPType
	schemaPricingFloatingIPType.Type = string(source.Type)
	if source.Pricings != nil {
		schemaPricingFloatingIPType.Prices = make([]schema.PricingFloatingIPTypePrice, len(source.Pricings))
		for i := 0; i < len(source.Pricings); i++ {
			schemaPricingFloatingIPType.Prices[i] = c.schemaFromFloatingIPTypeLocationPricing(source.Pricings[i])
		}
	}
	return schemaPricingFloatingIPType
}
func (c *converterImpl) schemaFromImagePricing(source ImagePricing) schema.PricingImage {
	var schemaPricingImage schema.PricingImage
	schemaPricingImage.PricePerGBMonth = c.hcloudPriceToSchemaPrice(source.PerGBMonth)
	return schemaPricingImage
}
func (c *converterImpl) schemaFromLoadBalancerTypePricing(source LoadBalancerTypePricing) schema.PricingLoadBalancerType {
	var schemaPricingLoadBalancerType schema.PricingLoadBalancerType
	var pInt64 *int64
	if source.LoadBalancerType != nil {
		pInt64 = &source.LoadBalancerType.ID
	}
	if pInt64 != nil {
		schemaPricingLoadBalancerType.ID = *pInt64
	}
	var pString *string
	if source.LoadBalancerType != nil {
		pString = &source.LoadBalancerType.Name
	}
	if pString != nil {
		schemaPricingLoadBalancerType.Name = *pString
	}
	if source.Pricings != nil {
		schemaPricingLoadBalancerType.Prices = make([]schema.PricingLoadBalancerTypePrice, len(source.Pricings))
		for i := 0; i < len(source.Pricings); i++ {
			schemaPricingLoadBalancerType.Prices[i] = c.SchemaFromLoadBalancerTypeLocationPricing(source.Pricings[i])
		}
	}
	return schemaPricingLoadBalancerType
}
func (c *converterImpl) schemaFromPrimaryIPPricing(source PrimaryIPPricing) schema.PricingPrimaryIP {
	var schemaPricingPrimaryIP schema.PricingPrimaryIP
	schemaPricingPrimaryIP.Type = source.Type
	if source.Pricings != nil {
		schemaPricingPrimaryIP.Prices = make([]schema.PricingPrimaryIPTypePrice, len(source.Pricings))
		for i := 0; i < len(source.Pricings); i++ {
			schemaPricingPrimaryIP.Prices[i] = c.schemaFromPrimaryIPTypePricing(source.Pricings[i])
		}
	}
	return schemaPricingPrimaryIP
}
func (c *converterImpl) schemaFromPrimaryIPTypePricing(source PrimaryIPTypePricing) schema.PricingPrimaryIPTypePrice {
	var schemaPricingPrimaryIPTypePrice schema.PricingPrimaryIPTypePrice
	schemaPricingPrimaryIPTypePrice.Datacenter = source.Datacenter
	schemaPricingPrimaryIPTypePrice.Location = source.Location
	schemaPricingPrimaryIPTypePrice.PriceHourly = c.hcloudPrimaryIPPriceToSchemaPrice(source.Hourly)
	schemaPricingPrimaryIPTypePrice.PriceMonthly = c.hcloudPrimaryIPPriceToSchemaPrice(source.Monthly)
	return schemaPricingPrimaryIPTypePrice
}
func (c *converterImpl) schemaFromServerTypeLocationPricing(source ServerTypeLocationPricing) schema.PricingServerTypePrice {
	var schemaPricingServerTypePrice schema.PricingServerTypePrice
	schemaPricingServerTypePrice.Location = c.pHcloudLocationToString(source.Location)
	schemaPricingServerTypePrice.PriceHourly = c.hcloudPriceToSchemaPrice(source.Hourly)
	schemaPricingServerTypePrice.PriceMonthly = c.hcloudPriceToSchemaPrice(source.Monthly)
	schemaPricingServerTypePrice.IncludedTraffic = source.IncludedTraffic
	schemaPricingServerTypePrice.PricePerTBTraffic = c.hcloudPriceToSchemaPrice(source.PerTBTraffic)
	return schemaPricingServerTypePrice
}
func (c *converterImpl) schemaFromServerTypePricing(source ServerTypePricing) schema.PricingServerType {
	var schemaPricingServerType schema.PricingServerType
	var pInt64 *int64
	if source.ServerType != nil {
		pInt64 = &source.ServerType.ID
	}
	if pInt64 != nil {
		schemaPricingServerType.ID = *pInt64
	}
	var pString *string
	if source.ServerType != nil {
		pString = &source.ServerType.Name
	}
	if pString != nil {
		schemaPricingServerType.Name = *pString
	}
	if source.Pricings != nil {
		schemaPricingServerType.Prices = make([]schema.PricingServerTypePrice, len(source.Pricings))
		for i := 0; i < len(source.Pricings); i++ {
			schemaPricingServerType.Prices[i] = c.schemaFromServerTypeLocationPricing(source.Pricings[i])
		}
	}
	return schemaPricingServerType
}
func (c *converterImpl) schemaFromTrafficPricing(source TrafficPricing) schema.PricingTraffic {
	var schemaPricingTraffic schema.PricingTraffic
	schemaPricingTraffic.PricePerTB = c.hcloudPriceToSchemaPrice(source.PerTB)
	return schemaPricingTraffic
}
func (c *converterImpl) schemaFromVolumePricing(source VolumePricing) schema.PricingVolume {
	var schemaPricingVolume schema.PricingVolume
	schemaPricingVolume.PricePerGBPerMonth = c.hcloudPriceToSchemaPrice(source.PerGBMonthly)
	return schemaPricingVolume
}
func (c *converterImpl) schemaImageProtectionToHcloudImageProtection(source schema.ImageProtection) ImageProtection {
	var hcloudImageProtection ImageProtection
	hcloudImageProtection.Delete = source.Delete
	return hcloudImageProtection
}
func (c *converterImpl) schemaLoadBalancerAlgorithmToHcloudLoadBalancerAlgorithm(source schema.LoadBalancerAlgorithm) LoadBalancerAlgorithm {
	var hcloudLoadBalancerAlgorithm LoadBalancerAlgorithm
	hcloudLoadBalancerAlgorithm.Type = LoadBalancerAlgorithmType(source.Type)
	return hcloudLoadBalancerAlgorithm
}
func (c *converterImpl) schemaLoadBalancerPrivateNetToHcloudLoadBalancerPrivateNet(source schema.LoadBalancerPrivateNet) LoadBalancerPrivateNet {
	var hcloudLoadBalancerPrivateNet LoadBalancerPrivateNet
	hcloudNetwork := networkFromInt64(source.Network)
	hcloudLoadBalancerPrivateNet.Network = &hcloudNetwork
	hcloudLoadBalancerPrivateNet.IP = ipFromString(source.IP)
	return hcloudLoadBalancerPrivateNet
}
func (c *converterImpl) schemaLoadBalancerProtectionToHcloudLoadBalancerProtection(source schema.LoadBalancerProtection) LoadBalancerProtection {
	var hcloudLoadBalancerProtection LoadBalancerProtection
	hcloudLoadBalancerProtection.Delete = source.Delete
	return hcloudLoadBalancerProtection
}
func (c *converterImpl) schemaLoadBalancerPublicNetIPv4ToHcloudLoadBalancerPublicNetIPv4(source schema.LoadBalancerPublicNetIPv4) LoadBalancerPublicNetIPv4 {
	var hcloudLoadBalancerPublicNetIPv4 LoadBalancerPublicNetIPv4
	hcloudLoadBalancerPublicNetIPv4.IP = ipFromString(source.IP)
	hcloudLoadBalancerPublicNetIPv4.DNSPtr = source.DNSPtr
	return hcloudLoadBalancerPublicNetIPv4
}
func (c *converterImpl) schemaLoadBalancerPublicNetIPv6ToHcloudLoadBalancerPublicNetIPv6(source schema.LoadBalancerPublicNetIPv6) LoadBalancerPublicNetIPv6 {
	var hcloudLoadBalancerPublicNetIPv6 LoadBalancerPublicNetIPv6
	hcloudLoadBalancerPublicNetIPv6.IP = ipFromString(source.IP)
	hcloudLoadBalancerPublicNetIPv6.DNSPtr = source.DNSPtr
	return hcloudLoadBalancerPublicNetIPv6
}
func (c *converterImpl) schemaLoadBalancerPublicNetToHcloudLoadBalancerPublicNet(source schema.LoadBalancerPublicNet) LoadBalancerPublicNet {
	var hcloudLoadBalancerPublicNet LoadBalancerPublicNet
	hcloudLoadBalancerPublicNet.Enabled = source.Enabled
	hcloudLoadBalancerPublicNet.IPv4 = c.schemaLoadBalancerPublicNetIPv4ToHcloudLoadBalancerPublicNetIPv4(source.IPv4)
	hcloudLoadBalancerPublicNet.IPv6 = c.schemaLoadBalancerPublicNetIPv6ToHcloudLoadBalancerPublicNetIPv6(source.IPv6)
	return hcloudLoadBalancerPublicNet
}
func (c *converterImpl) schemaNetworkProtectionToHcloudNetworkProtection(source schema.NetworkProtection) NetworkProtection {
	var hcloudNetworkProtection NetworkProtection
	hcloudNetworkProtection.Delete = source.Delete
	return hcloudNetworkProtection
}
func (c *converterImpl) schemaPricingServerBackupToHcloudServerBackupPricing(source schema.PricingServerBackup) ServerBackupPricing {
	var hcloudServerBackupPricing ServerBackupPricing
	hcloudServerBackupPricing.Percentage = source.Percentage
	return hcloudServerBackupPricing
}
func (c *converterImpl) schemaPrimaryIPProtectionToHcloudPrimaryIPProtection(source schema.PrimaryIPProtection) PrimaryIPProtection {
	var hcloudPrimaryIPProtection PrimaryIPProtection
	hcloudPrimaryIPProtection.Delete = source.Delete
	return hcloudPrimaryIPProtection
}
func (c *converterImpl) schemaServerProtectionToHcloudServerProtection(source schema.ServerProtection) ServerProtection {
	var hcloudServerProtection ServerProtection
	hcloudServerProtection.Delete = source.Delete
	hcloudServerProtection.Rebuild = source.Rebuild
	return hcloudServerProtection
}
func (c *converterImpl) schemaVolumeProtectionToHcloudVolumeProtection(source schema.VolumeProtection) VolumeProtection {
	var hcloudVolumeProtection VolumeProtection
	hcloudVolumeProtection.Delete = source.Delete
	return hcloudVolumeProtection
}
func (c *converterImpl) serverTypePricingFromSchema(source schema.PricingServerTypePrice) ServerTypeLocationPricing {
	var hcloudServerTypeLocationPricing ServerTypeLocationPricing
	hcloudLocation := locationFromString(source.Location)
	hcloudServerTypeLocationPricing.Location = &hcloudLocation
	hcloudServerTypeLocationPricing.Hourly = c.PriceFromSchema(source.PriceHourly)
	hcloudServerTypeLocationPricing.Monthly = c.PriceFromSchema(source.PriceMonthly)
	hcloudServerTypeLocationPricing.IncludedTraffic = source.IncludedTraffic
	hcloudServerTypeLocationPricing.PerTBTraffic = c.PriceFromSchema(source.PricePerTBTraffic)
	return hcloudServerTypeLocationPricing
}
func (c *converterImpl) timeTimeToTimeTime(source time.Time) time.Time {
	return source
}
