// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';

import type {CrDialogElement} from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import {CrLitElement} from 'chrome://resources/lit/v3_0/lit.rollup.js';

import {getCss} from './install_warnings_dialog.css.js';
import {getHtml} from './install_warnings_dialog.html.js';

interface ExtensionsInstallWarningsDialogElement {
  $: {
    dialog: CrDialogElement,
  };
}

class ExtensionsInstallWarningsDialogElement extends CrLitElement {
  static get is() {
    return 'extensions-install-warnings-dialog';
  }

  static override get styles() {
    return getCss();
  }

  override render() {
    return getHtml.bind(this)();
  }

  static override get properties() {
    return {
      installWarnings: {type: Array},
    };
  }

  installWarnings: string[] = [];

  protected onOkClick_() {
    this.$.dialog.close();
  }
}

// Exported to be used in the autogenerated Lit template file
export type InstallWarningsDialogElement =
    ExtensionsInstallWarningsDialogElement;

customElements.define(
    ExtensionsInstallWarningsDialogElement.is,
    ExtensionsInstallWarningsDialogElement);
