/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.schema.Table;

public class SpannerInterleaveIn {
    private Table table;
    private OnDelete onDelete;

    public SpannerInterleaveIn() {
    }

    public SpannerInterleaveIn(Table table, OnDelete action) {
        this.setTable(table);
        this.setOnDelete(action);
    }

    public SpannerInterleaveIn(List<String> nameParts) {
        this(new Table(nameParts), null);
    }

    public SpannerInterleaveIn(String tableName) {
        this(Collections.singletonList(tableName));
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public OnDelete getOnDelete() {
        return this.onDelete;
    }

    public void setOnDelete(OnDelete action) {
        this.onDelete = action;
    }

    public String toString() {
        return "INTERLEAVE IN PARENT " + this.getTable().getName() + (String)(this.getOnDelete() == null ? "" : " ON DELETE " + (this.getOnDelete() == OnDelete.CASCADE ? "CASCADE" : "NO ACTION"));
    }

    public SpannerInterleaveIn withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public SpannerInterleaveIn withOnDelete(OnDelete action) {
        this.setOnDelete(action);
        return this;
    }

    public static enum OnDelete {
        CASCADE,
        NO_ACTION;


        public static OnDelete from(String action) {
            return Enum.valueOf(OnDelete.class, action.toUpperCase());
        }
    }
}

