/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSOutdatedTextDocumentUtilKt;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.JSLanguageServiceObjectWithStateUpdater;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.QuickInfoCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptEnsureFileAndProjectOpened;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\b\u0017\u0018\u0000 A2\u00020\u0001:\u0002@AB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0004J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0007J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0003J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0002J4\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0004J\u0018\u0010+\u001a\u00020&2\u0006\u0010#\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0004J\u0018\u0010.\u001a\u00020&2\u0006\u0010#\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0002J6\u0010/\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003010\u001f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003010\u001f002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\n03H\u0002J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\n032\f\u00105\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0003J\u000e\u00106\u001a\u0002072\u0006\u0010#\u001a\u00020\nJ\u000e\u00108\u001a\u0002072\u0006\u0010#\u001a\u00020\nJ\"\u00109\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020*0;H\u0002J0\u0010<\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020*0;2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0002J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020\n032\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n03H\u0004J\u0010\u0010?\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "myUpdateFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo;", "myOpenedFilesByEvent", "", "myExternalConfigs", "myVfsChangedFiles", "tryGetServiceObjectWithoutStateUpdater", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/JSLanguageServiceObjectWithStateUpdater;", "input", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "getServiceObjectWithStateUpdater", "refreshAndGetCloseEditorCommand", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "getConfigForFile", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "virtualFile", "refreshAndGetOpenEditorCommand", "getUpdateFilesServiceObject", "command", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptLanguageServiceUpdateCommand;", "getConfigsForReload", "", "filesToOpen", "createOpenCommand", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptOpenEditorCommand;", "file", "info", "text", "", "projectFileName", "", "timestamp", "", "getPreprocessedDocumentText", "document", "Lcom/intellij/openapi/editor/Document;", "preprocessDocumentText", "getAndUpdateExternalConfigsCommand", "Lkotlin/Pair;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptCommandWithArguments;", "actualExternalConfigs", "", "getNonStandardConfigsForFiles", "files", "removeVfsFile", "", "addVfsFile", "getFilesToOpen", "currentChangedFiles", "", "getFilesToChange", "getFilesToClose", "currentFiles", "getDocumentTextMatchingTextAtServer", "LastUpdateInfo", "Companion", "intellij.javascript.backend"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nTypeScriptLanguageServiceCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptLanguageServiceCache.kt\ncom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,479:1\n216#2,2:480\n1869#3,2:482\n1617#3,9:484\n1869#3:493\n1870#3:495\n1626#3:496\n865#3,2:497\n865#3,2:499\n1#4:494\n*S KotlinDebug\n*F\n+ 1 TypeScriptLanguageServiceCache.kt\ncom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache\n*L\n216#1:480,2\n293#1:482,2\n340#1:484,9\n340#1:493\n340#1:495\n340#1:496\n396#1:497,2\n426#1:499,2\n340#1:494\n*E\n"})
public class TypeScriptLanguageServiceCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, LastUpdateInfo> myUpdateFiles;
    @NotNull
    private final Set<VirtualFile> myOpenedFilesByEvent;
    @NotNull
    private final Set<VirtualFile> myExternalConfigs;
    @NotNull
    private final Set<VirtualFile> myVfsChangedFiles;

    public TypeScriptLanguageServiceCache(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myUpdateFiles = new ConcurrentHashMap();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.myOpenedFilesByEvent = set;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.myExternalConfigs = set2;
        Set set3 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"createConcurrentSet(...)");
        this.myVfsChangedFiles = set3;
    }

    @NotNull
    protected final Project getMyProject() {
        return this.myProject;
    }

    @Nullable
    public JSLanguageServiceObjectWithStateUpdater tryGetServiceObjectWithoutStateUpdater(@NotNull JSLanguageServiceCommand input) {
        JSLanguageServiceObjectWithStateUpdater jSLanguageServiceObjectWithStateUpdater;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        JSLanguageServiceCommand jSLanguageServiceCommand = input;
        if (jSLanguageServiceCommand instanceof QuickInfoCommand) {
            Object[] objectArray = new TypeScriptCommandWithArguments[2];
            JSLanguageServiceObject jSLanguageServiceObject = ((QuickInfoCommand)input).arguments;
            Intrinsics.checkNotNullExpressionValue((Object)jSLanguageServiceObject, (String)"arguments");
            objectArray[0] = new TypeScriptEnsureFileAndProjectOpened((TypeScriptFileLocationRequestArgs)jSLanguageServiceObject);
            objectArray[1] = input;
            JSLanguageServiceObjectWithStateUpdater jSLanguageServiceObjectWithStateUpdater2 = new JSLanguageServiceObjectWithStateUpdater(CollectionsKt.listOf((Object[])objectArray), null, 2, null);
            jSLanguageServiceObjectWithStateUpdater = jSLanguageServiceObjectWithStateUpdater2;
        } else {
            jSLanguageServiceObjectWithStateUpdater = jSLanguageServiceCommand instanceof JSLanguageServiceSimpleCommand && !(input instanceof TypeScriptOpenEditorCommand) && !(input instanceof TypeScriptCloseEditorCommand) && !(input instanceof TypeScriptReloadFileCommand) ? new JSLanguageServiceObjectWithStateUpdater(CollectionsKt.listOf((Object)input), null, 2, null) : null;
        }
        return jSLanguageServiceObjectWithStateUpdater;
    }

    @Nullable
    public JSLanguageServiceObjectWithStateUpdater getServiceObjectWithStateUpdater(@NotNull JSLanguageServiceCommand input) {
        VirtualFile file;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        JSLanguageServiceCommand jSLanguageServiceCommand = input;
        Object object = jSLanguageServiceCommand instanceof TypeScriptLanguageServiceUpdateCommand ? this.getUpdateFilesServiceObject((TypeScriptLanguageServiceUpdateCommand)input) : (jSLanguageServiceCommand instanceof TypeScriptOpenEditorCommand ? this.refreshAndGetOpenEditorCommand((JSLanguageServiceSimpleCommand)input) : (jSLanguageServiceCommand instanceof TypeScriptCloseEditorCommand ? this.refreshAndGetCloseEditorCommand((JSLanguageServiceSimpleCommand)input) : (jSLanguageServiceCommand instanceof TypeScriptReloadFileCommand ? (this.myOpenedFilesByEvent.contains(file = ((TypeScriptReloadFileCommand)input).getFile()) || this.myUpdateFiles.containsKey(file) ? null : new JSLanguageServiceObjectWithStateUpdater((JSLanguageServiceSimpleCommand)input)) : null)));
        return object;
    }

    @RequiresReadLock
    @NotNull
    public final JSLanguageServiceObjectWithStateUpdater refreshAndGetCloseEditorCommand(@NotNull JSLanguageServiceSimpleCommand input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        TypeScriptCloseEditorCommand command = (TypeScriptCloseEditorCommand)input;
        VirtualFile virtualFile = command.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile fileToClose = virtualFile;
        ArrayList<Function0> cacheUpdates = new ArrayList<Function0>();
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetCloseEditorCommand$lambda$0(this, fileToClose));
        if (!this.myUpdateFiles.containsKey(fileToClose)) {
            return new JSLanguageServiceObjectWithStateUpdater(CollectionsKt.emptyList(), (List<? extends Function0<Unit>>)cacheUpdates);
        }
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetCloseEditorCommand$lambda$1(this, fileToClose));
        TypeScriptConfig config = this.getConfigForFile(fileToClose);
        if (TypeScriptConfigUtil.isNonStandardName((TypeScriptConfig)config)) {
            TypeScriptConfig typeScriptConfig = config;
            Intrinsics.checkNotNull((Object)typeScriptConfig);
            if (this.myExternalConfigs.contains(typeScriptConfig.getConfigFile())) {
                VirtualFile virtualFile2 = config.getConfigFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getConfigFile(...)");
                VirtualFile configFile = virtualFile2;
                String name = JSLanguageServiceUtil.normalizeNameAndPath(configFile);
                if (name != null) {
                    HashSet openOrUpdatedFiles = new HashSet();
                    openOrUpdatedFiles.addAll(this.myUpdateFiles.keySet());
                    openOrUpdatedFiles.addAll(this.myOpenedFilesByEvent);
                    openOrUpdatedFiles.remove(fileToClose);
                    Set<VirtualFile> configs = this.getNonStandardConfigsForFiles(openOrUpdatedFiles);
                    if (!configs.contains(configFile)) {
                        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetCloseEditorCommand$lambda$2(this, configFile));
                        Object[] objectArray = new TypeScriptCommandWithArguments[]{new TypeScriptCloseExternalProjectRequest(name), input};
                        return new JSLanguageServiceObjectWithStateUpdater(CollectionsKt.listOf((Object[])objectArray), (List<? extends Function0<Unit>>)cacheUpdates);
                    }
                }
            }
        }
        return new JSLanguageServiceObjectWithStateUpdater(CollectionsKt.listOf((Object)input), (List<? extends Function0<Unit>>)cacheUpdates);
    }

    @Nullable
    protected final TypeScriptConfig getConfigForFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return TypeScriptConfigUtil.getConfigForFile((Project)this.myProject, (VirtualFile)virtualFile);
    }

    @RequiresReadLock
    @NotNull
    public final JSLanguageServiceObjectWithStateUpdater refreshAndGetOpenEditorCommand(@NotNull JSLanguageServiceSimpleCommand input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        TypeScriptOpenEditorCommand command = (TypeScriptOpenEditorCommand)input;
        VirtualFile virtualFile = command.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        ArrayList<Function0> cacheUpdates = new ArrayList<Function0>();
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetOpenEditorCommand$lambda$0(this, file));
        if (this.myUpdateFiles.containsKey(file)) {
            return new JSLanguageServiceObjectWithStateUpdater(CollectionsKt.emptyList(), (List<? extends Function0<Unit>>)cacheUpdates);
        }
        String path2 = JSLanguageServiceUtil.normalizeNameAndPath(file);
        JSLanguageServiceObject jSLanguageServiceObject = command.arguments;
        TypeScriptOpenRequestArgs typeScriptOpenRequestArgs = jSLanguageServiceObject instanceof TypeScriptOpenRequestArgs ? (TypeScriptOpenRequestArgs)jSLanguageServiceObject : null;
        LastUpdateInfo info = new LastUpdateInfo(path2, command.getTimestamp(), command.getContentLength(), command.getLineCount(), command.getLastLineStartOffset(), typeScriptOpenRequestArgs != null ? typeScriptOpenRequestArgs.fileContent : null);
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetOpenEditorCommand$lambda$1(this, file, info));
        TypeScriptConfig config = this.getConfigForFile(file);
        SmartList commands = new SmartList();
        if (this.myVfsChangedFiles.contains(file) || command.getContentLength() == 0L && System.currentTimeMillis() - file.getTimeStamp() < 2500L) {
            commands.add((Object)TypeScriptLanguageServiceCache.Companion.createReloadCommand(config));
            cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetOpenEditorCommand$lambda$2(this, file));
        }
        if (TypeScriptConfigUtil.isNonStandardName((TypeScriptConfig)config)) {
            TypeScriptConfig typeScriptConfig = config;
            Intrinsics.checkNotNull((Object)typeScriptConfig);
            VirtualFile virtualFile2 = typeScriptConfig.getConfigFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getConfigFile(...)");
            VirtualFile configFile = virtualFile2;
            String name = JSLanguageServiceUtil.normalizeNameAndPath(configFile);
            if (name != null) {
                ((TypeScriptFileWithConfigArgs)command.arguments).projectFileName = LocalFilePath.Companion.createNotNull(name);
                if (!this.myExternalConfigs.contains(config.getConfigFile())) {
                    cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetOpenEditorCommand$lambda$3(this, configFile));
                    commands.add((Object)new TypeScriptOpenExternalProjectRequest(name));
                }
            }
        }
        commands.add((Object)input);
        return new JSLanguageServiceObjectWithStateUpdater((List)commands, (List<? extends Function0<Unit>>)cacheUpdates);
    }

    @RequiresReadLock
    private final JSLanguageServiceObjectWithStateUpdater getUpdateFilesServiceObject(TypeScriptLanguageServiceUpdateCommand command) {
        Map<VirtualFile, Long> map2 = command.myChangedFilesToTimeStamp;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"myChangedFilesToTimeStamp");
        Map<VirtualFile, Long> currentChangedFiles = map2;
        Map<VirtualFile, Document> map3 = command.myUnsavedFilesContent;
        Intrinsics.checkNotNullExpressionValue(map3, (String)"myUnsavedFilesContent");
        Map<VirtualFile, Document> unsavedContents = map3;
        Set<VirtualFile> currentFiles = currentChangedFiles.keySet();
        Set<VirtualFile> filesToClose = this.getFilesToClose(currentFiles);
        ArrayList<Function0> cacheUpdates = new ArrayList<Function0>();
        Collection<VirtualFile> filesToOpen = this.getFilesToOpen(currentChangedFiles);
        Collection<VirtualFile> changedFiles = this.getFilesToChange(currentChangedFiles, filesToOpen);
        HashMap toUpdateCache = new HashMap();
        List toOpen = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)filesToOpen), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$0(filesToClose, unsavedContents, arg_0)), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$1(unsavedContents, currentChangedFiles, this, toUpdateCache, arg_0)));
        ArrayList<TypeScriptCloseEditorCommand> toCloseByRename = new ArrayList<TypeScriptCloseEditorCommand>();
        ArrayList<TypeScriptOpenEditorCommand> toOpenByRename = new ArrayList<TypeScriptOpenEditorCommand>();
        Collection filesToCloseByRename = new HashSet();
        Collection configsToReload = new HashSet();
        Collection filesToOpenByRename = new HashSet();
        Map<VirtualFile, LastUpdateInfo> $this$forEach$iv = this.myUpdateFiles;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, LastUpdateInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VirtualFile, LastUpdateInfo> element$iv;
            Map.Entry<VirtualFile, LastUpdateInfo> entry = element$iv = iterator.next();
            boolean bl = false;
            VirtualFile file = entry.getKey();
            LastUpdateInfo storedInfo = entry.getValue();
            Object object = CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, TypeScriptLanguageServiceCache::getUpdateFilesServiceObject$lambda$2$0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            Map fileNameCache = (Map)object;
            String newPath = fileNameCache.computeIfAbsent(file, arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$2$2(TypeScriptLanguageServiceCache::getUpdateFilesServiceObject$lambda$2$1, arg_0));
            String oldPath = storedInfo.getMyLastPath();
            if (newPath == null || Intrinsics.areEqual((Object)newPath, (Object)oldPath)) continue;
            toCloseByRename.add(TypeScriptLanguageServiceCache.Companion.createCloseCommand(file, oldPath));
            filesToCloseByRename.add(file);
            if (filesToOpen.contains(file) || filesToClose.contains(file)) continue;
            LastUpdateInfo updateInfo = (LastUpdateInfo)toUpdateCache.get(file);
            LastUpdateInfo lastUpdateInfo = updateInfo;
            if (lastUpdateInfo == null) {
                lastUpdateInfo = storedInfo;
            }
            LastUpdateInfo info = new LastUpdateInfo(lastUpdateInfo, newPath);
            Document document = unsavedContents.get(file);
            CharSequence text = document == null ? null : this.getPreprocessedDocumentText(file, document);
            TypeScriptConfig config = this.getConfigForFile(file);
            String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName((TypeScriptConfig)config);
            toOpenByRename.add(this.createOpenCommand(file, info, text, projectFileName, info.getMyTimestamp()));
            ((Map)toUpdateCache).put(file, info);
            filesToOpenByRename.add(file);
            if (config == null) continue;
            configsToReload.add(config);
        }
        List toChange = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)changedFiles), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$3(filesToClose, filesToOpenByRename, arg_0)), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$4(unsavedContents, arg_0)), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$5(this, arg_0)), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$6(this, currentChangedFiles, toUpdateCache, arg_0)));
        Collection toClose = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)filesToClose), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$7(filesToCloseByRename, arg_0)), TypeScriptLanguageServiceCache::getUpdateFilesServiceObject$lambda$8));
        HashMap<VirtualFile, LastUpdateInfo> newUpdateFiles = new HashMap<VirtualFile, LastUpdateInfo>(this.myUpdateFiles);
        Iterable $this$forEach$iv2 = filesToClose;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            newUpdateFiles.remove(it);
        }
        newUpdateFiles.putAll(toUpdateCache);
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$10(this, newUpdateFiles));
        if (toChange.isEmpty() && toClose.isEmpty() && toOpen.isEmpty() && toCloseByRename.isEmpty() && toOpenByRename.isEmpty()) {
            return new JSLanguageServiceObjectWithStateUpdater(CollectionsKt.emptyList(), (List<? extends Function0<Unit>>)cacheUpdates);
        }
        HashSet openOrUpdatedFiles = new HashSet(this.myOpenedFilesByEvent);
        openOrUpdatedFiles.addAll(newUpdateFiles.keySet());
        Set<VirtualFile> actualExternalConfigs = this.getNonStandardConfigsForFiles(openOrUpdatedFiles);
        Iterator iterator2 = this.getAndUpdateExternalConfigsCommand(actualExternalConfigs);
        Collection openExternal = (Collection)iterator2.component1();
        Collection closeExternal = (Collection)iterator2.component2();
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$11(this, actualExternalConfigs));
        ArrayList result2 = new ArrayList();
        configsToReload.addAll(this.getConfigsForReload(filesToOpen));
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$12(this, filesToOpen));
        TypeScriptLanguageServiceCache.Companion.addReloadCommands(configsToReload, result2);
        result2.addAll(openExternal);
        result2.addAll(toCloseByRename);
        result2.addAll(toOpen);
        result2.addAll(toOpenByRename);
        result2.addAll(toChange);
        result2.addAll(toClose);
        result2.addAll(closeExternal);
        return new JSLanguageServiceObjectWithStateUpdater(result2, (List<? extends Function0<Unit>>)cacheUpdates);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<TypeScriptConfig> getConfigsForReload(Collection<? extends VirtualFile> filesToOpen) {
        void $this$mapNotNullTo$iv$iv;
        HashSet vfsFiles = new HashSet(this.myVfsChangedFiles);
        Iterable $this$mapNotNull$iv = filesToOpen;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TypeScriptConfig it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if ((vfsFiles.contains(file) ? this.getConfigForFile(file) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final TypeScriptOpenEditorCommand createOpenCommand(@NotNull VirtualFile file, @NotNull LastUpdateInfo info, @Nullable CharSequence text, @Nullable String projectFileName, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return new TypeScriptOpenEditorCommand(file, timestamp, info.getMyContentLength(), info.getMyLineCount(), info.getMyLastLineStartOffset(), text, projectFileName);
    }

    @NotNull
    protected final CharSequence getPreprocessedDocumentText(@NotNull VirtualFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        CharSequence charSequence = document.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence text = charSequence;
        return this.preprocessDocumentText(file, text);
    }

    private final CharSequence preprocessDocumentText(VirtualFile file, CharSequence text) {
        CharSequence charSequence = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.myProject, text, file);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"convertLineSeparatorsToFileOriginal(...)");
        return charSequence;
    }

    private final Pair<Collection<TypeScriptCommandWithArguments<?>>, Collection<TypeScriptCommandWithArguments<?>>> getAndUpdateExternalConfigsCommand(Set<? extends VirtualFile> actualExternalConfigs) {
        Set toClose = new HashSet(this.myExternalConfigs);
        toClose.removeAll((Collection)actualExternalConfigs);
        Set toOpen = new HashSet(actualExternalConfigs);
        toOpen.removeAll((Collection)this.myExternalConfigs);
        return new Pair((Object)TypeScriptLanguageServiceCache.Companion.convertToCommands(toOpen, TypeScriptLanguageServiceCache::getAndUpdateExternalConfigsCommand$lambda$0), (Object)TypeScriptLanguageServiceCache.Companion.convertToCommands(toClose, TypeScriptLanguageServiceCache::getAndUpdateExternalConfigsCommand$lambda$1));
    }

    @RequiresReadLock
    private final Set<VirtualFile> getNonStandardConfigsForFiles(Collection<? extends VirtualFile> files) {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)files), arg_0 -> TypeScriptLanguageServiceCache.getNonStandardConfigsForFiles$lambda$0(this, arg_0)), TypeScriptLanguageServiceCache::getNonStandardConfigsForFiles$lambda$1), TypeScriptLanguageServiceCache::getNonStandardConfigsForFiles$lambda$2));
    }

    public final void removeVfsFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myVfsChangedFiles.remove(file);
    }

    public final void addVfsFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myVfsChangedFiles.add(file);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFile> getFilesToOpen(Map<VirtualFile, Long> currentChangedFiles) {
        void var3_3;
        void $this$filterTo$iv;
        Iterable iterable = currentChangedFiles.keySet();
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(!this.myUpdateFiles.containsKey(it))) continue;
            destination$iv.add(element$iv);
        }
        return var3_3;
    }

    private final Collection<VirtualFile> getFilesToChange(Map<VirtualFile, Long> currentChangedFiles, Collection<? extends VirtualFile> filesToOpen) {
        ArrayList<VirtualFile> realChangedFiles = new ArrayList<VirtualFile>();
        for (Map.Entry<VirtualFile, Long> entry : currentChangedFiles.entrySet()) {
            VirtualFile file = entry.getKey();
            long modified = ((Number)entry.getValue()).longValue();
            if (filesToOpen.contains(file)) continue;
            LastUpdateInfo lastUpdateInfo = this.myUpdateFiles.get(file);
            if (lastUpdateInfo == null) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Incorrect cache");
                continue;
            }
            long timeStamp = lastUpdateInfo.getMyTimestamp();
            if (modified >= 0L && timeStamp != -1L && modified == timeStamp) continue;
            realChangedFiles.add(file);
        }
        return realChangedFiles;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<VirtualFile> getFilesToClose(@NotNull Set<? extends VirtualFile> currentFiles) {
        void var3_3;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(currentFiles, (String)"currentFiles");
        Iterable iterable = this.myUpdateFiles.keySet();
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(!currentFiles.contains(it) && !this.myOpenedFilesByEvent.contains(it))) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var3_3;
    }

    @Nullable
    public final CharSequence getDocumentTextMatchingTextAtServer(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LastUpdateInfo lastUpdateInfo = this.myUpdateFiles.get(file);
        return lastUpdateInfo != null ? lastUpdateInfo.getMyLastText() : null;
    }

    private static final Unit refreshAndGetCloseEditorCommand$lambda$0(TypeScriptLanguageServiceCache this$0, VirtualFile $fileToClose) {
        this$0.myOpenedFilesByEvent.remove($fileToClose);
        return Unit.INSTANCE;
    }

    private static final Unit refreshAndGetCloseEditorCommand$lambda$1(TypeScriptLanguageServiceCache this$0, VirtualFile $fileToClose) {
        this$0.myUpdateFiles.remove($fileToClose);
        return Unit.INSTANCE;
    }

    private static final Unit refreshAndGetCloseEditorCommand$lambda$2(TypeScriptLanguageServiceCache this$0, VirtualFile $configFile) {
        this$0.myExternalConfigs.remove($configFile);
        return Unit.INSTANCE;
    }

    private static final Unit refreshAndGetOpenEditorCommand$lambda$0(TypeScriptLanguageServiceCache this$0, VirtualFile $file) {
        this$0.myOpenedFilesByEvent.add($file);
        return Unit.INSTANCE;
    }

    private static final Unit refreshAndGetOpenEditorCommand$lambda$1(TypeScriptLanguageServiceCache this$0, VirtualFile $file, LastUpdateInfo $info) {
        this$0.myUpdateFiles.put($file, $info);
        return Unit.INSTANCE;
    }

    private static final Unit refreshAndGetOpenEditorCommand$lambda$2(TypeScriptLanguageServiceCache this$0, VirtualFile $file) {
        this$0.myVfsChangedFiles.remove($file);
        return Unit.INSTANCE;
    }

    private static final Unit refreshAndGetOpenEditorCommand$lambda$3(TypeScriptLanguageServiceCache this$0, VirtualFile $configFile) {
        this$0.myExternalConfigs.add($configFile);
        return Unit.INSTANCE;
    }

    private static final boolean getUpdateFilesServiceObject$lambda$0(Set $filesToClose, Map $unsavedContents, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$filesToClose.contains(it) && $unsavedContents.containsKey(it);
    }

    private static final TypeScriptOpenEditorCommand getUpdateFilesServiceObject$lambda$1(Map $unsavedContents, Map $currentChangedFiles, TypeScriptLanguageServiceCache this$0, HashMap $toUpdateCache, VirtualFile el) {
        PsiFile file;
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        Object v = $unsavedContents.get(el);
        Intrinsics.checkNotNull(v);
        Document document = (Document)v;
        Long timestampObject = (Long)$currentChangedFiles.get(el);
        CharSequence text = this$0.getPreprocessedDocumentText(el, document);
        Long l = timestampObject;
        long timestamp = l != null ? l : -1L;
        LastUpdateInfo value = TypeScriptLanguageServiceCache.Companion.createLastUpdateInfo(el, text, text, timestamp);
        ((Map)$toUpdateCache).put(el, value);
        PsiFile psiFile = file = PsiManager.getInstance((Project)this$0.myProject).findFile(el);
        String projectFileName = psiFile != null ? TypeScriptConfigUtil.getNonStandardProjectFileName((PsiFile)psiFile) : null;
        return this$0.createOpenCommand(el, value, text, projectFileName, timestamp);
    }

    private static final CachedValueProvider.Result getUpdateFilesServiceObject$lambda$2$0() {
        Object[] objectArray = new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS};
        return CachedValueProvider.Result.create((Object)CollectionFactory.createConcurrentWeakMap(), (Object[])objectArray);
    }

    private static final String getUpdateFilesServiceObject$lambda$2$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JSLanguageServiceUtil.normalizeNameAndPath(it);
    }

    private static final String getUpdateFilesServiceObject$lambda$2$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean getUpdateFilesServiceObject$lambda$3(Set $filesToClose, Collection $filesToOpenByRename, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$filesToClose.contains(it) && !$filesToOpenByRename.contains(it);
    }

    private static final Pair getUpdateFilesServiceObject$lambda$4(Map $unsavedContents, VirtualFile file) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = (Document)$unsavedContents.get(file);
        if (document != null) {
            Document document2 = document;
            boolean bl = false;
            pair = new Pair((Object)file, (Object)document2.getImmutableCharSequence());
        } else {
            pair = null;
        }
        return pair;
    }

    private static final boolean getUpdateFilesServiceObject$lambda$5(TypeScriptLanguageServiceCache this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        VirtualFile file = (VirtualFile)pair.component1();
        Object object = pair.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
        CharSequence newDocumentText = (CharSequence)object;
        Object object2 = this$0.myUpdateFiles.get(file);
        if (object2 == null || (object2 = ((LastUpdateInfo)object2).getMyLastText()) == null) {
            return true;
        }
        Object oldText = object2;
        boolean isOutdatedTextDocumentAllowed = JSOutdatedTextDocumentUtilKt.getTolerableTextChange((CharSequence)oldText, newDocumentText) != null;
        return !isOutdatedTextDocumentAllowed;
    }

    private static final TypeScriptChangeCommand getUpdateFilesServiceObject$lambda$6(TypeScriptLanguageServiceCache this$0, Map $currentChangedFiles, HashMap $toUpdateCache, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        VirtualFile file = (VirtualFile)pair.component1();
        Object object = pair.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
        CharSequence newDocumentText = (CharSequence)object;
        CharSequence newText = this$0.preprocessDocumentText(file, newDocumentText);
        LastUpdateInfo info = this$0.myUpdateFiles.get(file);
        if (info == null) {
            JSLanguageServiceQueue.Holder.LOGGER.error("myUpdateFiles does not contain " + file);
            return null;
        }
        Long newTimestamp = (Long)$currentChangedFiles.get(file);
        if (newTimestamp == null) {
            JSLanguageServiceQueue.Holder.LOGGER.error("currentChangedFiles does not contain " + file);
            return null;
        }
        LastUpdateInfo value = TypeScriptLanguageServiceCache.Companion.createLastUpdateInfo(file, newText, newDocumentText, newTimestamp);
        ((Map)$toUpdateCache).put(file, value);
        TypeScriptChangeRequestArgs typeScriptChangeRequestArgs = TypeScriptChangeRequestArgs.build(file, newText, info.getMyContentLength(), info.getMyLineCount(), info.getMyLastLineStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptChangeRequestArgs, (String)"build(...)");
        TypeScriptChangeRequestArgs req = typeScriptChangeRequestArgs;
        return new TypeScriptChangeCommand(req);
    }

    private static final boolean getUpdateFilesServiceObject$lambda$7(Collection $filesToCloseByRename, VirtualFile el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        return !$filesToCloseByRename.contains(el);
    }

    private static final TypeScriptCloseEditorCommand getUpdateFilesServiceObject$lambda$8(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String filePath = JSLanguageServiceUtil.normalizeNameAndPath(it);
        return TypeScriptLanguageServiceCache.Companion.createCloseCommand(it, filePath);
    }

    private static final Unit getUpdateFilesServiceObject$lambda$10(TypeScriptLanguageServiceCache this$0, HashMap $newUpdateFiles) {
        this$0.myUpdateFiles.clear();
        this$0.myUpdateFiles.putAll($newUpdateFiles);
        return Unit.INSTANCE;
    }

    private static final Unit getUpdateFilesServiceObject$lambda$11(TypeScriptLanguageServiceCache this$0, Set $actualExternalConfigs) {
        this$0.myExternalConfigs.clear();
        this$0.myExternalConfigs.addAll($actualExternalConfigs);
        return Unit.INSTANCE;
    }

    private static final Unit getUpdateFilesServiceObject$lambda$12(TypeScriptLanguageServiceCache this$0, Collection $filesToOpen) {
        this$0.myVfsChangedFiles.removeAll(CollectionsKt.intersect((Iterable)$filesToOpen, (Iterable)this$0.myVfsChangedFiles));
        return Unit.INSTANCE;
    }

    private static final TypeScriptCommandWithArguments getAndUpdateExternalConfigsCommand$lambda$0(String projectFileName) {
        Intrinsics.checkNotNullParameter((Object)projectFileName, (String)"projectFileName");
        return new TypeScriptOpenExternalProjectRequest(projectFileName);
    }

    private static final TypeScriptCommandWithArguments getAndUpdateExternalConfigsCommand$lambda$1(String projectFileName) {
        Intrinsics.checkNotNullParameter((Object)projectFileName, (String)"projectFileName");
        return new TypeScriptCloseExternalProjectRequest(projectFileName);
    }

    private static final TypeScriptConfig getNonStandardConfigsForFiles$lambda$0(TypeScriptLanguageServiceCache this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getConfigForFile(it);
    }

    private static final boolean getNonStandardConfigsForFiles$lambda$1(TypeScriptConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeScriptConfigUtil.isNonStandardName((TypeScriptConfig)it);
    }

    private static final VirtualFile getNonStandardConfigsForFiles$lambda$2(TypeScriptConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getConfigFile();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J8\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u001cH\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u001dH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$Companion;", "", "<init>", "()V", "addReloadCommands", "", "configsToReload", "", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "result", "", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptCommandWithArguments;", "createReloadCommand", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptReloadProjectsCommand;", "config", "createLastUpdateInfo", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo;", "el", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "unprocessedText", "newTimestamp", "", "convertToCommands", "", "toOpen", "factory", "Lkotlin/Function1;", "", "createCloseCommand", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptCloseEditorCommand;", "path", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final void addReloadCommands(Collection<? extends TypeScriptConfig> configsToReload, List<TypeScriptCommandWithArguments<?>> result2) {
            for (TypeScriptConfig typeScriptConfig : configsToReload) {
                result2.add(this.createReloadCommand(typeScriptConfig));
            }
        }

        private final TypeScriptReloadProjectsCommand createReloadCommand(TypeScriptConfig config) {
            TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
            TypeScriptConfig typeScriptConfig = config;
            args.projectFileName = typeScriptConfig != null ? LocalFilePath.Companion.create(TypeScriptConfigUtil.getConfigProjectFileName((TypeScriptConfig)typeScriptConfig)) : null;
            return new TypeScriptReloadProjectsCommand(args);
        }

        private final LastUpdateInfo createLastUpdateInfo(VirtualFile el, CharSequence text, CharSequence unprocessedText, long newTimestamp) {
            int lineCount = TypeScriptServerServiceImpl.Companion.getLineCountForText(text);
            int lastLineStartOffset = TypeScriptServerServiceImpl.Companion.getLastLineStartOffsetFromText(text, lineCount);
            int newContentLength = text.length();
            String path2 = JSLanguageServiceUtil.normalizeNameAndPath(el);
            return new LastUpdateInfo(path2, newTimestamp, newContentLength, lineCount, lastLineStartOffset, unprocessedText);
        }

        private final Set<TypeScriptCommandWithArguments<?>> convertToCommands(Set<? extends VirtualFile> toOpen, Function1<? super String, ? extends TypeScriptCommandWithArguments<?>> factory) {
            return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)toOpen), Companion::convertToCommands$lambda$0), arg_0 -> Companion.convertToCommands$lambda$1(factory, arg_0)));
        }

        private final TypeScriptCloseEditorCommand createCloseCommand(VirtualFile el, String path2) {
            TypeScriptFileObject object = new TypeScriptFileObject();
            object.file = LocalFilePath.Companion.create(path2);
            return new TypeScriptCloseEditorCommand(object, el);
        }

        private static final String convertToCommands$lambda$0(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return JSLanguageServiceUtil.normalizeNameAndPath(it);
        }

        private static final TypeScriptCommandWithArguments convertToCommands$lambda$1(Function1 $factory, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (TypeScriptCommandWithArguments)$factory.invoke((Object)it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B=\b\u0010\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0005\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo;", "", "toCopy", "newPath", "", "<init>", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo;Ljava/lang/String;)V", "path", "timestamp", "", "contentLength", "lineCount", "", "lastLineStartOffset", "text", "", "(Ljava/lang/String;JJIILjava/lang/CharSequence;)V", "myTimestamp", "getMyTimestamp", "()J", "myContentLength", "getMyContentLength", "myLineCount", "getMyLineCount", "()I", "myLastLineStartOffset", "getMyLastLineStartOffset", "myLastPath", "getMyLastPath", "()Ljava/lang/String;", "myLastText", "getMyLastText", "()Ljava/lang/CharSequence;", "intellij.javascript.backend"})
    public static final class LastUpdateInfo {
        private final long myTimestamp;
        private final long myContentLength;
        private final int myLineCount;
        private final int myLastLineStartOffset;
        @Nullable
        private final String myLastPath;
        @Nullable
        private final CharSequence myLastText;

        public final long getMyTimestamp() {
            return this.myTimestamp;
        }

        public final long getMyContentLength() {
            return this.myContentLength;
        }

        public final int getMyLineCount() {
            return this.myLineCount;
        }

        public final int getMyLastLineStartOffset() {
            return this.myLastLineStartOffset;
        }

        @Nullable
        public final String getMyLastPath() {
            return this.myLastPath;
        }

        @Nullable
        public final CharSequence getMyLastText() {
            return this.myLastText;
        }

        public LastUpdateInfo(@NotNull LastUpdateInfo toCopy, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)toCopy, (String)"toCopy");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            this.myTimestamp = toCopy.myTimestamp;
            this.myContentLength = toCopy.myContentLength;
            this.myLineCount = toCopy.myLineCount;
            this.myLastLineStartOffset = toCopy.myLastLineStartOffset;
            this.myLastPath = newPath;
            this.myLastText = toCopy.myLastText;
        }

        public LastUpdateInfo(@Nullable String path2, long timestamp, long contentLength, int lineCount, int lastLineStartOffset, @Nullable CharSequence text) {
            this.myTimestamp = timestamp;
            this.myContentLength = contentLength;
            this.myLineCount = lineCount;
            this.myLastLineStartOffset = lastLineStartOffset;
            this.myLastPath = path2;
            this.myLastText = text;
        }
    }
}

