/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.ComponentWithEmptyBrowseButton;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileManager;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.beforeRun.GulpBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class GulpRunConfigurationEditor
extends SettingsEditor<GulpRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(GulpRunConfigurationEditor.class);
    private final Project myProject;
    private final TextFieldWithHistoryWithBrowseButton myGulpfileTextFieldWithBrowseButton;
    private final TextFieldWithHistory myTasksField;
    private final RawCommandLineEditor myArguments;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final NodePackageField myGulpPackageField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;

    public GulpRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myGulpfileTextFieldWithBrowseButton = GulpRunConfigurationEditor.createGulpfileFieldWithBrowseButton(project);
        this.myTasksField = this.createTasksField();
        this.myArguments = new RawCommandLineEditor();
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = GulpRunConfigurationEditor.createNodeOptionsEditor();
        this.myGulpPackageField = new NodePackageField(this.myNodeInterpreterField, GulpUtil.GULP, null);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.gulpfile.label", (Object[])new Object[0]), (JComponent)this.myGulpfileTextFieldWithBrowseButton).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.tasks.label", (Object[])new Object[0]), ComponentWithEmptyBrowseButton.wrap(this.myTasksField)).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.arguments.label", (Object[])new Object[0]), (JComponent)this.myArguments).addComponent((JComponent)new JSeparator(), 8).addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.myNodeInterpreterField), 8).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.gulpPackage.label", (Object[])new Object[0]), (JComponent)((Object)this.myGulpPackageField)).addLabeledComponent(JavaScriptBundle.message((String)"gulp.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
    }

    @NotNull
    public static RawCommandLineEditor createNodeOptionsEditor() {
        return new RawCommandLineEditor();
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createGulpfileFieldWithBrowseButton(@NotNull Project project) {
        if (project == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(JavaScriptBundle.message((String)"gulp.rc.gulpfile.browseDialogTitle", (Object[])new Object[0]));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (FileChooserDescriptor)descriptor, () -> {
            List<VirtualFile> gulpfiles = GulpService.getInstance(project).detectAllBuildfiles();
            ArrayList<String> gulpfilePaths = new ArrayList<String>();
            for (VirtualFile gulpfile : gulpfiles) {
                gulpfilePaths.add(FileUtil.toSystemDependentName((String)gulpfile.getPath()));
            }
            Collections.sort(gulpfilePaths);
            return gulpfilePaths;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private TextFieldWithHistory createTasksField() {
        final TextFieldWithHistory field = new TextFieldWithHistory();
        field.setMinimumAndPreferredWidth(0);
        field.setHistorySize(-1);
        JsbtUtil.enableExpandingWithLazyHistoryLoading(field);
        final Ref lastGulpfileRef = Ref.create();
        field.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                final VirtualFile gulpfile = LocalFileSystem.getInstance().findFileByPath(((TextFieldWithHistory)GulpRunConfigurationEditor.this.myGulpfileTextFieldWithBrowseButton.getChildComponent()).getText());
                if (gulpfile == null || !gulpfile.isValid() || gulpfile.isDirectory()) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                    lastGulpfileRef.set(null);
                    return;
                }
                if (gulpfile.equals(lastGulpfileRef.get())) {
                    return;
                }
                lastGulpfileRef.set((Object)gulpfile);
                GulpfileManager gulpfileManager = GulpfileManager.getInstance(GulpRunConfigurationEditor.this.myProject);
                GulpfileStructure structure = gulpfileManager.getCachedStructure(gulpfile);
                if (structure != null) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, JsbtUtil.encodeNames(structure.getTaskNames()), (boolean)false);
                } else {
                    gulpfileManager.fetchStructure(gulpfile, (CatchingConsumer<? super JsbtFileStructure, ? super JsbtTaskFetchException>)new CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException>(){

                        public void consume(JsbtFileStructure structure) {
                            field.setHistory(JsbtUtil.encodeNames(structure.getTaskNames()));
                        }

                        public void consume(JsbtTaskFetchException e) {
                            SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                            LOG.warn("Cannot load gulp tasks for " + gulpfile.getPath(), (Throwable)e);
                        }
                    });
                }
            }
        });
        TextFieldWithHistory textFieldWithHistory = field;
        if (textFieldWithHistory == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return textFieldWithHistory;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    protected void resetEditorFrom(@NotNull GulpRunConfiguration gulpRc) {
        if (gulpRc == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        this.resetEditorFrom(gulpRc.getRunSettings());
    }

    public void resetEditorFrom(@NotNull GulpRunSettings runSettings) {
        if (runSettings == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        NodeJsInterpreterRef interpreterRef = runSettings.getInterpreterRef();
        NodePackage gulpPackage = GulpUtil.getGulpPackage(this.myProject, interpreterRef.resolve(this.myProject), runSettings.getGulpfile());
        this.myNodeInterpreterField.setInterpreterRef(interpreterRef);
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myGulpPackageField.setSelected(gulpPackage);
        this.myGulpfileTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getGulpfilePath());
        this.myTasksField.setTextAndAddToHistory(ParametersListUtil.join(runSettings.getTasks()));
        this.myArguments.setText(runSettings.getArguments());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (dialogWrapper instanceof SingleConfigurableEditor || dialogWrapper instanceof GulpBeforeRunTaskDialog) {
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myGulpfileTextFieldWithBrowseButton);
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myGulpPackageField.setPreferredWidthToFitText();
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.any());
        }
    }

    protected void applyEditorTo(@NotNull GulpRunConfiguration gulpRc) throws ConfigurationException {
        if (gulpRc == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        gulpRc.setRunSettings(this.getCurrentSettings());
    }

    @NotNull
    public GulpRunSettings getCurrentSettings() {
        GulpUtil.setGulpPackage(this.myProject, this.myGulpPackageField.getSelected());
        GulpRunSettings.Builder builder2 = new GulpRunSettings.Builder();
        builder2.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder2.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder2.setGulpfilePath(((TextFieldWithHistory)this.myGulpfileTextFieldWithBrowseButton.getChildComponent()).getText());
        List tasks = Collections.emptyList();
        String tasksText = this.myTasksField.getText();
        if (!StringUtil.isEmptyOrSpaces((String)tasksText)) {
            tasks = ParametersListUtil.parse((String)tasksText);
        }
        builder2.setTasks(tasks);
        builder2.setArguments(this.myArguments.getText());
        builder2.setEnvData(this.myEnvVarsComponent.getData());
        GulpRunSettings gulpRunSettings = builder2.build();
        if (gulpRunSettings == null) {
            GulpRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        return gulpRunSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpRc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createGulpfileFieldWithBrowseButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTasksField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createGulpfileFieldWithBrowseButton";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8 -> new IllegalStateException(string);
        };
    }
}

