/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.http.request;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.intellij.jpa.jpb.model.core.util.ApiJsonException;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0001H\u0007J\u001e\u0010\u0013\u001a\u0002H\u000b\"\u0006\b\u0000\u0010\u000b\u0018\u00012\u0006\u0010\u0014\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0015J)\u0010\u0013\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jpa/jpb/model/core/http/request/ApiContentHelper;", "", "<init>", "()V", "JSON_MIME_TYPE", "", "URL_ENCODED", "gson", "Lcom/google/gson/Gson;", "getGson$annotations", "readJson", "T", "reader", "Ljava/io/Reader;", "clazz", "Ljava/lang/Class;", "(Ljava/io/Reader;Ljava/lang/Class;)Ljava/lang/Object;", "toJson", "content", "fromJson", "string", "(Ljava/lang/String;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "intellij.javaee.jpa.jpb.model.core"})
public final class ApiContentHelper {
    @NotNull
    public static final ApiContentHelper INSTANCE = new ApiContentHelper();
    @NotNull
    public static final String JSON_MIME_TYPE = "application/json";
    @NotNull
    public static final String URL_ENCODED = "application/x-www-form-urlencoded";
    @NotNull
    private static final Gson gson;

    private ApiContentHelper() {
    }

    private static /* synthetic */ void getGson$annotations() {
    }

    @JvmStatic
    public static final <T> T readJson(@NotNull Reader reader, @NotNull Class<T> clazz) throws ApiJsonException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            return (T)gson.fromJson(reader, clazz);
        }
        catch (JsonParseException e) {
            throw new ApiJsonException("Can't parse API response", e);
        }
    }

    @JvmStatic
    @NotNull
    public static final String toJson(@NotNull Object content) throws ApiJsonException {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            String string = gson.toJson(content);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }
        catch (JsonIOException e) {
            throw new ApiJsonException("Can't serialize API request body", e);
        }
    }

    public final /* synthetic */ <T> T fromJson(String string) throws ApiJsonException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        boolean $i$f$fromJson = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)ApiContentHelper.fromJson(string, Object.class);
    }

    @JvmStatic
    public static final <T> T fromJson(@NotNull String string, @NotNull Class<T> clazz) throws ApiJsonException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            object = gson.fromJson(string, clazz);
        }
        catch (JsonParseException e) {
            throw new ApiJsonException("Can't parse API response", e);
        }
        return (T)object;
    }

    static {
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        ApiContentHelper.gson = gson;
    }
}

