/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.PairConsumer;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringDataSourceDetector
extends DataSourceDetector {
    @NonNls
    private final List<Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>> myProviders = new ArrayList<Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>>();

    SpringDataSourceDetector() {
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"com.mchange.v2.c3p0.ComboPooledDataSource", SpringDataSourceDetector.provider("c3p0", "jdbcUrl", "user", "password", "driverClass")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.apache.commons.dbcp.BasicDataSource", SpringDataSourceDetector.provider("jakarta commons-dbcp", "url", "username", "password", "driverClassName")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.springframework.jdbc.datasource.DriverManagerDataSource", SpringDataSourceDetector.provider("spring", "url", "username", "password", "driverClassName")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.logicalcobwebs.proxool.ProxoolDataSource", SpringDataSourceDetector.provider("proxool", "driverUrl", "user", "password", "driver")));
    }

    static PairConsumer<DataSourceDetector.Builder, SpringBean> provider(String category, String urlProp, String userProp, String passwordProp, String driverProp) {
        return (builder, bean) -> {
            SpringDataSourceDetector.collect((Setter<String>)((Setter)arg_0 -> ((DataSourceDetector.Builder)builder).withUrl(arg_0)), bean, urlProp);
            SpringDataSourceDetector.collect((Setter<String>)((Setter)arg_0 -> ((DataSourceDetector.Builder)builder).withUser(arg_0)), bean, userProp);
            SpringDataSourceDetector.collect((Setter<String>)((Setter)arg_0 -> ((DataSourceDetector.Builder)builder).withPassword(arg_0)), bean, passwordProp);
            SpringDataSourceDetector.collect((Setter<String>)((Setter)arg_0 -> ((DataSourceDetector.Builder)builder).withDriverClass(arg_0)), bean, driverProp);
            builder.withName(bean.getBeanName()).withComment(category).withOrigin((Object)bean.getIdentifyingPsiElement()).commit();
        };
    }

    private static void collect(@NotNull Setter<String> setter, SpringBean bean, String key) {
        SpringPropertyDefinition value;
        if (setter == null) {
            SpringDataSourceDetector.$$$reportNull$$$0(0);
        }
        if ((value = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)key)) == null) {
            return;
        }
        for (String s : PlaceholderUtils.getInstance().getValueVariants((SpringValueHolderDefinition)value)) {
            setter.set((Object)s);
        }
    }

    public void collectDataSources(@NotNull Project project, @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            SpringDataSourceDetector.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            SpringDataSourceDetector.$$$reportNull$$$0(2);
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, GlobalSearchScope.allScope((Project)project));
        Set localXmlModels = springXmlCandidates.stream().map(file -> SpringDataSourceDetector.getLocalXmlModel(project, PsiManager.getInstance((Project)project), file)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (localXmlModels.isEmpty()) {
            return;
        }
        for (Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>> provider : this.myProviders) {
            PsiClass beanPsiClass = JavaPsiFacade.getInstance((Project)project).findClass((String)provider.getFirst(), GlobalSearchScope.allScope((Project)project));
            if (beanPsiClass == null) continue;
            for (LocalXmlModel localXmlModel : localXmlModels) {
                for (SpringBeanPointer pointer : SpringModelSearchers.findBeans((CommonSpringModel)localXmlModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)beanPsiClass))) {
                    CommonSpringBean bean = pointer.getSpringBean();
                    if (!(bean instanceof SpringBean)) continue;
                    ((PairConsumer)provider.getSecond()).consume((Object)builder, (Object)((SpringBean)bean));
                }
            }
        }
    }

    @Nullable
    private static LocalXmlModel getLocalXmlModel(@NotNull Project project, PsiManager psiManager, VirtualFile file) {
        Module module;
        if (project == null) {
            SpringDataSourceDetector.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            return null;
        }
        PsiFile psiFile = psiManager.findFile(file);
        return psiFile instanceof XmlFile ? SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel((XmlFile)psiFile, module, Collections.emptySet()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/persistence/integration/hibernate/SpringDataSourceDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collect";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDataSources";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalXmlModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

