/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class JSElementProxy {
    private final int myOffset;
    private final JSImplicitElementImpl.Builder myElement;

    public JSElementProxy(JSImplicitElementImpl.Builder builder, int offset) {
        assert (builder.getProvider() == null) : "provider must be null to have equal deserialized elements";
        this.myElement = builder;
        this.myOffset = offset;
    }

    @NotNull
    public JSOffsetBasedImplicitElement toOffsetBasedImplicitElement(@NotNull PsiFile file) {
        if (file == null) {
            JSElementProxy.$$$reportNull$$$0(0);
        }
        return new JSOffsetBasedImplicitElement(this.myElement.copy(), this.myOffset, file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSElementProxy proxy = (JSElementProxy)o;
        if (this.myOffset != proxy.myOffset) {
            return false;
        }
        return this.myElement.equals(proxy.myElement);
    }

    public int hashCode() {
        int result = this.myOffset;
        result = 31 * result + this.myElement.hashCode();
        return result;
    }

    public void serialize(DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOffset);
        this.myElement.toImplicitElement().getStructure().serialize(out);
    }

    public static JSElementProxy deserialize(DataInput in) throws IOException {
        int offset = DataInputOutputUtil.readINT((DataInput)in);
        JSImplicitElementStructureImpl element = JSImplicitElementStructureImpl.deserialize(in);
        JSImplicitElementImpl.Builder builder = element.toBuilder();
        return new JSElementProxy(builder, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSElementProxy", "toOffsetBasedImplicitElement"));
    }
}

