/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.events;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.Stack;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.SamplesCountMetric;
import com.intellij.profiler.api.TimeValueMetric;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.ultimate.jfr.JFRMethodCall;
import com.intellij.profiler.ultimate.jfr.MultipleStepsProgressTracker;
import com.intellij.profiler.ultimate.jfr.events.JfrEvent;
import com.intellij.profiler.ultimate.jfr.events.JfrEventGroup;
import com.intellij.profiler.ultimate.jfr.events.JfrEventTypesBuilder;
import com.intellij.profiler.ultimate.jfr.events.JfrEvents;
import com.intellij.profiler.ultimate.jfr.events.JfrSamplingEvents;
import com.intellij.profiler.ultimate.jfr.events.JfrSamplingSingleEventTypeBuilder;
import com.intellij.profiler.ultimate.jfr.events.JfrTimelineEvents;
import com.intellij.profiler.ultimate.jfr.events.JfrWallBatchEventTypeBuilder;
import com.intellij.profiler.ultimate.jfr.events.JfrWallSleepingEventTypeBuilder;
import com.intellij.profiler.ultimate.jfr.ui.JfrTimelineEventKind;
import com.intellij.profiler.ultimate.model.JavaCachingStackElementReader;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 @2\u00020\u0001:\u0001@B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J%\u0010-\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u000e\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000/H\u0016\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u001e\u00108\u001a\b\u0012\u0004\u0012\u0002090)2\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u000209H\u0002J\u001f\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010?R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\r\u001aJ\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u0011 \u0010*#\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u0013\u00a2\u0006\u0002\b\u00120\u000e\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrCpuAllEventsTypeBuilder;", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cachingReader", "Lcom/intellij/profiler/ultimate/model/JavaCachingStackElementReader;", "nativeCallsCache", "Ljava/util/HashMap;", "", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lkotlin/collections/HashMap;", "jfrMethodCallCache", "", "Lorg/openjdk/jmc/common/IMCFrame;", "kotlin.jvm.PlatformType", "Lcom/intellij/profiler/ultimate/jfr/JFRMethodCall;", "Lorg/jetbrains/annotations/NotNull;", "", "runningEvents", "Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder;", "wallRunningEvents", "Lcom/intellij/profiler/ultimate/jfr/events/JfrWallBatchEventTypeBuilder;", "oldSleepingEvents", "newSleepingEvents", "Lcom/intellij/profiler/ultimate/jfr/events/JfrWallSleepingEventTypeBuilder;", "wallSleepingEvents", "allFrames", "", "getAllFrames", "()Ljava/util/Set;", "size", "", "getSize", "()J", "setDataStructure", "", "event", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;", "dataStructure", "", "Lorg/openjdk/jmc/flightrecorder/parser/ValueField;", "stateAccessor", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder$DataStructureAccessorProvider$AccessorInfo;", "addEvent", "values", "", "", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)V", "create", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEvents;", "progressTracker", "Lcom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker;", "context", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder$Context;", "cpuAndTotalSampling", "Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingEvents;", "running", "sleeping", "getActualWallClockInterval", "", "sleepingEvents", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder;Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder;)Ljava/lang/Double;", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJfrEventType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrCpuAllEventsTypeBuilder\n+ 2 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,843:1\n127#2,2:844\n13#3:846\n1#4:847\n*S KotlinDebug\n*F\n+ 1 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrCpuAllEventsTypeBuilder\n*L\n595#1:844,2\n632#1:846\n*E\n"})
public final class JfrCpuAllEventsTypeBuilder
extends JfrEventTypesBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaCachingStackElementReader cachingReader;
    @NotNull
    private final HashMap<String, BaseCallStackElement> nativeCallsCache;
    @NotNull
    private final Map<IMCFrame, JFRMethodCall> jfrMethodCallCache;
    @NotNull
    private final JfrSamplingSingleEventTypeBuilder runningEvents;
    @NotNull
    private final JfrWallBatchEventTypeBuilder wallRunningEvents;
    @NotNull
    private final JfrSamplingSingleEventTypeBuilder oldSleepingEvents;
    @NotNull
    private final JfrWallSleepingEventTypeBuilder newSleepingEvents;
    @NotNull
    private final JfrWallBatchEventTypeBuilder wallSleepingEvents;
    @NotNull
    private final JfrEventTypesBuilder.DataStructureAccessorProvider.AccessorInfo<String> stateAccessor;
    @NotNull
    public static final String STATE_DEFAULT = "STATE_DEFAULT";
    @NotNull
    public static final String STATE_RUNNABLE = "STATE_RUNNABLE";
    @NotNull
    public static final String STATE_SLEEPING = "STATE_SLEEPING";

    /*
     * WARNING - void declaration
     */
    public JfrCpuAllEventsTypeBuilder(@Nullable Project project) {
        void this_$iv$iv;
        void this_$iv;
        this.cachingReader = JavaCachingStackElementReader.Companion.getOrCreate(project);
        this.nativeCallsCache = new HashMap();
        Map map2 = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)HashingStrategy.identity());
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createCustomHashingStrategyMap(...)");
        this.jfrMethodCallCache = map2;
        this.runningEvents = new JfrSamplingSingleEventTypeBuilder(project, JfrEventGroup.WALL_CPU, this.cachingReader, this.nativeCallsCache, this.jfrMethodCallCache, JfrTimelineEventKind.CPU_RUNNING);
        this.wallRunningEvents = new JfrWallBatchEventTypeBuilder(project, JfrEventGroup.WALL_CPU, this.cachingReader, this.nativeCallsCache, this.jfrMethodCallCache, JfrTimelineEventKind.CPU_RUNNING);
        this.oldSleepingEvents = new JfrSamplingSingleEventTypeBuilder(project, JfrEventGroup.WALL_TOTAL, this.cachingReader, this.nativeCallsCache, this.jfrMethodCallCache, JfrTimelineEventKind.CPU_SLEEPING);
        this.newSleepingEvents = new JfrWallSleepingEventTypeBuilder(project, this.cachingReader, this.nativeCallsCache, this.jfrMethodCallCache, JfrTimelineEventKind.CPU_SLEEPING);
        this.wallSleepingEvents = new JfrWallBatchEventTypeBuilder(project, JfrEventGroup.WALL_TOTAL, this.cachingReader, this.nativeCallsCache, this.jfrMethodCallCache, JfrTimelineEventKind.CPU_SLEEPING);
        JfrEventTypesBuilder jfrEventTypesBuilder = this;
        Function1 predicate$iv = JfrCpuAllEventsTypeBuilder::stateAccessor$lambda$0;
        boolean $i$f$accessor = false;
        void var5_5 = this_$iv;
        List predicates$iv$iv = CollectionsKt.listOf((Object)predicate$iv);
        boolean $i$f$accessor2 = false;
        this.stateAccessor = JfrEventTypesBuilder.access$getAccessorProvider((JfrEventTypesBuilder)this_$iv$iv).create(String.class, predicates$iv$iv);
    }

    @Override
    @NotNull
    public Set<IMCFrame> getAllFrames() {
        return SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus(this.runningEvents.getAllFrames(), (Iterable)this.wallRunningEvents.getAllFrames()), (Iterable)this.oldSleepingEvents.getAllFrames()), (Iterable)this.newSleepingEvents.getAllFrames()), (Iterable)this.wallSleepingEvents.getAllFrames());
    }

    @Override
    public long getSize() {
        return this.runningEvents.getSize() + this.wallRunningEvents.getSize() + this.oldSleepingEvents.getSize() + this.newSleepingEvents.getSize() + this.wallSleepingEvents.getSize();
    }

    @Override
    public void setDataStructure(@NotNull JfrEvent event, @NotNull List<ValueField> dataStructure) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter(dataStructure, (String)"dataStructure");
        switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1: {
                this.runningEvents.setDataStructure(event, dataStructure);
                this.oldSleepingEvents.setDataStructure(event, dataStructure);
                break;
            }
            case 2: {
                this.newSleepingEvents.setDataStructure(event, dataStructure);
                break;
            }
            case 3: {
                this.wallRunningEvents.setDataStructure(event, dataStructure);
                this.wallSleepingEvents.setDataStructure(event, dataStructure);
            }
        }
        super.setDataStructure(event, dataStructure);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addEvent(@NotNull JfrEvent event, @NotNull Object[] values) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
                case 1: {
                    var3_3 = this.stateAccessor.invoke(event).get(values);
                    if (var3_3 == null) break;
                    switch (var3_3.hashCode()) {
                        case 105392569: {
                            if (var3_3.equals("STATE_SLEEPING")) break;
                            ** break;
                        }
                        case -623848365: {
                            if (!var3_3.equals("STATE_DEFAULT")) {
                                ** break;
                            }
                            ** GOTO lbl17
                        }
                        case -1974298837: {
                            if (!var3_3.equals("STATE_RUNNABLE")) ** break;
lbl17:
                            // 2 sources

                            this.runningEvents.addEvent(event, values);
                            ** break;
                        }
                    }
                    this.oldSleepingEvents.addEvent(event, values);
lbl20:
                    // 6 sources

                    break;
                }
                case 2: {
                    this.newSleepingEvents.addEvent(event, values);
                    break;
                }
                case 3: {
                    var3_4 = this.stateAccessor.invoke(event).get(values);
                    if (var3_4 == null) break;
                    switch (var3_4.hashCode()) {
                        case 105392569: {
                            if (var3_4.equals("STATE_SLEEPING")) break;
                            break block0;
                        }
                        case -623848365: {
                            if (!var3_4.equals("STATE_DEFAULT")) {
                                break block0;
                            }
                            ** GOTO lbl38
                        }
                        case -1974298837: {
                            if (!var3_4.equals("STATE_RUNNABLE")) break block20;
lbl38:
                            // 2 sources

                            this.wallRunningEvents.addEvent(event, values);
                            break block20;
                        }
                    }
                    this.wallSleepingEvents.addEvent(event, values);
                }
            }
        }
    }

    @Override
    @NotNull
    public JfrEvents create(@NotNull MultipleStepsProgressTracker progressTracker, @NotNull JfrEventTypesBuilder.Context context2) {
        JfrEvents jfrEvents;
        Intrinsics.checkNotNullParameter((Object)progressTracker, (String)"progressTracker");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getWallClockIntervalMs() != null) {
            Double intervalMs;
            JfrSamplingSingleEventTypeBuilder realRunningEvents = this.wallRunningEvents.getSize() > 0L ? (JfrSamplingSingleEventTypeBuilder)this.wallRunningEvents : this.runningEvents;
            JfrSamplingSingleEventTypeBuilder realSleepingEvents = this.wallSleepingEvents.getSize() > 0L ? (JfrSamplingSingleEventTypeBuilder)this.wallSleepingEvents : (this.oldSleepingEvents.getSize() > 0L ? this.oldSleepingEvents : (JfrSamplingSingleEventTypeBuilder)this.newSleepingEvents);
            TimeValueMetric metric = TimeValueMetric.INSTANCE;
            realRunningEvents.setValueMetric((ValueMetric)metric);
            realSleepingEvents.setValueMetric((ValueMetric)metric);
            JfrEventTypesBuilder.Context newContext = context2;
            if (context2.getHasFakeNativeEvents() && (intervalMs = this.getActualWallClockInterval(realRunningEvents, realSleepingEvents)) != null) {
                newContext = JfrEventTypesBuilder.Context.copy$default(context2, null, false, intervalMs, false, 11, null);
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JfrCpuAllEventsTypeBuilder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Actual sampling interval is " + intervalMs + " ms, while " + context2.getWallClockIntervalMs() + " ms interval was set in the configuration");
            }
            JfrEvents running = realRunningEvents.create(progressTracker, newContext);
            JfrEvents sleeping = realSleepingEvents.create(progressTracker, newContext);
            Object[] objectArray = new JfrTimelineEvents[]{CollectionsKt.single(running.getTimelineEvents()), CollectionsKt.single(sleeping.getTimelineEvents())};
            JfrEvents jfrEvents2 = new JfrEvents(this.cpuAndTotalSampling((JfrSamplingEvents)CollectionsKt.single(running.getSamplingEvents()), (JfrSamplingEvents)CollectionsKt.single(sleeping.getSamplingEvents())), CollectionsKt.listOf((Object[])objectArray));
            jfrEvents = jfrEvents2;
        } else {
            this.runningEvents.setValueMetric((ValueMetric)SamplesCountMetric.INSTANCE);
            this.runningEvents.setGroup(JfrEventGroup.CPU);
            jfrEvents = this.runningEvents.create(progressTracker, context2);
        }
        return jfrEvents;
    }

    private final List<JfrSamplingEvents> cpuAndTotalSampling(JfrSamplingEvents running, JfrSamplingEvents sleeping) {
        Collection p0;
        List rawStacks = new ArrayList();
        List<Stack<BaseCallStackElement>> list = running.getRawStacks();
        if (list != null) {
            p0 = list;
            boolean bl = false;
            rawStacks.addAll(p0);
        }
        List<Stack<BaseCallStackElement>> list2 = sleeping.getRawStacks();
        if (list2 != null) {
            p0 = list2;
            boolean bl = false;
            rawStacks.addAll(p0);
        }
        sleeping.setRawStacks(null);
        DummyCallTreeBuilder total = running.getSampling().merge(sleeping.getSampling());
        total.setMetric((ValueMetric)TimeValueMetric.INSTANCE);
        Object[] objectArray = new JfrSamplingEvents[]{running, new JfrSamplingEvents(JfrEventGroup.WALL_TOTAL, (DummyCallTreeBuilder<BaseCallStackElement>)total, rawStacks)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final Double getActualWallClockInterval(JfrSamplingSingleEventTypeBuilder runningEvents, JfrSamplingSingleEventTypeBuilder sleepingEvents) {
        if (!Registry.Companion.is("idea.profiler.determine.actual.sampling.interval")) {
            return null;
        }
        Map<IMCThread, JfrSamplingSingleEventTypeBuilder.PerThreadTimestampsStatistics> running = runningEvents.getTimestampStatistics();
        Map<IMCThread, JfrSamplingSingleEventTypeBuilder.PerThreadTimestampsStatistics> sleeping = sleepingEvents.getTimestampStatistics();
        Set threads = SetsKt.plus(running.keySet(), (Iterable)sleeping.keySet());
        long time = 0L;
        long count = 0L;
        for (IMCThread thread : threads) {
            long maxEventTime = Long.MIN_VALUE;
            long minEventTime = Long.MAX_VALUE;
            long eventsCount = 0L;
            long untrackedCount = 0L;
            Object[] objectArray = new JfrSamplingSingleEventTypeBuilder.PerThreadTimestampsStatistics[]{running.get(thread), sleeping.get(thread)};
            for (JfrSamplingSingleEventTypeBuilder.PerThreadTimestampsStatistics statistics : CollectionsKt.listOf((Object[])objectArray)) {
                if (statistics == null) continue;
                eventsCount += statistics.getCount();
                minEventTime = Math.min(minEventTime, statistics.getMinEventTime());
                if (statistics.getMaxEventTime() <= maxEventTime) continue;
                maxEventTime = statistics.getMaxEventTime();
                untrackedCount = statistics.getUntrackedCount();
            }
            long rangesCount = eventsCount - untrackedCount;
            if (rangesCount <= 0L) continue;
            time += maxEventTime - minEventTime;
            count += rangesCount;
        }
        if (count == 0L) {
            return null;
        }
        return (double)time / (double)count;
    }

    private static final boolean stateAccessor$lambda$0(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getIdentifier(), (Object)"state");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrCpuAllEventsTypeBuilder$Companion;", "", "<init>", "()V", "STATE_DEFAULT", "", "STATE_RUNNABLE", "STATE_SLEEPING", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JfrEvent.values().length];
            try {
                nArray[JfrEvent.EXECUTION_SAMPLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JfrEvent.WALL_CLOCK_SLEEPING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JfrEvent.WALL_CLOCK_BATCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

