/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class SetValueAction
extends AnAction
implements DumbAware,
GridAction {
    private final ReservedCellValue myValue;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SetValueAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    protected SetValueAction(ReservedCellValue value) {
        this.myValue = value;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            SetValueAction.$$$reportNull$$$0(1);
        }
        if ((grid = GridUtil.getDataGrid((DataContext)e.getDataContext())) == null || !grid.isEditable() || !grid.isReady()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        SelectionModel selectionModel = grid.getSelectionModel();
        e.getPresentation().setEnabledAndVisible(selectionModel.getSelectedRowCount() >= 1 && selectionModel.getSelectedColumnCount() >= 1 && this.areSelectedColumnsAssignable(grid));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            SetValueAction.$$$reportNull$$$0(2);
        }
        if ((grid = GridUtil.getDataGrid((DataContext)e.getDataContext())) != null) {
            grid.cancelEditing();
            grid.setCells(grid.getSelectionModel().getSelectedRows(), grid.getSelectionModel().getSelectedColumns(), (Object)this.myValue);
        }
    }

    protected abstract boolean canSetValue(@NotNull DataGrid var1, @Nullable GridColumn var2);

    @TestOnly
    public ReservedCellValue getValue() {
        return this.myValue;
    }

    private boolean areSelectedColumnsAssignable(@NotNull DataGrid grid) {
        if (grid == null) {
            SetValueAction.$$$reportNull$$$0(3);
        }
        List selectedColumns = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumns(grid.getSelectionModel().getSelectedColumns());
        return JBIterable.from((Iterable)selectedColumns).filter(column -> !this.canSetValue(grid, (GridColumn)column)).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/SetValueAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/SetValueAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "areSelectedColumnsAssignable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    public static class ClearCellAction
    extends SetValueAction {
        public ClearCellAction() {
            super(ReservedCellValue.UNSET);
        }

        @Override
        protected boolean canSetValue(@NotNull DataGrid grid, @Nullable GridColumn column) {
            if (grid == null) {
                ClearCellAction.$$$reportNull$$$0(0);
            }
            return DataGridUtil.getDbms(grid).in(Dbms.DOCUMENT_ORIENTED);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/actions/SetValueAction$ClearCellAction", "canSetValue"));
        }
    }

    public static class SetNullAction
    extends SetValueAction {
        public SetNullAction() {
            super(ReservedCellValue.NULL);
        }

        @Override
        protected boolean canSetValue(@NotNull DataGrid grid, @Nullable GridColumn column) {
            DasColumn columnInfo;
            if (grid == null) {
                SetNullAction.$$$reportNull$$$0(0);
            }
            return (columnInfo = DataGridUtilCore.getDatabaseColumn((CoreGrid)grid, (GridColumn)column)) != null && !columnInfo.isNotNull();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/actions/SetValueAction$SetNullAction", "canSetValue"));
        }
    }

    public static class SetDefaultAction
    extends SetValueAction {
        public SetDefaultAction() {
            super(ReservedCellValue.DEFAULT);
        }

        @Override
        protected boolean canSetValue(@NotNull DataGrid grid, @Nullable GridColumn column) {
            DasColumn columnInfo;
            if (grid == null) {
                SetDefaultAction.$$$reportNull$$$0(0);
            }
            return (columnInfo = DataGridUtilCore.getDatabaseColumn((CoreGrid)grid, (GridColumn)column)) != null && (columnInfo.getDefault() != null || SetDefaultAction.dataTypeAcceptsDefault(columnInfo));
        }

        private static boolean dataTypeAcceptsDefault(@NotNull DasColumn dasColumn) {
            BasicElement column;
            if (dasColumn == null) {
                SetDefaultAction.$$$reportNull$$$0(1);
            }
            if ((column = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap((DasObject)dasColumn), BasicTableColumn.class)) == null) {
                return false;
            }
            return DbImplUtil.getModelHelper((BasicElement)column).gridColumnHasDefaultValue(column);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dasColumn";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/SetValueAction$SetDefaultAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canSetValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataTypeAcceptsDefault";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

