/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public final class FileClob
implements Clob,
Serializable {
    private final File myFile;
    private final String myCharset;
    private transient Long myLength;

    public FileClob(@NotNull File file, String charset) {
        if (file == null) {
            FileClob.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myCharset = charset;
    }

    @Override
    public long length() throws SQLException {
        if (this.myLength == null || this.myLength < 1L && this.myFile.length() > 0L) {
            try (InputStreamReader reader = this.getCharacterStream();){
                this.myLength = FileClob.position(reader, Long.MAX_VALUE);
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
        }
        return this.myLength;
    }

    private static long position(InputStreamReader reader, long maxValue) throws IOException {
        int read;
        long count = 0L;
        long curMax = maxValue;
        char[] buf = new char[1024];
        while ((read = reader.read(buf, 0, (int)Math.min((long)buf.length, curMax))) > 0) {
            count += (long)read;
            curMax -= (long)read;
        }
        return count;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        InputStreamReader reader = this.getCharacterStream();
        try {
            FileClob.position(reader, pos - 1L);
            return new String(FileUtilRt.loadText((Reader)reader, (int)length));
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    @Override
    public InputStreamReader getCharacterStream() throws SQLException {
        try {
            FileInputStream stream = new FileInputStream(this.myFile);
            return this.myCharset == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, this.myCharset);
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        final InputStreamReader reader = this.getCharacterStream();
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return reader.read();
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }
        };
    }

    @Override
    public long position(String searchstr, long start) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public long position(Clob searchstr, long start) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public int setString(long pos, String str) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public int setString(long pos, String str, int offset, int len) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public OutputStream setAsciiStream(long pos) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Writer setCharacterStream(long pos) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void truncate(long len) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void free() {
    }

    @Override
    public Reader getCharacterStream(long pos, final long length) throws SQLException {
        final InputStreamReader reader = this.getCharacterStream();
        if (pos <= 1L && length == this.length()) {
            return reader;
        }
        try {
            FileClob.position(reader, pos - 1L);
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        return new Reader(){
            long avail;
            {
                this.avail = length;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                long min = Math.min((long)len, this.avail);
                this.avail -= (long)len;
                return reader.read(cbuf, off, (int)min);
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileClob fileClob = (FileClob)o;
        return this.myFile.equals(fileClob.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/remote/jdbc/impl/FileClob", "<init>"));
    }
}

