/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class MethodCallFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            MethodCallFixer.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = BasicJavaAstTreeUtil.toPsi(astNode);
        PsiExpressionList argList = null;
        if (psiElement instanceof PsiMethodCallExpression && psiElement.getLanguage().equals(JavaLanguage.INSTANCE)) {
            argList = ((PsiMethodCallExpression)psiElement).getArgumentList();
        } else if (psiElement instanceof PsiNewExpression) {
            argList = ((PsiNewExpression)psiElement).getArgumentList();
        }
        int caret = editor.getCaretModel().getOffset();
        if (argList != null && !MethodCallFixer.hasRParenth(argList)) {
            PsiExpression[] args;
            PsiCallExpression innermostCall = (PsiCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiElement.getContainingFile(), (int)(caret - 1), PsiCallExpression.class, (boolean)false);
            while (innermostCall != null && innermostCall != psiElement && MethodCallFixer.hasRParenth(innermostCall.getArgumentList()) && innermostCall.resolveMethodGenerics().isValidResult()) {
                innermostCall = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)innermostCall, PsiCallExpression.class);
            }
            if (innermostCall == null) {
                return;
            }
            argList = innermostCall.getArgumentList();
            if (argList == null) {
                return;
            }
            int endOffset = MethodCallFixer.getMissingParenthesisOffset(argList);
            TextRange argListRange = argList.getTextRange();
            if (endOffset == -1) {
                endOffset = argListRange.getEndOffset();
            }
            if ((args = argList.getExpressions()).length > 0 && MethodCallFixer.startLine(editor, argList) != MethodCallFixer.startLine(editor, args[0]) && caret < args[0].getTextRange().getStartOffset()) {
                endOffset = argListRange.getStartOffset() + 1;
            }
            if (args.length > 0 && !DumbService.isDumb((Project)argList.getProject())) {
                int minArg;
                int caretArg = MethodCallFixer.getCaretArgIndex(caret, argListRange, args);
                LongRangeSet innerCounts = MethodCallFixer.getPossibleParameterCounts(innermostCall).meet(LongRangeSet.range((long)caretArg, (long)args.length));
                if (!innerCounts.isEmpty() && (minArg = (int)(innerCounts = MethodCallFixer.tryFilterByOuterCall(innermostCall, args, innerCounts)).min()) > 0) {
                    endOffset = Math.min(endOffset, args[minArg - 1].getTextRange().getEndOffset());
                }
            }
            endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)" \t\n") + 1;
            editor.getDocument().insertString(endOffset, (CharSequence)")");
        }
    }

    private static int getCaretArgIndex(int caret, TextRange argListRange, PsiExpression[] args) {
        int caretArg;
        for (caretArg = 0; caretArg < args.length && args[caretArg].getStartOffsetInParent() + argListRange.getStartOffset() <= caret; ++caretArg) {
        }
        return caretArg;
    }

    private static int getMissingParenthesisOffset(PsiExpressionList argList) {
        for (PsiElement child = argList.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiErrorElement errorElement;
            if (!(child instanceof PsiErrorElement) || !(errorElement = (PsiErrorElement)child).getErrorDescription().contains("')'")) continue;
            return errorElement.getTextRange().getStartOffset();
        }
        return -1;
    }

    private static boolean hasRParenth(PsiExpressionList args) {
        if (args == null) {
            return false;
        }
        PsiElement parenth = args.getLastChild();
        return parenth != null && ")".equals(parenth.getText());
    }

    @NotNull
    private static LongRangeSet tryFilterByOuterCall(@NotNull PsiCallExpression innermostCall, @NotNull @NotNull PsiExpression @NotNull [] args, @NotNull LongRangeSet innerCounts) {
        LongRangeSet allowedByOuter;
        LongRangeSet innerCountsFiltered;
        LongRangeSet outerCounts;
        PsiCallExpression outerCall;
        Object[] outerArgs;
        PsiExpressionList outerArgList;
        if (innermostCall == null) {
            MethodCallFixer.$$$reportNull$$$0(1);
        }
        if (innerCounts == null) {
            MethodCallFixer.$$$reportNull$$$0(2);
        }
        if (args == null) {
            MethodCallFixer.$$$reportNull$$$0(3);
        }
        if ((outerArgList = (PsiExpressionList)ObjectUtils.tryCast((Object)innermostCall.getParent(), PsiExpressionList.class)) != null && innermostCall == ArrayUtil.getLastElement((Object[])(outerArgs = outerArgList.getExpressions())) && (outerCall = (PsiCallExpression)ObjectUtils.tryCast((Object)outerArgList.getParent(), PsiCallExpression.class)) != null && !(outerCounts = MethodCallFixer.getPossibleParameterCounts(outerCall)).isEmpty() && !(innerCountsFiltered = innerCounts.meet(allowedByOuter = LongRangeSet.point((long)args.length).minus(outerCounts.minus(LongRangeSet.point((long)outerArgs.length), LongRangeType.INT32), LongRangeType.INT32))).isEmpty()) {
            LongRangeSet longRangeSet = innerCountsFiltered;
            if (longRangeSet == null) {
                MethodCallFixer.$$$reportNull$$$0(4);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = innerCounts;
        if (longRangeSet == null) {
            MethodCallFixer.$$$reportNull$$$0(5);
        }
        return longRangeSet;
    }

    @NotNull
    private static LongRangeSet getPossibleParameterCounts(@NotNull PsiCallExpression call) {
        if (call == null) {
            MethodCallFixer.$$$reportNull$$$0(6);
        }
        LongRangeSet counts = LongRangeSet.empty();
        for (CandidateInfo candidate : PsiResolveHelper.getInstance(call.getProject()).getReferencedMethodCandidates(call, false)) {
            PsiMethod element = (PsiMethod)ObjectUtils.tryCast((Object)candidate.getElement(), PsiMethod.class);
            if (element == null) continue;
            int count = element.getParameterList().getParametersCount();
            counts = counts.join(element.isVarArgs() ? LongRangeSet.range((long)(count - 1), (long)Integer.MAX_VALUE) : LongRangeSet.point((long)count));
        }
        LongRangeSet longRangeSet = counts;
        if (longRangeSet == null) {
            MethodCallFixer.$$$reportNull$$$0(7);
        }
        return longRangeSet;
    }

    private static int startLine(Editor editor, PsiElement psiElement) {
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innermostCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerCounts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/smartEnter/MethodCallFixer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/MethodCallFixer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFilterByOuterCall";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleParameterCounts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryFilterByOuterCall";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleParameterCounts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

