/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitDownloadAndInstallKt;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitInstaller;
import git4idea.config.GitVersionIdentificationException;
import git4idea.i18n.GitBundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J#\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0000\u00a2\u0006\u0002\b\u0016J.\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J \u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u001cH\u0002J&\u0010$\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010(\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010)\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010,\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001c0.H\u0002J\u0010\u0010/\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lgit4idea/config/MacExecutableProblemHandler;", "Lgit4idea/config/GitExecutableProblemHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "tempPath", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "mountPoint", "showError", "", "exception", "", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "onErrorResolved", "Lkotlin/Function0;", "showGenericError", "downloadAndInstall", "downloadAndInstall$intellij_vcs_git", "installGit", "dmgFile", "pkgFileName", "", "attachVolume", "", "file", "installPackageOrShowError", "detachVolume", "runOrShowError", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sudo", "runCommand", "onError", "showCouldntInstallError", "showCouldntStartInstallerError", "showXCodeLicenseError", "showInvalidActiveDeveloperPathError", "isXcodeLicenseError", "isInvalidActiveDeveloperPath", "isXcodeError", "messageIndicator", "Lkotlin/Function1;", "execXCodeSelectInstall", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nMacExecutableProblemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacExecutableProblemHandler.kt\ngit4idea/config/MacExecutableProblemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,177:1\n13#2:178\n*S KotlinDebug\n*F\n+ 1 MacExecutableProblemHandler.kt\ngit4idea/config/MacExecutableProblemHandler\n*L\n16#1:178\n*E\n"})
public final class MacExecutableProblemHandler
implements GitExecutableProblemHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final File tempPath;
    @NotNull
    private final File mountPoint;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String XCODE_LICENSE_ERROR = "xcodebuild -license";
    @NotNull
    private static final String XCODE_DEVELOPER_PART_ERROR = "invalid active developer path";
    @NotNull
    private static final String XCODE_XCRUN = "xcrun";

    public MacExecutableProblemHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        File file = FileUtil.createTempDirectory((String)"git-install", null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        this.tempPath = file;
        this.mountPoint = new File(this.tempPath, "mount");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void showError(@NotNull Throwable exception, @NotNull ErrorNotifier errorNotifier, @NotNull Function0<Unit> onErrorResolved) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        Intrinsics.checkNotNullParameter(onErrorResolved, (String)"onErrorResolved");
        if (this.isXcodeLicenseError(exception)) {
            this.showXCodeLicenseError(errorNotifier);
        } else if (this.isInvalidActiveDeveloperPath(exception)) {
            this.showInvalidActiveDeveloperPathError(errorNotifier);
        } else {
            this.showGenericError(exception, errorNotifier);
        }
    }

    private final void showGenericError(Throwable exception, ErrorNotifier errorNotifier) {
        String string = GitBundle.message((String)"executable.error.git.not.installed", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        errorNotifier.showError(string, GitExecutableProblemHandlersKt.getHumanReadableErrorFor(exception), null);
    }

    public final void downloadAndInstall$intellij_vcs_git(@NotNull ErrorNotifier errorNotifier, @NotNull Function0<Unit> onErrorResolved) {
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        Intrinsics.checkNotNullParameter(onErrorResolved, (String)"onErrorResolved");
        String string = GitBundle.message((String)"install.downloading.progress", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        errorNotifier.executeTask(string, false, (Function0<Unit>)((Function0)() -> MacExecutableProblemHandler.downloadAndInstall$lambda$0(errorNotifier, this, onErrorResolved)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void installGit(File dmgFile, String pkgFileName, ErrorNotifier errorNotifier, Function0<Unit> onErrorResolved) {
        if (this.attachVolume(dmgFile, errorNotifier)) {
            try {
                if (this.installPackageOrShowError(pkgFileName, errorNotifier)) {
                    String string = GitBundle.message((String)"install.success.message", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    errorNotifier.showMessage(string);
                    onErrorResolved.invoke();
                    errorNotifier.resetGitExecutable();
                }
            }
            finally {
                this.detachVolume();
            }
        }
    }

    private final boolean attachVolume(File file, ErrorNotifier errorNotifier) {
        String[] stringArray = new String[]{"hdiutil", "attach", "-readonly", "-noautoopen", "-noautofsck", "-nobrowse", "-mountpoint", this.mountPoint.getPath(), file.getPath()};
        GeneralCommandLine cmd = new GeneralCommandLine(stringArray);
        return this.runOrShowError(cmd, errorNotifier, false);
    }

    private final boolean installPackageOrShowError(String pkgFileName, ErrorNotifier errorNotifier) {
        String[] stringArray = new String[]{"installer", "-package", this.mountPoint + "/" + pkgFileName, "-target", "/"};
        return this.runOrShowError(new GeneralCommandLine(stringArray), errorNotifier, true);
    }

    private final void detachVolume() {
        String[] stringArray = new String[]{"hdiutil", "detach", this.mountPoint.getPath()};
        this.runCommand(new GeneralCommandLine(stringArray), false, (Function0<Unit>)((Function0)MacExecutableProblemHandler::detachVolume$lambda$0));
    }

    private final boolean runOrShowError(GeneralCommandLine commandLine, ErrorNotifier errorNotifier, boolean sudo) {
        return this.runCommand(commandLine, sudo, (Function0<Unit>)((Function0)() -> MacExecutableProblemHandler.runOrShowError$lambda$0(this, errorNotifier)));
    }

    private final boolean runCommand(GeneralCommandLine commandLine, boolean sudo, Function0<Unit> onError) {
        try {
            GeneralCommandLine generalCommandLine;
            if (sudo) {
                String string = GitBundle.message((String)"title.sudo.command.install.git", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                generalCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)string);
            } else {
                generalCommandLine = commandLine;
            }
            GeneralCommandLine cmd = generalCommandLine;
            ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
            if (output2.checkSuccess(LOG)) {
                return true;
            }
            LOG.warn(output2.getStderr());
            onError.invoke();
            return false;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            onError.invoke();
            return false;
        }
    }

    private final void showCouldntInstallError(ErrorNotifier errorNotifier) {
        String string = GitBundle.message((String)"install.general.error", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showCouldntStartInstallerError(ErrorNotifier errorNotifier) {
        String string = GitBundle.message((String)"install.mac.error.couldnt.start.command.line.tools", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showXCodeLicenseError(ErrorNotifier errorNotifier) {
        String string = GitBundle.message((String)"git.executable.validation.error.xcode.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        errorNotifier.showError(string, GitBundle.message((String)"git.executable.validation.error.xcode.message", (Object[])new Object[0]), GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showInvalidActiveDeveloperPathError(ErrorNotifier errorNotifier) {
        String string = GitBundle.message((String)"executable.mac.fix.path.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ErrorNotifier.FixOption.Standard fixPathOption = new ErrorNotifier.FixOption.Standard(string, (Function0<Unit>)((Function0)() -> MacExecutableProblemHandler.showInvalidActiveDeveloperPathError$lambda$0(errorNotifier, this)));
        String string2 = GitBundle.message((String)"executable.mac.error.invalid.path.to.command.line.tools", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        errorNotifier.showError(string2, fixPathOption);
    }

    private final boolean isXcodeLicenseError(Throwable exception) {
        return this.isXcodeError(exception, (Function1<? super String, Boolean>)((Function1)MacExecutableProblemHandler::isXcodeLicenseError$lambda$0));
    }

    private final boolean isInvalidActiveDeveloperPath(Throwable exception) {
        return this.isXcodeError(exception, (Function1<? super String, Boolean>)((Function1)MacExecutableProblemHandler::isInvalidActiveDeveloperPath$lambda$0));
    }

    private final boolean isXcodeError(Throwable exception, Function1<? super String, Boolean> messageIndicator) {
        String string;
        if (exception instanceof GitVersionIdentificationException) {
            Throwable throwable = exception.getCause();
            string = throwable != null ? throwable.getMessage() : null;
        } else {
            string = exception.getMessage();
        }
        String message = string;
        return message != null && (Boolean)messageIndicator.invoke((Object)message) != false;
    }

    private final void execXCodeSelectInstall(ErrorNotifier errorNotifier) {
        try {
            String[] stringArray = new String[]{"xcode-select", "--install"};
            GeneralCommandLine cmd = new GeneralCommandLine(stringArray);
            ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
            errorNotifier.hideProgress();
            if (!output2.checkSuccess(LOG)) {
                LOG.warn(output2.getStderr());
                this.showCouldntStartInstallerError(errorNotifier);
            } else {
                errorNotifier.resetGitExecutable();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            this.showCouldntStartInstallerError(errorNotifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit downloadAndInstall$lambda$0(ErrorNotifier $errorNotifier, MacExecutableProblemHandler this$0, Function0 $onErrorResolved) {
        try {
            GitInstaller installer = GitDownloadAndInstallKt.fetchInstaller($errorNotifier, (Function1<? super GitInstaller, Boolean>)((Function1)MacExecutableProblemHandler::downloadAndInstall$lambda$0$0));
            if (installer != null) {
                String fileName = installer.getFileName();
                File dmgFile = new File(this$0.tempPath, fileName);
                String string = installer.getPkgFileName();
                Intrinsics.checkNotNull((Object)string);
                String pkgFileName = string;
                if (GitDownloadAndInstallKt.downloadGit(installer, dmgFile, this$0.project, $errorNotifier)) {
                    String string2 = GitBundle.message((String)"install.installing.progress", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    $errorNotifier.changeProgressTitle(string2);
                    this$0.installGit(dmgFile, pkgFileName, $errorNotifier, (Function0<Unit>)$onErrorResolved);
                }
            }
        }
        finally {
            FileUtil.delete((File)this$0.tempPath);
        }
        return Unit.INSTANCE;
    }

    private static final boolean downloadAndInstall$lambda$0$0(GitInstaller it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getOs(), (Object)"macOS") && it.getPkgFileName() != null;
    }

    private static final Unit detachVolume$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit runOrShowError$lambda$0(MacExecutableProblemHandler this$0, ErrorNotifier $errorNotifier) {
        this$0.showCouldntInstallError($errorNotifier);
        return Unit.INSTANCE;
    }

    private static final Unit showInvalidActiveDeveloperPathError$lambda$0(ErrorNotifier $errorNotifier, MacExecutableProblemHandler this$0) {
        $errorNotifier.executeTask(GitBundle.message((String)"install.mac.requesting.command.line.tools", (Object[])new Object[0]) + "\u2026", false, (Function0<Unit>)((Function0)() -> MacExecutableProblemHandler.showInvalidActiveDeveloperPathError$lambda$0$0(this$0, $errorNotifier)));
        return Unit.INSTANCE;
    }

    private static final Unit showInvalidActiveDeveloperPathError$lambda$0$0(MacExecutableProblemHandler this$0, ErrorNotifier $errorNotifier) {
        this$0.execXCodeSelectInstall($errorNotifier);
        return Unit.INSTANCE;
    }

    private static final boolean isXcodeLicenseError$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)it, (CharSequence)XCODE_LICENSE_ERROR, (boolean)false, (int)2, null);
    }

    private static final boolean isInvalidActiveDeveloperPath$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)it, (CharSequence)XCODE_DEVELOPER_PART_ERROR, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)XCODE_XCRUN, (boolean)false, (int)2, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MacExecutableProblemHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/config/MacExecutableProblemHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "XCODE_LICENSE_ERROR", "", "Lorg/jetbrains/annotations/NonNls;", "XCODE_DEVELOPER_PART_ERROR", "XCODE_XCRUN", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

