/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.context;

import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.context.NotebookDataContextUtils;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellOutput;
import com.intellij.notebooks.visualization.ui.NotebookEditorKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0017*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u0006*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u0006*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u0006*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001c\u00a8\u0006!"}, d2={"Lcom/intellij/notebooks/visualization/context/NotebookDataContext;", "", "<init>", "()V", "NOTEBOOK_CELL_LINES_INTERVAL", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getNOTEBOOK_CELL_LINES_INTERVAL", "()Lcom/intellij/openapi/actionSystem/DataKey;", "NOTEBOOK_CELL_INSERT_ABOVE", "", "getNOTEBOOK_CELL_INSERT_ABOVE", "SHOW_TEXT", "getSHOW_TEXT", "NOTEBOOK_CELL_OUTPUT_DATA_KEY", "Lcom/intellij/notebooks/visualization/ui/EditorCellOutput;", "getNOTEBOOK_CELL_OUTPUT_DATA_KEY", "notebookEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "Lcom/intellij/openapi/actionSystem/DataContext;", "getNotebookEditor", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/editor/impl/EditorImpl;", "selectedCellIntervals", "", "getSelectedCellIntervals", "(Lcom/intellij/openapi/actionSystem/DataContext;)Ljava/util/List;", "selectedCellInterval", "getSelectedCellInterval", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "hoveredInterval", "getHoveredInterval", "hoveredOrSelectedInterval", "getHoveredOrSelectedInterval", "intellij.notebooks.visualization"})
public final class NotebookDataContext {
    @NotNull
    public static final NotebookDataContext INSTANCE = new NotebookDataContext();
    @NotNull
    private static final DataKey<NotebookCellLines.Interval> NOTEBOOK_CELL_LINES_INTERVAL = DataKey.Companion.create("NOTEBOOK_CELL_LINES_INTERVAL");
    @NotNull
    private static final DataKey<Boolean> NOTEBOOK_CELL_INSERT_ABOVE = DataKey.Companion.create("NOTEBOOK_CELL_INSERT_ABOVE");
    @NotNull
    private static final DataKey<Boolean> SHOW_TEXT = DataKey.Companion.create("SHOW_ACTION_TEXT");
    @NotNull
    private static final DataKey<EditorCellOutput> NOTEBOOK_CELL_OUTPUT_DATA_KEY = DataKey.Companion.create("NOTEBOOK_CELL_OUTPUT");

    private NotebookDataContext() {
    }

    @NotNull
    public final DataKey<NotebookCellLines.Interval> getNOTEBOOK_CELL_LINES_INTERVAL() {
        return NOTEBOOK_CELL_LINES_INTERVAL;
    }

    @NotNull
    public final DataKey<Boolean> getNOTEBOOK_CELL_INSERT_ABOVE() {
        return NOTEBOOK_CELL_INSERT_ABOVE;
    }

    @NotNull
    public final DataKey<Boolean> getSHOW_TEXT() {
        return SHOW_TEXT;
    }

    @NotNull
    public final DataKey<EditorCellOutput> getNOTEBOOK_CELL_OUTPUT_DATA_KEY() {
        return NOTEBOOK_CELL_OUTPUT_DATA_KEY;
    }

    @Nullable
    public final EditorImpl getNotebookEditor(@NotNull DataContext $this$notebookEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookEditor, (String)"<this>");
        Component component = (Component)$this$notebookEditor.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)$this$notebookEditor.getData(PlatformCoreDataKeys.EDITOR);
        EditorImpl editorImpl = NotebookDataContextUtils.INSTANCE.getCurrentEditor(editor, component);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl noteEditor = editorImpl;
        if (NotebookDataContextUtils.INSTANCE.hasFocusedSearchReplaceComponent((Editor)noteEditor, component)) {
            return null;
        }
        return noteEditor;
    }

    @Nullable
    public final List<NotebookCellLines.Interval> getSelectedCellIntervals(@NotNull DataContext $this$selectedCellIntervals) {
        Intrinsics.checkNotNullParameter((Object)$this$selectedCellIntervals, (String)"<this>");
        EditorImpl editorImpl = this.getNotebookEditor($this$selectedCellIntervals);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl jupyterEditor = editorImpl;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)jupyterEditor);
        if (notebookCellSelectionModel == null) {
            return null;
        }
        NotebookCellSelectionModel selectionModel = notebookCellSelectionModel;
        return selectionModel.getSelectedCells();
    }

    @Nullable
    public final NotebookCellLines.Interval getSelectedCellInterval(@NotNull DataContext $this$selectedCellInterval) {
        Intrinsics.checkNotNullParameter((Object)$this$selectedCellInterval, (String)"<this>");
        NotebookCellLines.Interval cached = (NotebookCellLines.Interval)$this$selectedCellInterval.getData(NOTEBOOK_CELL_LINES_INTERVAL);
        if (cached != null) {
            return cached;
        }
        EditorImpl editorImpl = this.getNotebookEditor($this$selectedCellInterval);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl editor = editorImpl;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)editor);
        if (notebookCellSelectionModel == null) {
            return null;
        }
        NotebookCellSelectionModel selectionModel = notebookCellSelectionModel;
        return selectionModel.getPrimarySelectedCell();
    }

    @Nullable
    public final NotebookCellLines.Interval getHoveredInterval(@NotNull DataContext $this$hoveredInterval) {
        Intrinsics.checkNotNullParameter((Object)$this$hoveredInterval, (String)"<this>");
        Object object = this.getNotebookEditor($this$hoveredInterval);
        return object != null && (object = NotebookEditorKt.getNotebookEditor((Editor)object)) != null && (object = object.getHoveredCell()) != null && (object = (EditorCell)object.get()) != null ? ((EditorCell)object).getInterval() : null;
    }

    @Nullable
    public final NotebookCellLines.Interval getHoveredOrSelectedInterval(@NotNull DataContext $this$hoveredOrSelectedInterval) {
        Intrinsics.checkNotNullParameter((Object)$this$hoveredOrSelectedInterval, (String)"<this>");
        NotebookCellLines.Interval interval = this.getHoveredInterval($this$hoveredOrSelectedInterval);
        if (interval == null) {
            interval = this.getSelectedCellInterval($this$hoveredOrSelectedInterval);
        }
        return interval;
    }
}

