/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.project.Project;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.text.StringKt;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a\u001a\u0010\u0014\u001a\u00020\u00012\b\b\u0001\u0010\u0015\u001a\u00020\u00032\b\b\u0001\u0010\u0016\u001a\u00020\u0003\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\"\u0013\u0010\u0017\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0018X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"saveCredentials", "", "server", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "userName", "", "password", "isPasswordMemoryOnly", "", "credentials", "Lcom/intellij/credentialStore/Credentials;", "getCredentials", "getCredentialsAndMemoryOnlyStatus", "Lkotlin/Pair;", "createAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "getRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "copyServerCredentials", "from", "to", "EMPTY_PASSWORD_PREFIX", "Lorg/jetbrains/annotations/NonNls;", "patchCredentialsBeforeSaving", "patchCredentialsAfterReading", "intellij.webDeployment"})
@JvmName(name="WebDeploymentCredentialHelper")
public final class WebDeploymentCredentialHelper {
    @NotNull
    public static final String EMPTY_PASSWORD_PREFIX = "IntelliJ deployment empty password";

    @JvmOverloads
    public static final void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password, boolean isPasswordMemoryOnly) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        WebDeploymentCredentialHelper.saveCredentials(server, isPasswordMemoryOnly, new Credentials(StringKt.nullize((String)userName, (boolean)true), password));
    }

    public static /* synthetic */ void saveCredentials$default(WebServerConfig webServerConfig, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        WebDeploymentCredentialHelper.saveCredentials(webServerConfig, string, string2, bl);
    }

    public static final void saveCredentials(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly, @Nullable Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        PasswordSafe.Companion.getInstance().set(attributes, WebDeploymentCredentialHelper.patchCredentialsBeforeSaving(credentials));
    }

    @Nullable
    public static final Credentials getCredentials(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        Credentials credentials = PasswordSafe.Companion.getInstance().get(attributes);
        return WebDeploymentCredentialHelper.patchCredentialsAfterReading(credentials);
    }

    @NotNull
    public static final Pair<Credentials, Boolean> getCredentialsAndMemoryOnlyStatus(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        Credentials credentials = PasswordSafe.Companion.getInstance().get(attributes);
        boolean memoryOnly = credentials == null || PasswordSafe.Companion.getInstance().isPasswordStoredOnlyInMemory(attributes, credentials);
        return TuplesKt.to((Object)WebDeploymentCredentialHelper.patchCredentialsAfterReading(credentials), (Object)memoryOnly);
    }

    private static final CredentialAttributes createAttributes(WebServerConfig server, boolean isPasswordMemoryOnly) {
        return CredentialAttributes.copy$default((CredentialAttributes)new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"Deployment", (String)String.valueOf(server.getId()))), null, null, (boolean)isPasswordMemoryOnly, (boolean)false, (int)11, null);
    }

    @Nullable
    public static final RemoteCredentials getRemoteCredentials(@NotNull WebServerConfig server, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        RemoteCredentialsHolder remoteCredentials = new RemoteCredentialsHolder();
        PresentableId presentableId = server.getFileTransferConfig().getSshPresentableId();
        if (presentableId != null) {
            SshUiData sshUiData = SshConfigManager.getInstance((Project)project).findCurrentData(presentableId);
            if (sshUiData == null) {
                return null;
            }
            remoteCredentials.copyFrom((RemoteCredentials)sshUiData);
            return (RemoteCredentials)remoteCredentials;
        }
        Deployable deployable = Deployable.create(server, project);
        deployable.copyToCredentials((MutableRemoteCredentials)remoteCredentials);
        return (RemoteCredentials)remoteCredentials;
    }

    public static final void copyServerCredentials(@NotNull WebServerConfig from, @NotNull WebServerConfig to) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(from, false);
        Credentials credentials = passwordSafe.get(attributes);
        if (!(credentials == null || ((charSequence = (CharSequence)credentials.getUserName()) == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)credentials.getPasswordAsString()) == null || StringsKt.isBlank((CharSequence)charSequence)))) {
            boolean isMemoryOnly = passwordSafe.isPasswordStoredOnlyInMemory(attributes, credentials);
            CredentialAttributes cloneAttributes = WebDeploymentCredentialHelper.createAttributes(to, false);
            passwordSafe.set(cloneAttributes, credentials, isMemoryOnly);
        }
    }

    @Nullable
    public static final Credentials patchCredentialsBeforeSaving(@Nullable Credentials credentials) {
        if (credentials == null) {
            return null;
        }
        String password = credentials.getPasswordAsString();
        if (password != null && (((CharSequence)password).length() == 0 || StringsKt.startsWith$default((String)password, (String)EMPTY_PASSWORD_PREFIX, (boolean)false, (int)2, null))) {
            return new Credentials(credentials.getUserName(), EMPTY_PASSWORD_PREFIX + password);
        }
        return credentials;
    }

    @Nullable
    public static final Credentials patchCredentialsAfterReading(@Nullable Credentials credentials) {
        if (credentials == null) {
            return null;
        }
        String password = credentials.getPasswordAsString();
        if (password == null) {
            return credentials;
        }
        if (((CharSequence)password).length() == 0) {
            return new Credentials(credentials.getUserName(), null);
        }
        if (!StringsKt.startsWith$default((String)password, (String)EMPTY_PASSWORD_PREFIX, (boolean)false, (int)2, null)) {
            return credentials;
        }
        String string = credentials.getUserName();
        String string2 = password.substring(34);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return new Credentials(string, string2);
    }

    @JvmOverloads
    public static final void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        WebDeploymentCredentialHelper.saveCredentials$default(server, userName, password, false, 8, null);
    }
}

