/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac;

import com.intellij.ide.startup.importSettings.db.KnownKeymaps;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.transfer.backend.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers.GeneralSettingsParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers.KeyBindingsParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers.RecentProjectsParser;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/VSMacSettingsProcessor;", "", "<init>", "()V", "getProcessedSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "version", "", "Companion", "intellij.ide.startup.importSettings"})
public final class VSMacSettingsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String homeDirectory = System.getProperty("user.home");
    @NotNull
    private static final String vsHome = homeDirectory + "/Library/VisualStudio";
    @NotNull
    private static final String vsPreferences = homeDirectory + "/Library/Preferences/VisualStudio";

    @NotNull
    public final Settings getProcessedSettings(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Path keyBindingsFile = Companion.getKeyBindingsFile$intellij_ide_startup_importSettings(version);
        Path generalSettingsFile = Companion.getGeneralSettingsFile$intellij_ide_startup_importSettings(version);
        Path recentlyUsedFile = Companion.getRecentlyUsedFile$intellij_ide_startup_importSettings(version);
        Settings settings = Companion.getDefaultSettings();
        new KeyBindingsParser(settings).process(keyBindingsFile);
        new GeneralSettingsParser(settings).process(generalSettingsFile);
        new RecentProjectsParser(settings).process(recentlyUsedFile);
        return settings;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0013\u001a\u00020\u0014R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/VSMacSettingsProcessor$Companion;", "", "<init>", "()V", "homeDirectory", "", "kotlin.jvm.PlatformType", "vsHome", "vsPreferences", "getVsPreferences$intellij_ide_startup_importSettings", "()Ljava/lang/String;", "getRecentlyUsedFile", "Ljava/nio/file/Path;", "version", "getRecentlyUsedFile$intellij_ide_startup_importSettings", "getKeyBindingsFile", "getKeyBindingsFile$intellij_ide_startup_importSettings", "getGeneralSettingsFile", "getGeneralSettingsFile$intellij_ide_startup_importSettings", "getDefaultSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVsPreferences$intellij_ide_startup_importSettings() {
            return vsPreferences;
        }

        @NotNull
        public final Path getRecentlyUsedFile$intellij_ide_startup_importSettings(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Path path = Paths.get(this.getVsPreferences$intellij_ide_startup_importSettings() + "/" + version + "/RecentlyUsed.xml", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        @NotNull
        public final Path getKeyBindingsFile$intellij_ide_startup_importSettings(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Path path = Paths.get(vsHome + "/" + version + "/KeyBindings/Custom.mac-kb.xml", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        @NotNull
        public final Path getGeneralSettingsFile$intellij_ide_startup_importSettings(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Path path = Paths.get(this.getVsPreferences$intellij_ide_startup_importSettings() + "/" + version + "/MonoDevelopProperties.xml", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        @NotNull
        public final Settings getDefaultSettings() {
            return new Settings(null, KnownLafs.INSTANCE.getLight(), KnownColorSchemes.INSTANCE.getLight(), KnownKeymaps.INSTANCE.getVSMac(), null, 17, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

