/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view.focusview;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.ModelViewManager;
import com.intellij.openapi.graph.view.focusview.BaseGraphFocusView;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class GraphFocusOnEdgesView<N, E>
extends BaseGraphFocusView<N, E> {
    @NotNull
    private final Set<GraphIdentifiable.Edge.Identity> myFocusEdges;
    @NotNull
    private final Consumer<? super GraphSettings> myViewSettingsCustomizer;

    public GraphFocusOnEdgesView(@NotNull Set<GraphIdentifiable.Edge.Identity> edges, @NotNull Consumer<? super GraphSettings> customizer) {
        if (edges == null) {
            GraphFocusOnEdgesView.$$$reportNull$$$0(0);
        }
        if (customizer == null) {
            GraphFocusOnEdgesView.$$$reportNull$$$0(1);
        }
        this.myFocusEdges = edges;
        this.myViewSettingsCustomizer = customizer;
    }

    @Override
    @NotNull
    protected Graph2D createFocusGraph(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            GraphFocusOnEdgesView.$$$reportNull$$$0(2);
        }
        Graph2D modelGraph = modelBuilder.getGraph();
        FocusOnEdgesFilter focusGraphFilter = new FocusOnEdgesFilter(modelBuilder);
        Graph2D graph2D = (Graph2D)this.getFocusViewManager().createViewGraph(modelGraph.getGraphCopyFactory(), focusGraphFilter, false, false);
        if (graph2D == null) {
            GraphFocusOnEdgesView.$$$reportNull$$$0(3);
        }
        return graph2D;
    }

    @Override
    protected void customizeViewSettings(@NotNull Graph2DView view, @NotNull EditMode editMode, @NotNull GraphSettings viewSettings, @NotNull GraphBuilder<N, E> modelBuilder) {
        if (view == null) {
            GraphFocusOnEdgesView.$$$reportNull$$$0(4);
        }
        if (editMode == null) {
            GraphFocusOnEdgesView.$$$reportNull$$$0(5);
        }
        if (viewSettings == null) {
            GraphFocusOnEdgesView.$$$reportNull$$$0(6);
        }
        if (modelBuilder == null) {
            GraphFocusOnEdgesView.$$$reportNull$$$0(7);
        }
        this.myViewSettingsCustomizer.accept(viewSettings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/view/focusview/GraphFocusOnEdgesView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/view/focusview/GraphFocusOnEdgesView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFocusGraph";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizeViewSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class FocusOnEdgesFilter
    implements ModelViewManager.Filter {
        @NotNull
        private final GraphBuilder<N, E> myModelBuilder;
        @NotNull
        private final Set<GraphIdentifiable.Node.Identity> myFocusNodes;

        private FocusOnEdgesFilter(GraphBuilder<N, E> builder) {
            if (builder == null) {
                FocusOnEdgesFilter.$$$reportNull$$$0(0);
            }
            this.myModelBuilder = builder;
            this.myFocusNodes = Arrays.stream(this.myModelBuilder.getGraph().getEdgeArray()).filter(it -> GraphFocusOnEdgesView.this.myFocusEdges.contains(this.myModelBuilder.getEdgeIdentity((Edge)it))).flatMap(it -> Stream.of(it.source(), it.target())).map(it -> this.myModelBuilder.getNodeIdentity((Node)it)).collect(Collectors.toSet());
        }

        @Override
        public boolean acceptInsertion(@NotNull Node node) {
            if (node == null) {
                FocusOnEdgesFilter.$$$reportNull$$$0(1);
            }
            return this.acceptRetention(node);
        }

        @Override
        public boolean acceptInsertion(@NotNull Edge edge) {
            if (edge == null) {
                FocusOnEdgesFilter.$$$reportNull$$$0(2);
            }
            return this.acceptRetention(edge);
        }

        @Override
        public boolean acceptRemoval(@NotNull Node node) {
            if (node == null) {
                FocusOnEdgesFilter.$$$reportNull$$$0(3);
            }
            return !this.acceptRetention(node);
        }

        @Override
        public boolean acceptRemoval(@NotNull Edge edge) {
            if (edge == null) {
                FocusOnEdgesFilter.$$$reportNull$$$0(4);
            }
            return !this.acceptRetention(edge);
        }

        @Override
        public boolean acceptRetention(@NotNull Node node) {
            if (node == null) {
                FocusOnEdgesFilter.$$$reportNull$$$0(5);
            }
            return this.myFocusNodes.contains(this.myModelBuilder.getNodeIdentity(node));
        }

        @Override
        public boolean acceptRetention(@NotNull Edge edge) {
            if (edge == null) {
                FocusOnEdgesFilter.$$$reportNull$$$0(6);
            }
            return GraphFocusOnEdgesView.this.myFocusEdges.contains(this.myModelBuilder.getEdgeIdentity(edge));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edge";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/graph/view/focusview/GraphFocusOnEdgesView$FocusOnEdgesFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptInsertion";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptRemoval";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptRetention";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

