/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.plots.export;

import com.intellij.kotlin.jupyter.plots.FlavorsKt;
import com.intellij.kotlin.jupyter.plots.LetsPlotOutputDataKey;
import com.intellij.kotlin.jupyter.plots.export.BinaryPlotContent;
import com.intellij.kotlin.jupyter.plots.export.ExportFormat;
import com.intellij.kotlin.jupyter.plots.export.HtmlExportKt;
import com.intellij.kotlin.jupyter.plots.export.PlotContent;
import com.intellij.kotlin.jupyter.plots.export.PlotExportModel;
import com.intellij.kotlin.jupyter.plots.export.TextPlotContent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.awt.datatransfer.Transferable;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.ggdsl.util.serialization.SpecSerializationKt;
import org.jetbrains.letsPlot.awt.plot.PlotSvgExport;
import org.jetbrains.letsPlot.core.plot.export.PlotImageExport;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0003\u001a\u0018\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e*\u00020\u0003H\u0002\u00a8\u0006\u0011"}, d2={"savePlot", "", "plot", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "model", "Lcom/intellij/kotlin/jupyter/plots/export/PlotExportModel;", "file", "Ljava/nio/file/Path;", "copyPlotToClipboard", "project", "Lcom/intellij/openapi/project/Project;", "exportPlot", "Lcom/intellij/kotlin/jupyter/plots/export/PlotContent;", "toMutableSpec", "", "", "", "intellij.kotlin.jupyter.plots"})
public final class ExportImplKt {
    @RequiresBackgroundThread
    public static final void savePlot(@NotNull LetsPlotOutputDataKey plot, @NotNull PlotExportModel model, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)plot, (String)"plot");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PlotContent content = ExportImplKt.exportPlot(plot, model);
        content.saveToFile(file);
    }

    @RequiresBackgroundThread
    public static final void copyPlotToClipboard(@NotNull Project project, @NotNull LetsPlotOutputDataKey plot, @NotNull PlotExportModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plot, (String)"plot");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        PlotContent content = ExportImplKt.exportPlot(plot, model);
        Transferable transferable = content.asTransferable(project);
        CopyPasteManager.getInstance().setContents(transferable);
    }

    @RequiresBackgroundThread
    private static final PlotContent exportPlot(LetsPlotOutputDataKey plot, PlotExportModel model) {
        ThreadingAssertions.assertBackgroundThread();
        Map<String, Object> spec = ExportImplKt.toMutableSpec(plot);
        FlavorsKt.updateFlavor(spec, model.getLetsPlotFlavor());
        ExportFormat modelFormat = model.getFormat();
        return switch (WhenMappings.$EnumSwitchMapping$0[modelFormat.ordinal()]) {
            case 4 -> {
                String svg = PlotSvgExport.buildSvgImageFromRawSpecs$default((PlotSvgExport)PlotSvgExport.INSTANCE, spec, null, (boolean)false, null, (int)14, null);
                yield new TextPlotContent(svg);
            }
            case 5 -> {
                String html = HtmlExportKt.buildHtmlFromRawPlotSpec(spec);
                yield new TextPlotContent(html);
            }
            default -> {
                PlotImageExport.Format v1 = switch (WhenMappings.$EnumSwitchMapping$0[modelFormat.ordinal()]) {
                    case 1 -> PlotImageExport.Format.PNG.INSTANCE;
                    case 2 -> new PlotImageExport.Format.JPEG(0.0, 1, null);
                    case 3 -> PlotImageExport.Format.TIFF.INSTANCE;
                    default -> throw new IllegalStateException("No other formats are possible on this stage");
                };
                PlotImageExport.Format format = v1;
                byte[] byteArray = PlotImageExport.buildImageFromRawSpecs$default(PlotImageExport.INSTANCE, spec, format, model.getScalingFactor(), model.getTargetDPI(), null, null, 48, null).getBytes();
                yield new BinaryPlotContent(byteArray);
            }
        };
    }

    private static final Map<String, Object> toMutableSpec(LetsPlotOutputDataKey $this$toMutableSpec) {
        return MapsKt.toMutableMap(SpecSerializationKt.deserializeSpec((JsonElement)$this$toMutableSpec.getSpec()));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExportFormat.values().length];
            try {
                nArray[ExportFormat.PNG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExportFormat.JPG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExportFormat.TIFF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExportFormat.SVG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExportFormat.HTML.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

