/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.utils;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"paintHint", "", "g", "Ljava/awt/Graphics;", "component", "Ljava/awt/Component;", "hint", "", "paintHintIcon", "hintIcon", "Ljavax/swing/Icon;", "intellij.clouds.docker.shared"})
@JvmName(name="DockerConfigurablesUtil")
public final class DockerConfigurablesUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void paintHint(@NotNull Graphics g, @NotNull Component component2, @NotNull char[] hint) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        try {
            g.setColor((Color)JBColor.GRAY);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics metrics = g.getFontMetrics();
            int x = Math.abs(component2.getWidth() - metrics.charsWidth(hint, 0, hint.length) - 6);
            int y = Math.abs(component2.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
            g.drawChars(hint, 0, hint.length, x, y);
        }
        finally {
            g.setColor(oldColor);
            g.setFont(oldFont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static final void paintHintIcon(@NotNull Graphics g, @NotNull Component component2, @NotNull Icon hintIcon) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)hintIcon, (String)"hintIcon");
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        try {
            g.setColor((Color)JBColor.GRAY);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int x = Math.abs(component2.getWidth() - hintIcon.getIconWidth() - 6);
            int y = Math.abs(component2.getHeight() - hintIcon.getIconHeight()) / 2;
            hintIcon.paintIcon(component2, g, x, y);
        }
        finally {
            g.setColor(oldColor);
            g.setFont(oldFont);
        }
    }
}

