/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jpa.model.xml.converters.ClassConverter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassConverterBase
extends ClassConverter {
    @Nullable
    protected String getDefaultPackageName(ConvertContext context) {
        return null;
    }

    @Nullable
    protected String getBaseClassName(ConvertContext context) {
        return null;
    }

    @NotNull
    protected GlobalSearchScope getResolveSearchScope(ConvertContext context) {
        GlobalSearchScope globalSearchScope = ClassConverterBase.getDefaultSearchScope(context);
        if (globalSearchScope == null) {
            ClassConverterBase.$$$reportNull$$$0(0);
        }
        return globalSearchScope;
    }

    public static GlobalSearchScope getDefaultSearchScope(ConvertContext context) {
        GlobalSearchScope scope = context.getSearchScope();
        if (scope != null) {
            return scope;
        }
        return context.getFile().getResolveScope();
    }

    public PsiClass fromString(String s, @NotNull ConvertContext context) {
        if (context == null) {
            ClassConverterBase.$$$reportNull$$$0(1);
        }
        String fullClassName = ClassConverterBase.getQualifiedClassName(s, this.getDefaultPackageName(context));
        PsiClass result = null;
        if (fullClassName != null) {
            result = DomJavaUtil.findClass((String)fullClassName, (PsiFile)context.getFile(), (Module)context.getModule(), (GlobalSearchScope)this.getResolveSearchScope(context));
            if (result == null && !Objects.equals(s, fullClassName)) {
                result = DomJavaUtil.findClass((String)s, (PsiFile)context.getFile(), (Module)context.getModule(), (GlobalSearchScope)this.getResolveSearchScope(context));
            }
            if (result != null && !Objects.equals(this.getQualifiedName(result), fullClassName)) {
                return null;
            }
        }
        return result;
    }

    @Nullable
    public static String getQualifiedClassName(String s, String defaultPackage) {
        if (s == null) {
            return null;
        }
        return StringUtil.isEmpty((String)defaultPackage) || s.indexOf(46) > -1 ? s : defaultPackage + "." + s;
    }

    public String toString(PsiClass t, @NotNull ConvertContext context) {
        if (context == null) {
            ClassConverterBase.$$$reportNull$$$0(2);
        }
        if (t == null) {
            return null;
        }
        return this.processQualifiedName(this.getQualifiedName(t), context);
    }

    protected String getQualifiedName(PsiClass t) {
        return this.isJVMFormat() ? ClassUtil.getJVMClassName((PsiClass)t) : t.getQualifiedName();
    }

    protected boolean isJVMFormat() {
        return true;
    }

    private String processQualifiedName(String qualifiedName, ConvertContext context) {
        String defaultPackage = this.getDefaultPackageName(context);
        if (StringUtil.isNotEmpty((String)defaultPackage) && StringUtil.startsWithConcatenation((String)qualifiedName, (String[])new String[]{defaultPackage, ""})) {
            return qualifiedName.substring(defaultPackage.length() + 1);
        }
        return qualifiedName;
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            ClassConverterBase.$$$reportNull$$$0(3);
        }
        List list = Collections.emptyList();
        if (list == null) {
            ClassConverterBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void handleElementRename(GenericDomValue<PsiClass> genericValue, ConvertContext context, String newElementName) {
        String fqName;
        PsiClass psiClass = (PsiClass)genericValue.getValue();
        if (psiClass != null && StringUtil.isNotEmpty((String)(fqName = psiClass.getQualifiedName()))) {
            String packageName = StringUtil.getPackageName((String)fqName);
            String packagePrefix = StringUtil.isNotEmpty((String)packageName) ? packageName : "";
            genericValue.setStringValue(this.processQualifiedName(packagePrefix + newElementName, context));
            return;
        }
        super.handleElementRename(genericValue, context, newElementName);
    }

    public void bindReference(GenericDomValue<PsiClass> genericValue, ConvertContext context, PsiElement newTarget) {
        if (newTarget == null || newTarget instanceof PsiClass) {
            genericValue.setStringValue(this.toString((PsiClass)newTarget, context));
        } else {
            super.bindReference(genericValue, context, newTarget);
        }
    }

    public LocalQuickFix[] getQuickFixes(@NotNull ConvertContext context) {
        if (context == null) {
            ClassConverterBase.$$$reportNull$$$0(5);
        }
        String defaultPackage = this.getDefaultPackageName(context);
        return ClassConverterBase.getCreateClassQuickFixes(context, defaultPackage);
    }

    public static LocalQuickFix[] getCreateClassQuickFixes(ConvertContext context, String defaultPackage) {
        LocalQuickFix[] localQuickFixArray;
        IntentionAction quickFix;
        XmlFile classContext = context.getFile();
        String stringValue = ((GenericDomValue)context.getInvocationElement()).getStringValue();
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)context.getPsiManager().getProject());
        IntentionAction intentionAction = quickFix = !helper.isIdentifier(stringValue) && !helper.isQualifiedName(stringValue) ? null : QuickFixFactory.getInstance().createCreateClassOrPackageFix((PsiElement)classContext, ClassConverterBase.getQualifiedClassName(stringValue, defaultPackage), true, null);
        if (quickFix instanceof LocalQuickFix) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = (LocalQuickFix)quickFix;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ClassConverterBase.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<GenericDomValueReference> result = new ArrayList<GenericDomValueReference>();
        ContainerUtil.addAll(result, (Object[])this.createJavaClassReferences(element, context));
        result.add(this.createDomReference(genericDomValue));
        PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ClassConverterBase.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    protected PsiReference[] createJavaClassReferences(PsiElement element, ConvertContext context) {
        JavaClassReferenceProvider classReferenceProvider = new JavaClassReferenceProvider();
        this.setJavaClassReferenceProviderOptions(classReferenceProvider, context);
        classReferenceProvider.setSoft(true);
        return classReferenceProvider.getReferencesByElement(element);
    }

    protected void setJavaClassReferenceProviderOptions(JavaClassReferenceProvider referenceProvider, ConvertContext context) {
        String packageName = this.getDefaultPackageName(context);
        String baseClassName = this.getBaseClassName(context);
        boolean hasDefPackage = StringUtil.isNotEmpty((String)packageName);
        if (!StringUtil.isEmpty((String)baseClassName)) {
            referenceProvider.setOption(JavaClassReferenceProvider.EXTEND_CLASS_NAMES, (Object)new String[]{baseClassName});
        }
        if (hasDefPackage) {
            referenceProvider.setOption(JavaClassReferenceProvider.DEFAULT_PACKAGE, (Object)packageName);
        }
        if (this.isJVMFormat()) {
            referenceProvider.setOption(JavaClassReferenceProvider.JVM_FORMAT, (Object)Boolean.TRUE);
        }
    }

    protected GenericDomValueReference createDomReference(GenericDomValue genericDomValue) {
        return new GenericDomValueReference(genericDomValue);
    }

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            ClassConverterBase.$$$reportNull$$$0(8);
        }
        return CodeInsightBundle.message((String)"error.cannot.resolve.class", (Object[])new Object[]{s});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/model/xml/impl/converters/ClassConverterBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveSearchScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/model/xml/impl/converters/ClassConverterBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 8 -> new IllegalArgumentException(string);
        };
    }
}

